/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene;

import com.sun.javafx.Logging;
import com.sun.javafx.Utils;
import com.sun.javafx.css.CalculatedValue;
import com.sun.javafx.css.CascadingStyle;
import com.sun.javafx.css.CssError;
import com.sun.javafx.css.ParsedValueImpl;
import com.sun.javafx.css.PseudoClassState;
import com.sun.javafx.css.Rule;
import com.sun.javafx.css.Selector;
import com.sun.javafx.css.Style;
import com.sun.javafx.css.StyleCache;
import com.sun.javafx.css.StyleCacheEntry;
import com.sun.javafx.css.StyleConverterImpl;
import com.sun.javafx.css.StyleManager;
import com.sun.javafx.css.StyleMap;
import com.sun.javafx.css.Stylesheet;
import com.sun.javafx.css.converters.FontConverter;
import com.sun.javafx.scene.CssFlags;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.WritableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import javafx.collections.ObservableSet;
import javafx.css.CssMetaData;
import javafx.css.FontCssMetaData;
import javafx.css.ParsedValue;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.scene.Node;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.FontWeight;
import sun.util.logging.PlatformLogger;

final class CssStyleHelper {
    private static final PlatformLogger LOGGER = Logging.getCSSLogger();
    private CacheContainer cacheContainer;
    private PseudoClassState triggerStates = new PseudoClassState();
    ObservableMap<StyleableProperty<?>, List<Style>> observableStyleMap;
    static final Set<PseudoClass> NULL_PSEUDO_CLASS_STATE = null;
    private static final CssMetaData dummyFontProperty = new FontCssMetaData<Node>("-fx-font", Font.getDefault()){

        @Override
        public boolean isSettable(Node node) {
            return true;
        }

        @Override
        public StyleableProperty<Font> getStyleableProperty(Node node) {
            return null;
        }
    };

    private CssStyleHelper() {
    }

    static CssStyleHelper createStyleHelper(Node node, WritableValue<Boolean> writableValue, ObservableMap<StyleableProperty<?>, List<Style>> observableMap) {
        Styleable styleable;
        int n = 0;
        for (styleable = node; styleable != null; styleable = styleable.getStyleableParent()) {
            ++n;
        }
        PseudoClassState[] pseudoClassStateArray = new PseudoClassState[n];
        StyleMap styleMap = StyleManager.getInstance().findMatchingStyles(node, pseudoClassStateArray);
        if (CssStyleHelper.canReuseStyleHelper(node, styleMap)) {
            if (node.styleHelper.cacheContainer != null && (CssStyleHelper.isTrue(writableValue) || CssStyleHelper.isUserSetFont(node, node.styleHelper.cacheContainer.fontProp))) {
                CssStyleHelper.setTrue(writableValue);
                node.styleHelper.cacheContainer.fontSizeCache.clear();
            }
            return node.styleHelper;
        }
        if (styleMap == null || styleMap.isEmpty()) {
            boolean bl = false;
            List<CssMetaData<Styleable, ?>> list = node.getCssMetaData();
            int n2 = list != null ? list.size() : 0;
            for (int i = 0; i < n2; ++i) {
                CssMetaData<Styleable, ?> cssMetaData = list.get(i);
                if (!cssMetaData.isInherits()) continue;
                bl = true;
                break;
            }
            if (!(bl || observableMap != null && FXCollections.emptyObservableMap() != observableMap)) {
                if (node.styleHelper != null) {
                    node.styleHelper.resetToInitialValues(node);
                }
                return null;
            }
        }
        CssStyleHelper cssStyleHelper = new CssStyleHelper();
        cssStyleHelper.triggerStates.addAll((Collection)pseudoClassStateArray[0]);
        styleable = node.getStyleableParent();
        for (int i = 1; i < n; ++i) {
            if (!(styleable instanceof Node)) {
                styleable = styleable.getStyleableParent();
                continue;
            }
            Node node2 = (Node)styleable;
            PseudoClassState pseudoClassState = pseudoClassStateArray[i];
            if (pseudoClassState != null && pseudoClassState.size() > 0) {
                if (node2.styleHelper == null) {
                    node2.styleHelper = new CssStyleHelper();
                }
                node2.styleHelper.triggerStates.addAll((Collection)pseudoClassState);
            }
            styleable = styleable.getStyleableParent();
        }
        cssStyleHelper.cacheContainer = new CacheContainer(node, styleMap, n);
        if (node.styleHelper != null) {
            node.styleHelper.resetToInitialValues(node);
        }
        cssStyleHelper.observableStyleMap = observableMap;
        return cssStyleHelper;
    }

    private static boolean isUserSetFont(Styleable styleable, CssMetaData<Styleable, Font> cssMetaData) {
        StyleableProperty<Font> styleableProperty = cssMetaData != null ? cssMetaData.getStyleableProperty(styleable) : null;
        return styleableProperty != null && styleableProperty.getStyleOrigin() == StyleOrigin.USER;
    }

    private static boolean isTrue(WritableValue<Boolean> writableValue) {
        return writableValue != null && writableValue.getValue() != false;
    }

    private static void setTrue(WritableValue<Boolean> writableValue) {
        if (writableValue != null) {
            writableValue.setValue(true);
        }
    }

    private static boolean canReuseStyleHelper(Node node, StyleMap styleMap) {
        int[] nArray;
        int[] nArray2;
        if (node == null || node.styleHelper == null) {
            return false;
        }
        if (styleMap == null) {
            return false;
        }
        StyleMap styleMap2 = node.styleHelper.getStyleMap(node);
        if (styleMap2 != styleMap) {
            return false;
        }
        if (node.styleHelper.cacheContainer == null) {
            return true;
        }
        CssStyleHelper cssStyleHelper = null;
        Styleable styleable = node.getStyleableParent();
        if (styleable == null) {
            return true;
        }
        while (!(styleable == null || styleable instanceof Node && (cssStyleHelper = ((Node)styleable).styleHelper) != null)) {
            styleable = styleable.getStyleableParent();
        }
        if (cssStyleHelper != null && cssStyleHelper.cacheContainer != null && (nArray2 = cssStyleHelper.cacheContainer.styleCacheKey.getStyleMapIds()).length == (nArray = node.styleHelper.cacheContainer.styleCacheKey.getStyleMapIds()).length - 1) {
            boolean bl = true;
            for (int i = 0; i < nArray2.length; ++i) {
                if (nArray[i + 1] == nArray2[i]) continue;
                bl = false;
                break;
            }
            return bl;
        }
        return false;
    }

    private void resetToInitialValues(Styleable styleable) {
        if (this.cacheContainer == null || this.cacheContainer.cssSetProperties == null || this.cacheContainer.cssSetProperties.isEmpty()) {
            return;
        }
        HashSet hashSet = new HashSet(this.cacheContainer.cssSetProperties.entrySet());
        this.cacheContainer.cssSetProperties.clear();
        for (Map.Entry entry : hashSet) {
            CssMetaData cssMetaData = (CssMetaData)entry.getKey();
            StyleableProperty styleableProperty = cssMetaData.getStyleableProperty(styleable);
            StyleOrigin styleOrigin = styleableProperty.getStyleOrigin();
            if (styleOrigin == null || styleOrigin == StyleOrigin.USER) continue;
            CalculatedValue calculatedValue = (CalculatedValue)entry.getValue();
            styleableProperty.applyStyle(calculatedValue.getOrigin(), calculatedValue.getValue());
        }
    }

    private StyleMap getStyleMap(Styleable styleable) {
        if (this.cacheContainer == null || styleable == null) {
            return null;
        }
        return this.cacheContainer.getStyleMap(styleable);
    }

    boolean pseudoClassStateChanged(PseudoClass pseudoClass) {
        return this.triggerStates.contains(pseudoClass);
    }

    private Set<PseudoClass>[] getTransitionStates(Node node) {
        Object object;
        Node node2;
        if (this.cacheContainer == null) {
            return null;
        }
        int n = 0;
        for (node2 = node; node2 != null; node2 = node2.getParent()) {
            ++n;
        }
        PseudoClassState[] pseudoClassStateArray = new PseudoClassState[n];
        int n2 = 0;
        for (node2 = node; node2 != null; node2 = node2.getParent()) {
            Object object2 = object = node2 instanceof Node ? node2.styleHelper : null;
            if (object == null) continue;
            ObservableSet<PseudoClass> observableSet = node2.pseudoClassStates;
            pseudoClassStateArray[n2] = new PseudoClassState();
            pseudoClassStateArray[n2].addAll(observableSet);
            pseudoClassStateArray[n2].retainAll(object.triggerStates);
            ++n2;
        }
        object = new PseudoClassState[n2];
        System.arraycopy(pseudoClassStateArray, 0, object, 0, n2);
        return object;
    }

    ObservableMap<StyleableProperty<?>, List<Style>> getObservableStyleMap() {
        return this.observableStyleMap != null ? this.observableStyleMap : FXCollections.emptyObservableMap();
    }

    void setObservableStyleMap(ObservableMap<StyleableProperty<?>, List<Style>> observableMap) {
        this.observableStyleMap = observableMap;
    }

    void transitionToState(Node node, CssFlags cssFlags) {
        Font font;
        StyleCacheEntry.Key key;
        StyleCacheEntry styleCacheEntry;
        boolean bl;
        if (this.cacheContainer == null) {
            return;
        }
        StyleMap styleMap = this.getStyleMap(node);
        if (styleMap == null) {
            this.cacheContainer = null;
            node.impl_reapplyCSS();
            return;
        }
        boolean bl2 = styleMap.isEmpty();
        StyleCache styleCache = StyleManager.getInstance().getSharedCache(node, this.cacheContainer.styleCacheKey);
        if (styleCache == null) {
            this.cacheContainer = null;
            node.impl_reapplyCSS();
            return;
        }
        Set<PseudoClass>[] setArray = this.getTransitionStates(node);
        StyleCacheEntry.Key key2 = new StyleCacheEntry.Key(setArray, Font.getDefault());
        CalculatedValue calculatedValue = (CalculatedValue)this.cacheContainer.fontSizeCache.get(key2);
        if (calculatedValue == null) {
            if ((calculatedValue = this.lookupFont(node, "-fx-font", styleMap, calculatedValue)) == CalculatedValue.SKIP) {
                calculatedValue = this.getCachedFont(node.getStyleableParent());
            }
            if (calculatedValue == null) {
                calculatedValue = new CalculatedValue(Font.getDefault(), null, false);
            }
            this.cacheContainer.fontSizeCache.put(key2, calculatedValue);
        }
        boolean bl3 = bl = (styleCacheEntry = styleCache.getStyleCacheEntry(key = new StyleCacheEntry.Key(setArray, font = (Font)calculatedValue.getValue()))) != null;
        if (styleCacheEntry == null) {
            styleCacheEntry = new StyleCacheEntry();
            styleCache.addStyleCacheEntry(key, styleCacheEntry);
        }
        List<CssMetaData<Styleable, ?>> list = node.getCssMetaData();
        int n = list.size();
        CssError.setCurrentScene(node.getScene());
        for (int i = 0; i < n; ++i) {
            Object object;
            Object object2;
            Object object3;
            boolean bl4;
            Object object4;
            CssMetaData<Styleable, ?> cssMetaData = list.get(i);
            if (this.observableStyleMap != null && (object4 = cssMetaData.getStyleableProperty(node)) != null && this.observableStyleMap.containsKey(object4)) {
                this.observableStyleMap.remove(object4);
            }
            if (bl2 && !cssMetaData.isInherits() || !cssMetaData.isSettable(node)) continue;
            object4 = cssMetaData.getProperty();
            CalculatedValue calculatedValue2 = styleCacheEntry.get((String)object4);
            boolean bl5 = bl && calculatedValue2 == null && cssFlags == CssFlags.REAPPLY;
            boolean bl6 = bl4 = !bl && calculatedValue2 == null || bl5;
            if (bl && !bl5) {
                if (calculatedValue2 == CalculatedValue.SKIP) {
                    assert (false) : "cache returned SKIP for " + (String)object4;
                    continue;
                }
            } else if (calculatedValue2 == null && (calculatedValue2 = this.lookup(node, cssMetaData, styleMap, setArray[0], node, calculatedValue)) == null) {
                assert (false) : "lookup returned null for " + (String)object4;
                continue;
            }
            try {
                Object object5;
                Object object6;
                if (calculatedValue2 == null || calculatedValue2 == CalculatedValue.SKIP) {
                    object6 = (CalculatedValue)this.cacheContainer.cssSetProperties.get(cssMetaData);
                    if (object6 == null || (object3 = cssMetaData.getStyleableProperty(node)).getStyleOrigin() == StyleOrigin.USER) continue;
                    object3.applyStyle(((CalculatedValue)object6).getOrigin(), ((CalculatedValue)object6).getValue());
                    continue;
                }
                if (bl4) {
                    styleCacheEntry.put((String)object4, calculatedValue2);
                }
                object6 = cssMetaData.getStyleableProperty(node);
                object3 = object6.getStyleOrigin();
                object2 = calculatedValue2.getOrigin();
                if (object2 == null) {
                    assert (false) : object6.toString();
                    continue;
                }
                if (object3 == StyleOrigin.USER && object2 == StyleOrigin.USER_AGENT) continue;
                object = calculatedValue2.getValue();
                Object t = object6.getValue();
                if (object3 != object2 || (t != null ? !t.equals(object) : object != null)) {
                    if (LOGGER.isLoggable(PlatformLogger.Level.FINER)) {
                        LOGGER.finer((String)object4 + ", call applyStyle: " + object6 + ", value =" + String.valueOf(object) + ", originOfCalculatedValue=" + object2);
                    }
                    object6.applyStyle((StyleOrigin)((Object)object2), object);
                    if (!this.cacheContainer.cssSetProperties.containsKey(cssMetaData)) {
                        object5 = new CalculatedValue(t, (StyleOrigin)((Object)object3), false);
                        this.cacheContainer.cssSetProperties.put(cssMetaData, object5);
                    }
                }
                if (this.observableStyleMap == null) continue;
                object5 = this.getMatchingStyles(node, cssMetaData, true);
                this.observableStyleMap.put((StyleableProperty<?>)object6, (List<Style>)object5);
                continue;
            }
            catch (Exception exception) {
                styleCacheEntry.put((String)object4, null);
                object3 = null;
                object3 = StyleManager.getErrors();
                if (object3 != null) {
                    object2 = String.format("Failed to set css [%s] due to %s\n", cssMetaData, exception.getMessage());
                    object = new CssError.PropertySetError(cssMetaData, node, (String)object2);
                    object3.add(object);
                }
                if (!(object2 = Logging.getCSSLogger()).isLoggable(PlatformLogger.Level.WARNING)) continue;
                object2.warning(String.format("Failed to set css [%s]\n", cssMetaData), exception);
            }
        }
        CssError.setCurrentScene(null);
    }

    private CascadingStyle getStyle(Styleable styleable, String string, StyleMap styleMap, Set<PseudoClass> set) {
        if (styleMap == null || styleMap.isEmpty()) {
            return null;
        }
        Map<String, List<CascadingStyle>> map = styleMap.getCascadingStyles();
        if (map == null || map.isEmpty()) {
            return null;
        }
        List<CascadingStyle> list = map.get(string);
        if (list == null || list.isEmpty()) {
            return null;
        }
        CascadingStyle cascadingStyle = null;
        int n = list == null ? 0 : list.size();
        for (int i = 0; i < n; ++i) {
            Selector selector;
            CascadingStyle cascadingStyle2 = list.get(i);
            Selector selector2 = selector = cascadingStyle2 == null ? null : cascadingStyle2.getSelector();
            if (selector == null || !selector.stateMatches(styleable, set)) continue;
            cascadingStyle = cascadingStyle2;
            break;
        }
        return cascadingStyle;
    }

    private CalculatedValue lookup(Styleable styleable, CssMetaData cssMetaData, StyleMap styleMap, Set<PseudoClass> set, Styleable styleable2, CalculatedValue calculatedValue) {
        Object object;
        int n;
        if (cssMetaData.getConverter() == FontConverter.getInstance()) {
            return this.lookupFont(styleable, cssMetaData.getProperty(), styleMap, calculatedValue);
        }
        String string = cssMetaData.getProperty();
        CascadingStyle cascadingStyle = this.getStyle(styleable, string, styleMap, set);
        List<CssMetaData<Styleable, ?>> list = cssMetaData.getSubProperties();
        int n2 = n = list != null ? list.size() : 0;
        if (cascadingStyle == null) {
            Object object2;
            CssMetaData<Styleable, ?> cssMetaData2;
            if (n == 0) {
                return this.handleNoStyleFound(styleable, cssMetaData, styleMap, set, styleable2, calculatedValue);
            }
            HashMap<Object, Object> hashMap = null;
            StyleOrigin styleOrigin = null;
            boolean bl = false;
            for (int i = 0; i < n; ++i) {
                cssMetaData2 = list.get(i);
                object2 = this.lookup(styleable, cssMetaData2, styleMap, set, styleable2, calculatedValue);
                if (object2 == CalculatedValue.SKIP) continue;
                if (hashMap == null) {
                    hashMap = new HashMap<Object, Object>();
                }
                hashMap.put(cssMetaData2, ((CalculatedValue)object2).getValue());
                if (styleOrigin != null && ((CalculatedValue)object2).getOrigin() != null ? styleOrigin.compareTo(((CalculatedValue)object2).getOrigin()) < 0 : ((CalculatedValue)object2).getOrigin() != null) {
                    styleOrigin = ((CalculatedValue)object2).getOrigin();
                }
                bl = bl || ((CalculatedValue)object2).isRelative();
            }
            if (hashMap == null || hashMap.isEmpty()) {
                return this.handleNoStyleFound(styleable, cssMetaData, styleMap, set, styleable2, calculatedValue);
            }
            try {
                StyleConverter styleConverter = cssMetaData.getConverter();
                if (styleConverter instanceof StyleConverterImpl) {
                    cssMetaData2 = ((StyleConverterImpl)styleConverter).convert(hashMap);
                    return new CalculatedValue(cssMetaData2, styleOrigin, bl);
                }
                assert (false);
                return CalculatedValue.SKIP;
            }
            catch (ClassCastException classCastException) {
                cssMetaData2 = this.formatExceptionMessage(styleable, cssMetaData, null, classCastException);
                object2 = null;
                object2 = StyleManager.getErrors();
                if (object2 != null) {
                    CssError.PropertySetError propertySetError = new CssError.PropertySetError(cssMetaData, styleable, (String)((Object)cssMetaData2));
                    object2.add(propertySetError);
                }
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning((String)((Object)cssMetaData2));
                    LOGGER.fine("caught: ", classCastException);
                    LOGGER.fine("styleable = " + cssMetaData);
                    LOGGER.fine("node = " + styleable.toString());
                }
                return CalculatedValue.SKIP;
            }
        }
        if (cascadingStyle.getOrigin() == StyleOrigin.USER_AGENT && (object = cssMetaData.getStyleableProperty(styleable2)) != null && object.getStyleOrigin() == StyleOrigin.USER) {
            return CalculatedValue.SKIP;
        }
        object = cascadingStyle.getParsedValueImpl();
        if (object != null && "inherit".equals(((ParsedValue)object).getValue()) && (cascadingStyle = this.getInheritedStyle(styleable, string)) == null) {
            return CalculatedValue.SKIP;
        }
        return this.calculateValue(cascadingStyle, styleable, cssMetaData, styleMap, set, styleable2, calculatedValue);
    }

    private CalculatedValue handleNoStyleFound(Styleable styleable, CssMetaData cssMetaData, StyleMap styleMap, Set<PseudoClass> set, Styleable styleable2, CalculatedValue calculatedValue) {
        if (cssMetaData.isInherits()) {
            StyleOrigin styleOrigin;
            StyleableProperty styleableProperty = cssMetaData.getStyleableProperty(styleable);
            StyleOrigin styleOrigin2 = styleOrigin = styleableProperty != null ? styleableProperty.getStyleOrigin() : null;
            if (styleOrigin == StyleOrigin.USER) {
                return CalculatedValue.SKIP;
            }
            CascadingStyle cascadingStyle = this.getInheritedStyle(styleable, cssMetaData.getProperty());
            if (cascadingStyle == null) {
                return CalculatedValue.SKIP;
            }
            CalculatedValue calculatedValue2 = this.calculateValue(cascadingStyle, styleable, cssMetaData, styleMap, set, styleable2, calculatedValue);
            return calculatedValue2;
        }
        return CalculatedValue.SKIP;
    }

    private CascadingStyle getInheritedStyle(Styleable styleable, String string) {
        Styleable styleable2;
        Styleable styleable3 = styleable2 = styleable != null ? styleable.getStyleableParent() : null;
        while (styleable2 != null) {
            CssStyleHelper cssStyleHelper;
            CssStyleHelper cssStyleHelper2 = cssStyleHelper = styleable2 instanceof Node ? ((Node)styleable2).styleHelper : null;
            if (cssStyleHelper != null) {
                ObservableSet<PseudoClass> observableSet;
                StyleMap styleMap = cssStyleHelper.getStyleMap(styleable2);
                CascadingStyle cascadingStyle = cssStyleHelper.getStyle(styleable2, string, styleMap, observableSet = ((Node)styleable2).pseudoClassStates);
                if (cascadingStyle != null) {
                    ParsedValueImpl parsedValueImpl = cascadingStyle.getParsedValueImpl();
                    if ("inherit".equals(parsedValueImpl.getValue())) {
                        return this.getInheritedStyle(styleable2, string);
                    }
                    return cascadingStyle;
                }
                return null;
            }
            styleable2 = styleable2.getStyleableParent();
        }
        return null;
    }

    private CascadingStyle resolveRef(Styleable styleable, String string, StyleMap styleMap, Set<PseudoClass> set) {
        CascadingStyle cascadingStyle = this.getStyle(styleable, string, styleMap, set);
        if (cascadingStyle != null) {
            return cascadingStyle;
        }
        if (set != null && set.size() > 0) {
            return this.resolveRef(styleable, string, styleMap, NULL_PSEUDO_CLASS_STATE);
        }
        Styleable styleable2 = styleable.getStyleableParent();
        CssStyleHelper cssStyleHelper = null;
        if (styleable2 != null && styleable2 instanceof Node) {
            cssStyleHelper = ((Node)styleable2).styleHelper;
        }
        while (styleable2 != null && cssStyleHelper == null) {
            if ((styleable2 = styleable2.getStyleableParent()) == null || !(styleable2 instanceof Node)) continue;
            cssStyleHelper = ((Node)styleable2).styleHelper;
        }
        if (styleable2 == null || cssStyleHelper == null) {
            return null;
        }
        StyleMap styleMap2 = cssStyleHelper.getStyleMap(styleable2);
        ObservableSet<PseudoClass> observableSet = styleable2 instanceof Node ? ((Node)styleable2).pseudoClassStates : styleable.getPseudoClassStates();
        return cssStyleHelper.resolveRef(styleable2, string, styleMap2, observableSet);
    }

    private ParsedValueImpl resolveLookups(Styleable styleable, ParsedValueImpl parsedValueImpl, StyleMap styleMap, Set<PseudoClass> set, ObjectProperty<StyleOrigin> objectProperty, Set<ParsedValue> set2) {
        ParsedValueImpl[][] parsedValueImplArray;
        ParsedValueImpl[][] parsedValueImplArray2;
        Object v;
        if (parsedValueImpl.isLookup() && (v = parsedValueImpl.getValue()) instanceof String && (parsedValueImplArray2 = this.resolveRef(styleable, (String)(parsedValueImplArray = (ParsedValueImpl[][])v), styleMap, set)) != null) {
            if (set2.contains(parsedValueImplArray2.getParsedValueImpl())) {
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning("Loop detected in " + parsedValueImplArray2.getRule().toString() + " while resolving '" + (String)parsedValueImplArray + "'");
                }
                throw new IllegalArgumentException("Loop detected in " + parsedValueImplArray2.getRule().toString() + " while resolving '" + (String)parsedValueImplArray + "'");
            }
            set2.add(parsedValueImpl);
            StyleOrigin styleOrigin = (StyleOrigin)((Object)objectProperty.get());
            StyleOrigin styleOrigin2 = parsedValueImplArray2.getOrigin();
            if (styleOrigin2 != null && (styleOrigin == null || styleOrigin.compareTo(styleOrigin2) < 0)) {
                objectProperty.set(styleOrigin2);
            }
            ParsedValueImpl parsedValueImpl2 = this.resolveLookups(styleable, parsedValueImplArray2.getParsedValueImpl(), styleMap, set, objectProperty, set2);
            if (set2 != null) {
                set2.remove(parsedValueImpl);
            }
            return parsedValueImpl2;
        }
        if (!parsedValueImpl.isContainsLookups()) {
            return parsedValueImpl;
        }
        v = parsedValueImpl.getValue();
        if (v instanceof ParsedValueImpl[][]) {
            parsedValueImplArray = (ParsedValueImpl[][])v;
            parsedValueImplArray2 = new ParsedValueImpl[parsedValueImplArray.length][0];
            for (int i = 0; i < parsedValueImplArray.length; ++i) {
                parsedValueImplArray2[i] = new ParsedValueImpl[parsedValueImplArray[i].length];
                for (int j = 0; j < parsedValueImplArray[i].length; ++j) {
                    if (parsedValueImplArray[i][j] == null) continue;
                    parsedValueImplArray2[i][j] = this.resolveLookups(styleable, parsedValueImplArray[i][j], styleMap, set, objectProperty, set2);
                }
            }
            set2.clear();
            return new ParsedValueImpl(parsedValueImplArray2, parsedValueImpl.getConverter(), false);
        }
        if (v instanceof ParsedValueImpl[]) {
            parsedValueImplArray = (ParsedValueImpl[])v;
            parsedValueImplArray2 = new ParsedValueImpl[parsedValueImplArray.length];
            for (int i = 0; i < parsedValueImplArray.length; ++i) {
                if (parsedValueImplArray[i] == null) continue;
                parsedValueImplArray2[i] = this.resolveLookups(styleable, (ParsedValueImpl)parsedValueImplArray[i], styleMap, set, objectProperty, set2);
            }
            set2.clear();
            return new ParsedValueImpl(parsedValueImplArray2, parsedValueImpl.getConverter(), false);
        }
        return parsedValueImpl;
    }

    private String getUnresolvedLookup(ParsedValueImpl parsedValueImpl) {
        block5: {
            Object v;
            block4: {
                v = parsedValueImpl.getValue();
                if (parsedValueImpl.isLookup() && v instanceof String) {
                    return (String)v;
                }
                if (!(v instanceof ParsedValueImpl[][])) break block4;
                ParsedValueImpl[][] parsedValueImplArray = (ParsedValueImpl[][])v;
                for (int i = 0; i < parsedValueImplArray.length; ++i) {
                    for (int j = 0; j < parsedValueImplArray[i].length; ++j) {
                        String string;
                        if (parsedValueImplArray[i][j] == null || (string = this.getUnresolvedLookup(parsedValueImplArray[i][j])) == null) continue;
                        return string;
                    }
                }
                break block5;
            }
            if (!(v instanceof ParsedValueImpl[])) break block5;
            ParsedValueImpl[] parsedValueImplArray = (ParsedValueImpl[])v;
            for (int i = 0; i < parsedValueImplArray.length; ++i) {
                String string;
                if (parsedValueImplArray[i] == null || (string = this.getUnresolvedLookup(parsedValueImplArray[i])) == null) continue;
                return string;
            }
        }
        return null;
    }

    private String formatUnresolvedLookupMessage(Styleable styleable, CssMetaData cssMetaData, Style style, ParsedValueImpl parsedValueImpl) {
        String string;
        String string2;
        String string3 = string2 = parsedValueImpl != null ? this.getUnresolvedLookup(parsedValueImpl) : null;
        if (string2 == null) {
            string2 = "a lookup value";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Could not resolve '").append(string2).append("'").append(" while resolving lookups for '").append(cssMetaData.getProperty()).append("'");
        Rule rule = style != null ? style.getDeclaration().getRule() : null;
        Stylesheet stylesheet = rule != null ? rule.getStylesheet() : null;
        String string4 = string = stylesheet != null ? stylesheet.getUrl() : null;
        if (string != null) {
            stringBuilder.append(" from rule '").append(style.getSelector()).append("' in stylesheet ").append(string);
        } else if (stylesheet != null && StyleOrigin.INLINE == stylesheet.getOrigin()) {
            stringBuilder.append(" from inline style on ").append(styleable.toString());
        }
        return stringBuilder.toString();
    }

    private String formatExceptionMessage(Styleable styleable, CssMetaData cssMetaData, Style style, Exception exception) {
        String string;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Caught ").append(exception.toString()).append("'").append(" while calculating value for '").append(cssMetaData.getProperty()).append("'");
        Rule rule = style != null ? style.getDeclaration().getRule() : null;
        Stylesheet stylesheet = rule != null ? rule.getStylesheet() : null;
        String string2 = string = stylesheet != null ? stylesheet.getUrl() : null;
        if (string != null) {
            stringBuilder.append(" from rule '").append(style.getSelector()).append("' in stylesheet ").append(string);
        } else if (stylesheet != null && StyleOrigin.INLINE == stylesheet.getOrigin()) {
            stringBuilder.append(" from inline style on ").append(styleable.toString());
        }
        return stringBuilder.toString();
    }

    private CalculatedValue calculateValue(CascadingStyle cascadingStyle, Styleable styleable, CssMetaData cssMetaData, StyleMap styleMap, Set<PseudoClass> set, Styleable styleable2, CalculatedValue calculatedValue) {
        ParsedValueImpl parsedValueImpl = cascadingStyle.getParsedValueImpl();
        if (parsedValueImpl != null && !"null".equals(parsedValueImpl.getValue())) {
            ParsedValueImpl parsedValueImpl2 = null;
            try {
                Object object;
                SimpleObjectProperty<StyleOrigin> simpleObjectProperty = new SimpleObjectProperty<StyleOrigin>(cascadingStyle.getOrigin());
                parsedValueImpl2 = this.resolveLookups(styleable, parsedValueImpl, styleMap, set, simpleObjectProperty, new HashSet<ParsedValue>());
                String string = cssMetaData.getProperty();
                Object var12_18 = null;
                boolean bl = "-fx-font".equals(string) || "-fx-font-size".equals(string);
                boolean bl2 = ParsedValueImpl.containsFontRelativeSize(parsedValueImpl2, bl);
                Font font = null;
                if (bl2 && bl && (calculatedValue == null || calculatedValue.isRelative())) {
                    object = styleable;
                    CalculatedValue calculatedValue2 = calculatedValue;
                    do {
                        CalculatedValue calculatedValue3;
                        if ((calculatedValue3 = this.getCachedFont(object.getStyleableParent())) == null) continue;
                        if (calculatedValue3.isRelative()) {
                            if (calculatedValue2 == null || calculatedValue3.equals(calculatedValue2)) {
                                calculatedValue2 = calculatedValue3;
                                continue;
                            }
                            font = (Font)calculatedValue3.getValue();
                            continue;
                        }
                        font = (Font)calculatedValue3.getValue();
                    } while (font == null && (object = object.getStyleableParent()) != null);
                }
                if (font == null) {
                    font = calculatedValue != null && !calculatedValue.isRelative() ? (Font)calculatedValue.getValue() : Font.getDefault();
                }
                var12_18 = parsedValueImpl2.getConverter() != null ? parsedValueImpl2.convert(font) : cssMetaData.getConverter().convert(parsedValueImpl2, font);
                object = (StyleOrigin)((Object)simpleObjectProperty.get());
                return new CalculatedValue(var12_18, (StyleOrigin)((Object)object), bl2);
            }
            catch (ClassCastException classCastException) {
                String string = this.formatUnresolvedLookupMessage(styleable, cssMetaData, cascadingStyle.getStyle(), parsedValueImpl2);
                ObservableList<CssError> observableList = null;
                observableList = StyleManager.getErrors();
                if (observableList != null) {
                    CssError.PropertySetError propertySetError = new CssError.PropertySetError(cssMetaData, styleable, string);
                    observableList.add(propertySetError);
                }
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning(string);
                    LOGGER.fine("node = " + styleable.toString());
                    LOGGER.fine("cssMetaData = " + cssMetaData);
                    LOGGER.fine("styles = " + this.getMatchingStyles(styleable, cssMetaData));
                }
                return CalculatedValue.SKIP;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                String string = this.formatExceptionMessage(styleable, cssMetaData, cascadingStyle.getStyle(), illegalArgumentException);
                ObservableList<CssError> observableList = null;
                observableList = StyleManager.getErrors();
                if (observableList != null) {
                    CssError.PropertySetError propertySetError = new CssError.PropertySetError(cssMetaData, styleable, string);
                    observableList.add(propertySetError);
                }
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning(string);
                    LOGGER.fine("caught: ", illegalArgumentException);
                    LOGGER.fine("styleable = " + cssMetaData);
                    LOGGER.fine("node = " + styleable.toString());
                }
                return CalculatedValue.SKIP;
            }
            catch (NullPointerException nullPointerException) {
                String string = this.formatExceptionMessage(styleable, cssMetaData, cascadingStyle.getStyle(), nullPointerException);
                ObservableList<CssError> observableList = null;
                observableList = StyleManager.getErrors();
                if (observableList != null) {
                    CssError.PropertySetError propertySetError = new CssError.PropertySetError(cssMetaData, styleable, string);
                    observableList.add(propertySetError);
                }
                if (LOGGER.isLoggable(PlatformLogger.Level.WARNING)) {
                    LOGGER.warning(string);
                    LOGGER.fine("caught: ", nullPointerException);
                    LOGGER.fine("styleable = " + cssMetaData);
                    LOGGER.fine("node = " + styleable.toString());
                }
                return CalculatedValue.SKIP;
            }
        }
        return new CalculatedValue(null, cascadingStyle.getOrigin(), false);
    }

    private CalculatedValue getCachedFont(Styleable styleable) {
        if (!(styleable instanceof Node)) {
            return null;
        }
        CalculatedValue calculatedValue = null;
        Node node = (Node)styleable;
        CssStyleHelper cssStyleHelper = node.styleHelper;
        if (cssStyleHelper == null || cssStyleHelper.cacheContainer == null) {
            calculatedValue = this.getCachedFont(node.getStyleableParent());
        } else {
            CacheContainer cacheContainer = cssStyleHelper.cacheContainer;
            if (cacheContainer != null && cacheContainer.fontSizeCache != null && !cacheContainer.fontSizeCache.isEmpty()) {
                Set<PseudoClass>[] setArray = cssStyleHelper.getTransitionStates(node);
                StyleCacheEntry.Key key = new StyleCacheEntry.Key(setArray, Font.getDefault());
                calculatedValue = (CalculatedValue)cacheContainer.fontSizeCache.get(key);
            } else {
                ObservableSet<PseudoClass> observableSet = node.getPseudoClassStates();
                StyleMap styleMap = cssStyleHelper.getStyleMap(node);
                calculatedValue = cssStyleHelper.lookup(node, dummyFontProperty, styleMap, observableSet, node, null);
            }
        }
        return calculatedValue;
    }

    FontPosture getFontPosture(Font font) {
        if (font == null) {
            return FontPosture.REGULAR;
        }
        String string = font.getName().toLowerCase(Locale.ROOT);
        if (string.contains("italic")) {
            return FontPosture.ITALIC;
        }
        return FontPosture.REGULAR;
    }

    FontWeight getFontWeight(Font font) {
        if (font == null) {
            return FontWeight.NORMAL;
        }
        String string = font.getName().toLowerCase(Locale.ROOT);
        if (string.contains("bold")) {
            if (string.contains("extra")) {
                return FontWeight.EXTRA_BOLD;
            }
            if (string.contains("ultra")) {
                return FontWeight.EXTRA_BOLD;
            }
            if (string.contains("semi")) {
                return FontWeight.SEMI_BOLD;
            }
            if (string.contains("demi")) {
                return FontWeight.SEMI_BOLD;
            }
            return FontWeight.BOLD;
        }
        if (string.contains("light")) {
            if (string.contains("extra")) {
                return FontWeight.EXTRA_LIGHT;
            }
            if (string.contains("ultra")) {
                return FontWeight.EXTRA_LIGHT;
            }
            return FontWeight.LIGHT;
        }
        if (string.contains("black")) {
            return FontWeight.BLACK;
        }
        if (string.contains("heavy")) {
            return FontWeight.BLACK;
        }
        if (string.contains("medium")) {
            return FontWeight.MEDIUM;
        }
        return FontWeight.NORMAL;
    }

    String getFontFamily(Font font) {
        if (font == null) {
            return Font.getDefault().getFamily();
        }
        return font.getFamily();
    }

    Font deriveFont(Font font, String string, FontWeight fontWeight, FontPosture fontPosture, double d) {
        if (font != null && string == null) {
            string = this.getFontFamily(font);
        } else if (string != null) {
            string = Utils.stripQuotes(string);
        }
        if (font != null && fontWeight == null) {
            fontWeight = this.getFontWeight(font);
        }
        if (font != null && fontPosture == null) {
            fontPosture = this.getFontPosture(font);
        }
        if (font != null && d <= 0.0) {
            d = font.getSize();
        }
        return Font.font(string, fontWeight, fontPosture, d);
    }

    CalculatedValue lookupFont(Styleable styleable, String string, StyleMap styleMap, CalculatedValue calculatedValue) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        ObservableSet<PseudoClass> observableSet;
        StyleOrigin styleOrigin = null;
        int n = 0;
        boolean bl = false;
        String string2 = null;
        double d = -1.0;
        FontWeight fontWeight = null;
        FontPosture fontPosture = null;
        Object object8 = calculatedValue;
        ObservableSet<PseudoClass> observableSet2 = observableSet = styleable instanceof Node ? ((Node)styleable).pseudoClassStates : styleable.getPseudoClassStates();
        if (this.cacheContainer.fontProp != null && (object7 = (object6 = this.cacheContainer.fontProp.getStyleableProperty(styleable)).getStyleOrigin()) == StyleOrigin.USER) {
            styleOrigin = object7;
            object5 = (Font)object6.getValue();
            if (object5 == null) {
                object5 = Font.getDefault();
            }
            string2 = this.getFontFamily((Font)object5);
            d = ((Font)object5).getSize();
            fontWeight = this.getFontWeight((Font)object5);
            fontPosture = this.getFontPosture((Font)object5);
            object8 = new CalculatedValue(object5, (StyleOrigin)((Object)object7), false);
        }
        if ((object6 = this.getStyle(styleable, string, styleMap, observableSet)) == null && styleOrigin != StyleOrigin.USER) {
            Object object9 = object7 = styleable != null ? styleable.getStyleableParent() : null;
            while (object7 != null) {
                Object object10 = object5 = object7 instanceof Node ? ((Node)object7).styleHelper : null;
                if (object5 != null) {
                    ++n;
                    object4 = super.getStyleMap((Styleable)object7);
                    object2 = super.getStyle((Styleable)object7, string, (StyleMap)object4, (Set<PseudoClass>)(object3 = ((Node)object7).pseudoClassStates));
                    if (object2 != null && !"inherit".equals(((ParsedValue)(object = ((CascadingStyle)object2).getParsedValueImpl())).getValue())) {
                        object6 = object2;
                        break;
                    }
                }
                object7 = object7.getStyleableParent();
            }
        }
        if (object6 != null && (styleOrigin == null || styleOrigin.compareTo(((CascadingStyle)object6).getOrigin()) <= 0) && ((CalculatedValue)(object7 = this.calculateValue((CascadingStyle)object6, styleable, dummyFontProperty, styleMap, observableSet, styleable, (CalculatedValue)object8))).getValue() instanceof Font) {
            styleOrigin = ((CalculatedValue)object7).getOrigin();
            object5 = (Font)((CalculatedValue)object7).getValue();
            string2 = this.getFontFamily((Font)object5);
            d = ((Font)object5).getSize();
            fontWeight = this.getFontWeight((Font)object5);
            fontPosture = this.getFontPosture((Font)object5);
            object8 = object7;
            bl = true;
        }
        if ((object7 = this.getStyle(styleable, string.concat("-size"), styleMap, observableSet)) != null) {
            if (object6 != null && ((CascadingStyle)object6).compareTo((CascadingStyle)object7) < 0) {
                object7 = null;
            }
        } else if (styleOrigin != StyleOrigin.USER) {
            object7 = this.lookupInheritedFontProperty(styleable, string.concat("-size"), styleMap, n, (CascadingStyle)object6);
        }
        if (object7 != null && ((CalculatedValue)(object5 = this.calculateValue((CascadingStyle)object7, styleable, dummyFontProperty, styleMap, observableSet, styleable, (CalculatedValue)object8))).getValue() instanceof Double) {
            boolean bl2;
            if (styleOrigin == null || styleOrigin.compareTo(((CascadingStyle)object7).getOrigin()) <= 0) {
                styleOrigin = ((CalculatedValue)object5).getOrigin();
            }
            d = (Double)((CalculatedValue)object5).getValue();
            if (object8 != null) {
                bl2 = ((CalculatedValue)object8).isRelative() || ((CalculatedValue)object5).isRelative();
                object3 = this.deriveFont((Font)((CalculatedValue)object8).getValue(), string2, fontWeight, fontPosture, d);
                object8 = new CalculatedValue(object3, styleOrigin, bl2);
            } else {
                bl2 = ((CalculatedValue)object5).isRelative();
                object3 = this.deriveFont(Font.getDefault(), string2, fontWeight, fontPosture, d);
                object8 = new CalculatedValue(object3, styleOrigin, bl2);
            }
            bl = true;
        }
        if (calculatedValue == null) {
            return object8 != null ? object8 : CalculatedValue.SKIP;
        }
        object5 = this.getStyle(styleable, string.concat("-weight"), styleMap, observableSet);
        if (object5 != null) {
            if (object6 != null && ((CascadingStyle)object6).compareTo((CascadingStyle)object5) < 0) {
                object5 = null;
            }
        } else if (styleOrigin != StyleOrigin.USER) {
            object5 = this.lookupInheritedFontProperty(styleable, string.concat("-weight"), styleMap, n, (CascadingStyle)object6);
        }
        if (object5 != null && ((CalculatedValue)(object4 = this.calculateValue((CascadingStyle)object5, styleable, dummyFontProperty, styleMap, observableSet, styleable, null))).getValue() instanceof FontWeight) {
            if (styleOrigin == null || styleOrigin.compareTo(((CascadingStyle)object5).getOrigin()) <= 0) {
                styleOrigin = ((CalculatedValue)object4).getOrigin();
            }
            fontWeight = (FontWeight)((Object)((CalculatedValue)object4).getValue());
            bl = true;
        }
        if ((object4 = this.getStyle(styleable, string.concat("-style"), styleMap, observableSet)) != null) {
            if (object6 != null && ((CascadingStyle)object6).compareTo((CascadingStyle)object4) < 0) {
                object4 = null;
            }
        } else if (styleOrigin != StyleOrigin.USER) {
            object4 = this.lookupInheritedFontProperty(styleable, string.concat("-style"), styleMap, n, (CascadingStyle)object6);
        }
        if (object4 != null && ((CalculatedValue)(object3 = this.calculateValue((CascadingStyle)object4, styleable, dummyFontProperty, styleMap, observableSet, styleable, null))).getValue() instanceof FontPosture) {
            if (styleOrigin == null || styleOrigin.compareTo(((CascadingStyle)object4).getOrigin()) <= 0) {
                styleOrigin = ((CalculatedValue)object3).getOrigin();
            }
            fontPosture = (FontPosture)((Object)((CalculatedValue)object3).getValue());
            bl = true;
        }
        if ((object3 = this.getStyle(styleable, string.concat("-family"), styleMap, observableSet)) != null) {
            if (object6 != null && ((CascadingStyle)object6).compareTo((CascadingStyle)object3) < 0) {
                object3 = null;
            }
        } else if (styleOrigin != StyleOrigin.USER) {
            object3 = this.lookupInheritedFontProperty(styleable, string.concat("-family"), styleMap, n, (CascadingStyle)object6);
        }
        if (object3 != null && ((CalculatedValue)(object2 = this.calculateValue((CascadingStyle)object3, styleable, dummyFontProperty, styleMap, observableSet, styleable, null))).getValue() instanceof String) {
            if (styleOrigin == null || styleOrigin.compareTo(((CascadingStyle)object3).getOrigin()) <= 0) {
                styleOrigin = ((CalculatedValue)object2).getOrigin();
            }
            string2 = (String)((CalculatedValue)object2).getValue();
            bl = true;
        }
        if (bl) {
            object2 = object8 != null ? (Font)((CalculatedValue)object8).getValue() : Font.getDefault();
            object = this.deriveFont((Font)object2, string2, fontWeight, fontPosture, d);
            return new CalculatedValue(object, styleOrigin, false);
        }
        return CalculatedValue.SKIP;
    }

    private CascadingStyle lookupInheritedFontProperty(Styleable styleable, String string, StyleMap styleMap, int n, CascadingStyle cascadingStyle) {
        int n2 = n;
        for (Styleable styleable2 = styleable != null ? styleable.getStyleableParent() : null; styleable2 != null && n2 > 0; styleable2 = styleable2.getStyleableParent()) {
            ObservableSet<PseudoClass> observableSet;
            CssStyleHelper cssStyleHelper;
            CssStyleHelper cssStyleHelper2 = cssStyleHelper = styleable2 instanceof Node ? ((Node)styleable2).styleHelper : null;
            if (cssStyleHelper == null) continue;
            --n2;
            StyleMap styleMap2 = cssStyleHelper.getStyleMap(styleable2);
            CascadingStyle cascadingStyle2 = cssStyleHelper.getStyle(styleable2, string, styleMap2, observableSet = ((Node)styleable2).pseudoClassStates);
            if (cascadingStyle2 == null) continue;
            if (cascadingStyle != null && n2 == 0 && cascadingStyle.compareTo(cascadingStyle2) < 0) {
                return null;
            }
            ParsedValueImpl parsedValueImpl = cascadingStyle2.getParsedValueImpl();
            if ("inherit".equals(parsedValueImpl.getValue())) continue;
            return cascadingStyle2;
        }
        return null;
    }

    List<Style> getMatchingStyles(Styleable styleable, CssMetaData cssMetaData) {
        return this.getMatchingStyles(styleable, cssMetaData, false);
    }

    List<Style> getMatchingStyles(Styleable styleable, CssMetaData cssMetaData, boolean bl) {
        int n;
        ArrayList<CascadingStyle> arrayList = new ArrayList<CascadingStyle>();
        this.getMatchingStyles(styleable, cssMetaData, arrayList, bl);
        List<CssMetaData<Styleable, ?>> list = cssMetaData.getSubProperties();
        if (list != null) {
            n = list.size();
            for (int i = 0; i < n; ++i) {
                CssMetaData<Styleable, ?> cssMetaData2 = list.get(i);
                this.getMatchingStyles(styleable, cssMetaData2, arrayList, bl);
            }
        }
        Collections.sort(arrayList);
        ArrayList<Style> arrayList2 = new ArrayList<Style>(arrayList.size());
        int n2 = arrayList.size();
        for (n = 0; n < n2; ++n) {
            Style style = ((CascadingStyle)arrayList.get(n)).getStyle();
            if (arrayList2.contains(style)) continue;
            arrayList2.add(style);
        }
        return arrayList2;
    }

    private void getMatchingStyles(Styleable styleable, CssMetaData cssMetaData, List<CascadingStyle> list, boolean bl) {
        if (styleable != null) {
            List<CascadingStyle> list2;
            Map<String, List<CascadingStyle>> map;
            String string = cssMetaData.getProperty();
            Node node = styleable instanceof Node ? (Node)styleable : null;
            StyleMap styleMap = this.getStyleMap(node);
            if (styleMap == null) {
                return;
            }
            if (bl) {
                map = this.getStyle(styleable, cssMetaData.getProperty(), styleMap, node.pseudoClassStates);
                if (map != null) {
                    list.add((CascadingStyle)((Object)map));
                    list2 = ((CascadingStyle)((Object)map)).getParsedValueImpl();
                    this.getMatchingLookupStyles(styleable, (ParsedValueImpl)((Object)list2), list, bl);
                }
            } else {
                map = styleMap.getCascadingStyles();
                list2 = map.get(string);
                if (list2 != null) {
                    list.addAll(list2);
                    int n = list2.size();
                    for (int i = 0; i < n; ++i) {
                        CascadingStyle cascadingStyle = (CascadingStyle)list2.get(i);
                        ParsedValueImpl parsedValueImpl = cascadingStyle.getParsedValueImpl();
                        this.getMatchingLookupStyles(styleable, parsedValueImpl, list, bl);
                    }
                }
            }
            if (cssMetaData.isInherits()) {
                for (map = styleable.getStyleableParent(); map != null; map = map.getStyleableParent()) {
                    List<CascadingStyle> list3 = list2 = map instanceof Node ? ((Node)((Object)map)).styleHelper : null;
                    if (list2 == null) continue;
                    super.getMatchingStyles((Styleable)((Object)map), cssMetaData, list, bl);
                }
            }
        }
    }

    private void getMatchingLookupStyles(Styleable styleable, ParsedValueImpl parsedValueImpl, List<CascadingStyle> list, boolean bl) {
        block12: {
            ParsedValueImpl[][] parsedValueImplArray;
            Object v;
            block11: {
                if (parsedValueImpl.isLookup() && (v = parsedValueImpl.getValue()) instanceof String) {
                    parsedValueImplArray = (ParsedValueImpl[][])v;
                    Styleable styleable2 = styleable;
                    do {
                        Map<String, List<CascadingStyle>> map;
                        CssStyleHelper cssStyleHelper;
                        StyleMap styleMap;
                        if ((styleMap = this.getStyleMap(styleable2)) == null || styleMap.isEmpty()) continue;
                        Node node = styleable2 instanceof Node ? (Node)styleable2 : null;
                        CssStyleHelper cssStyleHelper2 = cssStyleHelper = node != null ? node.styleHelper : null;
                        if (cssStyleHelper == null) continue;
                        int n = list.size();
                        if (bl) {
                            map = cssStyleHelper.resolveRef(node, (String)parsedValueImplArray, styleMap, node.pseudoClassStates);
                            if (map != null) {
                                list.add((CascadingStyle)((Object)map));
                            }
                        } else {
                            map = styleMap.getCascadingStyles();
                            List<CascadingStyle> list2 = map.get(parsedValueImplArray);
                            if (list2 != null) {
                                list.addAll(list2);
                            }
                        }
                        int n2 = list.size();
                        for (int i = n; i < n2; ++i) {
                            CascadingStyle cascadingStyle = list.get(i);
                            this.getMatchingLookupStyles(styleable2, cascadingStyle.getParsedValueImpl(), list, bl);
                        }
                    } while ((styleable2 = styleable2.getStyleableParent()) != null);
                }
                if (!parsedValueImpl.isContainsLookups()) {
                    return;
                }
                v = parsedValueImpl.getValue();
                if (!(v instanceof ParsedValueImpl[][])) break block11;
                parsedValueImplArray = (ParsedValueImpl[][])v;
                for (int i = 0; i < parsedValueImplArray.length; ++i) {
                    for (int j = 0; j < parsedValueImplArray[i].length; ++j) {
                        if (parsedValueImplArray[i][j] == null) continue;
                        this.getMatchingLookupStyles(styleable, parsedValueImplArray[i][j], list, bl);
                    }
                }
                break block12;
            }
            if (!(v instanceof ParsedValueImpl[])) break block12;
            parsedValueImplArray = (ParsedValueImpl[])v;
            for (int i = 0; i < parsedValueImplArray.length; ++i) {
                if (parsedValueImplArray[i] == null) continue;
                this.getMatchingLookupStyles(styleable, (ParsedValueImpl)parsedValueImplArray[i], list, bl);
            }
        }
    }

    private static final class CacheContainer {
        private final StyleCache.Key styleCacheKey;
        private final CssMetaData<Styleable, Font> fontProp;
        private final int smapId;
        private final Map<StyleCacheEntry.Key, CalculatedValue> fontSizeCache;
        private Map<CssMetaData, CalculatedValue> cssSetProperties;

        private CacheContainer(Node node, StyleMap styleMap, int n) {
            List<CssMetaData<? extends Styleable, ?>> list;
            int n2 = 0;
            int[] nArray = new int[n];
            nArray[n2++] = this.smapId = styleMap.getId();
            Styleable styleable = node.getStyleableParent();
            for (int i = 1; i < n; ++i) {
                if (styleable instanceof Node) {
                    list = (Node)styleable;
                    CssStyleHelper cssStyleHelper = ((Node)((Object)list)).styleHelper;
                    if (cssStyleHelper != null && cssStyleHelper.cacheContainer != null) {
                        nArray[n2++] = ((CssStyleHelper)cssStyleHelper).cacheContainer.smapId;
                    }
                }
                styleable = styleable.getStyleableParent();
            }
            this.styleCacheKey = new StyleCache.Key(nArray, n2);
            CssMetaData cssMetaData = null;
            list = node.getCssMetaData();
            int n3 = list != null ? list.size() : 0;
            for (int i = 0; i < n3; ++i) {
                CssMetaData cssMetaData2 = (CssMetaData)list.get(i);
                if (!"-fx-font".equals(cssMetaData2.getProperty())) continue;
                cssMetaData = cssMetaData2;
                break;
            }
            this.fontProp = cssMetaData;
            this.fontSizeCache = new HashMap<StyleCacheEntry.Key, CalculatedValue>();
            this.cssSetProperties = new HashMap<CssMetaData, CalculatedValue>();
        }

        private StyleMap getStyleMap(Styleable styleable) {
            if (styleable != null) {
                return StyleManager.getInstance().getStyleMap(styleable, this.smapId);
            }
            return StyleMap.EMPTY_MAP;
        }
    }
}

