/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.tk.quantum;

import com.sun.javafx.logging.PulseLogger;
import com.sun.javafx.tk.quantum.QuantumToolkit;
import com.sun.javafx.tk.quantum.ViewPainter;
import com.sun.javafx.tk.quantum.ViewScene;
import com.sun.prism.Graphics;
import com.sun.prism.GraphicsPipeline;
import com.sun.prism.impl.Disposer;
import com.sun.prism.impl.ManagedResource;

final class PresentingPainter
extends ViewPainter {
    PresentingPainter(ViewScene viewScene) {
        super(viewScene);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        renderLock.lock();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            bl2 = this.validateStageGraphics();
            if (!bl2) {
                if (QuantumToolkit.verbose) {
                    System.err.println("PresentingPainter: validateStageGraphics failed");
                }
                return;
            }
            this.sceneState.lock();
            bl = true;
            if (this.factory == null) {
                this.factory = GraphicsPipeline.getDefaultResourceFactory();
            }
            if (this.factory == null || !this.factory.isDeviceReady()) {
                this.sceneState.getScene().entireSceneNeedsRepaint();
                return;
            }
            if (this.presentable != null && this.presentable.lockResources(this.sceneState)) {
                this.disposePresentable();
            }
            if (this.presentable == null) {
                this.presentable = this.factory.createPresentable(this.sceneState);
                this.penWidth = this.viewWidth;
                this.penHeight = this.viewHeight;
            }
            if (this.presentable != null) {
                long l;
                Graphics graphics = this.presentable.createGraphics();
                ViewScene viewScene = (ViewScene)this.sceneState.getScene();
                if (graphics != null) {
                    this.paintImpl(graphics);
                }
                long l2 = l = PulseLogger.PULSE_LOGGING_ENABLED ? System.currentTimeMillis() : 0L;
                if (!this.presentable.prepare(null)) {
                    this.disposePresentable();
                    this.sceneState.getScene().entireSceneNeedsRepaint();
                    if (PulseLogger.PULSE_LOGGING_ENABLED) {
                        PulseLogger.PULSE_LOGGER.renderMessage(l, System.currentTimeMillis(), "Presentable.prepare");
                    }
                    return;
                }
                long l3 = l = PulseLogger.PULSE_LOGGING_ENABLED ? System.currentTimeMillis() : 0L;
                if (viewScene.getDoPresent()) {
                    if (!this.presentable.present()) {
                        this.disposePresentable();
                        this.sceneState.getScene().entireSceneNeedsRepaint();
                    }
                    if (PulseLogger.PULSE_LOGGING_ENABLED) {
                        PulseLogger.PULSE_LOGGER.renderMessage(l, System.currentTimeMillis(), "Presentable.present");
                    }
                }
            }
        }
        catch (Throwable throwable) {
            bl3 = true;
            throwable.printStackTrace(System.err);
        }
        finally {
            if (bl2) {
                Disposer.cleanUp();
            }
            if (bl) {
                this.sceneState.unlock();
            }
            ViewScene viewScene = (ViewScene)this.sceneState.getScene();
            viewScene.setPainting(false);
            ManagedResource.freeDisposalRequestedAndCheckResources(bl3);
            renderLock.unlock();
            if (PulseLogger.PULSE_LOGGING_ENABLED) {
                PulseLogger.PULSE_LOGGER.renderMessage(System.currentTimeMillis(), System.currentTimeMillis(), "Finished Presenting Painter");
            }
        }
    }
}

