/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.Logging;
import com.sun.javafx.application.PlatformImpl;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.ContainerTabOrder;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.Hueristic2D;
import com.sun.javafx.scene.traversal.TraverseListener;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import sun.util.logging.PlatformLogger;

public class TraversalEngine {
    private final Algorithm algorithm;
    private final Parent root;
    private final boolean isScene;
    private final Bounds initialBounds;
    public final List<Node> registeredNodes;
    private final List<TraverseListener> listeners;
    PlatformLogger focusLogger;

    protected boolean isScene() {
        return this.isScene;
    }

    protected Parent getRoot() {
        return this.root;
    }

    public TraversalEngine(Parent parent, boolean bl) {
        this.root = parent;
        this.isScene = bl;
        this.algorithm = PlatformImpl.isContextual2DNavigation() ? new Hueristic2D() : new ContainerTabOrder();
        this.initialBounds = new BoundingBox(0.0, 0.0, 1.0, 1.0);
        this.registeredNodes = new ArrayList<Node>();
        this.listeners = new LinkedList<TraverseListener>();
        this.focusLogger = Logging.getFocusLogger();
        if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
            this.focusLogger.finer("TraversalEngine constructor");
        }
    }

    public void addTraverseListener(TraverseListener traverseListener) {
        this.listeners.add(traverseListener);
    }

    public void removeTraverseListener(TraverseListener traverseListener) {
        this.listeners.remove(traverseListener);
    }

    public void reg(Node node) {
        this.registeredNodes.add(node);
    }

    public void unreg(Node node) {
        this.registeredNodes.remove(node);
    }

    public void trav(Node node, Direction direction) {
        Node node2 = this.algorithm.traverse(node, direction, this);
        if (node2 == null) {
            if (this.focusLogger.isLoggable(PlatformLogger.Level.FINE)) {
                this.focusLogger.fine("new node is null, focus not moved");
            }
        } else {
            if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
                this.focusLogger.finer("new focus owner : " + node2);
            }
            node2.requestFocus();
            for (TraverseListener traverseListener : this.listeners) {
                traverseListener.onTraverse(node2, this.getBounds(node2));
            }
        }
    }

    public int getTopLeftFocusableNode() {
        List<Node> list = this.getAllTargetNodes();
        Point2D point2D = new Point2D(0.0, 0.0);
        if (list.size() > 0) {
            Node node = list.get(0);
            double d = point2D.distance(this.getBounds(list.get(0)).getMinX(), this.getBounds(list.get(0)).getMinY());
            for (int i = 1; i < list.size(); ++i) {
                double d2;
                if (this.focusLogger.isLoggable(PlatformLogger.Level.FINEST)) {
                    this.focusLogger.finest("getTopLeftFocusableNode(), distance : " + point2D.distance(this.getBounds(list.get(i)).getMinX(), this.getBounds(list.get(i)).getMinY()) + " to  : " + list.get(i) + ". @ : " + this.getBounds(list.get(i)).getMinX() + ":" + this.getBounds(list.get(i)).getMinY());
                }
                if (!(d > (d2 = point2D.distance(this.getBounds(list.get(i)).getMinX(), this.getBounds(list.get(i)).getMinY())))) continue;
                d = d2;
                node = list.get(i);
            }
            if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
                this.focusLogger.finer("getTopLeftFocusableNode(), nearest  : " + node + ", at : " + d);
            }
            node.requestFocus();
            for (TraverseListener traverseListener : this.listeners) {
                traverseListener.onTraverse(node, this.getBounds(node));
            }
        }
        list.clear();
        return 0;
    }

    protected List<Node> getAllTargetNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        Scene scene = this.root.getScene();
        this.addFocusableChildrenToList(arrayList, scene.getRoot());
        return arrayList;
    }

    private void addFocusableChildrenToList(List<Node> list, Parent parent) {
        ObservableList<Node> observableList = parent.getChildrenUnmodifiable();
        for (Node node : observableList) {
            if (node.isFocusTraversable() && !node.isFocused() && node.impl_isTreeVisible() && !node.isDisabled()) {
                list.add(node);
            }
            if (!(node instanceof Parent)) continue;
            this.addFocusableChildrenToList(list, (Parent)node);
        }
    }

    protected List<Node> getContainerTargetNodes() {
        ArrayList<Node> arrayList = new ArrayList<Node>();
        for (Node node : this.registeredNodes) {
            if (node.isFocused() || !node.impl_isTreeVisible() || node.isDisabled()) continue;
            arrayList.add(node);
        }
        return arrayList;
    }

    protected List<Bounds> getTargetBounds(List<Node> list) {
        ArrayList<Bounds> arrayList = new ArrayList<Bounds>();
        for (Node node : list) {
            arrayList.add(this.getBounds(node));
        }
        return arrayList;
    }

    protected Bounds getBounds(Node node) {
        Bounds bounds = node != null ? (this.isScene ? node.localToScene(node.getLayoutBounds()) : this.root.sceneToLocal(node.localToScene(node.getLayoutBounds()))) : this.initialBounds;
        return bounds;
    }
}

