/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.traversal;

import com.sun.javafx.Logging;
import com.sun.javafx.scene.traversal.Algorithm;
import com.sun.javafx.scene.traversal.Direction;
import com.sun.javafx.scene.traversal.TraversalEngine;
import java.util.List;
import java.util.Stack;
import java.util.function.Function;
import javafx.collections.ObservableList;
import javafx.geometry.BoundingBox;
import javafx.geometry.Bounds;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import sun.util.logging.PlatformLogger;

public class Hueristic2D
implements Algorithm {
    PlatformLogger focusLogger;
    protected Node cacheStartTraversalNode = null;
    protected Direction cacheStartTraversalDirection = null;
    protected boolean reverseDirection = false;
    protected Node cacheLastTraversalNode = null;
    protected Stack<Node> traversalNodeStack = new Stack();
    private static final Function<Bounds, Double> BOUNDS_TOP_SIDE = new Function<Bounds, Double>(){

        @Override
        public Double apply(Bounds bounds) {
            return bounds.getMinY();
        }
    };
    private static final Function<Bounds, Double> BOUNDS_BOTTOM_SIDE = new Function<Bounds, Double>(){

        @Override
        public Double apply(Bounds bounds) {
            return bounds.getMaxY();
        }
    };
    private static final Function<Bounds, Double> BOUNDS_LEFT_SIDE = new Function<Bounds, Double>(){

        @Override
        public Double apply(Bounds bounds) {
            return bounds.getMinX();
        }
    };
    private static final Function<Bounds, Double> BOUNDS_RIGHT_SIDE = new Function<Bounds, Double>(){

        @Override
        public Double apply(Bounds bounds) {
            return bounds.getMaxX();
        }
    };

    Hueristic2D() {
        this.focusLogger = Logging.getFocusLogger();
    }

    @Override
    public Node traverse(Node node, Direction direction, TraversalEngine traversalEngine) {
        Node node2 = null;
        this.cacheTraversal(node, direction, traversalEngine);
        if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
            this.focusLogger.finer("old focus owner : " + node + ", bounds : " + traversalEngine.getBounds(node));
        }
        if (Direction.NEXT.equals((Object)direction)) {
            node2 = this.findNextFocusablePeer(node);
        } else if (Direction.PREVIOUS.equals((Object)direction)) {
            node2 = this.findPreviousFocusablePeer(node);
        } else if (Direction.UP.equals((Object)direction) || Direction.DOWN.equals((Object)direction) || Direction.LEFT.equals((Object)direction) || Direction.RIGHT.equals((Object)direction)) {
            if (this.reverseDirection && !this.traversalNodeStack.empty()) {
                if (!this.traversalNodeStack.peek().isFocusTraversable()) {
                    this.traversalNodeStack.clear();
                } else {
                    node2 = this.traversalNodeStack.pop();
                }
            }
            if (node2 == null) {
                Bounds bounds = node.localToScene(node.getLayoutBounds());
                if (this.cacheStartTraversalNode != null) {
                    Bounds bounds2 = this.cacheStartTraversalNode.localToScene(this.cacheStartTraversalNode.getLayoutBounds());
                    switch (direction) {
                        case UP: 
                        case DOWN: {
                            node2 = this.getNearestNodeUpOrDown(bounds, bounds2, traversalEngine, node, direction);
                            break;
                        }
                        case LEFT: 
                        case RIGHT: {
                            node2 = this.getNearestNodeLeftOrRight(bounds, bounds2, traversalEngine, node, direction);
                            break;
                        }
                    }
                }
            }
        }
        if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
            if (node2 != null) {
                this.focusLogger.finer("new focus owner : " + node2 + ", bounds : " + traversalEngine.getBounds(node2));
            } else {
                this.focusLogger.finer("no focus transfer");
            }
        }
        if (node2 != null) {
            this.cacheLastTraversalNode = node2;
            if (!this.reverseDirection) {
                this.traversalNodeStack.push(node);
            }
        }
        return node2;
    }

    private Node findNextFocusablePeer(Node node) {
        Object object;
        Node node2 = node;
        Node node3 = null;
        List<Node> list = this.findPeers(node2);
        if (list == null) {
            if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
                this.focusLogger.finer("can't find peers for a node without a parent");
            }
            return null;
        }
        int n = list.indexOf(node2);
        if (n == -1) {
            if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
                this.focusLogger.finer("index not founds, no focus transfer");
            }
            return null;
        }
        node3 = this.findNextFocusableInList(list, n + 1);
        while (node3 == null && node2 != null) {
            Parent parent = node2.getParent();
            if (parent != null && (object = this.findPeers(parent)) != null) {
                int n2 = object.indexOf(parent);
                node3 = this.findNextFocusableInList((List<Node>)object, n2 + 1);
            }
            node2 = parent;
        }
        if (node3 == null) {
            object = null;
            for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
                object = parent;
            }
            list = ((Parent)object).getChildrenUnmodifiable();
            node3 = this.findNextFocusableInList(list, 0);
        }
        return node3;
    }

    private Node findNextFocusableInList(List<Node> list, int n) {
        Node node = null;
        for (int i = n; i < list.size(); ++i) {
            ObservableList<Node> observableList;
            Node node2 = list.get(i);
            if (node2.isFocusTraversable() && !node2.isDisabled() && node2.impl_isTreeVisible()) {
                node = node2;
                break;
            }
            if (node2 instanceof Parent && (observableList = ((Parent)node2).getChildrenUnmodifiable()).size() > 0 && (node = this.findNextFocusableInList(observableList, 0)) != null) break;
        }
        return node;
    }

    private Node findPreviousFocusablePeer(Node node) {
        Object object;
        Node node2 = node;
        Node node3 = null;
        List<Node> list = this.findPeers(node2);
        int n = list.indexOf(node2);
        if (n == -1) {
            if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
                this.focusLogger.finer("index not founds, no focus transfer");
            }
            return null;
        }
        node3 = this.findPreviousFocusableInList(list, n - 1);
        while (node3 == null && node2 != null) {
            Parent parent = node2.getParent();
            if (parent != null && (object = this.findPeers(parent)) != null) {
                int n2 = object.indexOf(parent);
                node3 = this.findPreviousFocusableInList((List<Node>)object, n2 - 1);
            }
            node2 = parent;
        }
        if (node3 == null) {
            object = null;
            for (Parent parent = node.getParent(); parent != null; parent = parent.getParent()) {
                object = parent;
            }
            list = ((Parent)object).getChildrenUnmodifiable();
            node3 = this.findPreviousFocusableInList(list, list.size() - 1);
        }
        return node3;
    }

    private Node findPreviousFocusableInList(List<Node> list, int n) {
        Node node = null;
        for (int i = n; i >= 0; --i) {
            ObservableList<Node> observableList;
            Node node2 = list.get(i);
            if (node2.isFocusTraversable() && !node2.isDisabled() && node2.impl_isTreeVisible()) {
                node = node2;
                break;
            }
            if (node2 instanceof Parent && (observableList = ((Parent)node2).getChildrenUnmodifiable()).size() > 0 && (node = this.findPreviousFocusableInList(observableList, observableList.size() - 1)) != null) break;
        }
        return node;
    }

    private List<Node> findPeers(Node node) {
        ObservableList<Node> observableList = null;
        Parent parent = node.getParent();
        if (parent != null) {
            observableList = parent.getChildrenUnmodifiable();
        }
        return observableList;
    }

    private boolean isOnAxis(Direction direction, Bounds bounds, Bounds bounds2) {
        double d;
        double d2;
        double d3;
        double d4;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            d4 = bounds.getMinX();
            d3 = bounds.getMaxX();
            d2 = bounds2.getMinX();
            d = bounds2.getMaxX();
        } else {
            d4 = bounds.getMinY();
            d3 = bounds.getMaxY();
            d2 = bounds2.getMinY();
            d = bounds2.getMaxY();
        }
        return d2 <= d3 && d >= d4;
    }

    private double outDistance(Direction direction, Bounds bounds, Bounds bounds2) {
        double d = direction == Direction.UP ? bounds.getMinY() - bounds2.getMaxY() : (direction == Direction.DOWN ? bounds2.getMinY() - bounds.getMaxY() : (direction == Direction.LEFT ? bounds.getMinX() - bounds2.getMaxX() : bounds2.getMinX() - bounds.getMaxX()));
        return d;
    }

    private double centerSideDistance(Direction direction, Bounds bounds, Bounds bounds2) {
        double d;
        double d2;
        if (direction == Direction.UP || direction == Direction.DOWN) {
            d2 = bounds.getMinX() + bounds.getWidth() / 2.0;
            d = bounds2.getMinX() + bounds2.getWidth() / 2.0;
        } else {
            d2 = bounds.getMinY() + bounds.getHeight() / 2.0;
            d = bounds2.getMinY() + bounds2.getHeight() / 2.0;
        }
        return Math.abs(d - d2);
    }

    private double cornerSideDistance(Direction direction, Bounds bounds, Bounds bounds2) {
        double d = direction == Direction.UP || direction == Direction.DOWN ? (bounds2.getMinX() > bounds.getMaxX() ? bounds2.getMinX() - bounds.getMaxX() : bounds.getMinX() - bounds2.getMaxX()) : (bounds2.getMinY() > bounds.getMaxY() ? bounds2.getMinY() - bounds.getMaxY() : bounds.getMinY() - bounds2.getMaxY());
        return d;
    }

    private void cacheTraversal(Node node, Direction direction, TraversalEngine traversalEngine) {
        if (!this.traversalNodeStack.empty() && node != this.cacheLastTraversalNode) {
            this.traversalNodeStack.clear();
        }
        if (direction == Direction.NEXT || direction == Direction.PREVIOUS) {
            this.traversalNodeStack.clear();
            this.reverseDirection = false;
        } else if (this.cacheStartTraversalNode == null || direction != this.cacheStartTraversalDirection) {
            if (direction == Direction.UP && this.cacheStartTraversalDirection == Direction.DOWN || direction == Direction.DOWN && this.cacheStartTraversalDirection == Direction.UP || direction == Direction.LEFT && this.cacheStartTraversalDirection == Direction.RIGHT || direction == Direction.RIGHT && this.cacheStartTraversalDirection == Direction.LEFT && !this.traversalNodeStack.empty()) {
                this.reverseDirection = true;
            } else {
                this.cacheStartTraversalNode = node;
                this.cacheStartTraversalDirection = direction;
                this.reverseDirection = false;
                this.traversalNodeStack.clear();
            }
        } else {
            this.reverseDirection = false;
        }
    }

    protected Node getNearestNodeUpOrDown(Bounds bounds, Bounds bounds2, TraversalEngine traversalEngine, Node node, Direction direction) {
        List<Node> list = traversalEngine.getAllTargetNodes();
        Function<Bounds, Double> function = direction == Direction.DOWN ? BOUNDS_BOTTOM_SIDE : BOUNDS_TOP_SIDE;
        Function<Bounds, Double> function2 = direction == Direction.DOWN ? BOUNDS_TOP_SIDE : BOUNDS_BOTTOM_SIDE;
        BoundingBox boundingBox = new BoundingBox(bounds2.getMinX(), bounds.getMinY(), bounds2.getWidth(), bounds.getHeight());
        Point2D point2D = new Point2D(bounds.getMinX() + bounds.getWidth() / 2.0, function.apply(bounds));
        Point2D point2D2 = new Point2D(bounds2.getMinX() + bounds2.getWidth() / 2.0, function.apply(bounds));
        Point2D point2D3 = new Point2D(bounds.getMinX(), function.apply(bounds));
        Point2D point2D4 = new Point2D(bounds2.getMinX(), function.apply(bounds));
        Point2D point2D5 = new Point2D(bounds.getMaxX(), function.apply(bounds));
        Point2D point2D6 = new Point2D(bounds2.getMaxX(), function.apply(bounds));
        Point2D point2D7 = new Point2D(bounds2.getMinX(), function.apply(bounds2));
        TargetNode targetNode = new TargetNode();
        TargetNode targetNode2 = null;
        TargetNode targetNode3 = null;
        TargetNode targetNode4 = null;
        TargetNode targetNode5 = null;
        TargetNode targetNode6 = null;
        TargetNode targetNode7 = null;
        TargetNode targetNode8 = null;
        for (int i = 0; i < list.size(); ++i) {
            double d;
            double d2;
            Node node2 = list.get(i);
            Bounds bounds3 = node2.localToScene(node2.getLayoutBounds());
            if (!(direction == Direction.UP ? bounds.getMinY() > bounds3.getMaxY() : bounds.getMaxY() < bounds3.getMinY())) continue;
            targetNode.node = node2;
            targetNode.bounds = bounds3;
            double d3 = Math.max(0.0, this.outDistance(direction, boundingBox, bounds3));
            if (this.isOnAxis(direction, boundingBox, bounds3)) {
                targetNode.biased2DMetric = d3 + this.centerSideDistance(direction, boundingBox, bounds3) / 100.0;
            } else {
                d2 = this.cornerSideDistance(direction, boundingBox, bounds3);
                targetNode.biased2DMetric = 100000.0 + d3 * d3 + 9.0 * d2 * d2;
            }
            d2 = Math.max(0.0, this.outDistance(direction, bounds, bounds3));
            if (this.isOnAxis(direction, bounds, bounds3)) {
                targetNode.current2DMetric = d2 + this.centerSideDistance(direction, bounds, bounds3) / 100.0;
            } else {
                d = this.cornerSideDistance(direction, bounds, bounds3);
                targetNode.current2DMetric = 100000.0 + d2 * d2 + 9.0 * d * d;
            }
            targetNode.leftCornerDistance = point2D3.distance(bounds3.getMinX(), function2.apply(bounds3));
            targetNode.rightCornerDistance = point2D5.distance(bounds3.getMaxX(), function2.apply(bounds3));
            d = point2D.distance(bounds3.getMinX() + bounds3.getWidth() / 2.0, function2.apply(bounds3));
            double d4 = point2D3.distance(bounds3.getMinX() + bounds3.getWidth() / 2.0, function2.apply(bounds3));
            double d5 = point2D3.distance(bounds3.getMaxX(), function2.apply(bounds3));
            double d6 = point2D5.distance(bounds3.getMinX(), function2.apply(bounds3));
            double d7 = point2D5.distance(bounds3.getMinX() + bounds3.getWidth() / 2.0, function2.apply(bounds3));
            double d8 = point2D5.distance(bounds3.getMaxX(), function2.apply(bounds3));
            double d9 = point2D.distance(bounds3.getMinX(), function2.apply(bounds3));
            double d10 = point2D.distance(bounds3.getMinX() + bounds3.getWidth() / 2.0, function2.apply(bounds3));
            double d11 = point2D.distance(bounds3.getMaxX(), function2.apply(bounds3));
            double d12 = point2D4.distance(bounds3.getMinX() + bounds3.getWidth() / 2.0, function2.apply(bounds3));
            double d13 = point2D4.distance(bounds3.getMaxX(), function2.apply(bounds3));
            double d14 = point2D6.distance(bounds3.getMinX() + bounds3.getWidth() / 2.0, function2.apply(bounds3));
            double d15 = point2D2.distance(bounds3.getMaxX(), function2.apply(bounds3));
            targetNode.averageDistance = (targetNode.leftCornerDistance + d12 + d13 + d6 + targetNode.rightCornerDistance + d14 + d) / 7.0;
            targetNode.biasShortestDistance = Hueristic2D.findMin(targetNode.leftCornerDistance, d12, d13, d6, d14, targetNode.rightCornerDistance, d9, d, d15);
            targetNode.shortestDistance = Hueristic2D.findMin(targetNode.leftCornerDistance, d4, d5, d6, d7, d8, d9, d10, d11);
            if (d3 >= 0.0 && (targetNode3 == null || targetNode.biased2DMetric < targetNode3.biased2DMetric)) {
                if (targetNode3 == null) {
                    targetNode3 = new TargetNode();
                }
                targetNode3.copy(targetNode);
            }
            if (d2 >= 0.0 && (targetNode2 == null || targetNode.current2DMetric < targetNode2.current2DMetric)) {
                if (targetNode2 == null) {
                    targetNode2 = new TargetNode();
                }
                targetNode2.copy(targetNode);
            }
            if (bounds2.getMaxX() > bounds3.getMinX() && bounds3.getMaxX() > bounds2.getMinX() && (targetNode5 == null || targetNode5.biasShortestDistance > targetNode.biasShortestDistance)) {
                if (targetNode5 == null) {
                    targetNode5 = new TargetNode();
                }
                targetNode5.copy(targetNode);
            }
            if (bounds.getMaxX() > bounds3.getMinX() && bounds3.getMaxX() > bounds.getMinX() && (targetNode6 == null || targetNode6.biasShortestDistance > targetNode.biasShortestDistance)) {
                if (targetNode6 == null) {
                    targetNode6 = new TargetNode();
                }
                targetNode6.copy(targetNode);
            }
            if ((targetNode7 == null || targetNode7.leftCornerDistance > targetNode.leftCornerDistance) && (bounds2.getMinX() >= bounds.getMinX() && bounds3.getMinX() >= bounds.getMinX() || bounds2.getMinX() <= bounds.getMinX() && bounds3.getMinX() <= bounds.getMinX())) {
                if (targetNode7 == null) {
                    targetNode7 = new TargetNode();
                }
                targetNode7.copy(targetNode);
            }
            if ((targetNode4 == null || targetNode4.averageDistance > targetNode.averageDistance) && (bounds2.getMinX() >= bounds.getMinX() && bounds3.getMinX() >= bounds.getMinX() || bounds2.getMinX() <= bounds.getMinX() && bounds3.getMinX() <= bounds.getMinX())) {
                if (targetNode4 == null) {
                    targetNode4 = new TargetNode();
                }
                targetNode4.copy(targetNode);
            }
            if (targetNode8 != null && !(targetNode8.shortestDistance > targetNode.shortestDistance)) continue;
            if (targetNode8 == null) {
                targetNode8 = new TargetNode();
            }
            targetNode8.copy(targetNode);
        }
        list.clear();
        if (targetNode5 != null) {
            targetNode5.originLeftCornerDistance = point2D7.distance(targetNode5.bounds.getMinX(), function2.apply(targetNode5.bounds));
        }
        if (targetNode6 != null) {
            targetNode6.originLeftCornerDistance = point2D7.distance(targetNode6.bounds.getMinX(), function2.apply(targetNode6.bounds));
        }
        if (targetNode4 != null) {
            targetNode4.originLeftCornerDistance = point2D7.distance(targetNode4.bounds.getMinX(), function2.apply(targetNode4.bounds));
        }
        if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
            if (targetNode3 != null) {
                this.focusLogger.finer("nearestNodeOriginSimple2D.node : " + targetNode3.node);
            }
            if (targetNode2 != null) {
                this.focusLogger.finer("nearestNodeCurrentSimple2D.node : " + targetNode2.node);
            }
            if (targetNode5 != null) {
                this.focusLogger.finer("nearestNodeOnOriginX.node : " + targetNode5.node);
            }
            if (targetNode6 != null) {
                this.focusLogger.finer("nearestNodeOnCurrentX.node : " + targetNode6.node);
            }
            if (targetNode4 != null) {
                this.focusLogger.finer("nearestNodeAverageUp.node : " + targetNode4.node);
            }
            if (targetNode7 != null) {
                this.focusLogger.finer("nearestNodeTopLeft.node : " + targetNode7.node);
            }
            if (targetNode8 != null) {
                this.focusLogger.finer("nearestNodeAnythingAnywhereUp.node : " + targetNode8.node);
            }
        }
        if (targetNode5 != null) {
            if (targetNode6 != null && targetNode5.node == targetNode6.node && (targetNode4 != null && targetNode5.node == targetNode4.node || targetNode3 != null && targetNode5.node == targetNode3.node || targetNode7 != null && targetNode5.node == targetNode7.node || targetNode8 != null && targetNode5.node == targetNode8.node)) {
                return targetNode5.node;
            }
            if (targetNode4 != null && targetNode5.node == targetNode4.node) {
                return targetNode5.node;
            }
            if (targetNode6 != null) {
                if (targetNode6.leftCornerDistance < targetNode5.leftCornerDistance && targetNode6.originLeftCornerDistance < targetNode5.originLeftCornerDistance && targetNode6.bounds.getMinX() - point2D3.getX() < targetNode5.bounds.getMinX() - point2D3.getX()) {
                    return targetNode6.node;
                }
                if (targetNode4 == null || targetNode5.averageDistance < targetNode4.averageDistance) {
                    return targetNode5.node;
                }
            }
        } else {
            if (targetNode6 == null && targetNode2 != null) {
                if (targetNode4 != null && targetNode7 != null && targetNode4.node == targetNode7.node && targetNode4.node == targetNode8.node) {
                    return targetNode4.node;
                }
                return targetNode2.node;
            }
            if (targetNode4 != null && targetNode7 != null && targetNode8 != null && targetNode4.biasShortestDistance == targetNode7.biasShortestDistance && targetNode4.biasShortestDistance == targetNode8.biasShortestDistance && targetNode4.biasShortestDistance < Double.MAX_VALUE) {
                return targetNode4.node;
            }
        }
        if (targetNode4 != null && (targetNode5 == null || targetNode4.biasShortestDistance < targetNode5.biasShortestDistance)) {
            if (targetNode5 != null && function2.apply(targetNode5.bounds) >= function2.apply(targetNode4.bounds)) {
                return targetNode5.node;
            }
            if (targetNode3 != null) {
                if (targetNode3.current2DMetric <= targetNode4.current2DMetric) {
                    return targetNode3.node;
                }
                if (function2.apply(targetNode3.bounds) >= function2.apply(targetNode4.bounds)) {
                    return targetNode3.node;
                }
            }
            return targetNode4.node;
        }
        if (targetNode2 != null && targetNode6 != null && targetNode4 != null && targetNode7 != null && targetNode8 != null && targetNode2.node == targetNode6.node && targetNode2.node == targetNode4.node && targetNode2.node == targetNode7.node && targetNode2.node == targetNode8.node) {
            return targetNode2.node;
        }
        if (targetNode5 != null && (targetNode6 == null || targetNode5.rightCornerDistance < targetNode6.rightCornerDistance)) {
            return targetNode5.node;
        }
        if (targetNode5 != null) {
            return targetNode5.node;
        }
        if (targetNode3 != null) {
            return targetNode3.node;
        }
        if (targetNode6 != null) {
            return targetNode6.node;
        }
        if (targetNode4 != null) {
            return targetNode4.node;
        }
        if (targetNode7 != null) {
            return targetNode7.node;
        }
        if (targetNode8 != null) {
            return targetNode8.node;
        }
        return null;
    }

    protected Node getNearestNodeLeftOrRight(Bounds bounds, Bounds bounds2, TraversalEngine traversalEngine, Node node, Direction direction) {
        List<Node> list = traversalEngine.getAllTargetNodes();
        Function<Bounds, Double> function = direction == Direction.LEFT ? BOUNDS_LEFT_SIDE : BOUNDS_RIGHT_SIDE;
        Function<Bounds, Double> function2 = direction == Direction.LEFT ? BOUNDS_RIGHT_SIDE : BOUNDS_LEFT_SIDE;
        BoundingBox boundingBox = new BoundingBox(bounds.getMinX(), bounds2.getMinY(), bounds.getWidth(), bounds2.getHeight());
        Point2D point2D = new Point2D(function.apply(bounds), bounds.getMinY() + bounds.getHeight() / 2.0);
        Point2D point2D2 = new Point2D(function.apply(bounds), bounds2.getMinY() + bounds2.getHeight() / 2.0);
        Point2D point2D3 = new Point2D(function.apply(bounds), bounds.getMinY());
        Point2D point2D4 = new Point2D(function.apply(bounds), bounds2.getMinY());
        Point2D point2D5 = new Point2D(function.apply(bounds), bounds.getMaxY());
        Point2D point2D6 = new Point2D(function.apply(bounds), bounds2.getMaxY());
        Point2D point2D7 = new Point2D(function.apply(bounds2), bounds2.getMinY());
        TargetNode targetNode = new TargetNode();
        TargetNode targetNode2 = null;
        TargetNode targetNode3 = null;
        TargetNode targetNode4 = null;
        TargetNode targetNode5 = null;
        TargetNode targetNode6 = null;
        TargetNode targetNode7 = null;
        TargetNode targetNode8 = null;
        for (int i = 0; i < list.size(); ++i) {
            double d;
            double d2;
            Node node2 = list.get(i);
            Bounds bounds3 = node2.localToScene(node2.getLayoutBounds());
            if (!(direction == Direction.LEFT ? bounds.getMinX() > bounds3.getMinX() : bounds.getMaxX() < bounds3.getMaxX())) continue;
            targetNode.node = node2;
            targetNode.bounds = bounds3;
            double d3 = Math.max(0.0, this.outDistance(direction, boundingBox, bounds3));
            if (this.isOnAxis(direction, boundingBox, bounds3)) {
                targetNode.biased2DMetric = d3 + this.centerSideDistance(direction, boundingBox, bounds3) / 100.0;
            } else {
                d2 = this.cornerSideDistance(direction, boundingBox, bounds3);
                targetNode.biased2DMetric = 100000.0 + d3 * d3 + 9.0 * d2 * d2;
            }
            d2 = Math.max(0.0, this.outDistance(direction, bounds, bounds3));
            if (this.isOnAxis(direction, bounds, bounds3)) {
                targetNode.current2DMetric = d2 + this.centerSideDistance(direction, bounds, bounds3) / 100.0;
            } else {
                d = this.cornerSideDistance(direction, bounds, bounds3);
                targetNode.current2DMetric = 100000.0 + d2 * d2 + 9.0 * d * d;
            }
            targetNode.topCornerDistance = point2D3.distance(function2.apply(bounds3), bounds3.getMinY());
            targetNode.bottomCornerDistance = point2D5.distance(function2.apply(bounds3), bounds3.getMaxY());
            d = point2D.distance(function2.apply(bounds3), bounds3.getMinY() + bounds3.getHeight() / 2.0);
            double d4 = point2D3.distance(function2.apply(bounds3), bounds3.getMaxY());
            double d5 = point2D3.distance(function2.apply(bounds3), bounds3.getMinY() + bounds3.getHeight() / 2.0);
            double d6 = point2D5.distance(function2.apply(bounds3), bounds3.getMinY());
            double d7 = point2D5.distance(function2.apply(bounds3), bounds3.getMaxY());
            double d8 = point2D5.distance(function2.apply(bounds3), bounds3.getMinY() + bounds3.getHeight() / 2.0);
            double d9 = point2D.distance(function2.apply(bounds3), bounds3.getMinY());
            double d10 = point2D.distance(function2.apply(bounds3), bounds3.getMaxY());
            double d11 = point2D.distance(function2.apply(bounds3), bounds3.getMinY() + bounds3.getHeight() / 2.0);
            double d12 = point2D4.distance(function2.apply(bounds3), bounds3.getMaxY());
            double d13 = point2D4.distance(function2.apply(bounds3), bounds3.getMinY() + bounds3.getHeight() / 2.0);
            double d14 = point2D6.distance(function2.apply(bounds3), bounds3.getMinY() + bounds3.getHeight() / 2.0);
            double d15 = point2D2.distance(function2.apply(bounds3), bounds3.getMaxY());
            targetNode.averageDistance = (targetNode.topCornerDistance + d12 + d13 + d6 + targetNode.bottomCornerDistance + d14 + d) / 7.0;
            targetNode.biasShortestDistance = Hueristic2D.findMin(targetNode.topCornerDistance, d12, d13, d6, targetNode.bottomCornerDistance, d14, d9, d15, d);
            targetNode.shortestDistance = Hueristic2D.findMin(targetNode.topCornerDistance, d4, d5, d6, d7, d8, d9, d10, d11);
            if (d3 >= 0.0 && (targetNode3 == null || targetNode.biased2DMetric < targetNode3.biased2DMetric)) {
                if (targetNode3 == null) {
                    targetNode3 = new TargetNode();
                }
                targetNode3.copy(targetNode);
            }
            if (d2 >= 0.0 && (targetNode2 == null || targetNode.current2DMetric < targetNode2.current2DMetric)) {
                if (targetNode2 == null) {
                    targetNode2 = new TargetNode();
                }
                targetNode2.copy(targetNode);
            }
            if (bounds2.getMaxY() > bounds3.getMinY() && bounds3.getMaxY() > bounds2.getMinY() && (targetNode5 == null || targetNode5.topCornerDistance > targetNode.topCornerDistance)) {
                if (targetNode5 == null) {
                    targetNode5 = new TargetNode();
                }
                targetNode5.copy(targetNode);
            }
            if (bounds.getMaxY() > bounds3.getMinY() && bounds3.getMaxY() > bounds.getMinY() && (targetNode6 == null || targetNode6.topCornerDistance > targetNode.topCornerDistance)) {
                if (targetNode6 == null) {
                    targetNode6 = new TargetNode();
                }
                targetNode6.copy(targetNode);
            }
            if (targetNode7 == null || targetNode7.topCornerDistance > targetNode.topCornerDistance) {
                if (targetNode7 == null) {
                    targetNode7 = new TargetNode();
                }
                targetNode7.copy(targetNode);
            }
            if (targetNode4 == null || targetNode4.averageDistance > targetNode.averageDistance) {
                if (targetNode4 == null) {
                    targetNode4 = new TargetNode();
                }
                targetNode4.copy(targetNode);
            }
            if (targetNode8 != null && !(targetNode8.shortestDistance > targetNode.shortestDistance)) continue;
            if (targetNode8 == null) {
                targetNode8 = new TargetNode();
            }
            targetNode8.copy(targetNode);
        }
        list.clear();
        if (targetNode5 != null) {
            targetNode5.originTopCornerDistance = point2D7.distance(function2.apply(targetNode5.bounds), targetNode5.bounds.getMinY());
        }
        if (targetNode6 != null) {
            targetNode6.originTopCornerDistance = point2D7.distance(function2.apply(targetNode6.bounds), targetNode6.bounds.getMinY());
        }
        if (targetNode4 != null) {
            targetNode4.originTopCornerDistance = point2D7.distance(function2.apply(targetNode4.bounds), targetNode4.bounds.getMinY());
        }
        if (targetNode6 == null && targetNode5 == null) {
            this.cacheStartTraversalNode = null;
            this.cacheStartTraversalDirection = null;
            this.reverseDirection = false;
            this.traversalNodeStack.clear();
        }
        if (this.focusLogger.isLoggable(PlatformLogger.Level.FINER)) {
            if (targetNode3 != null) {
                this.focusLogger.finer("nearestNodeOriginSimple2D.node : " + targetNode3.node);
            }
            if (targetNode2 != null) {
                this.focusLogger.finer("nearestNodeCurrentSimple2D.node : " + targetNode2.node);
            }
            if (targetNode5 != null) {
                this.focusLogger.finer("nearestNodeOnOriginY.node : " + targetNode5.node);
            }
            if (targetNode6 != null) {
                this.focusLogger.finer("nearestNodeOnCurrentY.node : " + targetNode6.node);
            }
            if (targetNode4 != null) {
                this.focusLogger.finer("nearestNodeAverageLeft.node : " + targetNode4.node);
            }
            if (targetNode7 != null) {
                this.focusLogger.finer("nearestNodeTopLeft.node : " + targetNode7.node);
            }
            if (targetNode8 != null) {
                this.focusLogger.finer("nearestNodeAnythingAnywhereLeft.node : " + targetNode8.node);
            }
        }
        if (targetNode5 != null) {
            if (targetNode6 != null && targetNode5.node == targetNode6.node && (targetNode4 != null && targetNode5.node == targetNode4.node || targetNode7 != null && targetNode5.node == targetNode7.node || targetNode8 != null && targetNode5.node == targetNode8.node)) {
                return targetNode5.node;
            }
            if (targetNode4 != null && targetNode5.node == targetNode4.node) {
                return targetNode5.node;
            }
            if (targetNode6 != null) {
                if (targetNode6.bottomCornerDistance < targetNode5.bottomCornerDistance && targetNode6.originTopCornerDistance < targetNode5.originTopCornerDistance && targetNode6.bounds.getMinY() - point2D3.getY() < targetNode5.bounds.getMinY() - point2D3.getY()) {
                    return targetNode6.node;
                }
                if (targetNode4 == null || targetNode5.averageDistance < targetNode4.averageDistance) {
                    return targetNode5.node;
                }
            }
        } else {
            if (targetNode6 == null && targetNode2 != null) {
                if (targetNode4 != null && targetNode7 != null && targetNode4.node == targetNode7.node && targetNode4.node == targetNode8.node) {
                    return targetNode4.node;
                }
                return targetNode2.node;
            }
            if (targetNode4 != null && targetNode7 != null && targetNode8 != null && targetNode4.biasShortestDistance == targetNode7.biasShortestDistance && targetNode4.biasShortestDistance == targetNode8.biasShortestDistance && targetNode4.biasShortestDistance < Double.MAX_VALUE) {
                return targetNode4.node;
            }
        }
        if (targetNode4 != null && (targetNode5 == null || targetNode4.biasShortestDistance < targetNode5.biasShortestDistance)) {
            if (targetNode5 != null && function2.apply(targetNode5.bounds) >= function2.apply(targetNode4.bounds)) {
                return targetNode5.node;
            }
            if (targetNode5 != null && targetNode6 != null && targetNode5.biasShortestDistance < Double.MAX_VALUE && targetNode5.node == targetNode6.node) {
                return targetNode5.node;
            }
            if (targetNode6 != null && targetNode5 != null && targetNode6.biasShortestDistance < Double.MAX_VALUE && targetNode6.biasShortestDistance < targetNode5.biasShortestDistance) {
                return targetNode6.node;
            }
            if (targetNode5 != null && targetNode5.biasShortestDistance < Double.MAX_VALUE && targetNode5.originTopCornerDistance < targetNode4.originTopCornerDistance) {
                return targetNode5.node;
            }
            return targetNode4.node;
        }
        if (targetNode5 != null && targetNode6 != null && targetNode5.bottomCornerDistance < targetNode6.bottomCornerDistance) {
            return targetNode5.node;
        }
        if (targetNode6 != null && targetNode7 != null && targetNode6.biasShortestDistance < Double.MAX_VALUE && targetNode6.node == targetNode7.node) {
            return targetNode6.node;
        }
        if (targetNode5 != null) {
            return targetNode5.node;
        }
        if (targetNode3 != null) {
            return targetNode3.node;
        }
        if (targetNode6 != null) {
            return targetNode6.node;
        }
        if (targetNode4 != null) {
            return targetNode4.node;
        }
        if (targetNode7 != null) {
            return targetNode7.node;
        }
        if (targetNode8 != null) {
            return targetNode8.node;
        }
        return null;
    }

    public static double findMin(double ... dArray) {
        double d = Double.MAX_VALUE;
        for (int i = 0; i < dArray.length; ++i) {
            d = d < dArray[i] ? d : dArray[i];
        }
        return d;
    }

    static final class TargetNode {
        Node node = null;
        Bounds bounds = null;
        double biased2DMetric = Double.MAX_VALUE;
        double current2DMetric = Double.MAX_VALUE;
        double leftCornerDistance = Double.MAX_VALUE;
        double rightCornerDistance = Double.MAX_VALUE;
        double topCornerDistance = Double.MAX_VALUE;
        double bottomCornerDistance = Double.MAX_VALUE;
        double shortestDistance = Double.MAX_VALUE;
        double biasShortestDistance = Double.MAX_VALUE;
        double averageDistance = Double.MAX_VALUE;
        double originLeftCornerDistance = Double.MAX_VALUE;
        double originTopCornerDistance = Double.MAX_VALUE;

        TargetNode() {
        }

        void copy(TargetNode targetNode) {
            this.node = targetNode.node;
            this.bounds = targetNode.bounds;
            this.biased2DMetric = targetNode.biased2DMetric;
            this.current2DMetric = targetNode.current2DMetric;
            this.leftCornerDistance = targetNode.leftCornerDistance;
            this.rightCornerDistance = targetNode.rightCornerDistance;
            this.shortestDistance = targetNode.shortestDistance;
            this.biasShortestDistance = targetNode.biasShortestDistance;
            this.averageDistance = targetNode.averageDistance;
            this.topCornerDistance = targetNode.topCornerDistance;
            this.bottomCornerDistance = targetNode.bottomCornerDistance;
            this.originLeftCornerDistance = targetNode.originLeftCornerDistance;
            this.originTopCornerDistance = targetNode.originTopCornerDistance;
        }
    }
}

