/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.MenuButtonBehaviorBase;
import com.sun.javafx.scene.control.skin.BehaviorSkinBase;
import com.sun.javafx.scene.control.skin.ContextMenuContent;
import com.sun.javafx.scene.control.skin.LabeledImpl;
import com.sun.javafx.scene.control.skin.Utils;
import java.util.Collection;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.Event;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Scene;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Labeled;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuButton;
import javafx.scene.control.MenuItem;
import javafx.scene.control.RadioMenuItem;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.StackPane;

public abstract class MenuButtonSkinBase<C extends MenuButton, B extends MenuButtonBehaviorBase<C>>
extends BehaviorSkinBase<C, B> {
    protected final LabeledImpl label;
    protected final StackPane arrow;
    protected final StackPane arrowButton;
    protected ContextMenu popup;
    protected boolean behaveLikeButton = false;
    private ListChangeListener<MenuItem> itemsChangedListener;

    public MenuButtonSkinBase(C c, B b) {
        super(c, b);
        if (((Node)c).getOnMousePressed() == null) {
            ((Node)c).setOnMousePressed((EventHandler<MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ((MenuButtonBehaviorBase)MenuButtonSkinBase.this.getBehavior()).mousePressed(mouseEvent, MenuButtonSkinBase.this.behaveLikeButton);
                }
            });
        }
        if (((Node)c).getOnMouseReleased() == null) {
            ((Node)c).setOnMouseReleased((EventHandler<MouseEvent>)new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    ((MenuButtonBehaviorBase)MenuButtonSkinBase.this.getBehavior()).mouseReleased(mouseEvent, MenuButtonSkinBase.this.behaveLikeButton);
                }
            });
        }
        this.label = new MenuLabeledImpl((MenuButton)this.getSkinnable());
        this.label.setMnemonicParsing(((Labeled)c).isMnemonicParsing());
        this.label.setLabelFor((Node)c);
        this.arrow = new StackPane();
        this.arrow.getStyleClass().setAll((String[])new String[]{"arrow"});
        this.arrow.setMaxWidth(Double.NEGATIVE_INFINITY);
        this.arrow.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.arrowButton = new StackPane();
        this.arrowButton.getStyleClass().setAll((String[])new String[]{"arrow-button"});
        this.arrowButton.getChildren().add(this.arrow);
        this.popup = new ContextMenu();
        this.popup.getItems().clear();
        this.popup.getItems().addAll((Collection<MenuItem>)((MenuButton)this.getSkinnable()).getItems());
        this.getChildren().clear();
        this.getChildren().addAll((Node[])new Node[]{this.label, this.arrowButton});
        ((MenuButton)this.getSkinnable()).requestLayout();
        this.itemsChangedListener = new ListChangeListener<MenuItem>(){

            @Override
            public void onChanged(ListChangeListener.Change<? extends MenuItem> change) {
                while (change.next()) {
                    MenuButtonSkinBase.this.popup.getItems().removeAll((Collection<?>)change.getRemoved());
                    MenuButtonSkinBase.this.popup.getItems().addAll(change.getFrom(), (Collection<MenuItem>)change.getAddedSubList());
                }
            }
        };
        ((MenuButton)c).getItems().addListener(this.itemsChangedListener);
        if (((MenuButton)this.getSkinnable()).getScene() != null) {
            this.addAccelerators(((MenuButton)this.getSkinnable()).getItems());
        }
        ((Node)c).sceneProperty().addListener(new ChangeListener<Scene>(){

            @Override
            public void changed(ObservableValue<? extends Scene> observableValue, Scene scene, Scene scene2) {
                if (MenuButtonSkinBase.this.getSkinnable() != null && ((MenuButton)MenuButtonSkinBase.this.getSkinnable()).getScene() != null) {
                    MenuButtonSkinBase.this.addAccelerators(((MenuButton)MenuButtonSkinBase.this.getSkinnable()).getItems());
                }
            }
        });
        this.registerChangeListener(((MenuButton)c).showingProperty(), "SHOWING");
        this.registerChangeListener(((Node)c).focusedProperty(), "FOCUSED");
        this.registerChangeListener(((Labeled)c).mnemonicParsingProperty(), "MNEMONIC_PARSING");
        this.registerChangeListener(this.popup.showingProperty(), "POPUP_VISIBLE");
    }

    @Override
    public void dispose() {
        ((MenuButton)this.getSkinnable()).getItems().removeListener(this.itemsChangedListener);
        super.dispose();
        if (this.popup != null) {
            if (this.popup.getSkin() != null && this.popup.getSkin().getNode() != null) {
                ContextMenuContent contextMenuContent = (ContextMenuContent)this.popup.getSkin().getNode();
                contextMenuContent.dispose();
                contextMenuContent = null;
            }
            this.popup.setSkin(null);
            this.popup = null;
        }
    }

    private void show() {
        if (!this.popup.isShowing()) {
            this.popup.show((Node)((Object)this.getSkinnable()), ((MenuButton)this.getSkinnable()).getPopupSide(), 0.0, 0.0);
        }
    }

    private void hide() {
        if (this.popup.isShowing()) {
            this.popup.hide();
        }
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        super.handleControlPropertyChanged(string);
        if ("SHOWING".equals(string)) {
            if (((MenuButton)this.getSkinnable()).isShowing()) {
                this.show();
            } else {
                this.hide();
            }
        } else if ("FOCUSED".equals(string)) {
            if (!((MenuButton)this.getSkinnable()).isFocused() && ((MenuButton)this.getSkinnable()).isShowing()) {
                this.hide();
            }
            if (!((MenuButton)this.getSkinnable()).isFocused() && this.popup.isShowing()) {
                this.hide();
            }
        } else if ("POPUP_VISIBLE".equals(string)) {
            if (!this.popup.isShowing() && ((MenuButton)this.getSkinnable()).isShowing()) {
                ((MenuButton)this.getSkinnable()).hide();
            }
            if (this.popup.isShowing()) {
                Utils.addMnemonics(this.popup, ((MenuButton)this.getSkinnable()).getScene(), ((MenuButton)this.getSkinnable()).impl_isShowMnemonics());
            } else {
                Utils.removeMnemonics(this.popup, ((MenuButton)this.getSkinnable()).getScene());
            }
        } else if ("MNEMONIC_PARSING".equals(string)) {
            this.label.setMnemonicParsing(((MenuButton)this.getSkinnable()).isMnemonicParsing());
            ((MenuButton)this.getSkinnable()).requestLayout();
        }
    }

    @Override
    protected double computeMinWidth(double d, double d2, double d3, double d4, double d5) {
        return d5 + this.label.minWidth(d) + this.snapSize(this.arrowButton.minWidth(d)) + d3;
    }

    @Override
    protected double computeMinHeight(double d, double d2, double d3, double d4, double d5) {
        return d2 + Math.max(this.label.minHeight(d), this.snapSize(this.arrowButton.minHeight(-1.0))) + d4;
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        return d5 + this.label.prefWidth(d) + this.snapSize(this.arrowButton.prefWidth(d)) + d3;
    }

    @Override
    protected double computePrefHeight(double d, double d2, double d3, double d4, double d5) {
        return d2 + Math.max(this.label.prefHeight(d), this.snapSize(this.arrowButton.prefHeight(-1.0))) + d4;
    }

    @Override
    protected double computeMaxWidth(double d, double d2, double d3, double d4, double d5) {
        return ((MenuButton)this.getSkinnable()).prefWidth(d);
    }

    @Override
    protected double computeMaxHeight(double d, double d2, double d3, double d4, double d5) {
        return ((MenuButton)this.getSkinnable()).prefHeight(d);
    }

    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        double d5 = this.snapSize(this.arrowButton.prefWidth(-1.0));
        this.label.resizeRelocate(d, d2, d3 - d5, d4);
        this.arrowButton.resizeRelocate(d + (d3 - d5), d2, d5, d4);
    }

    private void addAccelerators(ObservableList<MenuItem> observableList) {
        for (final MenuItem menuItem : observableList) {
            if (menuItem instanceof Menu) {
                this.addAccelerators(((Menu)menuItem).getItems());
                continue;
            }
            if (menuItem.getAccelerator() == null || ((MenuButton)this.getSkinnable()).getScene().getAccelerators() == null) continue;
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                    Menu menu;
                    if (menuItem.getOnMenuValidation() != null) {
                        Event.fireEvent(menuItem, new Event(MenuItem.MENU_VALIDATION_EVENT));
                    }
                    if ((menu = menuItem.getParentMenu()) != null && menu.getOnMenuValidation() != null) {
                        Event.fireEvent(menu, new Event(MenuItem.MENU_VALIDATION_EVENT));
                    }
                    if (!menuItem.isDisable()) {
                        if (menuItem instanceof RadioMenuItem) {
                            ((RadioMenuItem)menuItem).setSelected(!((RadioMenuItem)menuItem).isSelected());
                        } else if (menuItem instanceof CheckMenuItem) {
                            ((CheckMenuItem)menuItem).setSelected(!((CheckMenuItem)menuItem).isSelected());
                        }
                        menuItem.fire();
                    }
                }
            };
            ((MenuButton)this.getSkinnable()).getScene().getAccelerators().put(menuItem.getAccelerator(), runnable);
        }
    }

    private class MenuLabeledImpl
    extends LabeledImpl {
        MenuButton button;

        public MenuLabeledImpl(MenuButton menuButton) {
            super(menuButton);
            this.button = menuButton;
            this.addEventHandler(ActionEvent.ACTION, new EventHandler<ActionEvent>(){

                @Override
                public void handle(ActionEvent actionEvent) {
                    MenuLabeledImpl.this.button.fireEvent(new ActionEvent());
                    actionEvent.consume();
                }
            });
        }
    }
}

