/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.scene.control.skin;

import com.sun.javafx.scene.control.behavior.ComboBoxListViewBehavior;
import com.sun.javafx.scene.control.skin.ComboBoxPopupControl;
import com.sun.javafx.scene.control.skin.ListViewSkin;
import com.sun.javafx.scene.control.skin.Utils;
import com.sun.javafx.scene.control.skin.VirtualContainerBase;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.WeakListChangeListener;
import javafx.css.PseudoClass;
import javafx.event.EventHandler;
import javafx.event.EventTarget;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ComboBoxBase;
import javafx.scene.control.Control;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextField;
import javafx.scene.input.DragEvent;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;

public class ComboBoxListViewSkin<T>
extends ComboBoxPopupControl<T> {
    private static final String COMBO_BOX_ROWS_TO_MEASURE_WIDTH_KEY = "comboBoxRowsToMeasureWidth";
    private final ComboBox<T> comboBox;
    private ObservableList<T> comboBoxItems;
    private ListCell<T> buttonCell;
    private Callback<ListView<T>, ListCell<T>> cellFactory;
    private TextField textField;
    private final ListView<T> listView;
    private ObservableList<T> listViewItems;
    private boolean listSelectionLock = false;
    private boolean listViewSelectionDirty = false;
    private boolean itemCountDirty;
    private final ListChangeListener<T> listViewItemsListener = new ListChangeListener<T>(){

        @Override
        public void onChanged(ListChangeListener.Change<? extends T> change) {
            ComboBoxListViewSkin.this.itemCountDirty = true;
            ((ComboBoxBase)ComboBoxListViewSkin.this.getSkinnable()).requestLayout();
        }
    };
    private final WeakListChangeListener<T> weakListViewItemsListener = new WeakListChangeListener<T>(this.listViewItemsListener);
    private String initialTextFieldValue = null;
    private static PseudoClass CONTAINS_FOCUS_PSEUDOCLASS_STATE = PseudoClass.getPseudoClass("contains-focus");
    private static final PseudoClass PSEUDO_CLASS_SELECTED = PseudoClass.getPseudoClass("selected");
    private static final PseudoClass PSEUDO_CLASS_EMPTY = PseudoClass.getPseudoClass("empty");
    private static final PseudoClass PSEUDO_CLASS_FILLED = PseudoClass.getPseudoClass("filled");

    public ComboBoxListViewSkin(final ComboBox<T> comboBox) {
        super(comboBox, new ComboBoxListViewBehavior<T>(comboBox));
        this.comboBox = comboBox;
        this.updateComboBoxItems();
        TextField textField = this.textField = comboBox.isEditable() ? this.getEditableInputNode() : null;
        if (this.textField != null) {
            this.getChildren().add(this.textField);
        }
        this.listView = this.createListView();
        this.listView.setManaged(false);
        this.getChildren().add(this.listView);
        this.updateListViewItems();
        this.updateCellFactory();
        this.updateButtonCell();
        comboBox.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (comboBox.isEditable()) {
                    ((FakeFocusTextField)ComboBoxListViewSkin.this.textField).setFakeFocus(bl2);
                }
            }
        });
        comboBox.addEventFilter(KeyEvent.ANY, new EventHandler<KeyEvent>(){

            @Override
            public void handle(KeyEvent keyEvent) {
                if (ComboBoxListViewSkin.this.textField == null) {
                    return;
                }
                if (keyEvent.getTarget().equals(ComboBoxListViewSkin.this.textField)) {
                    return;
                }
                if (keyEvent.getCode() == KeyCode.ENTER) {
                    ComboBoxListViewSkin.this.setTextFromTextFieldIntoComboBoxValue();
                    if (!Utils.isTwoLevelFocus()) {
                        keyEvent.consume();
                    }
                    return;
                }
                if (keyEvent.getCode() == KeyCode.F4 && keyEvent.getEventType() == KeyEvent.KEY_RELEASED) {
                    if (comboBox.isShowing()) {
                        comboBox.hide();
                    } else {
                        comboBox.show();
                    }
                    keyEvent.consume();
                    return;
                }
                if (keyEvent.getCode() == KeyCode.F10 || keyEvent.getCode() == KeyCode.ESCAPE) {
                    keyEvent.consume();
                    return;
                }
                ComboBoxListViewSkin.this.textField.fireEvent(keyEvent.copyFor(ComboBoxListViewSkin.this.textField, ComboBoxListViewSkin.this.textField));
                keyEvent.consume();
            }
        });
        if (this.textField != null) {
            this.textField.addEventFilter(MouseEvent.DRAG_DETECTED, new EventHandler<MouseEvent>(){

                @Override
                public void handle(MouseEvent mouseEvent) {
                    if (mouseEvent.getTarget().equals(comboBox)) {
                        return;
                    }
                    comboBox.fireEvent(mouseEvent.copyFor(comboBox, comboBox));
                    mouseEvent.consume();
                }
            });
            this.textField.addEventFilter(DragEvent.ANY, new EventHandler<DragEvent>(){

                @Override
                public void handle(DragEvent dragEvent) {
                    if (dragEvent.getTarget().equals(comboBox)) {
                        return;
                    }
                    comboBox.fireEvent(dragEvent.copyFor(comboBox, comboBox));
                    dragEvent.consume();
                }
            });
        }
        this.updateValue();
        this.registerChangeListener(comboBox.itemsProperty(), "ITEMS");
        this.registerChangeListener(comboBox.promptTextProperty(), "PROMPT_TEXT");
        this.registerChangeListener(comboBox.cellFactoryProperty(), "CELL_FACTORY");
        this.registerChangeListener(comboBox.visibleRowCountProperty(), "VISIBLE_ROW_COUNT");
        this.registerChangeListener(comboBox.converterProperty(), "CONVERTER");
        this.registerChangeListener(comboBox.buttonCellProperty(), "BUTTON_CELL");
        this.registerChangeListener(comboBox.valueProperty(), "VALUE");
    }

    @Override
    protected void handleControlPropertyChanged(String string) {
        if ("SHOWING".equals(string)) {
            if (((ComboBoxBase)this.getSkinnable()).isShowing()) {
                this.listView.setManaged(true);
            } else {
                this.listView.setManaged(false);
            }
        }
        super.handleControlPropertyChanged(string);
        if ("ITEMS".equals(string)) {
            this.updateComboBoxItems();
            this.updateListViewItems();
        } else if ("PROMPT_TEXT".equals(string)) {
            this.updateDisplayNode();
        } else if ("CELL_FACTORY".equals(string)) {
            this.updateCellFactory();
        } else if ("VISIBLE_ROW_COUNT".equals(string)) {
            if (this.listView == null) {
                return;
            }
            this.listView.setPrefHeight(this.getListViewPrefHeight());
        } else if ("CONVERTER".equals(string)) {
            this.updateListViewItems();
        } else if ("EDITOR".equals(string)) {
            this.getEditableInputNode();
        } else if ("BUTTON_CELL".equals(string)) {
            this.updateButtonCell();
        } else if ("VALUE".equals(string)) {
            this.updateValue();
        }
    }

    @Override
    public Node getDisplayNode() {
        Control control = this.comboBox.isEditable() ? this.getEditableInputNode() : this.buttonCell;
        this.updateDisplayNode();
        return control;
    }

    private void updateComboBoxItems() {
        this.comboBoxItems = this.comboBox.getItems();
        this.comboBoxItems = this.comboBoxItems == null ? FXCollections.emptyObservableList() : this.comboBoxItems;
    }

    public void updateListViewItems() {
        if (this.listViewItems != null) {
            this.listViewItems.removeListener(this.weakListViewItemsListener);
        }
        this.listViewItems = this.comboBoxItems;
        this.listView.setItems(null);
        this.listView.setItems(this.listViewItems);
        if (this.listViewItems != null) {
            this.listViewItems.addListener(this.weakListViewItemsListener);
        }
        this.itemCountDirty = true;
        ((ComboBoxBase)this.getSkinnable()).requestLayout();
    }

    @Override
    public Node getPopupContent() {
        return this.listView;
    }

    @Override
    protected double computePrefWidth(double d, double d2, double d3, double d4, double d5) {
        double d6 = super.computePrefWidth(d, d2, d3, d4, d5);
        double d7 = this.listView.prefWidth(d);
        double d8 = Math.max(d6, d7);
        this.reconfigurePopup();
        return d8;
    }

    @Override
    protected double computeMinWidth(double d, double d2, double d3, double d4, double d5) {
        return 50.0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void layoutChildren(double d, double d2, double d3, double d4) {
        if (this.listViewSelectionDirty) {
            try {
                this.listSelectionLock = true;
                Object t = this.comboBox.getSelectionModel().getSelectedItem();
                this.listView.getSelectionModel().clearSelection();
                this.listView.getSelectionModel().select(t);
            }
            finally {
                this.listSelectionLock = false;
                this.listViewSelectionDirty = false;
            }
        }
        super.layoutChildren(d, d2, d3, d4);
    }

    protected boolean isHideOnClickEnabled() {
        return true;
    }

    private void updateValue() {
        Object t = this.comboBox.getValue();
        MultipleSelectionModel multipleSelectionModel = this.listView.getSelectionModel();
        if (t == null) {
            multipleSelectionModel.clearSelection();
        } else {
            int n = this.getIndexOfComboBoxValueInItemsList();
            if (n == -1) {
                this.listSelectionLock = true;
                multipleSelectionModel.clearSelection();
                this.listSelectionLock = false;
            } else {
                int n2 = this.comboBox.getSelectionModel().getSelectedIndex();
                if (n2 >= 0 && n2 < this.comboBoxItems.size()) {
                    Object e = this.comboBoxItems.get(n2);
                    if (e != null && e.equals(t)) {
                        multipleSelectionModel.select(n2);
                    } else {
                        multipleSelectionModel.select(t);
                    }
                } else {
                    int n3 = this.comboBoxItems.indexOf(t);
                    if (n3 == -1) {
                        this.updateDisplayNode();
                    } else {
                        multipleSelectionModel.select(n3);
                    }
                }
            }
        }
    }

    private TextField getEditableInputNode() {
        if (this.textField != null) {
            return this.textField;
        }
        this.textField = this.comboBox.getEditor();
        this.textField.setFocusTraversable(true);
        this.textField.promptTextProperty().bind(this.comboBox.promptTextProperty());
        this.textField.tooltipProperty().bind(this.comboBox.tooltipProperty());
        this.initialTextFieldValue = this.textField.getText();
        this.textField.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> observableValue, Boolean bl, Boolean bl2) {
                if (!ComboBoxListViewSkin.this.comboBox.isEditable()) {
                    return;
                }
                ComboBoxListViewSkin.this.comboBox.getProperties().put("FOCUSED", bl2);
                if (!bl2.booleanValue()) {
                    ComboBoxListViewSkin.this.setTextFromTextFieldIntoComboBoxValue();
                    ComboBoxListViewSkin.this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, false);
                } else {
                    ComboBoxListViewSkin.this.pseudoClassStateChanged(CONTAINS_FOCUS_PSEUDOCLASS_STATE, true);
                }
            }
        });
        return this.textField;
    }

    private void updateDisplayNode() {
        StringConverter stringConverter = this.comboBox.getConverter();
        if (stringConverter == null) {
            return;
        }
        Object t = this.comboBox.getValue();
        if (this.comboBox.isEditable()) {
            if (this.initialTextFieldValue != null && !this.initialTextFieldValue.isEmpty()) {
                this.textField.setText(this.initialTextFieldValue);
                this.initialTextFieldValue = null;
            } else {
                String string = stringConverter.toString(t);
                if (t == null || string == null) {
                    this.textField.setText("");
                } else if (!string.equals(this.textField.getText())) {
                    this.textField.setText(string);
                }
            }
        } else {
            int n = this.getIndexOfComboBoxValueInItemsList();
            if (n > -1) {
                this.buttonCell.setItem(null);
                this.buttonCell.updateIndex(n);
            } else {
                this.buttonCell.updateIndex(-1);
                boolean bl = this.updateDisplayText(this.buttonCell, t, false);
                this.buttonCell.pseudoClassStateChanged(PSEUDO_CLASS_EMPTY, bl);
                this.buttonCell.pseudoClassStateChanged(PSEUDO_CLASS_FILLED, !bl);
                this.buttonCell.pseudoClassStateChanged(PSEUDO_CLASS_SELECTED, true);
            }
        }
    }

    private boolean updateDisplayText(ListCell<T> listCell, T t, boolean bl) {
        if (bl) {
            if (listCell == null) {
                return true;
            }
            listCell.setGraphic(null);
            listCell.setText(null);
            return true;
        }
        if (t instanceof Node) {
            Node node = listCell.getGraphic();
            Node node2 = (Node)t;
            if (node == null || !node.equals(node2)) {
                listCell.setText(null);
                listCell.setGraphic(node2);
            }
            return node2 == null;
        }
        StringConverter<T> stringConverter = this.comboBox.getConverter();
        String string = t == null ? this.comboBox.getPromptText() : (stringConverter == null ? t.toString() : stringConverter.toString(t));
        listCell.setText(string);
        listCell.setGraphic(null);
        return string == null || string.isEmpty();
    }

    private void setTextFromTextFieldIntoComboBoxValue() {
        Object object;
        if (!this.comboBox.isEditable()) {
            return;
        }
        StringConverter<T> stringConverter = this.comboBox.getConverter();
        if (stringConverter == null) {
            return;
        }
        Object t = this.comboBox.getValue();
        String string = this.textField.getText();
        Object object2 = object = t == null && (string == null || string.isEmpty()) ? null : (Object)stringConverter.fromString(this.textField.getText());
        if (object == null && t == null || object != null && object.equals(t)) {
            return;
        }
        this.comboBox.setValue(object);
    }

    private int getIndexOfComboBoxValueInItemsList() {
        Object t = this.comboBox.getValue();
        int n = this.comboBoxItems.indexOf(t);
        return n;
    }

    private void updateButtonCell() {
        this.buttonCell = this.comboBox.getButtonCell() != null ? this.comboBox.getButtonCell() : this.getDefaultCellFactory().call(this.listView);
        this.buttonCell.setMouseTransparent(true);
        this.buttonCell.updateListView(this.listView);
    }

    private void updateCellFactory() {
        Callback<ListView<T>, ListCell<T>> callback = this.comboBox.getCellFactory();
        this.cellFactory = callback != null ? callback : this.getDefaultCellFactory();
        this.listView.setCellFactory(this.cellFactory);
    }

    private Callback<ListView<T>, ListCell<T>> getDefaultCellFactory() {
        return new Callback<ListView<T>, ListCell<T>>(){

            @Override
            public ListCell<T> call(ListView<T> listView) {
                return new ListCell<T>(){

                    @Override
                    public void updateItem(T t, boolean bl) {
                        super.updateItem(t, bl);
                        ComboBoxListViewSkin.this.updateDisplayText(this, t, bl);
                    }
                };
            }
        };
    }

    private ListView<T> createListView() {
        ListView listView = new ListView<T>(){

            @Override
            protected double computeMinHeight(double d) {
                return 30.0;
            }

            @Override
            protected double computePrefWidth(double d) {
                double d2;
                if (this.getSkin() instanceof ListViewSkin) {
                    ListViewSkin listViewSkin = (ListViewSkin)this.getSkin();
                    if (ComboBoxListViewSkin.this.itemCountDirty) {
                        listViewSkin.updateRowCount();
                        ComboBoxListViewSkin.this.itemCountDirty = false;
                    }
                    int n = -1;
                    if (ComboBoxListViewSkin.this.comboBox.getProperties().containsKey(ComboBoxListViewSkin.COMBO_BOX_ROWS_TO_MEASURE_WIDTH_KEY)) {
                        n = (Integer)ComboBoxListViewSkin.this.comboBox.getProperties().get(ComboBoxListViewSkin.COMBO_BOX_ROWS_TO_MEASURE_WIDTH_KEY);
                    }
                    d2 = Math.max(ComboBoxListViewSkin.this.comboBox.getWidth(), listViewSkin.getMaxCellWidth(n) + 30.0);
                } else {
                    d2 = Math.max(100.0, ComboBoxListViewSkin.this.comboBox.getWidth());
                }
                if (this.getItems().isEmpty() && this.getPlaceholder() != null) {
                    d2 = Math.max(super.computePrefWidth(d), d2);
                }
                return Math.max(50.0, d2);
            }

            @Override
            protected double computePrefHeight(double d) {
                return ComboBoxListViewSkin.this.getListViewPrefHeight();
            }
        };
        listView.setId("list-view");
        listView.placeholderProperty().bind(this.comboBox.placeholderProperty());
        listView.getSelectionModel().setSelectionMode(SelectionMode.SINGLE);
        listView.getSelectionModel().selectedIndexProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                if (ComboBoxListViewSkin.this.listSelectionLock) {
                    return;
                }
                int n = ComboBoxListViewSkin.this.listView.getSelectionModel().getSelectedIndex();
                ComboBoxListViewSkin.this.comboBox.getSelectionModel().select(n);
                ComboBoxListViewSkin.this.updateDisplayNode();
            }
        });
        this.comboBox.getSelectionModel().selectedItemProperty().addListener(new InvalidationListener(){

            @Override
            public void invalidated(Observable observable) {
                ComboBoxListViewSkin.this.listViewSelectionDirty = true;
            }
        });
        listView.addEventFilter(MouseEvent.MOUSE_RELEASED, new EventHandler<MouseEvent>(){

            @Override
            public void handle(MouseEvent mouseEvent) {
                ObservableList<String> observableList;
                EventTarget eventTarget = mouseEvent.getTarget();
                if (eventTarget instanceof Parent && ((observableList = ((Parent)eventTarget).getStyleClass()).contains("thumb") || observableList.contains("track") || observableList.contains("decrement-arrow") || observableList.contains("increment-arrow"))) {
                    return;
                }
                if (ComboBoxListViewSkin.this.isHideOnClickEnabled()) {
                    ComboBoxListViewSkin.this.comboBox.hide();
                }
            }
        });
        listView.setOnKeyPressed(new EventHandler<KeyEvent>(){

            @Override
            public void handle(KeyEvent keyEvent) {
                if (keyEvent.getCode() == KeyCode.ENTER || keyEvent.getCode() == KeyCode.SPACE || keyEvent.getCode() == KeyCode.ESCAPE) {
                    ComboBoxListViewSkin.this.comboBox.hide();
                }
            }
        });
        return listView;
    }

    private double getListViewPrefHeight() {
        double d;
        if (this.listView.getSkin() instanceof VirtualContainerBase) {
            int n = this.comboBox.getVisibleRowCount();
            VirtualContainerBase virtualContainerBase = (VirtualContainerBase)this.listView.getSkin();
            d = virtualContainerBase.getVirtualFlowPreferredHeight(n);
        } else {
            double d2 = this.comboBoxItems.size() * 25;
            d = Math.min(d2, 200.0);
        }
        return d;
    }

    public ListView<T> getListView() {
        return this.listView;
    }

    public static final class FakeFocusTextField
    extends TextField {
        public void setFakeFocus(boolean bl) {
            this.setFocused(bl);
        }
    }
}

