/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.saxon;

import java.io.InputStream;
import java.lang.ref.SoftReference;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import org.kitesdk.morphline.saxon.ClassLoaderUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class XMLInputFactoryCreator {
    private static final boolean CACHE_DTDS = true;
    private static final Logger LOG = LoggerFactory.getLogger(XMLInputFactoryCreator.class);
    private SoftReference factoryRef = new SoftReference<Object>(null);
    private static final String[] StAX_FACTORIES = new String[]{"com.ctc.wstx.stax.WstxInputFactory", "com.sun.xml.internal.stream.XMLInputFactoryImpl"};

    public synchronized XMLInputFactory getXMLInputFactory() {
        XMLInputFactory inputFactory = (XMLInputFactory)this.factoryRef.get();
        if (inputFactory == null) {
            inputFactory = this.createInputFactory();
            this.factoryRef = new SoftReference<XMLInputFactory>(inputFactory);
        }
        return inputFactory;
    }

    private XMLInputFactory createInputFactory() {
        XMLInputFactory factory2;
        for (int i = 0; i < StAX_FACTORIES.length; ++i) {
            try {
                XMLInputFactory factory2 = (XMLInputFactory)ClassLoaderUtil.newInstance(StAX_FACTORIES[i]);
                this.setupProperties(factory2);
                LOG.debug("Using XMLInputFactory {}", (Object)factory2.getClass().getName());
                return factory2;
            }
            catch (IllegalArgumentException e) {
                continue;
            }
            catch (NoClassDefFoundError err) {
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            factory2 = XMLInputFactory.newInstance();
            this.setupProperties(factory2);
        }
        catch (IllegalArgumentException ex) {
            throw new IllegalArgumentException("Could not find or create a suitable StAX parser - check your classpath", ex);
        }
        catch (Exception ex) {
            throw new IllegalArgumentException("Could not find or create a suitable StAX parser - check your classpath", ex);
        }
        catch (NoClassDefFoundError ex) {
            throw new IllegalArgumentException("Could not find or create a suitable StAX parser - check your classpath", ex);
        }
        LOG.debug("Using default XMLInputFactory {}", (Object)factory2.getClass().getName());
        return factory2;
    }

    protected void setupProperties(XMLInputFactory factory) {
        factory.setProperty("javax.xml.stream.isNamespaceAware", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
        factory.setProperty("javax.xml.stream.supportDTD", Boolean.TRUE);
        try {
            factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            factory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.TRUE);
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        factory.setXMLResolver(new XMLResolver(){

            @Override
            public InputStream resolveEntity(String publicID, String systemID, String baseURI, String namespace) {
                return new InputStream(){

                    @Override
                    public int read() {
                        return -1;
                    }
                };
            }
        });
        String factoryName = factory.getClass().getName();
        if (factoryName.equals("com.ctc.wstx.stax.WstxInputFactory")) {
            try {
                String P_LAZY_PARSING = "com.ctc.wstx.lazyParsing";
                factory.setProperty(P_LAZY_PARSING, Boolean.FALSE);
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
            try {
                String P_CACHE_DTDS = "com.ctc.wstx.cacheDTDs";
                factory.setProperty(P_CACHE_DTDS, true);
            }
            catch (IllegalArgumentException e) {}
        } else if (factoryName.equals("com.sun.xml.stream.ZephyrParserFactory")) {
            try {
                String P_REPORT_CDATA = "report-cdata-event";
                factory.setProperty(P_REPORT_CDATA, Boolean.TRUE);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }
}

