/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.config.Config;
import com.sun.deploy.resources.ResourceManager;
import com.sun.deploy.security.CertStore;
import com.sun.deploy.security.CertUtils;
import com.sun.deploy.security.CredentialInfo;
import com.sun.deploy.security.ImmutableCertStore;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Random;
import java.util.TreeSet;

public final class RootCertStore
implements CertStore {
    private static String _userFilename = null;
    private static String _systemFilename = null;
    private long _userLastModified = 0L;
    private long _sysLastModified = 0L;
    private KeyStore _deploymentUserCACerts = CertUtils.createEmptyKeyStore();
    private KeyStore _deploymentSystemCACerts = CertUtils.createEmptyKeyStore();
    private char[] keyPassphrase = new char[0];
    private boolean cancelFlag = false;
    private int certStoreType = 0;

    private RootCertStore(int n) {
        this.certStoreType = n;
    }

    public static CertStore getCertStore() {
        return new ImmutableCertStore(new RootCertStore(3));
    }

    public static CertStore getUserCertStore() {
        return new RootCertStore(1);
    }

    public static CertStore getSystemCertStore() {
        return new ImmutableCertStore(new RootCertStore(2));
    }

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        this.load(false);
    }

    public void load(boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        long l;
        if ((this.certStoreType & 1) == 1 && _userFilename != null && (l = CertUtils.getFileLastModified(_userFilename)) != this._userLastModified) {
            this._deploymentUserCACerts = this.loadCertStore(_userFilename, bl);
            this._userLastModified = l;
        }
        if ((this.certStoreType & 2) == 2 && _systemFilename != null) {
            l = CertUtils.getFileLastModified(_systemFilename);
            if (l != this._sysLastModified) {
                this._deploymentSystemCACerts = this.loadCertStore(_systemFilename, bl);
                this._sysLastModified = l;
            }
            if (l == 0L) {
                Trace.msgSecurityPrintln("rootcertstore.cert.noload", new Object[]{_systemFilename});
            }
        }
    }

    private KeyStore loadCertStore(final String string, final boolean bl) throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("rootcertstore.cert.loading", new Object[]{string});
        final File file = new File(string);
        final KeyStore keyStore = KeyStore.getInstance("JKS");
        keyStore.load(null, null);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    if (file.exists()) {
                        FileInputStream fileInputStream = new FileInputStream(file);
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        if (bl) {
                            RootCertStore.this.cancelFlag = false;
                            keyStore.load(bufferedInputStream, new char[0]);
                        } else {
                            keyStore.load(bufferedInputStream, null);
                        }
                        bufferedInputStream.close();
                        fileInputStream.close();
                    } else {
                        Trace.msgSecurityPrintln("rootcertstore.cert.noload", new Object[]{string});
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                if (bl) {
                    FileInputStream fileInputStream = new FileInputStream(file);
                    BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                    CredentialInfo credentialInfo = ToolkitStore.getUI().showPasswordDialog(null, ResourceManager.getMessage("password.dialog.title"), ResourceManager.getMessage("rootcertstore.password.dialog.text"), false, false, null, false, null);
                    if (credentialInfo != null) {
                        this.cancelFlag = false;
                        this.keyPassphrase = credentialInfo.getPassword();
                        keyStore.load(bufferedInputStream, this.keyPassphrase);
                    } else {
                        this.cancelFlag = true;
                    }
                    bufferedInputStream.close();
                    fileInputStream.close();
                }
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("rootcertstore.cert.loaded", new Object[]{string});
        return keyStore;
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.msgSecurityPrintln("rootcertstore.cert.saving", new Object[]{_userFilename});
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file = new File(_userFilename);
                    file.getParentFile().mkdirs();
                    FileOutputStream fileOutputStream = new FileOutputStream(file);
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    RootCertStore.this._deploymentUserCACerts.store(bufferedOutputStream, RootCertStore.this.keyPassphrase);
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.msgSecurityPrintln("cacertstore.cert.saved", new Object[]{_userFilename});
    }

    public boolean add(Certificate certificate) throws KeyStoreException {
        return this.add(certificate, null, false);
    }

    public boolean add(Certificate certificate, String string, boolean bl) throws KeyStoreException {
        Trace.msgSecurityPrintln("rootcertstore.cert.adding");
        if (this.cancelFlag) {
            return false;
        }
        String string2 = this._deploymentUserCACerts.getCertificateAlias(certificate);
        if (string2 == null) {
            Random random = new Random();
            boolean bl2 = false;
            String string3 = null;
            do {
                Certificate certificate2;
                if ((certificate2 = this._deploymentUserCACerts.getCertificate(string3 = "usercacert" + random.nextLong())) != null) continue;
                bl2 = true;
            } while (!bl2);
            this._deploymentUserCACerts.setCertificateEntry(string3, certificate);
            Trace.msgSecurityPrintln("rootcertstore.cert.added", new Object[]{string3});
        }
        return true;
    }

    public boolean remove(Certificate certificate) throws IOException, KeyStoreException {
        Trace.msgSecurityPrintln("rootcertstore.cert.removing");
        if (this.cancelFlag) {
            return false;
        }
        String string = this._deploymentUserCACerts.getCertificateAlias(certificate);
        if (string != null) {
            this._deploymentUserCACerts.deleteEntry(string);
        }
        Trace.msgSecurityPrintln("rootcertstore.cert.removed", new Object[]{string});
        return true;
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        return this.contains(certificate, null, false);
    }

    public boolean contains(Certificate certificate, String string, boolean bl) throws KeyStoreException {
        Trace.msgSecurityPrintln("rootcertstore.cert.instore");
        String string2 = null;
        string2 = this._deploymentSystemCACerts.getCertificateAlias(certificate);
        if (string2 != null) {
            return true;
        }
        string2 = this._deploymentUserCACerts.getCertificateAlias(certificate);
        return string2 != null;
    }

    public boolean verify(Certificate certificate) throws KeyStoreException {
        Trace.msgSecurityPrintln("rootcertstore.cert.canverify");
        Trace.msgSecurityPrintln("rootcertstore.cert.tobeverified", new Object[]{certificate});
        StringBuffer stringBuffer = new StringBuffer();
        Enumeration<String> enumeration = this._deploymentSystemCACerts.aliases();
        Enumeration<String> enumeration2 = this._deploymentUserCACerts.aliases();
        while (enumeration.hasMoreElements() || enumeration2.hasMoreElements()) {
            Certificate certificate2;
            String string;
            if (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                certificate2 = this._deploymentSystemCACerts.getCertificate(string);
            } else {
                string = enumeration2.nextElement();
                certificate2 = this._deploymentUserCACerts.getCertificate(string);
            }
            Trace.msgSecurityPrintln("rootcertstore.cert.tobecompared", new Object[]{certificate2});
            try {
                certificate.verify(certificate2.getPublicKey());
                Trace.msgSecurityPrintln("rootcertstore.cert.verify.ok");
                return true;
            }
            catch (GeneralSecurityException generalSecurityException) {
            }
        }
        Trace.msgSecurityPrintln("rootcertstore.cert.verify.fail");
        return false;
    }

    public Collection getCertificates() throws KeyStoreException {
        HashSet hashSet = new HashSet();
        if ((this.certStoreType & 1) == 1) {
            hashSet.addAll(this.getCertificates(1));
        }
        if ((this.certStoreType & 2) == 2) {
            hashSet.addAll(this.getCertificates(2));
        }
        return hashSet;
    }

    private Collection getCertificates(int n) throws KeyStoreException {
        Object object;
        Trace.msgSecurityPrintln("rootcertstore.cert.getcertificates");
        ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
        KeyStore keyStore = null;
        keyStore = n == 1 ? this._deploymentUserCACerts : this._deploymentSystemCACerts;
        Enumeration<String> enumeration = keyStore.aliases();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            treeSet.add(object);
        }
        object = treeSet.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            Certificate certificate = keyStore.getCertificate(string);
            arrayList.add(certificate);
        }
        return arrayList;
    }

    static {
        _userFilename = Config.getUserRootCertificateFile();
        _systemFilename = Config.isJavaVersionAtLeast15() ? Config.getSystemRootCertificateFile() : Config.getOldSystemRootCertificateFile();
    }
}

