/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.security;

import com.sun.deploy.model.Resource;
import com.sun.deploy.model.ResourceProvider;
import com.sun.deploy.security.ruleset.DeploymentRuleSet;
import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import com.sun.deploy.ui.AppInfo;
import com.sun.deploy.uitoolkit.ToolkitStore;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.jar.Attributes;
import java.util.jar.JarFile;

public class DeployManifestChecker {
    private static final String PERMISSIONS_ATTR = "Permissions";
    private static final String CODEBASE_ATTR = "Codebase";
    private static final String NAME_ATTR = "Application-Name";
    private static final String LIBRARY_CODEBASE_ATTR = "Application-Library-Allowable-Codebase";
    private static final String SANDBOX_VALUE = "sandbox";
    private static final String ALLPERMS_VALUE = "all-permissions";
    private static final String ENTRY_POINT = "Entry-Point";
    private static final String JARJNLP_SUFFIX = ".jarjnlp";
    private static final String JAR_SUFFIX = ".jar";

    private DeployManifestChecker() {
    }

    public static void verify(DeploymentRuleSet deploymentRuleSet, URL uRL, boolean bl, AppInfo appInfo) {
        String string = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL);
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        if (resource == null || !resource.isJarFile()) {
            return;
        }
        JarFile jarFile = resource.getJarFile();
        try {
            DeployManifestChecker.verify(deploymentRuleSet, uRL, jarFile.getManifest().getMainAttributes(), bl, appInfo);
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
            throw new SecurityException("unexpected exception when trying to access manifest attributes");
        }
    }

    public static void verifyMainJar(DeploymentRuleSet deploymentRuleSet, URL uRL, boolean bl, AppInfo appInfo) {
        String string = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL);
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        if (resource == null || !resource.isJarFile()) {
            return;
        }
        JarFile jarFile = resource.getJarFile();
        try {
            DeployManifestChecker.verifyMainJar(deploymentRuleSet, uRL, jarFile.getManifest().getMainAttributes(), bl, appInfo);
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
            throw new SecurityException("unexpected exception when trying to access manifest attributes");
        }
    }

    static void verifyMainJar(DeploymentRuleSet deploymentRuleSet, URL uRL, Attributes attributes, boolean bl, AppInfo appInfo) {
        String string = attributes.getValue(PERMISSIONS_ATTR);
        if (string == null) {
            if (deploymentRuleSet.isPermissionsManifestRequired()) {
                throw new SecurityException("Missing required Permissions manifest attribute in main jar: " + uRL);
            }
            Trace.println("Missing Permissions manifest attribute in main jar: " + uRL);
        }
    }

    public static int getPermissionRequestType(URL uRL, String string) {
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        if (resource == null || !resource.isJarFile()) {
            return 0;
        }
        JarFile jarFile = resource.getJarFile();
        try {
            Attributes attributes = jarFile.getManifest().getMainAttributes();
            String string2 = attributes.getValue(PERMISSIONS_ATTR);
            if (string2 != null) {
                if (string2.equals(SANDBOX_VALUE)) {
                    return 1;
                }
                if (string2.equals(ALLPERMS_VALUE)) {
                    return 2;
                }
            }
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
        return 0;
    }

    static void verify(DeploymentRuleSet deploymentRuleSet, URL uRL, Attributes attributes, boolean bl, AppInfo appInfo) {
        String string;
        if (appInfo != null && !appInfo.hasSignedJNLP()) {
            string = attributes.getValue(NAME_ATTR);
            if (string == null) {
                string = attributes.getValue(Attributes.Name.MAIN_CLASS);
            }
            appInfo.setTitle(string);
        }
        string = attributes.getValue(PERMISSIONS_ATTR);
        if (appInfo != null) {
            appInfo.setPermissionAttr(string != null);
        }
        if (SANDBOX_VALUE.equals(string)) {
            if (bl) {
                throw new SecurityException("JAR manifest requested to run in sandbox only: " + uRL);
            }
        } else if (ALLPERMS_VALUE.equals(string)) {
            if (!bl) {
                throw new SecurityException("JAR manifest requested to run in all-permissons only: " + uRL);
            }
        } else if (string != null) {
            throw new SecurityException("Invalid Permissions value: " + string);
        }
        if ((string = attributes.getValue(CODEBASE_ATTR)) == null) {
            Trace.println("Missing Codebase manifest attribute for: " + uRL, TraceLevel.SECURITY);
        } else if (!DeployManifestChecker.verifyCodebase(uRL, string, false)) {
            throw new SecurityException("JAR manifest codebase mismatch for " + uRL);
        }
        string = attributes.getValue(LIBRARY_CODEBASE_ATTR);
        if (string == null) {
            Trace.println("Missing Application-Library-Allowable-Codebase manifest attribute for: " + uRL, TraceLevel.SECURITY);
        } else if (!DeployManifestChecker.verifyApplicationLibraryAllowableCodebase(uRL, appInfo)) {
            throw new SecurityException("JAR manifest application-library-allowable-codebase  mismatch for " + uRL);
        }
    }

    public static String verifyMainClass(String string, Attributes attributes) {
        if (string == null) {
            string = attributes.getValue(Attributes.Name.MAIN_CLASS);
        }
        String string2 = attributes.getValue(ENTRY_POINT);
        String[] stringArray = null;
        if (string2 == null) {
            return string;
        }
        stringArray = string2.split("\\s");
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (int i = 0; i < stringArray.length; ++i) {
            hashMap.put(stringArray[i].trim(), "true");
        }
        if (string != null && hashMap.get(string) == null) {
            throw new SecurityException(string + " class is not mentioned in the Entry point list");
        }
        return string;
    }

    public static boolean verifyCodebase(URL uRL, String string, boolean bl) {
        int n = DeployManifestChecker.verifyCodebaseEx(uRL, string, bl);
        return n == 4 || n == 2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int verifyCodebaseEx(URL uRL, String string, boolean bl) {
        String string2 = uRL.getHost();
        String string3 = uRL.getProtocol();
        int n = uRL.getPort();
        boolean bl2 = false;
        String[] stringArray = string.split("\\s");
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        int n2 = 0;
        while (n2 < stringArray.length) {
            int n3;
            String string4 = null;
            String string5 = null;
            URL uRL2 = null;
            try {
                uRL2 = new URL(stringArray[n2]);
                string4 = uRL2.getHost();
                string5 = uRL2.getProtocol();
                n3 = uRL2.getPort();
            }
            catch (MalformedURLException malformedURLException) {
                string4 = stringArray[n2];
                int n4 = string4.indexOf(":");
                if (n4 == -1) {
                    n3 = -1;
                }
                string4 = stringArray[n2].substring(0, n4);
                n3 = Integer.parseInt(stringArray[n2].substring(n4 + 1));
            }
            if (n3 == -1) {
                bl5 = true;
            } else if (n3 == n) {
                bl5 = true;
            }
            if (string5 != null) {
                if (string5.equals(string3)) {
                    bl3 = true;
                }
            } else {
                bl3 = true;
            }
            if (string4.equals("*")) {
                bl4 = true;
                bl2 = true;
            } else if (string4.indexOf("*") != -1) {
                if (!string4.startsWith("*.")) throw new SecurityException("Invalid Codebase value: " + stringArray[n2]);
                String string6 = string4.substring(2);
                if (string2.endsWith(string6)) {
                    bl4 = true;
                    if (string6.indexOf(46) == -1) {
                        bl2 = true;
                    }
                }
            } else if (string4.equals(string2)) {
                bl4 = true;
            }
            if (bl3 && bl4 && bl5) {
                if (bl && "http".equals(uRL.getProtocol()) && !"http".equals(string5)) {
                    Trace.println("Javascript from a non secure page is accessing privileged code. Consider using HTTPS protocol when using Javascript -> Java liveconnect calls.", TraceLevel.SECURITY);
                }
                if (!bl2) return 2;
                return 4;
            }
            bl4 = false;
            bl3 = false;
            bl5 = false;
            ++n2;
        }
        return 1;
    }

    public static boolean verifyApplicationLibraryAllowableCodebase(URL uRL, AppInfo appInfo) {
        String string;
        if (uRL.toString().endsWith(JARJNLP_SUFFIX)) {
            string = uRL.toString();
            try {
                uRL = new URL(string.substring(0, string.length() - JARJNLP_SUFFIX.length()) + JAR_SUFFIX);
            }
            catch (MalformedURLException malformedURLException) {
                Trace.ignored(malformedURLException);
                return false;
            }
        }
        string = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL);
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        if (resource == null || !resource.isJarFile()) {
            return true;
        }
        JarFile jarFile = resource.getJarFile();
        boolean bl = false;
        try {
            String string2 = jarFile.getManifest().getMainAttributes().getValue(LIBRARY_CODEBASE_ATTR);
            if (string2 == null) {
                Trace.println("Missing Application-Library-Allowable-Codebase manifest attribute for: " + uRL, TraceLevel.SECURITY);
            }
            if (string2 != null && string2.trim().length() > 0) {
                URL[] uRLArray = appInfo.getMultiHostUrls();
                for (int i = 0; i < uRLArray.length && (bl = DeployManifestChecker.verifyCodebase(uRLArray[i], string2, false)); ++i) {
                }
            }
        }
        catch (IOException iOException) {
            Trace.ignored(iOException);
        }
        return bl;
    }

    static void printWarningsIfRequired(URL uRL, AppInfo appInfo) {
        String string = (String)ToolkitStore.get().getAppContext().get("deploy-" + uRL);
        Resource resource = ResourceProvider.get().getCachedResource(uRL, string);
        if (resource == null || !resource.isJarFile()) {
            return;
        }
        JarFile jarFile = resource.getJarFile();
        if (appInfo != null && !appInfo.hasSignedJNLP()) {
            try {
                Attributes attributes = jarFile.getManifest().getMainAttributes();
                String string2 = attributes.getValue(NAME_ATTR);
                if (string2 == null) {
                    Trace.println("Missing Application-Name manifest attribute for: " + uRL);
                }
            }
            catch (IOException iOException) {
                Trace.ignored(iOException);
            }
        }
    }

    public final class CodebaseCheckState {
        public static final int NO_MATCH = 1;
        public static final int STRICT_MATCH = 2;
        public static final int MATCH_BY_WILDCARD = 4;
    }
}

