/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.tagger.trainAndTest;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SuffixTree {
    public String text = "";
    public List<Node> nodes = new ArrayList<Node>();
    public Map<EDGE_KEY, Edge> edges = new HashMap<EDGE_KEY, Edge>();
    char[] chars;
    Suffix active_point = new Suffix(0, 0, -1);

    public SuffixTree() {
        this("");
    }

    public SuffixTree(String text) {
        this.nodes.removeAll(this.nodes);
        this.text = text;
        this.chars = text.toCharArray();
        for (int i = 0; i < this.chars.length; ++i) {
            this.add_prefix(i, this.active_point);
        }
    }

    public void insert_edge(Edge edge) {
        EDGE_KEY keys = new EDGE_KEY(edge.start_node, this.chars[edge.first_char_index]);
        this.edges.put(keys, edge);
    }

    public void add_prefix(int last_char, Suffix active_point) {
        int last_parent_node = -1;
        int parent_node = 0;
        while (true) {
            Edge edge;
            parent_node = active_point.origin_node;
            if (active_point.isExplicit()) {
                EDGE_KEY keys = new EDGE_KEY(active_point.origin_node, this.chars[last_char]);
                if (this.edges.containsKey(keys)) {
                    edge = this.edges.get(keys);
                    break;
                }
            } else if (active_point.isImplicit()) {
                EDGE_KEY keys2 = new EDGE_KEY(active_point.origin_node, this.chars[active_point.first_char_index]);
                edge = this.edges.get(keys2);
                int span = active_point.last_char_index - active_point.first_char_index;
                if (this.chars[edge.first_char_index + span + 1] == this.chars[last_char]) break;
                parent_node = edge.split_edge(active_point);
            }
            Node next = new Node();
            this.nodes.add(next);
            int new_node_index = this.nodes.size();
            edge = new Edge(parent_node, new_node_index, last_char, this.chars.length - 1);
            this.insert_edge(edge);
            if (last_parent_node > 0) {
                this.nodes.get((int)(last_parent_node - 1)).suffix_node = parent_node;
            }
            last_parent_node = parent_node;
            if (active_point.origin_node == 0) {
                ++active_point.first_char_index;
            } else {
                active_point.origin_node = this.nodes.get((int)(active_point.origin_node - 1)).suffix_node;
            }
            active_point.canonize();
        }
        if (last_parent_node > 0) {
            this.nodes.get((int)(last_parent_node - 1)).suffix_node = parent_node;
        }
        ++active_point.last_char_index;
        active_point.canonize();
    }

    public class Node {
        public int suffix_node = -1;
    }

    public class Edge {
        public int first_char_index;
        public int last_char_index;
        int start_node;
        public int end_node;

        public Edge(int parent_node, int end_node, int first_char_index, int last_char_index) {
            this.first_char_index = first_char_index;
            this.last_char_index = last_char_index;
            this.start_node = parent_node;
            this.end_node = end_node;
        }

        public int split_edge(Suffix suffix) {
            Node next = new Node();
            SuffixTree.this.nodes.add(next);
            int new_node_index = SuffixTree.this.nodes.size();
            int suf_span = suffix.last_char_index - suffix.first_char_index + 1;
            SuffixTree.this.nodes.get((int)(new_node_index - 1)).suffix_node = suffix.origin_node;
            Edge new_edge = new Edge(new_node_index, this.end_node, this.first_char_index + suf_span, this.last_char_index);
            SuffixTree.this.insert_edge(new_edge);
            this.last_char_index = this.first_char_index + suf_span - 1;
            SuffixTree.this.insert_edge(new Edge(this.start_node, new_node_index, this.first_char_index, this.last_char_index));
            return new_node_index;
        }
    }

    public class EDGE_KEY {
        private int suffix_begin;
        private char suffix;

        public EDGE_KEY(int i, char s) {
            this.suffix_begin = i;
            this.suffix = s;
        }

        public boolean equals(Object o) {
            if (o instanceof EDGE_KEY) {
                EDGE_KEY ek = (EDGE_KEY)o;
                if (this.suffix_begin == ek.suffix_begin && this.suffix == ek.suffix) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            int hash = 0;
            if ((hash <<= 1) < 0) {
                hash |= 1;
            }
            hash ^= this.suffix_begin;
            return hash ^= this.suffix;
        }
    }

    class Suffix {
        int origin_node;
        int first_char_index;
        int last_char_index;

        public Suffix(int node, int begin, int end) {
            this.origin_node = node;
            this.first_char_index = begin;
            this.last_char_index = end;
        }

        boolean isExplicit() {
            return this.first_char_index > this.last_char_index;
        }

        boolean isImplicit() {
            return this.last_char_index >= this.first_char_index;
        }

        void canonize() {
            if (!this.isExplicit()) {
                EDGE_KEY keys = new EDGE_KEY(this.origin_node, SuffixTree.this.chars[this.first_char_index]);
                Edge edge = SuffixTree.this.edges.get(keys);
                int edge_span = edge.last_char_index - edge.first_char_index + 1;
                int suffix_span = this.last_char_index - this.first_char_index + 1;
                if (edge_span <= suffix_span) {
                    this.first_char_index += edge_span;
                    this.origin_node = edge.end_node;
                    this.canonize();
                }
            }
        }
    }
}

