/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.examples.tagger;

import java.util.ArrayList;
import org.apache.uima.UIMAFramework;
import org.apache.uima.UimaContext;
import org.apache.uima.analysis_component.JCasAnnotator_ImplBase;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.CASException;
import org.apache.uima.cas.FSIterator;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.Type;
import org.apache.uima.examples.tagger.trainAndTest.ModelGeneration;
import org.apache.uima.examples.tagger.trainAndTest.Token;
import org.apache.uima.jcas.JCas;
import org.apache.uima.jcas.tcas.Annotation;
import org.apache.uima.resource.ResourceInitializationException;
import org.apache.uima.util.Level;

public class HMMModelTrainer
extends JCasAnnotator_ImplBase {
    public static String PARAM_VIEW = "View";
    public static String PARAM_FILE = "ModelExportFile";
    public static String PARAM_POSFP = "FeaturePathPOS";
    private String theView;
    private String fileOutput;
    private String theTokenTypeName;
    private String thePOSAttribute;
    private ArrayList<Token> theLearnedTokens;

    public void initialize(UimaContext aContext) throws ResourceInitializationException {
        super.initialize(aContext);
        this.theView = (String)aContext.getConfigParameterValue(PARAM_VIEW);
        this.fileOutput = (String)aContext.getConfigParameterValue(PARAM_FILE);
        String fpPOS = (String)aContext.getConfigParameterValue(PARAM_POSFP);
        Integer idx = fpPOS.lastIndexOf(":");
        if (idx < 0) {
            throw new ResourceInitializationException("The feature path passed in parameter ('" + fpPOS + "') is not valid. " + "It should be like : 'type.name:attribute'", null);
        }
        this.theTokenTypeName = fpPOS.substring(0, idx);
        this.thePOSAttribute = fpPOS.substring(idx + 1);
        this.theLearnedTokens = new ArrayList();
    }

    public void process(JCas cas) throws AnalysisEngineProcessException {
        try {
            Integer i;
            Integer c;
            JCas workingView = cas.getView(this.theView);
            Type tokenType = workingView.getTypeSystem().getType(this.theTokenTypeName);
            if (tokenType != null) {
                Feature featPOS = tokenType.getFeatureByBaseName(this.thePOSAttribute);
                FSIterator itPOS = workingView.getAnnotationIndex(tokenType).iterator();
                c = 0;
                i = 0;
                while (itPOS.hasNext()) {
                    Integer n;
                    Integer n2;
                    Annotation token = (Annotation)itPOS.next();
                    Token tokenTmp = new Token();
                    tokenTmp.word = token.getCoveredText();
                    tokenTmp.pos = token.getStringValue(featPOS);
                    if (tokenTmp.pos != null) {
                        n2 = c;
                        n = c = Integer.valueOf(c + 1);
                        this.theLearnedTokens.add(tokenTmp);
                        continue;
                    }
                    UIMAFramework.getLogger().log(Level.WARNING, "Ignoring token " + tokenTmp.word + " because its " + "POS value is null");
                    n2 = i;
                    n = i = Integer.valueOf(i + 1);
                }
            } else {
                throw new AnalysisEngineProcessException("The type '" + this.theTokenTypeName + "', passed as token type " + "for the training is not in the type system.", null);
            }
            UIMAFramework.getLogger().log(Level.INFO, c + " tokens to be learned added, " + i + " tokens ignored.");
        }
        catch (CASException e) {
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }

    public void collectionProcessComplete() throws AnalysisEngineProcessException {
        try {
            UIMAFramework.getLogger().log(Level.INFO, "Generation of model '" + this.fileOutput + "' with " + this.theLearnedTokens.size() + " tokens to be learned.");
            ModelGeneration md = new ModelGeneration(this.theLearnedTokens, this.fileOutput);
            md.init();
            UIMAFramework.getLogger().log(Level.INFO, "Model generated: " + md.suffix_tree.size() + " leaves suffix tree, " + md.transition_probs.size() + " transitions probabilities, " + md.word_probs.size() + " tag probabilities.");
        }
        catch (Exception e) {
            UIMAFramework.getLogger().log(Level.SEVERE, "Something happened : " + e.getMessage());
            e.printStackTrace();
            throw new AnalysisEngineProcessException((Throwable)e);
        }
    }
}

