/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop.dedup;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Reducer;
import org.apache.solr.common.SolrInputDocument;
import org.apache.solr.hadoop.dedup.SolrInputDocumentComparator;
import org.apache.solr.hadoop.dedup.UpdateConflictResolver;

public class SortingUpdateConflictResolver
implements UpdateConflictResolver,
Configurable {
    private Configuration conf;
    private String orderByFieldName = "file_last_modified";
    public static final String ORDER_BY_FIELD_NAME_KEY = SortingUpdateConflictResolver.class.getName() + ".orderByFieldName";
    public static final String ORDER_BY_FIELD_NAME_DEFAULT = "file_last_modified";

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.orderByFieldName = conf.get(ORDER_BY_FIELD_NAME_KEY, this.orderByFieldName);
    }

    public Configuration getConf() {
        return this.conf;
    }

    protected String getOrderByFieldName() {
        return this.orderByFieldName;
    }

    @Override
    public Iterator<SolrInputDocument> orderUpdates(Text key, Iterator<SolrInputDocument> updates, Reducer.Context ctx) {
        return this.sort(updates, this.getOrderByFieldName(), new SolrInputDocumentComparator.TimeStampComparator());
    }

    protected Iterator<SolrInputDocument> sort(Iterator<SolrInputDocument> updates, String fieldName, Comparator child) {
        ArrayList<SolrInputDocument> sortedUpdates = new ArrayList<SolrInputDocument>(1);
        while (updates.hasNext()) {
            sortedUpdates.add(updates.next());
        }
        if (sortedUpdates.size() > 1) {
            Collections.sort(sortedUpdates, new SolrInputDocumentComparator(fieldName, child));
        }
        return sortedUpdates.iterator();
    }
}

