/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.solr.hadoop.SolrRecordWriter;
import org.apache.solr.hadoop.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrOutputFormat<K, V>
extends FileOutputFormat<K, V> {
    private static final Logger LOG = LoggerFactory.getLogger(SolrOutputFormat.class);
    public static final String SETUP_OK = "solr.output.format.setup";
    public static final String ZIP_NAME = "solr.zip.name";
    public static final String ZIP_FILE_BASE_NAME = "solr.zip";
    public static final String OUTPUT_ZIP_FILE = "solr.output.zip.format";
    static int defaultSolrWriterThreadCount = 0;
    public static final String SOLR_WRITER_THREAD_COUNT = "solr.record.writer.num.threads";
    static int defaultSolrWriterQueueSize = 1;
    public static final String SOLR_WRITER_QUEUE_SIZE = "solr.record.writer.max.queues.size";
    static int defaultSolrBatchSize = 20;
    public static final String SOLR_RECORD_WRITER_BATCH_SIZE = "solr.record.writer.batch.size";
    public static final String SOLR_RECORD_WRITER_MAX_SEGMENTS = "solr.record.writer.maxSegments";

    public static String getSetupOk() {
        return SETUP_OK;
    }

    public static void setSolrWriterThreadCount(int count, Configuration conf) {
        conf.setInt(SOLR_WRITER_THREAD_COUNT, count);
    }

    public static int getSolrWriterThreadCount(Configuration conf) {
        return conf.getInt(SOLR_WRITER_THREAD_COUNT, defaultSolrWriterThreadCount);
    }

    public static void setSolrWriterQueueSize(int count, Configuration conf) {
        conf.setInt(SOLR_WRITER_QUEUE_SIZE, count);
    }

    public static int getSolrWriterQueueSize(Configuration conf) {
        return conf.getInt(SOLR_WRITER_QUEUE_SIZE, defaultSolrWriterQueueSize);
    }

    public static String getZipName(Configuration conf) {
        return conf.get(ZIP_NAME, ZIP_FILE_BASE_NAME);
    }

    public static void setOutputZipFormat(boolean output, Configuration conf) {
        conf.setBoolean(OUTPUT_ZIP_FILE, output);
    }

    public static boolean isOutputZipFormat(Configuration conf) {
        return conf.getBoolean(OUTPUT_ZIP_FILE, false);
    }

    public static String getOutputName(JobContext job) {
        return FileOutputFormat.getOutputName((JobContext)job);
    }

    public void checkOutputSpecs(JobContext job) throws IOException {
        super.checkOutputSpecs(job);
        if (job.getConfiguration().get(SETUP_OK) == null) {
            throw new IOException("Solr home cache not set up!");
        }
    }

    public RecordWriter<K, V> getRecordWriter(TaskAttemptContext context) throws IOException, InterruptedException {
        Utils.getLogConfigFile(context.getConfiguration());
        Path workDir = this.getDefaultWorkFile(context, "");
        int batchSize = SolrOutputFormat.getBatchSize(context.getConfiguration());
        return new SolrRecordWriter(context, workDir, batchSize);
    }

    public static void setupSolrHomeCache(File solrHomeDir, Job job) throws IOException {
        File solrHomeZip = SolrOutputFormat.createSolrHomeZip(solrHomeDir);
        SolrOutputFormat.addSolrConfToDistributedCache(job, solrHomeZip);
    }

    public static File createSolrHomeZip(File solrHomeDir) throws IOException {
        return SolrOutputFormat.createSolrHomeZip(solrHomeDir, false);
    }

    private static File createSolrHomeZip(File solrHomeDir, boolean safeToModify) throws IOException {
        if (solrHomeDir == null || !solrHomeDir.exists() || !solrHomeDir.isDirectory()) {
            throw new IOException("Invalid solr home: " + solrHomeDir);
        }
        File solrHomeZip = File.createTempFile("solr", ".zip");
        SolrOutputFormat.createZip(solrHomeDir, solrHomeZip);
        return solrHomeZip;
    }

    public static void addSolrConfToDistributedCache(Job job, File solrHomeZip) throws IOException {
        String hdfsZipName = UUID.randomUUID().toString() + '.' + ZIP_FILE_BASE_NAME;
        Configuration jobConf = job.getConfiguration();
        jobConf.set(ZIP_NAME, hdfsZipName);
        Path zipPath = new Path("/tmp", SolrOutputFormat.getZipName(jobConf));
        FileSystem fs = FileSystem.get((Configuration)jobConf);
        fs.copyFromLocalFile(new Path(solrHomeZip.toString()), zipPath);
        URI baseZipUrl = fs.getUri().resolve(zipPath.toString() + '#' + SolrOutputFormat.getZipName(jobConf));
        DistributedCache.addCacheArchive((URI)baseZipUrl, (Configuration)jobConf);
        LOG.debug("Set Solr distributed cache: {}", Arrays.asList(job.getCacheArchives()));
        LOG.debug("Set zipPath: {}", (Object)zipPath);
        jobConf.set(SETUP_OK, zipPath.toString());
    }

    private static void createZip(File dir, File out) throws IOException {
        HashSet<File> files = new HashSet<File>();
        for (String allowedDirectory : SolrRecordWriter.getAllowedConfigDirectories()) {
            File configDir = new File(dir, allowedDirectory);
            boolean configDirExists = configDir.exists();
            if (!configDirExists && SolrRecordWriter.isRequiredConfigDirectory(allowedDirectory)) {
                throw new IOException(String.format(Locale.ENGLISH, "required configuration directory %s is not present in %s", allowedDirectory, dir));
            }
            if (!configDirExists) continue;
            SolrOutputFormat.listFiles(configDir, files);
        }
        out.delete();
        int subst = dir.toString().length();
        ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(out));
        byte[] buf = new byte[1024];
        for (File f : files) {
            int cnt;
            ZipEntry ze = new ZipEntry(f.toString().substring(subst));
            zos.putNextEntry(ze);
            FileInputStream is = new FileInputStream(f);
            while ((cnt = ((InputStream)is).read(buf)) >= 0) {
                zos.write(buf, 0, cnt);
            }
            ((InputStream)is).close();
            zos.flush();
            zos.closeEntry();
        }
        ZipEntry ze = new ZipEntry("solr.xml");
        zos.putNextEntry(ze);
        zos.write("<cores><core name=\"collection1\" instanceDir=\".\"/></cores>".getBytes(StandardCharsets.UTF_8));
        zos.flush();
        zos.closeEntry();
        zos.close();
    }

    private static void listFiles(File dir, Set<File> files) throws IOException {
        File[] list = dir.listFiles();
        if (list == null && dir.isFile()) {
            files.add(dir);
            return;
        }
        for (File f : list) {
            if (f.isFile()) {
                files.add(f);
                continue;
            }
            SolrOutputFormat.listFiles(f, files);
        }
    }

    public static int getBatchSize(Configuration jobConf) {
        return jobConf.getInt(SOLR_RECORD_WRITER_BATCH_SIZE, defaultSolrBatchSize);
    }

    public static void setBatchSize(int count, Configuration jobConf) {
        jobConf.setInt(SOLR_RECORD_WRITER_BATCH_SIZE, count);
    }
}

