/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.hadoop;

import java.io.IOException;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;

public final class PathParts {
    private final String uploadURL;
    private final Configuration conf;
    private final FileSystem fs;
    private final Path normalizedPath;
    private FileStatus stats;

    public PathParts(String uploadURL, Configuration conf) throws IOException {
        if (uploadURL == null) {
            throw new IllegalArgumentException("Path must not be null: " + uploadURL);
        }
        this.uploadURL = uploadURL;
        if (conf == null) {
            throw new IllegalArgumentException("Configuration must not be null: " + uploadURL);
        }
        this.conf = conf;
        URI uri = this.stringToUri(uploadURL);
        this.fs = FileSystem.get((URI)uri, (Configuration)conf);
        if (this.fs == null) {
            throw new IllegalArgumentException("File system must not be null: " + uploadURL);
        }
        this.normalizedPath = this.fs.makeQualified(new Path(uri));
        if (!this.normalizedPath.isAbsolute()) {
            throw new IllegalArgumentException("Path must be absolute: " + uploadURL);
        }
        if (this.getScheme() == null) {
            throw new IllegalArgumentException("Scheme must not be null: " + uploadURL);
        }
        if (this.getHost() == null) {
            throw new IllegalArgumentException("Host must not be null: " + uploadURL);
        }
        if (this.getPort() < 0) {
            throw new IllegalArgumentException("Port must not be negative: " + uploadURL);
        }
    }

    public String getUploadURL() {
        return this.uploadURL;
    }

    public Path getUploadPath() {
        return new Path(this.getUploadURL());
    }

    public String getURIPath() {
        return this.normalizedPath.toUri().getPath();
    }

    public String getName() {
        return this.normalizedPath.getName();
    }

    public String getScheme() {
        return this.normalizedPath.toUri().getScheme();
    }

    public String getHost() {
        return this.normalizedPath.toUri().getHost();
    }

    public int getPort() {
        int port = this.normalizedPath.toUri().getPort();
        if (port == -1 && (port = this.fs.getWorkingDirectory().toUri().getPort()) == -1) {
            port = 8020;
        }
        return port;
    }

    public String getId() {
        return this.getScheme() + "://" + this.getHost() + ":" + this.getPort() + this.getURIPath();
    }

    public String getDownloadURL() {
        return this.getId();
    }

    public Configuration getConfiguration() {
        return this.conf;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public FileStatus getFileStatus() throws IOException {
        if (this.stats == null) {
            this.stats = this.getFileSystem().getFileStatus(this.getUploadPath());
        }
        return this.stats;
    }

    private URI stringToUri(String pathString) {
        return URI.create(pathString).normalize();
    }
}

