/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.cloud;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IpTables {
    static final Logger log = LoggerFactory.getLogger(IpTables.class);
    private static boolean ENABLED = Boolean.getBoolean("solr.tests.use.iptables");
    private static Set<Integer> BLOCK_PORTS = Collections.synchronizedSet(new HashSet());

    public static void blockPort(int port) throws IOException, InterruptedException {
        if (ENABLED) {
            log.info("Block port with iptables: " + port);
            BLOCK_PORTS.add(port);
            IpTables.runCmd(("iptables -A INPUT -p tcp --dport " + port + " -j DROP").split("\\s"));
            IpTables.runCmd(("iptables -A OUTPUT -p tcp --dport " + port + " -j DROP").split("\\s"));
        }
    }

    public static void unblockPort(int port) throws IOException, InterruptedException {
        if (ENABLED) {
            log.info("Unblock port with iptables: " + port);
            IpTables.runCmd(("iptables -D INPUT -p tcp --dport " + port + " -j DROP").split("\\s"));
            IpTables.runCmd(("iptables -D OUTPUT -p tcp --dport " + port + " -j DROP").split("\\s"));
        }
    }

    public static void unblockAllPorts() throws IOException, InterruptedException {
        if (ENABLED) {
            log.info("Unblocking any ports previously blocked with iptables...");
            for (Integer port : BLOCK_PORTS) {
                IpTables.unblockPort(port);
            }
        }
    }

    private static void runCmd(String[] cmd) throws IOException, InterruptedException {
        ProcessBuilder pb = new ProcessBuilder(cmd);
        pb.redirectErrorStream(true);
        Process p = pb.start();
        PrintStream childOut = System.err;
        Thread stdoutPumper = ThreadPumper.start(p.getInputStream(), childOut, true);
        Thread stderrPumper = ThreadPumper.start(p.getErrorStream(), childOut, true);
        childOut.println(">>> Begin subprocess output");
        p.waitFor();
        stdoutPumper.join();
        stderrPumper.join();
        childOut.println("<<< End subprocess output");
    }

    static class ThreadPumper {
        public static Thread start(final InputStream from, final OutputStream to, final boolean verbose) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        int len;
                        byte[] buffer = new byte[1024];
                        while ((len = from.read(buffer)) != -1) {
                            if (!verbose) continue;
                            to.write(buffer, 0, len);
                        }
                    }
                    catch (IOException e) {
                        System.err.println("Couldn't pipe from the forked process: " + e.toString());
                    }
                }
            };
            t.start();
            return t;
        }
    }
}

