/*
 * Decompiled with CFR 0.152.
 */
package org.kitesdk.morphline.stdlib;

import com.google.common.base.Joiner;
import com.typesafe.config.Config;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.TimeZone;
import org.kitesdk.morphline.api.Command;
import org.kitesdk.morphline.api.CommandBuilder;
import org.kitesdk.morphline.api.MorphlineCompilationException;
import org.kitesdk.morphline.api.MorphlineContext;
import org.kitesdk.morphline.api.Record;
import org.kitesdk.morphline.base.AbstractCommand;

public final class ConvertTimestampBuilder
implements CommandBuilder {
    @Override
    public Collection<String> getNames() {
        return Collections.singletonList("convertTimestamp");
    }

    @Override
    public Command build(Config config, Command parent, Command child, MorphlineContext context) {
        return new ConvertTimestamp(this, config, parent, child, context);
    }

    private static final class ConvertTimestamp
    extends AbstractCommand {
        private final String fieldName;
        private final List<SimpleDateFormat> inputFormats = new ArrayList<SimpleDateFormat>();
        private final SimpleDateFormat outputFormat;
        private final String inputFormatsDebugString;
        private static final String NATIVE_SOLR_FORMAT = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
        private static final SimpleDateFormat UNIX_TIME_IN_MILLIS = new SimpleDateFormat("'unixTimeInMillis'");
        private static final SimpleDateFormat UNIX_TIME_IN_SECONDS = new SimpleDateFormat("'unixTimeInSeconds'");

        public ConvertTimestamp(CommandBuilder builder, Config config, Command parent, Command child, MorphlineContext context) {
            super(builder, config, parent, child, context);
            this.fieldName = this.getConfigs().getString(config, "field", "timestamp");
            TimeZone inputTimeZone = this.getTimeZone(this.getConfigs().getString(config, "inputTimezone", "UTC"));
            Locale inputLocale = this.getLocale(this.getConfigs().getString(config, "inputLocale", ""));
            for (String inputFormat : this.getConfigs().getStringList(config, "inputFormats", DateUtil.DEFAULT_DATE_FORMATS)) {
                SimpleDateFormat dateFormat = this.getUnixTimeFormat(inputFormat, inputTimeZone);
                if (dateFormat == null) {
                    dateFormat = new SimpleDateFormat(inputFormat, inputLocale);
                    dateFormat.setTimeZone(inputTimeZone);
                    dateFormat.set2DigitYearStart(DateUtil.DEFAULT_TWO_DIGIT_YEAR_START);
                }
                this.inputFormats.add(dateFormat);
            }
            TimeZone outputTimeZone = this.getTimeZone(this.getConfigs().getString(config, "outputTimezone", "UTC"));
            Locale outputLocale = this.getLocale(this.getConfigs().getString(config, "outputLocale", ""));
            String outputFormatStr = this.getConfigs().getString(config, "outputFormat", NATIVE_SOLR_FORMAT);
            SimpleDateFormat dateFormat = this.getUnixTimeFormat(outputFormatStr, outputTimeZone);
            if (dateFormat == null) {
                dateFormat = new SimpleDateFormat(outputFormatStr, outputLocale);
                dateFormat.setTimeZone(outputTimeZone);
            }
            this.outputFormat = dateFormat;
            this.validateArguments();
            ArrayList<String> inputFormatsStringList = new ArrayList<String>();
            for (SimpleDateFormat inputFormat : this.inputFormats) {
                inputFormatsStringList.add(inputFormat.toPattern());
            }
            this.inputFormatsDebugString = ((Object)inputFormatsStringList).toString();
            if (this.LOG.isTraceEnabled()) {
                this.LOG.trace("inputFormatsDebugString: {}", (Object)this.inputFormatsDebugString);
                this.LOG.trace("availableTimeZoneIDs: {}", (Object)Joiner.on((String)"\n").join((Object[])TimeZone.getAvailableIDs()));
                this.LOG.trace("availableLocales: {}", (Object)Joiner.on((String)"\n").join((Object[])Locale.getAvailableLocales()));
            }
        }

        @Override
        protected boolean doProcess(Record record) {
            ParsePosition pos = new ParsePosition(0);
            ListIterator<String> iter = record.get(this.fieldName).listIterator();
            while (iter.hasNext()) {
                String timestamp = iter.next().toString();
                boolean foundMatchingFormat = false;
                for (SimpleDateFormat inputFormat : this.inputFormats) {
                    Date date;
                    boolean isUnixTime;
                    if (inputFormat == UNIX_TIME_IN_MILLIS) {
                        isUnixTime = true;
                        date = this.parseUnixTime(timestamp, 1L);
                    } else if (inputFormat == UNIX_TIME_IN_SECONDS) {
                        isUnixTime = true;
                        date = this.parseUnixTime(timestamp, 1000L);
                    } else {
                        isUnixTime = false;
                        pos.setIndex(0);
                        date = inputFormat.parse(timestamp, pos);
                    }
                    if (date == null || !isUnixTime && pos.getIndex() != timestamp.length()) continue;
                    String result = this.outputFormat == UNIX_TIME_IN_MILLIS ? String.valueOf(date.getTime()) : (this.outputFormat == UNIX_TIME_IN_SECONDS ? String.valueOf(date.getTime() / 1000L) : this.outputFormat.format(date));
                    iter.set(result);
                    foundMatchingFormat = true;
                    break;
                }
                if (foundMatchingFormat) continue;
                this.LOG.debug("Cannot parse timestamp '{}' with any of these input formats: {}", (Object)timestamp, (Object)this.inputFormatsDebugString);
                return false;
            }
            return super.doProcess(record);
        }

        private SimpleDateFormat getUnixTimeFormat(String format, TimeZone timeZone) {
            if (format.equals("unixTimeInMillis")) {
                if (!"UTC".equals(timeZone.getID())) {
                    throw new MorphlineCompilationException("timeZone must be UTC for date format 'unixTimeInMillis'", this.getConfig());
                }
                return UNIX_TIME_IN_MILLIS;
            }
            if (format.equals("unixTimeInSeconds")) {
                if (!"UTC".equals(timeZone.getID())) {
                    throw new MorphlineCompilationException("timeZone must be UTC for date format 'unixTimeInSeconds'", this.getConfig());
                }
                return UNIX_TIME_IN_SECONDS;
            }
            return null;
        }

        private Date parseUnixTime(String timestamp, long scale) {
            try {
                return new Date(scale * Long.parseLong(timestamp));
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        private TimeZone getTimeZone(String timeZoneID) {
            if (!Arrays.asList(TimeZone.getAvailableIDs()).contains(timeZoneID)) {
                throw new MorphlineCompilationException("Unknown timezone: " + timeZoneID, this.getConfig());
            }
            return TimeZone.getTimeZone(timeZoneID);
        }

        private Locale getLocale(String name) {
            for (Locale locale : Locale.getAvailableLocales()) {
                if (!locale.toString().equals(name)) continue;
                return locale;
            }
            assert (Locale.ROOT.toString().equals(""));
            if (name.equals(Locale.ROOT.toString())) {
                return Locale.ROOT;
            }
            throw new MorphlineCompilationException("Unknown locale: " + name, this.getConfig());
        }

        static {
            DateUtil.DEFAULT_DATE_FORMATS.add(0, NATIVE_SOLR_FORMAT);
        }

        private static final class DateUtil {
            public static final String PATTERN_RFC1123 = "EEE, dd MMM yyyy HH:mm:ss zzz";
            public static final String PATTERN_RFC1036 = "EEEE, dd-MMM-yy HH:mm:ss zzz";
            public static final String PATTERN_ASCTIME = "EEE MMM d HH:mm:ss yyyy";
            private static final Collection<String> DEFAULT_HTTP_CLIENT_PATTERNS = Arrays.asList("EEE MMM d HH:mm:ss yyyy", "EEEE, dd-MMM-yy HH:mm:ss zzz", "EEE, dd MMM yyyy HH:mm:ss zzz");
            private static final Date DEFAULT_TWO_DIGIT_YEAR_START;
            public static final List<String> DEFAULT_DATE_FORMATS;

            private DateUtil() {
            }

            static {
                Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("GMT"), Locale.ROOT);
                calendar.set(2000, 0, 1, 0, 0);
                DEFAULT_TWO_DIGIT_YEAR_START = calendar.getTime();
                DEFAULT_DATE_FORMATS = new ArrayList<String>();
                DEFAULT_DATE_FORMATS.add("yyyy-MM-dd'T'HH:mm:ss'Z'");
                DEFAULT_DATE_FORMATS.add("yyyy-MM-dd'T'HH:mm:ss");
                DEFAULT_DATE_FORMATS.add("yyyy-MM-dd");
                DEFAULT_DATE_FORMATS.add("yyyy-MM-dd hh:mm:ss");
                DEFAULT_DATE_FORMATS.add("yyyy-MM-dd HH:mm:ss");
                DEFAULT_DATE_FORMATS.add("EEE MMM d hh:mm:ss z yyyy");
                DEFAULT_DATE_FORMATS.addAll(DEFAULT_HTTP_CLIENT_PATTERNS);
            }
        }
    }
}

