/*
 * Decompiled with CFR 0.152.
 */
package sun.util.locale.provider;

import java.util.Locale;
import java.util.Map;
import java.util.spi.CalendarDataProvider;
import java.util.spi.CalendarNameProvider;
import sun.util.locale.provider.CalendarNameProviderImpl;
import sun.util.locale.provider.LocaleServiceProviderPool;

public class CalendarDataUtility {
    public static final String FIRST_DAY_OF_WEEK = "firstDayOfWeek";
    public static final String MINIMAL_DAYS_IN_FIRST_WEEK = "minimalDaysInFirstWeek";

    private CalendarDataUtility() {
    }

    public static int retrieveFirstDayOfWeek(Locale locale) {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CalendarDataProvider.class);
        Integer n = localeServiceProviderPool.getLocalizedObject(CalendarWeekParameterGetter.INSTANCE, locale, FIRST_DAY_OF_WEEK, new Object[0]);
        return n != null && n >= 1 && n <= 7 ? n : 1;
    }

    public static int retrieveMinimalDaysInFirstWeek(Locale locale) {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CalendarDataProvider.class);
        Integer n = localeServiceProviderPool.getLocalizedObject(CalendarWeekParameterGetter.INSTANCE, locale, MINIMAL_DAYS_IN_FIRST_WEEK, new Object[0]);
        return n != null && n >= 1 && n <= 7 ? n : 1;
    }

    public static String retrieveFieldValueName(String string, int n, int n2, int n3, Locale locale) {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CalendarNameProvider.class);
        return localeServiceProviderPool.getLocalizedObject(CalendarFieldValueNameGetter.INSTANCE, locale, CalendarDataUtility.normalizeCalendarType(string), n, n2, n3, false);
    }

    public static String retrieveJavaTimeFieldValueName(String string, int n, int n2, int n3, Locale locale) {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CalendarNameProvider.class);
        String string2 = localeServiceProviderPool.getLocalizedObject(CalendarFieldValueNameGetter.INSTANCE, locale, CalendarDataUtility.normalizeCalendarType(string), n, n2, n3, true);
        if (string2 == null) {
            string2 = localeServiceProviderPool.getLocalizedObject(CalendarFieldValueNameGetter.INSTANCE, locale, CalendarDataUtility.normalizeCalendarType(string), n, n2, n3, false);
        }
        return string2;
    }

    public static Map<String, Integer> retrieveFieldValueNames(String string, int n, int n2, Locale locale) {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CalendarNameProvider.class);
        return localeServiceProviderPool.getLocalizedObject(CalendarFieldValueNamesMapGetter.INSTANCE, locale, CalendarDataUtility.normalizeCalendarType(string), n, n2, false);
    }

    public static Map<String, Integer> retrieveJavaTimeFieldValueNames(String string, int n, int n2, Locale locale) {
        LocaleServiceProviderPool localeServiceProviderPool = LocaleServiceProviderPool.getPool(CalendarNameProvider.class);
        Map<String, Integer> map = localeServiceProviderPool.getLocalizedObject(CalendarFieldValueNamesMapGetter.INSTANCE, locale, CalendarDataUtility.normalizeCalendarType(string), n, n2, true);
        if (map == null) {
            map = localeServiceProviderPool.getLocalizedObject(CalendarFieldValueNamesMapGetter.INSTANCE, locale, CalendarDataUtility.normalizeCalendarType(string), n, n2, false);
        }
        return map;
    }

    static String normalizeCalendarType(String string) {
        String string2 = string.equals("gregorian") || string.equals("iso8601") ? "gregory" : (string.startsWith("islamic") ? "islamic" : string);
        return string2;
    }

    private static class CalendarFieldValueNameGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<CalendarNameProvider, String> {
        private static final CalendarFieldValueNameGetter INSTANCE = new CalendarFieldValueNameGetter();

        private CalendarFieldValueNameGetter() {
        }

        @Override
        public String getObject(CalendarNameProvider calendarNameProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 4);
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            int n3 = (Integer)objectArray[2];
            boolean bl = (Boolean)objectArray[3];
            if (bl && calendarNameProvider instanceof CalendarNameProviderImpl) {
                String string2 = ((CalendarNameProviderImpl)calendarNameProvider).getJavaTimeDisplayName(string, n, n2, n3, locale);
                return string2;
            }
            return calendarNameProvider.getDisplayName(string, n, n2, n3, locale);
        }
    }

    private static class CalendarFieldValueNamesMapGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<CalendarNameProvider, Map<String, Integer>> {
        private static final CalendarFieldValueNamesMapGetter INSTANCE = new CalendarFieldValueNamesMapGetter();

        private CalendarFieldValueNamesMapGetter() {
        }

        @Override
        public Map<String, Integer> getObject(CalendarNameProvider calendarNameProvider, Locale locale, String string, Object ... objectArray) {
            assert (objectArray.length == 3);
            int n = (Integer)objectArray[0];
            int n2 = (Integer)objectArray[1];
            boolean bl = (Boolean)objectArray[2];
            if (bl && calendarNameProvider instanceof CalendarNameProviderImpl) {
                Map<String, Integer> map = ((CalendarNameProviderImpl)calendarNameProvider).getJavaTimeDisplayNames(string, n, n2, locale);
                return map;
            }
            return calendarNameProvider.getDisplayNames(string, n, n2, locale);
        }
    }

    private static class CalendarWeekParameterGetter
    implements LocaleServiceProviderPool.LocalizedObjectGetter<CalendarDataProvider, Integer> {
        private static final CalendarWeekParameterGetter INSTANCE = new CalendarWeekParameterGetter();

        private CalendarWeekParameterGetter() {
        }

        @Override
        public Integer getObject(CalendarDataProvider calendarDataProvider, Locale locale, String string, Object ... objectArray) {
            int n;
            assert (objectArray.length == 0);
            switch (string) {
                case "firstDayOfWeek": {
                    n = calendarDataProvider.getFirstDayOfWeek(locale);
                    break;
                }
                case "minimalDaysInFirstWeek": {
                    n = calendarDataProvider.getMinimalDaysInFirstWeek(locale);
                    break;
                }
                default: {
                    throw new InternalError("invalid requestID: " + string);
                }
            }
            return n != 0 ? Integer.valueOf(n) : null;
        }
    }
}

