/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.AWTException;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.CheckboxMenuItem;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.FileDialog;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Image;
import java.awt.Insets;
import java.awt.JobAttributes;
import java.awt.Label;
import java.awt.List;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.PageAttributes;
import java.awt.Panel;
import java.awt.Point;
import java.awt.PopupMenu;
import java.awt.PrintJob;
import java.awt.RenderingHints;
import java.awt.Robot;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.SystemTray;
import java.awt.TextArea;
import java.awt.TextField;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.dnd.MouseDragGestureRecognizer;
import java.awt.dnd.peer.DragSourceContextPeer;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.awt.im.spi.InputMethodDescriptor;
import java.awt.image.ColorModel;
import java.awt.peer.ButtonPeer;
import java.awt.peer.CanvasPeer;
import java.awt.peer.CheckboxMenuItemPeer;
import java.awt.peer.CheckboxPeer;
import java.awt.peer.ChoicePeer;
import java.awt.peer.DesktopPeer;
import java.awt.peer.DialogPeer;
import java.awt.peer.FileDialogPeer;
import java.awt.peer.FontPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.KeyboardFocusManagerPeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.ListPeer;
import java.awt.peer.MenuBarPeer;
import java.awt.peer.MenuItemPeer;
import java.awt.peer.MenuPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.PopupMenuPeer;
import java.awt.peer.RobotPeer;
import java.awt.peer.ScrollPanePeer;
import java.awt.peer.ScrollbarPeer;
import java.awt.peer.SystemTrayPeer;
import java.awt.peer.TextAreaPeer;
import java.awt.peer.TextFieldPeer;
import java.awt.peer.TrayIconPeer;
import java.awt.peer.WindowPeer;
import java.beans.PropertyChangeListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import sun.awt.AWTAutoShutdown;
import sun.awt.AppContext;
import sun.awt.LightweightFrame;
import sun.awt.SunToolkit;
import sun.awt.Win32GraphicsDevice;
import sun.awt.Win32GraphicsEnvironment;
import sun.awt.windows.WButtonPeer;
import sun.awt.windows.WCanvasPeer;
import sun.awt.windows.WCheckboxMenuItemPeer;
import sun.awt.windows.WCheckboxPeer;
import sun.awt.windows.WChoicePeer;
import sun.awt.windows.WClipboard;
import sun.awt.windows.WCustomCursor;
import sun.awt.windows.WDesktopPeer;
import sun.awt.windows.WDesktopProperties;
import sun.awt.windows.WDialogPeer;
import sun.awt.windows.WDragSourceContextPeer;
import sun.awt.windows.WEmbeddedFrame;
import sun.awt.windows.WEmbeddedFramePeer;
import sun.awt.windows.WFileDialogPeer;
import sun.awt.windows.WFontMetrics;
import sun.awt.windows.WFontPeer;
import sun.awt.windows.WFramePeer;
import sun.awt.windows.WInputMethod;
import sun.awt.windows.WInputMethodDescriptor;
import sun.awt.windows.WKeyboardFocusManagerPeer;
import sun.awt.windows.WLabelPeer;
import sun.awt.windows.WLightweightFramePeer;
import sun.awt.windows.WListPeer;
import sun.awt.windows.WMenuBarPeer;
import sun.awt.windows.WMenuItemPeer;
import sun.awt.windows.WMenuPeer;
import sun.awt.windows.WMouseDragGestureRecognizer;
import sun.awt.windows.WPageDialog;
import sun.awt.windows.WPageDialogPeer;
import sun.awt.windows.WPanelPeer;
import sun.awt.windows.WPopupMenuPeer;
import sun.awt.windows.WPrintDialog;
import sun.awt.windows.WPrintDialogPeer;
import sun.awt.windows.WRobotPeer;
import sun.awt.windows.WScrollPanePeer;
import sun.awt.windows.WScrollbarPeer;
import sun.awt.windows.WSystemTrayPeer;
import sun.awt.windows.WTextAreaPeer;
import sun.awt.windows.WTextFieldPeer;
import sun.awt.windows.WTrayIconPeer;
import sun.awt.windows.WWindowPeer;
import sun.font.FontManager;
import sun.font.FontManagerFactory;
import sun.font.SunFontManager;
import sun.java2d.Disposer;
import sun.java2d.DisposerRecord;
import sun.java2d.d3d.D3DRenderQueue;
import sun.java2d.opengl.OGLRenderQueue;
import sun.misc.PerformanceLogger;
import sun.misc.ThreadGroupUtils;
import sun.print.PrintJob2D;
import sun.security.util.SecurityConstants;
import sun.util.logging.PlatformLogger;

public class WToolkit
extends SunToolkit
implements Runnable {
    private static final PlatformLogger log = PlatformLogger.getLogger("sun.awt.windows.WToolkit");
    static GraphicsConfiguration config;
    WClipboard clipboard;
    private Hashtable<String, FontPeer> cacheFontPeer;
    private WDesktopProperties wprops;
    protected boolean dynamicLayoutSetting = false;
    private static boolean areExtraMouseButtonsEnabled;
    private static boolean loaded;
    public static final String DATA_TRANSFERER_CLASS_NAME = "sun.awt.windows.WDataTransferer";
    private final Object anchor = new Object();
    private boolean inited = false;
    static ColorModel screenmodel;
    private static final String prefix = "DnD.Cursor.";
    private static final String postfix = ".32x32";
    private static final String awtPrefix = "awt.";
    private static final String dndPrefix = "DnD.";

    private static native void initIDs();

    public static void loadLibraries() {
        if (!loaded) {
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    System.loadLibrary("awt");
                    return null;
                }
            });
            loaded = true;
        }
    }

    private static native String getWindowsVersion();

    private static native void disableCustomPalette();

    public static void resetGC() {
        config = GraphicsEnvironment.isHeadless() ? null : GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
    }

    public static native boolean embeddedInit();

    public static native boolean embeddedDispose();

    public native void embeddedEventLoopIdleProcessing();

    private static native void postDispose();

    private static native boolean startToolkitThread(Runnable var0, ThreadGroup var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WToolkit() {
        Runnable runnable;
        if (PerformanceLogger.loggingEnabled()) {
            PerformanceLogger.setTime("WToolkit construction");
        }
        Disposer.addRecord(this.anchor, new ToolkitDisposer());
        AWTAutoShutdown.notifyToolkitThreadBusy();
        ThreadGroup threadGroup = AccessController.doPrivileged(ThreadGroupUtils::getRootThreadGroup);
        if (!WToolkit.startToolkitThread(this, threadGroup)) {
            runnable = new Thread(threadGroup, this, "AWT-Windows");
            ((Thread)runnable).setDaemon(true);
            ((Thread)runnable).start();
        }
        try {
            runnable = this;
            synchronized (runnable) {
                while (!this.inited) {
                    this.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        SunToolkit.setDataTransfererClassName(DATA_TRANSFERER_CLASS_NAME);
        this.setDynamicLayout(true);
        areExtraMouseButtonsEnabled = Boolean.parseBoolean(System.getProperty("sun.awt.enableExtraMouseButtons", "true"));
        System.setProperty("sun.awt.enableExtraMouseButtons", "" + areExtraMouseButtonsEnabled);
        WToolkit.setExtraMouseButtonsEnabledNative(areExtraMouseButtonsEnabled);
    }

    private final void registerShutdownHook() {
        AccessController.doPrivileged(() -> {
            Thread thread = new Thread(ThreadGroupUtils.getRootThreadGroup(), this::shutdown);
            thread.setContextClassLoader(null);
            Runtime.getRuntime().addShutdownHook(thread);
            return null;
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        AccessController.doPrivileged(() -> {
            Thread.currentThread().setContextClassLoader(null);
            return null;
        });
        Thread.currentThread().setPriority(6);
        boolean bl = this.init();
        if (bl) {
            this.registerShutdownHook();
        }
        WToolkit wToolkit = this;
        synchronized (wToolkit) {
            this.inited = true;
            this.notifyAll();
        }
        if (bl) {
            this.eventLoop();
        }
    }

    private native boolean init();

    private native void eventLoop();

    private native void shutdown();

    public static native void startSecondaryEventLoop();

    public static native void quitSecondaryEventLoop();

    @Override
    public ButtonPeer createButton(Button button) {
        WButtonPeer wButtonPeer = new WButtonPeer(button);
        WToolkit.targetCreatedPeer(button, wButtonPeer);
        return wButtonPeer;
    }

    @Override
    public TextFieldPeer createTextField(TextField textField) {
        WTextFieldPeer wTextFieldPeer = new WTextFieldPeer(textField);
        WToolkit.targetCreatedPeer(textField, wTextFieldPeer);
        return wTextFieldPeer;
    }

    @Override
    public LabelPeer createLabel(Label label) {
        WLabelPeer wLabelPeer = new WLabelPeer(label);
        WToolkit.targetCreatedPeer(label, wLabelPeer);
        return wLabelPeer;
    }

    @Override
    public ListPeer createList(List list) {
        WListPeer wListPeer = new WListPeer(list);
        WToolkit.targetCreatedPeer(list, wListPeer);
        return wListPeer;
    }

    @Override
    public CheckboxPeer createCheckbox(Checkbox checkbox) {
        WCheckboxPeer wCheckboxPeer = new WCheckboxPeer(checkbox);
        WToolkit.targetCreatedPeer(checkbox, wCheckboxPeer);
        return wCheckboxPeer;
    }

    @Override
    public ScrollbarPeer createScrollbar(Scrollbar scrollbar) {
        WScrollbarPeer wScrollbarPeer = new WScrollbarPeer(scrollbar);
        WToolkit.targetCreatedPeer(scrollbar, wScrollbarPeer);
        return wScrollbarPeer;
    }

    @Override
    public ScrollPanePeer createScrollPane(ScrollPane scrollPane) {
        WScrollPanePeer wScrollPanePeer = new WScrollPanePeer(scrollPane);
        WToolkit.targetCreatedPeer(scrollPane, wScrollPanePeer);
        return wScrollPanePeer;
    }

    @Override
    public TextAreaPeer createTextArea(TextArea textArea) {
        WTextAreaPeer wTextAreaPeer = new WTextAreaPeer(textArea);
        WToolkit.targetCreatedPeer(textArea, wTextAreaPeer);
        return wTextAreaPeer;
    }

    @Override
    public ChoicePeer createChoice(Choice choice) {
        WChoicePeer wChoicePeer = new WChoicePeer(choice);
        WToolkit.targetCreatedPeer(choice, wChoicePeer);
        return wChoicePeer;
    }

    @Override
    public FramePeer createFrame(Frame frame) {
        WFramePeer wFramePeer = new WFramePeer(frame);
        WToolkit.targetCreatedPeer(frame, wFramePeer);
        return wFramePeer;
    }

    @Override
    public FramePeer createLightweightFrame(LightweightFrame lightweightFrame) {
        WLightweightFramePeer wLightweightFramePeer = new WLightweightFramePeer(lightweightFrame);
        WToolkit.targetCreatedPeer(lightweightFrame, wLightweightFramePeer);
        return wLightweightFramePeer;
    }

    @Override
    public CanvasPeer createCanvas(Canvas canvas) {
        WCanvasPeer wCanvasPeer = new WCanvasPeer(canvas);
        WToolkit.targetCreatedPeer(canvas, wCanvasPeer);
        return wCanvasPeer;
    }

    @Override
    public void disableBackgroundErase(Canvas canvas) {
        WCanvasPeer wCanvasPeer = (WCanvasPeer)canvas.getPeer();
        if (wCanvasPeer == null) {
            throw new IllegalStateException("Canvas must have a valid peer");
        }
        wCanvasPeer.disableBackgroundErase();
    }

    @Override
    public PanelPeer createPanel(Panel panel) {
        WPanelPeer wPanelPeer = new WPanelPeer(panel);
        WToolkit.targetCreatedPeer(panel, wPanelPeer);
        return wPanelPeer;
    }

    @Override
    public WindowPeer createWindow(Window window) {
        WWindowPeer wWindowPeer = new WWindowPeer(window);
        WToolkit.targetCreatedPeer(window, wWindowPeer);
        return wWindowPeer;
    }

    @Override
    public DialogPeer createDialog(Dialog dialog) {
        WDialogPeer wDialogPeer = new WDialogPeer(dialog);
        WToolkit.targetCreatedPeer(dialog, wDialogPeer);
        return wDialogPeer;
    }

    @Override
    public FileDialogPeer createFileDialog(FileDialog fileDialog) {
        WFileDialogPeer wFileDialogPeer = new WFileDialogPeer(fileDialog);
        WToolkit.targetCreatedPeer(fileDialog, wFileDialogPeer);
        return wFileDialogPeer;
    }

    @Override
    public MenuBarPeer createMenuBar(MenuBar menuBar) {
        WMenuBarPeer wMenuBarPeer = new WMenuBarPeer(menuBar);
        WToolkit.targetCreatedPeer(menuBar, wMenuBarPeer);
        return wMenuBarPeer;
    }

    @Override
    public MenuPeer createMenu(Menu menu) {
        WMenuPeer wMenuPeer = new WMenuPeer(menu);
        WToolkit.targetCreatedPeer(menu, wMenuPeer);
        return wMenuPeer;
    }

    @Override
    public PopupMenuPeer createPopupMenu(PopupMenu popupMenu) {
        WPopupMenuPeer wPopupMenuPeer = new WPopupMenuPeer(popupMenu);
        WToolkit.targetCreatedPeer(popupMenu, wPopupMenuPeer);
        return wPopupMenuPeer;
    }

    @Override
    public MenuItemPeer createMenuItem(MenuItem menuItem) {
        WMenuItemPeer wMenuItemPeer = new WMenuItemPeer(menuItem);
        WToolkit.targetCreatedPeer(menuItem, wMenuItemPeer);
        return wMenuItemPeer;
    }

    @Override
    public CheckboxMenuItemPeer createCheckboxMenuItem(CheckboxMenuItem checkboxMenuItem) {
        WCheckboxMenuItemPeer wCheckboxMenuItemPeer = new WCheckboxMenuItemPeer(checkboxMenuItem);
        WToolkit.targetCreatedPeer(checkboxMenuItem, wCheckboxMenuItemPeer);
        return wCheckboxMenuItemPeer;
    }

    @Override
    public RobotPeer createRobot(Robot robot, GraphicsDevice graphicsDevice) {
        return new WRobotPeer(graphicsDevice);
    }

    public WEmbeddedFramePeer createEmbeddedFrame(WEmbeddedFrame wEmbeddedFrame) {
        WEmbeddedFramePeer wEmbeddedFramePeer = new WEmbeddedFramePeer(wEmbeddedFrame);
        WToolkit.targetCreatedPeer(wEmbeddedFrame, wEmbeddedFramePeer);
        return wEmbeddedFramePeer;
    }

    WPrintDialogPeer createWPrintDialog(WPrintDialog wPrintDialog) {
        WPrintDialogPeer wPrintDialogPeer = new WPrintDialogPeer(wPrintDialog);
        WToolkit.targetCreatedPeer(wPrintDialog, wPrintDialogPeer);
        return wPrintDialogPeer;
    }

    WPageDialogPeer createWPageDialog(WPageDialog wPageDialog) {
        WPageDialogPeer wPageDialogPeer = new WPageDialogPeer(wPageDialog);
        WToolkit.targetCreatedPeer(wPageDialog, wPageDialogPeer);
        return wPageDialogPeer;
    }

    @Override
    public TrayIconPeer createTrayIcon(TrayIcon trayIcon) {
        WTrayIconPeer wTrayIconPeer = new WTrayIconPeer(trayIcon);
        WToolkit.targetCreatedPeer(trayIcon, wTrayIconPeer);
        return wTrayIconPeer;
    }

    @Override
    public SystemTrayPeer createSystemTray(SystemTray systemTray) {
        return new WSystemTrayPeer(systemTray);
    }

    @Override
    public boolean isTraySupported() {
        return true;
    }

    @Override
    public KeyboardFocusManagerPeer getKeyboardFocusManagerPeer() throws HeadlessException {
        return WKeyboardFocusManagerPeer.getInstance();
    }

    protected native void setDynamicLayoutNative(boolean var1);

    @Override
    public void setDynamicLayout(boolean bl) {
        if (bl == this.dynamicLayoutSetting) {
            return;
        }
        this.dynamicLayoutSetting = bl;
        this.setDynamicLayoutNative(bl);
    }

    @Override
    protected boolean isDynamicLayoutSet() {
        return this.dynamicLayoutSetting;
    }

    protected native boolean isDynamicLayoutSupportedNative();

    @Override
    public boolean isDynamicLayoutActive() {
        return this.isDynamicLayoutSet() && this.isDynamicLayoutSupported();
    }

    @Override
    public boolean isFrameStateSupported(int n) {
        switch (n) {
            case 0: 
            case 1: 
            case 6: {
                return true;
            }
        }
        return false;
    }

    static native ColorModel makeColorModel();

    static ColorModel getStaticColorModel() {
        if (GraphicsEnvironment.isHeadless()) {
            throw new IllegalArgumentException();
        }
        if (config == null) {
            WToolkit.resetGC();
        }
        return config.getColorModel();
    }

    @Override
    public ColorModel getColorModel() {
        return WToolkit.getStaticColorModel();
    }

    @Override
    public Insets getScreenInsets(GraphicsConfiguration graphicsConfiguration) {
        return this.getScreenInsets(((Win32GraphicsDevice)graphicsConfiguration.getDevice()).getScreen());
    }

    @Override
    public int getScreenResolution() {
        Win32GraphicsEnvironment win32GraphicsEnvironment = (Win32GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment();
        return win32GraphicsEnvironment.getXResolution();
    }

    @Override
    protected native int getScreenWidth();

    @Override
    protected native int getScreenHeight();

    protected native Insets getScreenInsets(int var1);

    @Override
    public FontMetrics getFontMetrics(Font font) {
        FontManager fontManager = FontManagerFactory.getInstance();
        if (fontManager instanceof SunFontManager && ((SunFontManager)fontManager).usePlatformFontMetrics()) {
            return WFontMetrics.getFontMetrics(font);
        }
        return super.getFontMetrics(font);
    }

    @Override
    public FontPeer getFontPeer(String string, int n) {
        FontPeer fontPeer = null;
        String string2 = string.toLowerCase();
        if (null != this.cacheFontPeer && null != (fontPeer = this.cacheFontPeer.get(string2 + n))) {
            return fontPeer;
        }
        fontPeer = new WFontPeer(string, n);
        if (fontPeer != null) {
            if (null == this.cacheFontPeer) {
                this.cacheFontPeer = new Hashtable(5, 0.9f);
            }
            if (null != this.cacheFontPeer) {
                this.cacheFontPeer.put(string2 + n, fontPeer);
            }
        }
        return fontPeer;
    }

    private native void nativeSync();

    @Override
    public void sync() {
        this.nativeSync();
        OGLRenderQueue.sync();
        D3DRenderQueue.sync();
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, Properties properties) {
        return this.getPrintJob(frame, string, null, null);
    }

    @Override
    public PrintJob getPrintJob(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        if (frame == null) {
            throw new NullPointerException("frame must not be null");
        }
        PrintJob2D printJob2D = new PrintJob2D(frame, string, jobAttributes, pageAttributes);
        if (!printJob2D.printDialog()) {
            printJob2D = null;
        }
        return printJob2D;
    }

    @Override
    public native void beep();

    @Override
    public boolean getLockingKeyState(int n) {
        if (n != 20 && n != 144 && n != 145 && n != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.getLockingKeyState");
        }
        return this.getLockingKeyStateNative(n);
    }

    public native boolean getLockingKeyStateNative(int var1);

    @Override
    public void setLockingKeyState(int n, boolean bl) {
        if (n != 20 && n != 144 && n != 145 && n != 262) {
            throw new IllegalArgumentException("invalid key for Toolkit.setLockingKeyState");
        }
        this.setLockingKeyStateNative(n, bl);
    }

    public native void setLockingKeyStateNative(int var1, boolean var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Clipboard getSystemClipboard() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.AWT.ACCESS_CLIPBOARD_PERMISSION);
        }
        WToolkit wToolkit = this;
        synchronized (wToolkit) {
            if (this.clipboard == null) {
                this.clipboard = new WClipboard();
            }
        }
        return this.clipboard;
    }

    @Override
    protected native void loadSystemColors(int[] var1);

    public static final Object targetToPeer(Object object) {
        return SunToolkit.targetToPeer(object);
    }

    public static final void targetDisposedPeer(Object object, Object object2) {
        SunToolkit.targetDisposedPeer(object, object2);
    }

    @Override
    public InputMethodDescriptor getInputMethodAdapterDescriptor() {
        return new WInputMethodDescriptor();
    }

    @Override
    public Map<TextAttribute, ?> mapInputMethodHighlight(InputMethodHighlight inputMethodHighlight) {
        return WInputMethod.mapInputMethodHighlight(inputMethodHighlight);
    }

    @Override
    public boolean enableInputMethodsForTextComponent() {
        return true;
    }

    @Override
    public Locale getDefaultKeyboardLocale() {
        Locale locale = WInputMethod.getNativeLocale();
        if (locale == null) {
            return super.getDefaultKeyboardLocale();
        }
        return locale;
    }

    @Override
    public Cursor createCustomCursor(Image image, Point point, String string) throws IndexOutOfBoundsException {
        return new WCustomCursor(image, point, string);
    }

    @Override
    public Dimension getBestCursorSize(int n, int n2) {
        return new Dimension(WCustomCursor.getCursorWidth(), WCustomCursor.getCursorHeight());
    }

    @Override
    public native int getMaximumCursorColors();

    static void paletteChanged() {
        ((Win32GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment()).paletteChanged();
    }

    public static void displayChanged() {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                ((Win32GraphicsEnvironment)GraphicsEnvironment.getLocalGraphicsEnvironment()).displayChanged();
            }
        });
    }

    @Override
    public DragSourceContextPeer createDragSourceContextPeer(DragGestureEvent dragGestureEvent) throws InvalidDnDOperationException {
        return WDragSourceContextPeer.createDragSourceContextPeer(dragGestureEvent);
    }

    @Override
    public <T extends DragGestureRecognizer> T createDragGestureRecognizer(Class<T> clazz, DragSource dragSource, Component component, int n, DragGestureListener dragGestureListener) {
        if (MouseDragGestureRecognizer.class.equals(clazz)) {
            return (T)new WMouseDragGestureRecognizer(dragSource, component, n, dragGestureListener);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Object lazilyLoadDesktopProperty(String string) {
        if (string.startsWith(prefix)) {
            String string2 = string.substring(prefix.length(), string.length()) + postfix;
            try {
                return Cursor.getSystemCustomCursor(string2);
            }
            catch (AWTException aWTException) {
                throw new RuntimeException("cannot load system cursor: " + string2, aWTException);
            }
        }
        if (string.equals("awt.dynamicLayoutSupported")) {
            return this.isDynamicLayoutSupported();
        }
        if (WDesktopProperties.isWindowsProperty(string) || string.startsWith(awtPrefix) || string.startsWith(dndPrefix)) {
            WToolkit wToolkit = this;
            synchronized (wToolkit) {
                this.lazilyInitWProps();
                return this.desktopProperties.get(string);
            }
        }
        return super.lazilyLoadDesktopProperty(string);
    }

    private synchronized void lazilyInitWProps() {
        if (this.wprops == null) {
            this.wprops = new WDesktopProperties(this);
            this.updateProperties();
        }
    }

    private synchronized boolean isDynamicLayoutSupported() {
        boolean bl = this.isDynamicLayoutSupportedNative();
        this.lazilyInitWProps();
        Boolean bl2 = (Boolean)this.desktopProperties.get("awt.dynamicLayoutSupported");
        if (log.isLoggable(PlatformLogger.Level.FINER)) {
            log.finer("In WTK.isDynamicLayoutSupported()   nativeDynamic == " + bl + "   wprops.dynamic == " + bl2);
        }
        if (bl2 == null || bl != bl2) {
            this.windowsSettingChange();
            return bl;
        }
        return bl2;
    }

    private void windowsSettingChange() {
        if (AppContext.getAppContext() == null) {
            this.updateProperties();
        } else {
            EventQueue.invokeLater(this::updateProperties);
        }
    }

    private synchronized void updateProperties() {
        if (null == this.wprops) {
            return;
        }
        Map<String, Object> map = this.wprops.getProperties();
        for (String string : map.keySet()) {
            Object object = map.get(string);
            if (log.isLoggable(PlatformLogger.Level.FINER)) {
                log.finer("changed " + string + " to " + object);
            }
            this.setDesktopProperty(string, object);
        }
    }

    @Override
    public synchronized void addPropertyChangeListener(String string, PropertyChangeListener propertyChangeListener) {
        if (string == null) {
            return;
        }
        if (WDesktopProperties.isWindowsProperty(string) || string.startsWith(awtPrefix) || string.startsWith(dndPrefix)) {
            this.lazilyInitWProps();
        }
        super.addPropertyChangeListener(string, propertyChangeListener);
    }

    @Override
    protected synchronized void initializeDesktopProperties() {
        this.desktopProperties.put("DnD.Autoscroll.initialDelay", 50);
        this.desktopProperties.put("DnD.Autoscroll.interval", 50);
        this.desktopProperties.put("DnD.isDragImageSupported", Boolean.TRUE);
        this.desktopProperties.put("Shell.shellFolderManager", "sun.awt.shell.Win32ShellFolderManager2");
    }

    @Override
    protected synchronized RenderingHints getDesktopAAHints() {
        if (this.wprops == null) {
            return null;
        }
        return this.wprops.getDesktopAAHints();
    }

    @Override
    public boolean isModalityTypeSupported(Dialog.ModalityType modalityType) {
        return modalityType == null || modalityType == Dialog.ModalityType.MODELESS || modalityType == Dialog.ModalityType.DOCUMENT_MODAL || modalityType == Dialog.ModalityType.APPLICATION_MODAL || modalityType == Dialog.ModalityType.TOOLKIT_MODAL;
    }

    @Override
    public boolean isModalExclusionTypeSupported(Dialog.ModalExclusionType modalExclusionType) {
        return modalExclusionType == null || modalExclusionType == Dialog.ModalExclusionType.NO_EXCLUDE || modalExclusionType == Dialog.ModalExclusionType.APPLICATION_EXCLUDE || modalExclusionType == Dialog.ModalExclusionType.TOOLKIT_EXCLUDE;
    }

    public static WToolkit getWToolkit() {
        WToolkit wToolkit = (WToolkit)Toolkit.getDefaultToolkit();
        return wToolkit;
    }

    @Override
    public boolean useBufferPerWindow() {
        return !Win32GraphicsEnvironment.isDWMCompositionEnabled();
    }

    @Override
    public void grab(Window window) {
        if (window.getPeer() != null) {
            ((WWindowPeer)window.getPeer()).grab();
        }
    }

    @Override
    public void ungrab(Window window) {
        if (window.getPeer() != null) {
            ((WWindowPeer)window.getPeer()).ungrab();
        }
    }

    @Override
    public native boolean syncNativeQueue(long var1);

    @Override
    public boolean isDesktopSupported() {
        return true;
    }

    @Override
    public DesktopPeer createDesktopPeer(Desktop desktop) {
        return new WDesktopPeer();
    }

    public static native void setExtraMouseButtonsEnabledNative(boolean var0);

    @Override
    public boolean areExtraMouseButtonsEnabled() throws HeadlessException {
        return areExtraMouseButtonsEnabled;
    }

    private synchronized native int getNumberOfButtonsImpl();

    @Override
    public int getNumberOfButtons() {
        if (numberOfButtons == 0) {
            numberOfButtons = this.getNumberOfButtonsImpl();
        }
        return numberOfButtons > 20 ? 20 : numberOfButtons;
    }

    @Override
    public boolean isWindowOpacitySupported() {
        return true;
    }

    @Override
    public boolean isWindowShapingSupported() {
        return true;
    }

    @Override
    public boolean isWindowTranslucencySupported() {
        return true;
    }

    @Override
    public boolean isTranslucencyCapable(GraphicsConfiguration graphicsConfiguration) {
        return true;
    }

    @Override
    public boolean needUpdateWindow() {
        return true;
    }

    static {
        areExtraMouseButtonsEnabled = true;
        loaded = false;
        WToolkit.loadLibraries();
        WToolkit.initIDs();
        if (log.isLoggable(PlatformLogger.Level.FINE)) {
            log.fine("Win version: " + WToolkit.getWindowsVersion());
        }
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                String string = System.getProperty("browser");
                if (string != null && string.equals("sun.plugin")) {
                    WToolkit.disableCustomPalette();
                }
                return null;
            }
        });
    }

    static class ToolkitDisposer
    implements DisposerRecord {
        ToolkitDisposer() {
        }

        @Override
        public void dispose() {
            WToolkit.postDispose();
        }
    }
}

