/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FocusTraversalPolicy;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.peer.LightweightPeer;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.Transient;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectInputValidation;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.AncestorNotifier;
import javax.swing.ArrayTable;
import javax.swing.Autoscroller;
import javax.swing.CellRendererPane;
import javax.swing.ClientPropertyKey;
import javax.swing.ComponentInputMap;
import javax.swing.DebugGraphics;
import javax.swing.InputMap;
import javax.swing.InputVerifier;
import javax.swing.JInternalFrame;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.JToolTip;
import javax.swing.KeyStroke;
import javax.swing.KeyboardManager;
import javax.swing.LegacyGlueFocusTraversalPolicy;
import javax.swing.LookAndFeel;
import javax.swing.Popup;
import javax.swing.RepaintManager;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.AncestorListener;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.ComponentUI;
import javax.swing.table.JTableHeader;
import sun.awt.CausedFocusEvent;
import sun.awt.RequestFocusController;
import sun.swing.SwingUtilities2;
import sun.swing.UIClientPropertyKey;

public abstract class JComponent
extends Container
implements Serializable,
TransferHandler.HasGetTransferHandler {
    private static final String uiClassID = "ComponentUI";
    private static final Hashtable<ObjectInputStream, ReadObjectCallback> readObjectCallbacks = new Hashtable(1);
    private static Set<KeyStroke> managingFocusForwardTraversalKeys;
    private static Set<KeyStroke> managingFocusBackwardTraversalKeys;
    private static final int NOT_OBSCURED = 0;
    private static final int PARTIALLY_OBSCURED = 1;
    private static final int COMPLETELY_OBSCURED = 2;
    static boolean DEBUG_GRAPHICS_LOADED;
    private static final Object INPUT_VERIFIER_SOURCE_KEY;
    private boolean isAlignmentXSet;
    private float alignmentX;
    private boolean isAlignmentYSet;
    private float alignmentY;
    protected transient ComponentUI ui;
    protected EventListenerList listenerList = new EventListenerList();
    private transient ArrayTable clientProperties;
    private VetoableChangeSupport vetoableChangeSupport;
    private boolean autoscrolls;
    private Border border;
    private int flags;
    private InputVerifier inputVerifier = null;
    private boolean verifyInputWhenFocusTarget = true;
    transient Component paintingChild;
    public static final int WHEN_FOCUSED = 0;
    public static final int WHEN_ANCESTOR_OF_FOCUSED_COMPONENT = 1;
    public static final int WHEN_IN_FOCUSED_WINDOW = 2;
    public static final int UNDEFINED_CONDITION = -1;
    private static final String KEYBOARD_BINDINGS_KEY = "_KeyboardBindings";
    private static final String WHEN_IN_FOCUSED_WINDOW_BINDINGS = "_WhenInFocusedWindow";
    public static final String TOOL_TIP_TEXT_KEY = "ToolTipText";
    private static final String NEXT_FOCUS = "nextFocus";
    private JPopupMenu popupMenu;
    private static final int IS_DOUBLE_BUFFERED = 0;
    private static final int ANCESTOR_USING_BUFFER = 1;
    private static final int IS_PAINTING_TILE = 2;
    private static final int IS_OPAQUE = 3;
    private static final int KEY_EVENTS_ENABLED = 4;
    private static final int FOCUS_INPUTMAP_CREATED = 5;
    private static final int ANCESTOR_INPUTMAP_CREATED = 6;
    private static final int WIF_INPUTMAP_CREATED = 7;
    private static final int ACTIONMAP_CREATED = 8;
    private static final int CREATED_DOUBLE_BUFFER = 9;
    private static final int IS_PRINTING = 11;
    private static final int IS_PRINTING_ALL = 12;
    private static final int IS_REPAINTING = 13;
    private static final int WRITE_OBJ_COUNTER_FIRST = 14;
    private static final int RESERVED_1 = 15;
    private static final int RESERVED_2 = 16;
    private static final int RESERVED_3 = 17;
    private static final int RESERVED_4 = 18;
    private static final int RESERVED_5 = 19;
    private static final int RESERVED_6 = 20;
    private static final int WRITE_OBJ_COUNTER_LAST = 21;
    private static final int REQUEST_FOCUS_DISABLED = 22;
    private static final int INHERITS_POPUP_MENU = 23;
    private static final int OPAQUE_SET = 24;
    private static final int AUTOSCROLLS_SET = 25;
    private static final int FOCUS_TRAVERSAL_KEYS_FORWARD_SET = 26;
    private static final int FOCUS_TRAVERSAL_KEYS_BACKWARD_SET = 27;
    private static final int REVALIDATE_RUNNABLE_SCHEDULED = 28;
    private static List<Rectangle> tempRectangles;
    private InputMap focusInputMap;
    private InputMap ancestorInputMap;
    private ComponentInputMap windowInputMap;
    private ActionMap actionMap;
    private static final String defaultLocale = "JComponent.defaultLocale";
    private static Component componentObtainingGraphicsFrom;
    private static Object componentObtainingGraphicsFromLock;
    private transient Object aaTextInfo;
    static final RequestFocusController focusController;

    static Graphics safelyGetGraphics(Component component) {
        return JComponent.safelyGetGraphics(component, SwingUtilities.getRoot(component));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Graphics safelyGetGraphics(Component component, Component component2) {
        Object object = componentObtainingGraphicsFromLock;
        synchronized (object) {
            componentObtainingGraphicsFrom = component2;
            Graphics graphics = component.getGraphics();
            componentObtainingGraphicsFrom = null;
            return graphics;
        }
    }

    static void getGraphicsInvoked(Component component) {
        JRootPane jRootPane;
        if (!JComponent.isComponentObtainingGraphicsFrom(component) && (jRootPane = ((RootPaneContainer)((Object)component)).getRootPane()) != null) {
            jRootPane.disableTrueDoubleBuffering();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isComponentObtainingGraphicsFrom(Component component) {
        Object object = componentObtainingGraphicsFromLock;
        synchronized (object) {
            return componentObtainingGraphicsFrom == component;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<KeyStroke> getManagingFocusForwardTraversalKeys() {
        Class<JComponent> clazz = JComponent.class;
        synchronized (JComponent.class) {
            if (managingFocusForwardTraversalKeys == null) {
                managingFocusForwardTraversalKeys = new HashSet<KeyStroke>(1);
                managingFocusForwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 2));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return managingFocusForwardTraversalKeys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Set<KeyStroke> getManagingFocusBackwardTraversalKeys() {
        Class<JComponent> clazz = JComponent.class;
        synchronized (JComponent.class) {
            if (managingFocusBackwardTraversalKeys == null) {
                managingFocusBackwardTraversalKeys = new HashSet<KeyStroke>(1);
                managingFocusBackwardTraversalKeys.add(KeyStroke.getKeyStroke(9, 3));
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return managingFocusBackwardTraversalKeys;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Rectangle fetchRectangle() {
        List<Rectangle> list = tempRectangles;
        synchronized (list) {
            int n = tempRectangles.size();
            Rectangle rectangle = n > 0 ? tempRectangles.remove(n - 1) : new Rectangle(0, 0, 0, 0);
            return rectangle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void recycleRectangle(Rectangle rectangle) {
        List<Rectangle> list = tempRectangles;
        synchronized (list) {
            tempRectangles.add(rectangle);
        }
    }

    public void setInheritsPopupMenu(boolean bl) {
        boolean bl2 = this.getFlag(23);
        this.setFlag(23, bl);
        this.firePropertyChange("inheritsPopupMenu", bl2, bl);
    }

    public boolean getInheritsPopupMenu() {
        return this.getFlag(23);
    }

    public void setComponentPopupMenu(JPopupMenu jPopupMenu) {
        if (jPopupMenu != null) {
            this.enableEvents(16L);
        }
        JPopupMenu jPopupMenu2 = this.popupMenu;
        this.popupMenu = jPopupMenu;
        this.firePropertyChange("componentPopupMenu", jPopupMenu2, jPopupMenu);
    }

    public JPopupMenu getComponentPopupMenu() {
        if (!this.getInheritsPopupMenu()) {
            return this.popupMenu;
        }
        if (this.popupMenu == null) {
            for (Container container = this.getParent(); container != null; container = container.getParent()) {
                if (container instanceof JComponent) {
                    return ((JComponent)container).getComponentPopupMenu();
                }
                if (container instanceof Window || container instanceof Applet) break;
            }
            return null;
        }
        return this.popupMenu;
    }

    public JComponent() {
        this.enableEvents(8L);
        if (this.isManagingFocus()) {
            LookAndFeel.installProperty(this, "focusTraversalKeysForward", JComponent.getManagingFocusForwardTraversalKeys());
            LookAndFeel.installProperty(this, "focusTraversalKeysBackward", JComponent.getManagingFocusBackwardTraversalKeys());
        }
        super.setLocale(JComponent.getDefaultLocale());
    }

    public void updateUI() {
    }

    protected void setUI(ComponentUI componentUI) {
        this.uninstallUIAndProperties();
        this.aaTextInfo = UIManager.getDefaults().get(SwingUtilities2.AA_TEXT_PROPERTY_KEY);
        ComponentUI componentUI2 = this.ui;
        this.ui = componentUI;
        if (this.ui != null) {
            this.ui.installUI(this);
        }
        this.firePropertyChange("UI", componentUI2, componentUI);
        this.revalidate();
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uninstallUIAndProperties() {
        if (this.ui != null) {
            this.ui.uninstallUI(this);
            if (this.clientProperties != null) {
                ArrayTable arrayTable = this.clientProperties;
                synchronized (arrayTable) {
                    Object[] objectArray = this.clientProperties.getKeys(null);
                    if (objectArray != null) {
                        for (Object object : objectArray) {
                            if (!(object instanceof UIClientPropertyKey)) continue;
                            this.putClientProperty(object, null);
                        }
                    }
                }
            }
        }
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected Graphics getComponentGraphics(Graphics graphics) {
        Graphics graphics2 = graphics;
        if (this.ui != null && DEBUG_GRAPHICS_LOADED && DebugGraphics.debugComponentCount() != 0 && this.shouldDebugGraphics() != 0 && !(graphics instanceof DebugGraphics)) {
            graphics2 = new DebugGraphics(graphics, this);
        }
        graphics2.setColor(this.getForeground());
        graphics2.setFont(this.getFont());
        return graphics2;
    }

    protected void paintComponent(Graphics graphics) {
        if (this.ui != null) {
            Graphics graphics2 = graphics == null ? null : graphics.create();
            try {
                this.ui.update(graphics2, this);
            }
            finally {
                graphics2.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintChildren(Graphics graphics) {
        Graphics graphics2 = graphics;
        Object object = this.getTreeLock();
        synchronized (object) {
            boolean bl;
            int n;
            if (n < 0) {
                return;
            }
            if (this.paintingChild != null && this.paintingChild instanceof JComponent && this.paintingChild.isOpaque()) {
                for (n = this.getComponentCount() - 1; n >= 0 && this.getComponent(n) != this.paintingChild; --n) {
                }
            }
            Rectangle rectangle = JComponent.fetchRectangle();
            boolean bl2 = !this.isOptimizedDrawingEnabled() && this.checkIfChildObscuredBySibling();
            Rectangle rectangle2 = null;
            if (bl2 && (rectangle2 = graphics2.getClipBounds()) == null) {
                rectangle2 = new Rectangle(0, 0, this.getWidth(), this.getHeight());
            }
            boolean bl3 = this.getFlag(11);
            Window window = SwingUtilities.getWindowAncestor(this);
            boolean bl4 = bl = window == null || window.isOpaque();
            while (n >= 0) {
                block27: {
                    int n2;
                    Rectangle rectangle3;
                    boolean bl5;
                    Component component;
                    block28: {
                        component = this.getComponent(n);
                        if (component == null) break block27;
                        bl5 = component instanceof JComponent;
                        if (bl && !bl5 && !JComponent.isLightweightComponent(component) || !component.isVisible()) break block27;
                        rectangle3 = component.getBounds(rectangle);
                        boolean bl6 = graphics.hitClip(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                        if (!bl6) break block27;
                        if (!bl2 || n <= 0) break block28;
                        int n3 = rectangle3.x;
                        n2 = rectangle3.y;
                        int n4 = rectangle3.width;
                        int n5 = rectangle3.height;
                        SwingUtilities.computeIntersection(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, rectangle3);
                        if (this.getObscuredState(n, rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height) == 2) break block27;
                        rectangle3.x = n3;
                        rectangle3.y = n2;
                        rectangle3.width = n4;
                        rectangle3.height = n5;
                    }
                    Graphics graphics3 = graphics2.create(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
                    graphics3.setColor(component.getForeground());
                    graphics3.setFont(component.getFont());
                    n2 = 0;
                    try {
                        if (bl5) {
                            if (this.getFlag(1)) {
                                ((JComponent)component).setFlag(1, true);
                                n2 = 1;
                            }
                            if (this.getFlag(2)) {
                                ((JComponent)component).setFlag(2, true);
                                n2 = 1;
                            }
                            if (!bl3) {
                                component.paint(graphics3);
                            } else if (!this.getFlag(12)) {
                                component.print(graphics3);
                            } else {
                                component.printAll(graphics3);
                            }
                        } else if (!bl3) {
                            component.paint(graphics3);
                        } else if (!this.getFlag(12)) {
                            component.print(graphics3);
                        } else {
                            component.printAll(graphics3);
                        }
                    }
                    finally {
                        graphics3.dispose();
                        if (n2 != 0) {
                            ((JComponent)component).setFlag(1, false);
                            ((JComponent)component).setFlag(2, false);
                        }
                    }
                }
                --n;
            }
            JComponent.recycleRectangle(rectangle);
        }
    }

    protected void paintBorder(Graphics graphics) {
        Border border = this.getBorder();
        if (border != null) {
            border.paintBorder(this, graphics, 0, 0, this.getWidth(), this.getHeight());
        }
    }

    @Override
    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics graphics) {
        block20: {
            boolean bl = false;
            if (this.getWidth() <= 0 || this.getHeight() <= 0) {
                return;
            }
            Graphics graphics2 = this.getComponentGraphics(graphics);
            Graphics graphics3 = graphics2.create();
            try {
                boolean bl2;
                int n;
                int n2;
                int n3;
                int n4;
                RepaintManager repaintManager = RepaintManager.currentManager(this);
                Rectangle rectangle = graphics3.getClipBounds();
                if (rectangle == null) {
                    n4 = 0;
                    n3 = 0;
                    n2 = this.getWidth();
                    n = this.getHeight();
                } else {
                    n3 = rectangle.x;
                    n4 = rectangle.y;
                    n2 = rectangle.width;
                    n = rectangle.height;
                }
                if (n2 > this.getWidth()) {
                    n2 = this.getWidth();
                }
                if (n > this.getHeight()) {
                    n = this.getHeight();
                }
                if (this.getParent() != null && !(this.getParent() instanceof JComponent)) {
                    this.adjustPaintFlags();
                    bl = true;
                }
                if (!(bl2 = this.getFlag(11)) && repaintManager.isDoubleBufferingEnabled() && !this.getFlag(1) && this.isDoubleBuffered() && (this.getFlag(13) || repaintManager.isPainting())) {
                    repaintManager.beginPaint();
                    try {
                        repaintManager.paint(this, this, graphics3, n3, n4, n2, n);
                        break block20;
                    }
                    finally {
                        repaintManager.endPaint();
                    }
                }
                if (rectangle == null) {
                    graphics3.setClip(n3, n4, n2, n);
                }
                if (!this.rectangleIsObscured(n3, n4, n2, n)) {
                    if (!bl2) {
                        this.paintComponent(graphics3);
                        this.paintBorder(graphics3);
                    } else {
                        this.printComponent(graphics3);
                        this.printBorder(graphics3);
                    }
                }
                if (!bl2) {
                    this.paintChildren(graphics3);
                } else {
                    this.printChildren(graphics3);
                }
            }
            finally {
                graphics3.dispose();
                if (bl) {
                    this.setFlag(1, false);
                    this.setFlag(2, false);
                    this.setFlag(11, false);
                    this.setFlag(12, false);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintForceDoubleBuffered(Graphics graphics) {
        RepaintManager repaintManager = RepaintManager.currentManager(this);
        Rectangle rectangle = graphics.getClipBounds();
        repaintManager.beginPaint();
        this.setFlag(13, true);
        try {
            repaintManager.paint(this, this, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        finally {
            repaintManager.endPaint();
            this.setFlag(13, false);
        }
    }

    boolean isPainting() {
        for (Container container = this; container != null; container = container.getParent()) {
            if (!(container instanceof JComponent) || !container.getFlag(1)) continue;
            return true;
        }
        return false;
    }

    private void adjustPaintFlags() {
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            if (!(container instanceof JComponent)) continue;
            JComponent jComponent = (JComponent)container;
            if (jComponent.getFlag(1)) {
                this.setFlag(1, true);
            }
            if (jComponent.getFlag(2)) {
                this.setFlag(2, true);
            }
            if (jComponent.getFlag(11)) {
                this.setFlag(11, true);
            }
            if (!jComponent.getFlag(12)) break;
            this.setFlag(12, true);
            break;
        }
    }

    @Override
    public void printAll(Graphics graphics) {
        this.setFlag(12, true);
        try {
            this.print(graphics);
        }
        finally {
            this.setFlag(12, false);
        }
    }

    @Override
    public void print(Graphics graphics) {
        this.setFlag(11, true);
        this.firePropertyChange("paintingForPrint", false, true);
        try {
            this.paint(graphics);
        }
        finally {
            this.setFlag(11, false);
            this.firePropertyChange("paintingForPrint", true, false);
        }
    }

    protected void printComponent(Graphics graphics) {
        this.paintComponent(graphics);
    }

    protected void printChildren(Graphics graphics) {
        this.paintChildren(graphics);
    }

    protected void printBorder(Graphics graphics) {
        this.paintBorder(graphics);
    }

    public boolean isPaintingTile() {
        return this.getFlag(2);
    }

    public final boolean isPaintingForPrint() {
        return this.getFlag(11);
    }

    @Deprecated
    public boolean isManagingFocus() {
        return false;
    }

    private void registerNextFocusableComponent() {
        this.registerNextFocusableComponent(this.getNextFocusableComponent());
    }

    private void registerNextFocusableComponent(Component component) {
        if (component == null) {
            return;
        }
        Container container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (!(focusTraversalPolicy instanceof LegacyGlueFocusTraversalPolicy)) {
            focusTraversalPolicy = new LegacyGlueFocusTraversalPolicy(focusTraversalPolicy);
            container.setFocusTraversalPolicy(focusTraversalPolicy);
        }
        ((LegacyGlueFocusTraversalPolicy)focusTraversalPolicy).setNextFocusableComponent(this, component);
    }

    private void deregisterNextFocusableComponent() {
        Container container;
        Component component = this.getNextFocusableComponent();
        if (component == null) {
            return;
        }
        Container container2 = container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        if (container == null) {
            return;
        }
        FocusTraversalPolicy focusTraversalPolicy = container.getFocusTraversalPolicy();
        if (focusTraversalPolicy instanceof LegacyGlueFocusTraversalPolicy) {
            ((LegacyGlueFocusTraversalPolicy)focusTraversalPolicy).unsetNextFocusableComponent(this, component);
        }
    }

    @Deprecated
    public void setNextFocusableComponent(Component component) {
        boolean bl = this.isDisplayable();
        if (bl) {
            this.deregisterNextFocusableComponent();
        }
        this.putClientProperty(NEXT_FOCUS, component);
        if (bl) {
            this.registerNextFocusableComponent(component);
        }
    }

    @Deprecated
    public Component getNextFocusableComponent() {
        return (Component)this.getClientProperty(NEXT_FOCUS);
    }

    public void setRequestFocusEnabled(boolean bl) {
        this.setFlag(22, !bl);
    }

    public boolean isRequestFocusEnabled() {
        return !this.getFlag(22);
    }

    @Override
    public void requestFocus() {
        super.requestFocus();
    }

    @Override
    public boolean requestFocus(boolean bl) {
        return super.requestFocus(bl);
    }

    @Override
    public boolean requestFocusInWindow() {
        return super.requestFocusInWindow();
    }

    @Override
    protected boolean requestFocusInWindow(boolean bl) {
        return super.requestFocusInWindow(bl);
    }

    public void grabFocus() {
        this.requestFocus();
    }

    public void setVerifyInputWhenFocusTarget(boolean bl) {
        boolean bl2 = this.verifyInputWhenFocusTarget;
        this.verifyInputWhenFocusTarget = bl;
        this.firePropertyChange("verifyInputWhenFocusTarget", bl2, bl);
    }

    public boolean getVerifyInputWhenFocusTarget() {
        return this.verifyInputWhenFocusTarget;
    }

    @Override
    public FontMetrics getFontMetrics(Font font) {
        return SwingUtilities2.getFontMetrics(this, font);
    }

    @Override
    public void setPreferredSize(Dimension dimension) {
        super.setPreferredSize(dimension);
    }

    @Override
    @Transient
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getPreferredSize(this);
        }
        return dimension != null ? dimension : super.getPreferredSize();
    }

    @Override
    public void setMaximumSize(Dimension dimension) {
        super.setMaximumSize(dimension);
    }

    @Override
    @Transient
    public Dimension getMaximumSize() {
        if (this.isMaximumSizeSet()) {
            return super.getMaximumSize();
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMaximumSize(this);
        }
        return dimension != null ? dimension : super.getMaximumSize();
    }

    @Override
    public void setMinimumSize(Dimension dimension) {
        super.setMinimumSize(dimension);
    }

    @Override
    @Transient
    public Dimension getMinimumSize() {
        if (this.isMinimumSizeSet()) {
            return super.getMinimumSize();
        }
        Dimension dimension = null;
        if (this.ui != null) {
            dimension = this.ui.getMinimumSize(this);
        }
        return dimension != null ? dimension : super.getMinimumSize();
    }

    @Override
    public boolean contains(int n, int n2) {
        return this.ui != null ? this.ui.contains(this, n, n2) : super.contains(n, n2);
    }

    public void setBorder(Border border) {
        Border border2 = this.border;
        this.border = border;
        this.firePropertyChange("border", border2, border);
        if (border != border2) {
            if (border == null || border2 == null || !border.getBorderInsets(this).equals(border2.getBorderInsets(this))) {
                this.revalidate();
            }
            this.repaint();
        }
    }

    public Border getBorder() {
        return this.border;
    }

    @Override
    public Insets getInsets() {
        if (this.border != null) {
            return this.border.getBorderInsets(this);
        }
        return super.getInsets();
    }

    public Insets getInsets(Insets insets) {
        if (insets == null) {
            insets = new Insets(0, 0, 0, 0);
        }
        if (this.border != null) {
            if (this.border instanceof AbstractBorder) {
                return ((AbstractBorder)this.border).getBorderInsets(this, insets);
            }
            return this.border.getBorderInsets(this);
        }
        insets.bottom = 0;
        insets.right = 0;
        insets.top = 0;
        insets.left = 0;
        return insets;
    }

    @Override
    public float getAlignmentY() {
        if (this.isAlignmentYSet) {
            return this.alignmentY;
        }
        return super.getAlignmentY();
    }

    public void setAlignmentY(float f) {
        this.alignmentY = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
        this.isAlignmentYSet = true;
    }

    @Override
    public float getAlignmentX() {
        if (this.isAlignmentXSet) {
            return this.alignmentX;
        }
        return super.getAlignmentX();
    }

    public void setAlignmentX(float f) {
        this.alignmentX = f > 1.0f ? 1.0f : (f < 0.0f ? 0.0f : f);
        this.isAlignmentXSet = true;
    }

    public void setInputVerifier(InputVerifier inputVerifier) {
        InputVerifier inputVerifier2 = (InputVerifier)this.getClientProperty((Object)ClientPropertyKey.JComponent_INPUT_VERIFIER);
        this.putClientProperty((Object)ClientPropertyKey.JComponent_INPUT_VERIFIER, inputVerifier);
        this.firePropertyChange("inputVerifier", inputVerifier2, inputVerifier);
    }

    public InputVerifier getInputVerifier() {
        return (InputVerifier)this.getClientProperty((Object)ClientPropertyKey.JComponent_INPUT_VERIFIER);
    }

    @Override
    public Graphics getGraphics() {
        if (DEBUG_GRAPHICS_LOADED && this.shouldDebugGraphics() != 0) {
            DebugGraphics debugGraphics = new DebugGraphics(super.getGraphics(), this);
            return debugGraphics;
        }
        return super.getGraphics();
    }

    public void setDebugGraphicsOptions(int n) {
        DebugGraphics.setDebugOptions(this, n);
    }

    public int getDebugGraphicsOptions() {
        return DebugGraphics.getDebugOptions(this);
    }

    int shouldDebugGraphics() {
        return DebugGraphics.shouldComponentDebug(this);
    }

    public void registerKeyboardAction(ActionListener actionListener, String string, KeyStroke keyStroke, int n) {
        InputMap inputMap = this.getInputMap(n, true);
        if (inputMap != null) {
            ActionMap actionMap = this.getActionMap(true);
            ActionStandin actionStandin = new ActionStandin(actionListener, string);
            inputMap.put(keyStroke, actionStandin);
            if (actionMap != null) {
                actionMap.put(actionStandin, actionStandin);
            }
        }
    }

    private void registerWithKeyboardManager(boolean bl) {
        int n;
        KeyStroke[] keyStrokeArray;
        InputMap inputMap = this.getInputMap(2, false);
        Hashtable<KeyStroke, KeyStroke> hashtable = (Hashtable<KeyStroke, KeyStroke>)this.getClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS);
        if (inputMap != null) {
            keyStrokeArray = inputMap.allKeys();
            if (keyStrokeArray != null) {
                for (n = keyStrokeArray.length - 1; n >= 0; --n) {
                    if (!bl || hashtable == null || hashtable.get(keyStrokeArray[n]) == null) {
                        this.registerWithKeyboardManager(keyStrokeArray[n]);
                    }
                    if (hashtable == null) continue;
                    hashtable.remove(keyStrokeArray[n]);
                }
            }
        } else {
            keyStrokeArray = null;
        }
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
                this.unregisterWithKeyboardManager(keyStroke);
            }
            hashtable.clear();
        }
        if (keyStrokeArray != null && keyStrokeArray.length > 0) {
            if (hashtable == null) {
                hashtable = new Hashtable<KeyStroke, KeyStroke>(keyStrokeArray.length);
                this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, hashtable);
            }
            for (n = keyStrokeArray.length - 1; n >= 0; --n) {
                hashtable.put(keyStrokeArray[n], keyStrokeArray[n]);
            }
        } else {
            this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, null);
        }
    }

    private void unregisterWithKeyboardManager() {
        Hashtable hashtable = (Hashtable)this.getClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS);
        if (hashtable != null && hashtable.size() > 0) {
            Enumeration enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                KeyStroke keyStroke = (KeyStroke)enumeration.nextElement();
                this.unregisterWithKeyboardManager(keyStroke);
            }
        }
        this.putClientProperty(WHEN_IN_FOCUSED_WINDOW_BINDINGS, null);
    }

    void componentInputMapChanged(ComponentInputMap componentInputMap) {
        InputMap inputMap;
        for (inputMap = this.getInputMap(2, false); inputMap != componentInputMap && inputMap != null; inputMap = inputMap.getParent()) {
        }
        if (inputMap != null) {
            this.registerWithKeyboardManager(false);
        }
    }

    private void registerWithKeyboardManager(KeyStroke keyStroke) {
        KeyboardManager.getCurrentManager().registerKeyStroke(keyStroke, this);
    }

    private void unregisterWithKeyboardManager(KeyStroke keyStroke) {
        KeyboardManager.getCurrentManager().unregisterKeyStroke(keyStroke, this);
    }

    public void registerKeyboardAction(ActionListener actionListener, KeyStroke keyStroke, int n) {
        this.registerKeyboardAction(actionListener, null, keyStroke, n);
    }

    public void unregisterKeyboardAction(KeyStroke keyStroke) {
        ActionMap actionMap = this.getActionMap(false);
        for (int i = 0; i < 3; ++i) {
            InputMap inputMap = this.getInputMap(i, false);
            if (inputMap == null) continue;
            Object object = inputMap.get(keyStroke);
            if (actionMap != null && object != null) {
                actionMap.remove(object);
            }
            inputMap.remove(keyStroke);
        }
    }

    public KeyStroke[] getRegisteredKeyStrokes() {
        int[] nArray = new int[3];
        KeyStroke[][] keyStrokeArrayArray = new KeyStroke[3][];
        for (int i = 0; i < 3; ++i) {
            InputMap inputMap = this.getInputMap(i, false);
            keyStrokeArrayArray[i] = inputMap != null ? inputMap.allKeys() : null;
            nArray[i] = keyStrokeArrayArray[i] != null ? keyStrokeArrayArray[i].length : 0;
        }
        KeyStroke[] keyStrokeArray = new KeyStroke[nArray[0] + nArray[1] + nArray[2]];
        int n = 0;
        for (int i = 0; i < 3; ++i) {
            if (nArray[i] <= 0) continue;
            System.arraycopy(keyStrokeArrayArray[i], 0, keyStrokeArray, n, nArray[i]);
            n += nArray[i];
        }
        return keyStrokeArray;
    }

    public int getConditionForKeyStroke(KeyStroke keyStroke) {
        for (int i = 0; i < 3; ++i) {
            InputMap inputMap = this.getInputMap(i, false);
            if (inputMap == null || inputMap.get(keyStroke) == null) continue;
            return i;
        }
        return -1;
    }

    public ActionListener getActionForKeyStroke(KeyStroke keyStroke) {
        ActionMap actionMap = this.getActionMap(false);
        if (actionMap == null) {
            return null;
        }
        for (int i = 0; i < 3; ++i) {
            Object object;
            InputMap inputMap = this.getInputMap(i, false);
            if (inputMap == null || (object = inputMap.get(keyStroke)) == null) continue;
            Action action = actionMap.get(object);
            if (action instanceof ActionStandin) {
                return ((ActionStandin)action).actionListener;
            }
            return action;
        }
        return null;
    }

    public void resetKeyboardActions() {
        for (int i = 0; i < 3; ++i) {
            InputMap inputMap = this.getInputMap(i, false);
            if (inputMap == null) continue;
            inputMap.clear();
        }
        ActionMap actionMap = this.getActionMap(false);
        if (actionMap != null) {
            actionMap.clear();
        }
    }

    public final void setInputMap(int n, InputMap inputMap) {
        switch (n) {
            case 2: {
                if (inputMap != null && !(inputMap instanceof ComponentInputMap)) {
                    throw new IllegalArgumentException("WHEN_IN_FOCUSED_WINDOW InputMaps must be of type ComponentInputMap");
                }
                this.windowInputMap = (ComponentInputMap)inputMap;
                this.setFlag(7, true);
                this.registerWithKeyboardManager(false);
                break;
            }
            case 1: {
                this.ancestorInputMap = inputMap;
                this.setFlag(6, true);
                break;
            }
            case 0: {
                this.focusInputMap = inputMap;
                this.setFlag(5, true);
                break;
            }
            default: {
                throw new IllegalArgumentException("condition must be one of JComponent.WHEN_IN_FOCUSED_WINDOW, JComponent.WHEN_FOCUSED or JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT");
            }
        }
    }

    public final InputMap getInputMap(int n) {
        return this.getInputMap(n, true);
    }

    public final InputMap getInputMap() {
        return this.getInputMap(0, true);
    }

    public final void setActionMap(ActionMap actionMap) {
        this.actionMap = actionMap;
        this.setFlag(8, true);
    }

    public final ActionMap getActionMap() {
        return this.getActionMap(true);
    }

    final InputMap getInputMap(int n, boolean bl) {
        switch (n) {
            case 0: {
                if (this.getFlag(5)) {
                    return this.focusInputMap;
                }
                if (!bl) break;
                InputMap inputMap = new InputMap();
                this.setInputMap(n, inputMap);
                return inputMap;
            }
            case 1: {
                if (this.getFlag(6)) {
                    return this.ancestorInputMap;
                }
                if (!bl) break;
                InputMap inputMap = new InputMap();
                this.setInputMap(n, inputMap);
                return inputMap;
            }
            case 2: {
                if (this.getFlag(7)) {
                    return this.windowInputMap;
                }
                if (!bl) break;
                ComponentInputMap componentInputMap = new ComponentInputMap(this);
                this.setInputMap(n, componentInputMap);
                return componentInputMap;
            }
            default: {
                throw new IllegalArgumentException("condition must be one of JComponent.WHEN_IN_FOCUSED_WINDOW, JComponent.WHEN_FOCUSED or JComponent.WHEN_ANCESTOR_OF_FOCUSED_COMPONENT");
            }
        }
        return null;
    }

    final ActionMap getActionMap(boolean bl) {
        if (this.getFlag(8)) {
            return this.actionMap;
        }
        if (bl) {
            ActionMap actionMap = new ActionMap();
            this.setActionMap(actionMap);
            return actionMap;
        }
        return null;
    }

    @Override
    public int getBaseline(int n, int n2) {
        super.getBaseline(n, n2);
        if (this.ui != null) {
            return this.ui.getBaseline(this, n, n2);
        }
        return -1;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        if (this.ui != null) {
            return this.ui.getBaselineResizeBehavior(this);
        }
        return Component.BaselineResizeBehavior.OTHER;
    }

    @Deprecated
    public boolean requestDefaultFocus() {
        Container container;
        Container container2 = container = this.isFocusCycleRoot() ? this : this.getFocusCycleRootAncestor();
        if (container == null) {
            return false;
        }
        Component component = container.getFocusTraversalPolicy().getDefaultComponent(container);
        if (component != null) {
            component.requestFocus();
            return true;
        }
        return false;
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl != this.isVisible()) {
            super.setVisible(bl);
            if (bl) {
                Container container = this.getParent();
                if (container != null) {
                    Rectangle rectangle = this.getBounds();
                    container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                }
                this.revalidate();
            }
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        boolean bl2 = this.isEnabled();
        super.setEnabled(bl);
        this.firePropertyChange("enabled", bl2, bl);
        if (bl != bl2) {
            this.repaint();
        }
    }

    @Override
    public void setForeground(Color color) {
        Color color2 = this.getForeground();
        super.setForeground(color);
        if (color2 != null ? !color2.equals(color) : color != null && !color.equals(color2)) {
            this.repaint();
        }
    }

    @Override
    public void setBackground(Color color) {
        Color color2 = this.getBackground();
        super.setBackground(color);
        if (color2 != null ? !color2.equals(color) : color != null && !color.equals(color2)) {
            this.repaint();
        }
    }

    @Override
    public void setFont(Font font) {
        Font font2 = this.getFont();
        super.setFont(font);
        if (font != font2) {
            this.revalidate();
            this.repaint();
        }
    }

    public static Locale getDefaultLocale() {
        Locale locale = (Locale)SwingUtilities.appContextGet(defaultLocale);
        if (locale == null) {
            locale = Locale.getDefault();
            JComponent.setDefaultLocale(locale);
        }
        return locale;
    }

    public static void setDefaultLocale(Locale locale) {
        SwingUtilities.appContextPut(defaultLocale, locale);
    }

    protected void processComponentKeyEvent(KeyEvent keyEvent) {
    }

    @Override
    protected void processKeyEvent(KeyEvent keyEvent) {
        super.processKeyEvent(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.processComponentKeyEvent(keyEvent);
        }
        boolean bl = KeyboardState.shouldProcess(keyEvent);
        if (keyEvent.isConsumed()) {
            return;
        }
        if (bl && this.processKeyBindings(keyEvent, keyEvent.getID() == 401)) {
            keyEvent.consume();
        }
    }

    protected boolean processKeyBinding(KeyStroke keyStroke, KeyEvent keyEvent, int n, boolean bl) {
        InputMap inputMap = this.getInputMap(n, false);
        ActionMap actionMap = this.getActionMap(false);
        if (inputMap != null && actionMap != null && this.isEnabled()) {
            Action action;
            Object object = inputMap.get(keyStroke);
            Action action2 = action = object == null ? null : actionMap.get(object);
            if (action != null) {
                return SwingUtilities.notifyAction(action, keyStroke, keyEvent, this, keyEvent.getModifiers());
            }
        }
        return false;
    }

    boolean processKeyBindings(KeyEvent keyEvent, boolean bl) {
        Container container;
        KeyStroke keyStroke;
        if (!SwingUtilities.isValidKeyEventForKeyBindings(keyEvent)) {
            return false;
        }
        KeyStroke keyStroke2 = null;
        if (keyEvent.getID() == 400) {
            keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyChar());
        } else {
            keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), !bl);
            if (keyEvent.getKeyCode() != keyEvent.getExtendedKeyCode()) {
                keyStroke2 = KeyStroke.getKeyStroke(keyEvent.getExtendedKeyCode(), keyEvent.getModifiers(), !bl);
            }
        }
        if (keyStroke2 != null && this.processKeyBinding(keyStroke2, keyEvent, 0, bl)) {
            return true;
        }
        if (this.processKeyBinding(keyStroke, keyEvent, 0, bl)) {
            return true;
        }
        for (container = this; container != null && !(container instanceof Window) && !(container instanceof Applet); container = container.getParent()) {
            if (container instanceof JComponent) {
                if (keyStroke2 != null && container.processKeyBinding(keyStroke2, keyEvent, 1, bl)) {
                    return true;
                }
                if (container.processKeyBinding(keyStroke, keyEvent, 1, bl)) {
                    return true;
                }
            }
            if (!(container instanceof JInternalFrame) || !JComponent.processKeyBindingsForAllComponents(keyEvent, container, bl)) continue;
            return true;
        }
        if (container != null) {
            return JComponent.processKeyBindingsForAllComponents(keyEvent, container, bl);
        }
        return false;
    }

    static boolean processKeyBindingsForAllComponents(KeyEvent keyEvent, Container container, boolean bl) {
        while (true) {
            if (KeyboardManager.getCurrentManager().fireKeyboardAction(keyEvent, bl, container)) {
                return true;
            }
            if (!(container instanceof Popup.HeavyWeightWindow)) break;
            container = ((Window)container).getOwner();
        }
        return false;
    }

    public void setToolTipText(String string) {
        String string2 = this.getToolTipText();
        this.putClientProperty(TOOL_TIP_TEXT_KEY, string);
        ToolTipManager toolTipManager = ToolTipManager.sharedInstance();
        if (string != null) {
            if (string2 == null) {
                toolTipManager.registerComponent(this);
            }
        } else {
            toolTipManager.unregisterComponent(this);
        }
    }

    public String getToolTipText() {
        return (String)this.getClientProperty(TOOL_TIP_TEXT_KEY);
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        return this.getToolTipText();
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        return null;
    }

    public Point getPopupLocation(MouseEvent mouseEvent) {
        return null;
    }

    public JToolTip createToolTip() {
        JToolTip jToolTip = new JToolTip();
        jToolTip.setComponent(this);
        return jToolTip;
    }

    public void scrollRectToVisible(Rectangle rectangle) {
        Container container;
        int n = this.getX();
        int n2 = this.getY();
        for (container = this.getParent(); container != null && !(container instanceof JComponent) && !(container instanceof CellRendererPane); container = container.getParent()) {
            Rectangle rectangle2 = container.getBounds();
            n += rectangle2.x;
            n2 += rectangle2.y;
        }
        if (container != null && !(container instanceof CellRendererPane)) {
            rectangle.x += n;
            rectangle.y += n2;
            ((JComponent)container).scrollRectToVisible(rectangle);
            rectangle.x -= n;
            rectangle.y -= n2;
        }
    }

    public void setAutoscrolls(boolean bl) {
        this.setFlag(25, true);
        if (this.autoscrolls != bl) {
            this.autoscrolls = bl;
            if (bl) {
                this.enableEvents(16L);
                this.enableEvents(32L);
            } else {
                Autoscroller.stop(this);
            }
        }
    }

    public boolean getAutoscrolls() {
        return this.autoscrolls;
    }

    public void setTransferHandler(TransferHandler transferHandler) {
        TransferHandler transferHandler2 = (TransferHandler)this.getClientProperty((Object)ClientPropertyKey.JComponent_TRANSFER_HANDLER);
        this.putClientProperty((Object)ClientPropertyKey.JComponent_TRANSFER_HANDLER, transferHandler);
        SwingUtilities.installSwingDropTargetAsNecessary(this, transferHandler);
        this.firePropertyChange("transferHandler", transferHandler2, transferHandler);
    }

    @Override
    public TransferHandler getTransferHandler() {
        return (TransferHandler)this.getClientProperty((Object)ClientPropertyKey.JComponent_TRANSFER_HANDLER);
    }

    TransferHandler.DropLocation dropLocationForPoint(Point point) {
        return null;
    }

    Object setDropLocation(TransferHandler.DropLocation dropLocation, Object object, boolean bl) {
        return null;
    }

    void dndDone() {
    }

    @Override
    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (this.autoscrolls && mouseEvent.getID() == 502) {
            Autoscroller.stop(this);
        }
        super.processMouseEvent(mouseEvent);
    }

    @Override
    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        boolean bl = true;
        if (this.autoscrolls && mouseEvent.getID() == 506) {
            bl = !Autoscroller.isRunning(this);
            Autoscroller.processMouseDragged(mouseEvent);
        }
        if (bl) {
            super.processMouseMotionEvent(mouseEvent);
        }
    }

    void superProcessMouseMotionEvent(MouseEvent mouseEvent) {
        super.processMouseMotionEvent(mouseEvent);
    }

    void setCreatedDoubleBuffer(boolean bl) {
        this.setFlag(9, bl);
    }

    boolean getCreatedDoubleBuffer() {
        return this.getFlag(9);
    }

    @Override
    @Deprecated
    public void enable() {
        if (!this.isEnabled()) {
            super.enable();
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.ENABLED);
            }
        }
    }

    @Override
    @Deprecated
    public void disable() {
        if (this.isEnabled()) {
            super.disable();
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.ENABLED, null);
            }
        }
    }

    private ArrayTable getClientProperties() {
        if (this.clientProperties == null) {
            this.clientProperties = new ArrayTable();
        }
        return this.clientProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object getClientProperty(Object object) {
        if (object == SwingUtilities2.AA_TEXT_PROPERTY_KEY) {
            return this.aaTextInfo;
        }
        if (object == SwingUtilities2.COMPONENT_UI_PROPERTY_KEY) {
            return this.ui;
        }
        if (this.clientProperties == null) {
            return null;
        }
        ArrayTable arrayTable = this.clientProperties;
        synchronized (arrayTable) {
            return this.clientProperties.get(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void putClientProperty(Object object, Object object2) {
        Object object3;
        ArrayTable arrayTable;
        if (object == SwingUtilities2.AA_TEXT_PROPERTY_KEY) {
            this.aaTextInfo = object2;
            return;
        }
        if (object2 == null && this.clientProperties == null) {
            return;
        }
        ArrayTable arrayTable2 = arrayTable = this.getClientProperties();
        synchronized (arrayTable2) {
            object3 = arrayTable.get(object);
            if (object2 != null) {
                arrayTable.put(object, object2);
            } else if (object3 != null) {
                arrayTable.remove(object);
            } else {
                return;
            }
        }
        this.clientPropertyChanged(object, object3, object2);
        this.firePropertyChange(object.toString(), object3, object2);
    }

    void clientPropertyChanged(Object object, Object object2, Object object3) {
    }

    void setUIProperty(String string, Object object) {
        if (string == "opaque") {
            if (!this.getFlag(24)) {
                this.setOpaque((Boolean)object);
                this.setFlag(24, false);
            }
        } else if (string == "autoscrolls") {
            if (!this.getFlag(25)) {
                this.setAutoscrolls((Boolean)object);
                this.setFlag(25, false);
            }
        } else if (string == "focusTraversalKeysForward") {
            if (!this.getFlag(26)) {
                super.setFocusTraversalKeys(0, (Set)object);
            }
        } else if (string == "focusTraversalKeysBackward") {
            if (!this.getFlag(27)) {
                super.setFocusTraversalKeys(1, (Set)object);
            }
        } else {
            throw new IllegalArgumentException("property \"" + string + "\" cannot be set using this method");
        }
    }

    @Override
    public void setFocusTraversalKeys(int n, Set<? extends AWTKeyStroke> set) {
        if (n == 0) {
            this.setFlag(26, true);
        } else if (n == 1) {
            this.setFlag(27, true);
        }
        super.setFocusTraversalKeys(n, set);
    }

    public static boolean isLightweightComponent(Component component) {
        return component.getPeer() instanceof LightweightPeer;
    }

    @Override
    @Deprecated
    public void reshape(int n, int n2, int n3, int n4) {
        super.reshape(n, n2, n3, n4);
    }

    @Override
    public Rectangle getBounds(Rectangle rectangle) {
        if (rectangle == null) {
            return new Rectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        }
        rectangle.setBounds(this.getX(), this.getY(), this.getWidth(), this.getHeight());
        return rectangle;
    }

    @Override
    public Dimension getSize(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(this.getWidth(), this.getHeight());
        }
        dimension.setSize(this.getWidth(), this.getHeight());
        return dimension;
    }

    @Override
    public Point getLocation(Point point) {
        if (point == null) {
            return new Point(this.getX(), this.getY());
        }
        point.setLocation(this.getX(), this.getY());
        return point;
    }

    @Override
    public int getX() {
        return super.getX();
    }

    @Override
    public int getY() {
        return super.getY();
    }

    @Override
    public int getWidth() {
        return super.getWidth();
    }

    @Override
    public int getHeight() {
        return super.getHeight();
    }

    @Override
    public boolean isOpaque() {
        return this.getFlag(3);
    }

    public void setOpaque(boolean bl) {
        boolean bl2 = this.getFlag(3);
        this.setFlag(3, bl);
        this.setFlag(24, true);
        this.firePropertyChange("opaque", bl2, bl);
    }

    boolean rectangleIsObscured(int n, int n2, int n3, int n4) {
        int n5 = this.getComponentCount();
        for (int i = 0; i < n5; ++i) {
            Component component = this.getComponent(i);
            int n6 = component.getX();
            int n7 = component.getY();
            int n8 = component.getWidth();
            int n9 = component.getHeight();
            if (n < n6 || n + n3 > n6 + n8 || n2 < n7 || n2 + n4 > n7 + n9 || !component.isVisible()) continue;
            if (component instanceof JComponent) {
                return component.isOpaque();
            }
            return false;
        }
        return false;
    }

    static final void computeVisibleRect(Component component, Rectangle rectangle) {
        Container container = component.getParent();
        Rectangle rectangle2 = component.getBounds();
        if (container == null || container instanceof Window || container instanceof Applet) {
            rectangle.setBounds(0, 0, rectangle2.width, rectangle2.height);
        } else {
            JComponent.computeVisibleRect(container, rectangle);
            rectangle.x -= rectangle2.x;
            rectangle.y -= rectangle2.y;
            SwingUtilities.computeIntersection(0, 0, rectangle2.width, rectangle2.height, rectangle);
        }
    }

    public void computeVisibleRect(Rectangle rectangle) {
        JComponent.computeVisibleRect(this, rectangle);
    }

    public Rectangle getVisibleRect() {
        Rectangle rectangle = new Rectangle();
        this.computeVisibleRect(rectangle);
        return rectangle;
    }

    @Override
    public void firePropertyChange(String string, boolean bl, boolean bl2) {
        super.firePropertyChange(string, bl, bl2);
    }

    @Override
    public void firePropertyChange(String string, int n, int n2) {
        super.firePropertyChange(string, n, n2);
    }

    @Override
    public void firePropertyChange(String string, char c, char c2) {
        super.firePropertyChange(string, c, c2);
    }

    protected void fireVetoableChange(String string, Object object, Object object2) throws PropertyVetoException {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.fireVetoableChange(string, object, object2);
    }

    public synchronized void addVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            this.vetoableChangeSupport = new VetoableChangeSupport(this);
        }
        this.vetoableChangeSupport.addVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized void removeVetoableChangeListener(VetoableChangeListener vetoableChangeListener) {
        if (this.vetoableChangeSupport == null) {
            return;
        }
        this.vetoableChangeSupport.removeVetoableChangeListener(vetoableChangeListener);
    }

    public synchronized VetoableChangeListener[] getVetoableChangeListeners() {
        if (this.vetoableChangeSupport == null) {
            return new VetoableChangeListener[0];
        }
        return this.vetoableChangeSupport.getVetoableChangeListeners();
    }

    public Container getTopLevelAncestor() {
        for (Container container = this; container != null; container = container.getParent()) {
            if (!(container instanceof Window) && !(container instanceof Applet)) continue;
            return container;
        }
        return null;
    }

    private AncestorNotifier getAncestorNotifier() {
        return (AncestorNotifier)this.getClientProperty((Object)ClientPropertyKey.JComponent_ANCESTOR_NOTIFIER);
    }

    public void addAncestorListener(AncestorListener ancestorListener) {
        AncestorNotifier ancestorNotifier = this.getAncestorNotifier();
        if (ancestorNotifier == null) {
            ancestorNotifier = new AncestorNotifier(this);
            this.putClientProperty((Object)ClientPropertyKey.JComponent_ANCESTOR_NOTIFIER, ancestorNotifier);
        }
        ancestorNotifier.addAncestorListener(ancestorListener);
    }

    public void removeAncestorListener(AncestorListener ancestorListener) {
        AncestorNotifier ancestorNotifier = this.getAncestorNotifier();
        if (ancestorNotifier == null) {
            return;
        }
        ancestorNotifier.removeAncestorListener(ancestorListener);
        if (ancestorNotifier.listenerList.getListenerList().length == 0) {
            ancestorNotifier.removeAllListeners();
            this.putClientProperty((Object)ClientPropertyKey.JComponent_ANCESTOR_NOTIFIER, null);
        }
    }

    public AncestorListener[] getAncestorListeners() {
        AncestorNotifier ancestorNotifier = this.getAncestorNotifier();
        if (ancestorNotifier == null) {
            return new AncestorListener[0];
        }
        return ancestorNotifier.getAncestorListeners();
    }

    @Override
    public <T extends EventListener> T[] getListeners(Class<T> clazz) {
        EventListener[] eventListenerArray = clazz == AncestorListener.class ? (EventListener[])this.getAncestorListeners() : (clazz == VetoableChangeListener.class ? (EventListener[])this.getVetoableChangeListeners() : (clazz == PropertyChangeListener.class ? (EventListener[])this.getPropertyChangeListeners() : this.listenerList.getListeners(clazz)));
        if (eventListenerArray.length == 0) {
            return super.getListeners(clazz);
        }
        return eventListenerArray;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.firePropertyChange("ancestor", null, this.getParent());
        this.registerWithKeyboardManager(false);
        this.registerNextFocusableComponent();
    }

    @Override
    public void removeNotify() {
        super.removeNotify();
        this.firePropertyChange("ancestor", this.getParent(), null);
        this.unregisterWithKeyboardManager();
        this.deregisterNextFocusableComponent();
        if (this.getCreatedDoubleBuffer()) {
            RepaintManager.currentManager(this).resetDoubleBuffer();
            this.setCreatedDoubleBuffer(false);
        }
        if (this.autoscrolls) {
            Autoscroller.stop(this);
        }
    }

    @Override
    public void repaint(long l, int n, int n2, int n3, int n4) {
        RepaintManager.currentManager(this).addDirtyRegion(this, n, n2, n3, n4);
    }

    public void repaint(Rectangle rectangle) {
        this.repaint(0L, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void revalidate() {
        if (this.getParent() == null) {
            return;
        }
        if (SwingUtilities.isEventDispatchThread()) {
            this.invalidate();
            RepaintManager.currentManager(this).addInvalidComponent(this);
        } else {
            Object object = this;
            synchronized (object) {
                if (this.getFlag(28)) {
                    return;
                }
                this.setFlag(28, true);
            }
            object = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    JComponent jComponent = JComponent.this;
                    synchronized (jComponent) {
                        JComponent.this.setFlag(28, false);
                    }
                    JComponent.this.revalidate();
                }
            };
            SwingUtilities.invokeLater((Runnable)object);
        }
    }

    @Override
    public boolean isValidateRoot() {
        return false;
    }

    public boolean isOptimizedDrawingEnabled() {
        return true;
    }

    protected boolean isPaintingOrigin() {
        return false;
    }

    public void paintImmediately(int n, int n2, int n3, int n4) {
        Container container;
        Container container2 = this;
        if (!this.isShowing()) {
            return;
        }
        JComponent jComponent = SwingUtilities.getPaintingOrigin(this);
        if (jComponent != null) {
            Rectangle rectangle = SwingUtilities.convertRectangle(container2, new Rectangle(n, n2, n3, n4), jComponent);
            jComponent.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            return;
        }
        while (!((Component)container2).isOpaque() && (container = container2.getParent()) != null) {
            n += ((Component)container2).getX();
            n2 += ((Component)container2).getY();
            container2 = container;
            if (container2 instanceof JComponent) continue;
        }
        if (container2 instanceof JComponent) {
            container2._paintImmediately(n, n2, n3, n4);
        } else {
            container2.repaint(n, n2, n3, n4);
        }
    }

    public void paintImmediately(Rectangle rectangle) {
        this.paintImmediately(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    boolean alwaysOnTop() {
        return false;
    }

    void setPaintingChild(Component component) {
        this.paintingChild = component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void _paintImmediately(int n, int n2, int n3, int n4) {
        Rectangle rectangle;
        block31: {
            int n5;
            Object object;
            Container container;
            boolean bl;
            int n6 = 0;
            int n7 = 0;
            boolean bl2 = false;
            JComponent jComponent = null;
            JComponent jComponent2 = this;
            RepaintManager repaintManager = RepaintManager.currentManager(this);
            ArrayList<JComponent> arrayList = new ArrayList<JComponent>(7);
            int n8 = -1;
            int n9 = 0;
            int n10 = 0;
            int n11 = 0;
            int n12 = 0;
            int n13 = 0;
            rectangle = JComponent.fetchRectangle();
            rectangle.x = n;
            rectangle.y = n2;
            rectangle.width = n3;
            rectangle.height = n4;
            boolean bl3 = bl = this.alwaysOnTop() && this.isOpaque();
            if (bl) {
                SwingUtilities.computeIntersection(0, 0, this.getWidth(), this.getHeight(), rectangle);
                if (rectangle.width == 0) {
                    JComponent.recycleRectangle(rectangle);
                    return;
                }
            }
            JComponent jComponent3 = null;
            for (container = this; container != null && !(container instanceof Window) && !(container instanceof Applet); container = container.getParent()) {
                object = container instanceof JComponent ? container : null;
                arrayList.add((JComponent)container);
                if (!bl && object != null && !((JComponent)object).isOptimizedDrawingEnabled()) {
                    if (container != this) {
                        if (((JComponent)object).isPaintingOrigin()) {
                            n5 = 1;
                        } else {
                            int n14;
                            Component[] componentArray = container.getComponents();
                            for (n14 = 0; n14 < componentArray.length && componentArray[n14] != jComponent3; ++n14) {
                            }
                            switch (((JComponent)object).getObscuredState(n14, rectangle.x, rectangle.y, rectangle.width, rectangle.height)) {
                                case 0: {
                                    n5 = 0;
                                    break;
                                }
                                case 2: {
                                    JComponent.recycleRectangle(rectangle);
                                    return;
                                }
                                default: {
                                    n5 = 1;
                                    break;
                                }
                            }
                        }
                    } else {
                        n5 = 0;
                    }
                    if (n5 != 0) {
                        jComponent2 = object;
                        n8 = n9;
                        n7 = 0;
                        n6 = 0;
                        bl2 = false;
                    }
                }
                ++n9;
                if (repaintManager.isDoubleBufferingEnabled() && object != null && ((JComponent)object).isDoubleBuffered()) {
                    bl2 = true;
                    jComponent = object;
                }
                if (!bl) {
                    n5 = container.getX();
                    int n15 = container.getY();
                    n11 = container.getWidth();
                    n10 = container.getHeight();
                    SwingUtilities.computeIntersection(n13, n12, n11, n10, rectangle);
                    rectangle.x += n5;
                    rectangle.y += n15;
                    n6 += n5;
                    n7 += n15;
                }
                jComponent3 = container;
            }
            if (container == null || container.getPeer() == null || rectangle.width <= 0 || rectangle.height <= 0) {
                JComponent.recycleRectangle(rectangle);
                return;
            }
            jComponent2.setFlag(13, true);
            rectangle.x -= n6;
            rectangle.y -= n7;
            if (jComponent2 != this) {
                for (n5 = n8; n5 > 0; --n5) {
                    object = (Component)arrayList.get(n5);
                    if (!(object instanceof JComponent)) continue;
                    ((JComponent)object).setPaintingChild((Component)arrayList.get(n5 - 1));
                }
            }
            try {
                Graphics graphics = JComponent.safelyGetGraphics(jComponent2, container);
                if (graphics == null) break block31;
                try {
                    if (bl2) {
                        object = RepaintManager.currentManager(jComponent);
                        ((RepaintManager)object).beginPaint();
                        try {
                            ((RepaintManager)object).paint(jComponent2, jComponent, graphics, rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                            break block31;
                        }
                        finally {
                            ((RepaintManager)object).endPaint();
                        }
                    }
                    graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
                    jComponent2.paint(graphics);
                }
                finally {
                    graphics.dispose();
                }
            }
            finally {
                if (jComponent2 != this) {
                    for (n5 = n8; n5 > 0; --n5) {
                        object = (Component)arrayList.get(n5);
                        if (!(object instanceof JComponent)) continue;
                        ((JComponent)object).setPaintingChild(null);
                    }
                }
                jComponent2.setFlag(13, false);
            }
        }
        JComponent.recycleRectangle(rectangle);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paintToOffscreen(Graphics graphics, int n, int n2, int n3, int n4, int n5, int n6) {
        try {
            this.setFlag(1, true);
            if (n2 + n4 < n6 || n + n3 < n5) {
                this.setFlag(2, true);
            }
            if (this.getFlag(13)) {
                this.paint(graphics);
            } else {
                if (!this.rectangleIsObscured(n, n2, n3, n4)) {
                    this.paintComponent(graphics);
                    this.paintBorder(graphics);
                }
                this.paintChildren(graphics);
            }
        }
        finally {
            this.setFlag(1, false);
            this.setFlag(2, false);
        }
    }

    private int getObscuredState(int n, int n2, int n3, int n4, int n5) {
        int n6 = 0;
        Rectangle rectangle = JComponent.fetchRectangle();
        for (int i = n - 1; i >= 0; --i) {
            boolean bl;
            Component component = this.getComponent(i);
            if (!component.isVisible()) continue;
            if (component instanceof JComponent) {
                bl = component.isOpaque();
                if (!bl && n6 == 1) {
                    continue;
                }
            } else {
                bl = true;
            }
            Rectangle rectangle2 = component.getBounds(rectangle);
            if (bl && n2 >= rectangle2.x && n2 + n4 <= rectangle2.x + rectangle2.width && n3 >= rectangle2.y && n3 + n5 <= rectangle2.y + rectangle2.height) {
                JComponent.recycleRectangle(rectangle);
                return 2;
            }
            if (n6 != 0 || n2 + n4 <= rectangle2.x || n3 + n5 <= rectangle2.y || n2 >= rectangle2.x + rectangle2.width || n3 >= rectangle2.y + rectangle2.height) continue;
            n6 = 1;
        }
        JComponent.recycleRectangle(rectangle);
        return n6;
    }

    boolean checkIfChildObscuredBySibling() {
        return true;
    }

    private void setFlag(int n, boolean bl) {
        this.flags = bl ? (this.flags |= 1 << n) : (this.flags &= ~(1 << n));
    }

    private boolean getFlag(int n) {
        int n2 = 1 << n;
        return (this.flags & n2) == n2;
    }

    static void setWriteObjCounter(JComponent jComponent, byte by) {
        jComponent.flags = jComponent.flags & 0xFFC03FFF | by << 14;
    }

    static byte getWriteObjCounter(JComponent jComponent) {
        return (byte)(jComponent.flags >> 14 & 0xFF);
    }

    public void setDoubleBuffered(boolean bl) {
        this.setFlag(0, bl);
    }

    @Override
    public boolean isDoubleBuffered() {
        return this.getFlag(0);
    }

    public JRootPane getRootPane() {
        return SwingUtilities.getRootPane(this);
    }

    void compWriteObjectNotify() {
        byte by = JComponent.getWriteObjCounter(this);
        JComponent.setWriteObjCounter(this, (byte)(by + 1));
        if (by != 0) {
            return;
        }
        this.uninstallUIAndProperties();
        if (this.getToolTipText() != null || this instanceof JTableHeader) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        ReadObjectCallback readObjectCallback = readObjectCallbacks.get(objectInputStream);
        if (readObjectCallback == null) {
            try {
                readObjectCallback = new ReadObjectCallback(objectInputStream);
                readObjectCallbacks.put(objectInputStream, readObjectCallback);
            }
            catch (Exception exception) {
                throw new IOException(exception.toString());
            }
        }
        readObjectCallback.registerComponent(this);
        int n = objectInputStream.readInt();
        if (n > 0) {
            this.clientProperties = new ArrayTable();
            for (int i = 0; i < n; ++i) {
                this.clientProperties.put(objectInputStream.readObject(), objectInputStream.readObject());
            }
        }
        if (this.getToolTipText() != null) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
        JComponent.setWriteObjCounter(this, (byte)0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
        ArrayTable.writeArrayTable(objectOutputStream, this.clientProperties);
    }

    @Override
    protected String paramString() {
        String string;
        String string2 = this.isPreferredSizeSet() ? this.getPreferredSize().toString() : "";
        String string3 = this.isMinimumSizeSet() ? this.getMinimumSize().toString() : "";
        String string4 = string = this.isMaximumSizeSet() ? this.getMaximumSize().toString() : "";
        String string5 = this.border == null ? "" : (this.border == this ? "this" : this.border.toString());
        return super.paramString() + ",alignmentX=" + this.alignmentX + ",alignmentY=" + this.alignmentY + ",border=" + string5 + ",flags=" + this.flags + ",maximumSize=" + string + ",minimumSize=" + string3 + ",preferredSize=" + string2;
    }

    @Override
    @Deprecated
    public void hide() {
        boolean bl = this.isShowing();
        super.hide();
        if (bl) {
            Container container = this.getParent();
            if (container != null) {
                Rectangle rectangle = this.getBounds();
                container.repaint(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            }
            this.revalidate();
        }
    }

    static {
        INPUT_VERIFIER_SOURCE_KEY = new StringBuilder("InputVerifierSourceKey");
        tempRectangles = new ArrayList<Rectangle>(11);
        componentObtainingGraphicsFromLock = new StringBuilder("componentObtainingGraphicsFrom");
        focusController = new RequestFocusController(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean acceptRequestFocus(Component component, Component component2, boolean bl, boolean bl2, CausedFocusEvent.Cause cause) {
                if (component2 == null || !(component2 instanceof JComponent)) {
                    return true;
                }
                if (component == null || !(component instanceof JComponent)) {
                    return true;
                }
                JComponent jComponent = (JComponent)component2;
                if (!jComponent.getVerifyInputWhenFocusTarget()) {
                    return true;
                }
                JComponent jComponent2 = (JComponent)component;
                InputVerifier inputVerifier = jComponent2.getInputVerifier();
                if (inputVerifier == null) {
                    return true;
                }
                Object object = SwingUtilities.appContextGet(INPUT_VERIFIER_SOURCE_KEY);
                if (object == jComponent2) {
                    return true;
                }
                SwingUtilities.appContextPut(INPUT_VERIFIER_SOURCE_KEY, jComponent2);
                try {
                    boolean bl3 = inputVerifier.shouldYieldFocus(jComponent2);
                    return bl3;
                }
                finally {
                    if (object != null) {
                        SwingUtilities.appContextPut(INPUT_VERIFIER_SOURCE_KEY, object);
                    } else {
                        SwingUtilities.appContextRemove(INPUT_VERIFIER_SOURCE_KEY);
                    }
                }
            }
        };
    }

    public abstract class AccessibleJComponent
    extends Container.AccessibleAWTContainer
    implements AccessibleExtendedComponent {
        private volatile transient int propertyListenersCount;
        @Deprecated
        protected FocusListener accessibleFocusHandler;

        protected AccessibleJComponent() {
            super(JComponent.this);
            this.propertyListenersCount = 0;
            this.accessibleFocusHandler = null;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (this.accessibleFocusHandler == null) {
                this.accessibleFocusHandler = new AccessibleFocusHandler();
            }
            if (this.accessibleContainerHandler == null) {
                this.accessibleContainerHandler = new AccessibleContainerHandler();
            }
            if (this.propertyListenersCount++ == 0) {
                JComponent.this.addFocusListener(this.accessibleFocusHandler);
                JComponent.this.addContainerListener(this.accessibleContainerHandler);
            }
            super.addPropertyChangeListener(propertyChangeListener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            if (--this.propertyListenersCount == 0) {
                JComponent.this.removeFocusListener(this.accessibleFocusHandler);
                JComponent.this.removeContainerListener(this.accessibleContainerHandler);
            }
            super.removePropertyChangeListener(propertyChangeListener);
        }

        protected String getBorderTitle(Border border) {
            if (border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            if (border instanceof CompoundBorder) {
                String string = this.getBorderTitle(((CompoundBorder)border).getInsideBorder());
                if (string == null) {
                    string = this.getBorderTitle(((CompoundBorder)border).getOutsideBorder());
                }
                return string;
            }
            return null;
        }

        @Override
        public String getAccessibleName() {
            AccessibleContext accessibleContext;
            Object object;
            String string = this.accessibleName;
            if (string == null) {
                string = (String)JComponent.this.getClientProperty("AccessibleName");
            }
            if (string == null) {
                string = this.getBorderTitle(JComponent.this.getBorder());
            }
            if (string == null && (object = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible && (accessibleContext = ((Accessible)object).getAccessibleContext()) != null) {
                string = accessibleContext.getAccessibleName();
            }
            return string;
        }

        @Override
        public String getAccessibleDescription() {
            AccessibleContext accessibleContext;
            Object object;
            String string = this.accessibleDescription;
            if (string == null) {
                string = (String)JComponent.this.getClientProperty("AccessibleDescription");
            }
            if (string == null) {
                try {
                    string = this.getToolTipText();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (string == null && (object = JComponent.this.getClientProperty("labeledBy")) instanceof Accessible && (accessibleContext = ((Accessible)object).getAccessibleContext()) != null) {
                string = accessibleContext.getAccessibleDescription();
            }
            return string;
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.SWING_COMPONENT;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = super.getAccessibleStateSet();
            if (JComponent.this.isOpaque()) {
                accessibleStateSet.add(AccessibleState.OPAQUE);
            }
            return accessibleStateSet;
        }

        @Override
        public int getAccessibleChildrenCount() {
            return super.getAccessibleChildrenCount();
        }

        @Override
        public Accessible getAccessibleChild(int n) {
            return super.getAccessibleChild(n);
        }

        AccessibleExtendedComponent getAccessibleExtendedComponent() {
            return this;
        }

        @Override
        public String getToolTipText() {
            return JComponent.this.getToolTipText();
        }

        @Override
        public String getTitledBorderText() {
            Border border = JComponent.this.getBorder();
            if (border instanceof TitledBorder) {
                return ((TitledBorder)border).getTitle();
            }
            return null;
        }

        @Override
        public AccessibleKeyBinding getAccessibleKeyBinding() {
            return null;
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            @Override
            public void componentAdded(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", null, component.getAccessibleContext());
                }
            }

            @Override
            public void componentRemoved(ContainerEvent containerEvent) {
                Component component = containerEvent.getChild();
                if (component != null && component instanceof Accessible) {
                    AccessibleJComponent.this.firePropertyChange("AccessibleChild", component.getAccessibleContext(), null);
                }
            }
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            protected AccessibleFocusHandler() {
            }

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (JComponent.this.accessibleContext != null) {
                    JComponent.this.accessibleContext.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                if (JComponent.this.accessibleContext != null) {
                    JComponent.this.accessibleContext.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
                }
            }
        }
    }

    final class ActionStandin
    implements Action {
        private final ActionListener actionListener;
        private final String command;
        private final Action action;

        ActionStandin(ActionListener actionListener, String string) {
            this.actionListener = actionListener;
            this.action = actionListener instanceof Action ? (Action)actionListener : null;
            this.command = string;
        }

        @Override
        public Object getValue(String string) {
            if (string != null) {
                if (string.equals("ActionCommandKey")) {
                    return this.command;
                }
                if (this.action != null) {
                    return this.action.getValue(string);
                }
                if (string.equals("Name")) {
                    return "ActionStandin";
                }
            }
            return null;
        }

        @Override
        public boolean isEnabled() {
            if (this.actionListener == null) {
                return false;
            }
            if (this.action == null) {
                return true;
            }
            return this.action.isEnabled();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.actionListener != null) {
                this.actionListener.actionPerformed(actionEvent);
            }
        }

        @Override
        public void putValue(String string, Object object) {
        }

        @Override
        public void setEnabled(boolean bl) {
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }
    }

    static final class IntVector {
        int[] array = null;
        int count = 0;
        int capacity = 0;

        IntVector() {
        }

        int size() {
            return this.count;
        }

        int elementAt(int n) {
            return this.array[n];
        }

        void addElement(int n) {
            if (this.count == this.capacity) {
                this.capacity = (this.capacity + 2) * 2;
                int[] nArray = new int[this.capacity];
                if (this.count > 0) {
                    System.arraycopy(this.array, 0, nArray, 0, this.count);
                }
                this.array = nArray;
            }
            this.array[this.count++] = n;
        }

        void setElementAt(int n, int n2) {
            this.array[n2] = n;
        }
    }

    static class KeyboardState
    implements Serializable {
        private static final Object keyCodesKey = KeyboardState.class;

        KeyboardState() {
        }

        static IntVector getKeyCodeArray() {
            IntVector intVector = (IntVector)SwingUtilities.appContextGet(keyCodesKey);
            if (intVector == null) {
                intVector = new IntVector();
                SwingUtilities.appContextPut(keyCodesKey, intVector);
            }
            return intVector;
        }

        static void registerKeyPressed(int n) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n2 = intVector.size();
            for (int i = 0; i < n2; ++i) {
                if (intVector.elementAt(i) != -1) continue;
                intVector.setElementAt(n, i);
                return;
            }
            intVector.addElement(n);
        }

        static void registerKeyReleased(int n) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n2 = intVector.size();
            for (int i = 0; i < n2; ++i) {
                if (intVector.elementAt(i) != n) continue;
                intVector.setElementAt(-1, i);
                return;
            }
        }

        static boolean keyIsPressed(int n) {
            IntVector intVector = KeyboardState.getKeyCodeArray();
            int n2 = intVector.size();
            for (int i = 0; i < n2; ++i) {
                if (intVector.elementAt(i) != n) continue;
                return true;
            }
            return false;
        }

        static boolean shouldProcess(KeyEvent keyEvent) {
            switch (keyEvent.getID()) {
                case 401: {
                    if (!KeyboardState.keyIsPressed(keyEvent.getKeyCode())) {
                        KeyboardState.registerKeyPressed(keyEvent.getKeyCode());
                    }
                    return true;
                }
                case 402: {
                    if (KeyboardState.keyIsPressed(keyEvent.getKeyCode()) || keyEvent.getKeyCode() == 154) {
                        KeyboardState.registerKeyReleased(keyEvent.getKeyCode());
                        return true;
                    }
                    return false;
                }
                case 400: {
                    return true;
                }
            }
            return false;
        }
    }

    private class ReadObjectCallback
    implements ObjectInputValidation {
        private final Vector<JComponent> roots = new Vector(1);
        private final ObjectInputStream inputStream;

        ReadObjectCallback(ObjectInputStream objectInputStream) throws Exception {
            this.inputStream = objectInputStream;
            objectInputStream.registerValidation(this, 0);
        }

        @Override
        public void validateObject() throws InvalidObjectException {
            try {
                for (JComponent jComponent : this.roots) {
                    SwingUtilities.updateComponentTreeUI(jComponent);
                }
            }
            finally {
                readObjectCallbacks.remove(this.inputStream);
            }
        }

        private void registerComponent(JComponent jComponent) {
            Container container;
            for (JComponent jComponent2 : this.roots) {
                for (container = jComponent; container != null; container = container.getParent()) {
                    if (container != jComponent2) continue;
                    return;
                }
            }
            block2: for (int i = 0; i < this.roots.size(); ++i) {
                JComponent jComponent2;
                jComponent2 = this.roots.elementAt(i);
                for (container = jComponent2.getParent(); container != null; container = container.getParent()) {
                    if (container != jComponent) continue;
                    this.roots.removeElementAt(i--);
                    continue block2;
                }
            }
            this.roots.addElement(jComponent);
        }
    }
}

