/*
 * Decompiled with CFR 0.152.
 */
package java.util.logging;

import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.logging.Filter;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.Logging;
import java.util.logging.LoggingMXBean;
import java.util.logging.LoggingPermission;
import sun.misc.JavaAWTAccess;
import sun.misc.SharedSecrets;
import sun.util.logging.PlatformLogger;

public class LogManager {
    private static final LogManager manager;
    private volatile Properties props = new Properties();
    private static final Level defaultLevel;
    private final Map<Object, Integer> listenerMap = new HashMap<Object, Integer>();
    private final LoggerContext systemContext = new SystemLoggerContext();
    private final LoggerContext userContext = new LoggerContext();
    private volatile Logger rootLogger;
    private volatile boolean readPrimordialConfiguration;
    private boolean initializedGlobalHandlers = true;
    private boolean deathImminent;
    private boolean initializedCalled = false;
    private volatile boolean initializationDone = false;
    private WeakHashMap<Object, LoggerContext> contextsMap = null;
    private final ReferenceQueue<Logger> loggerRefQueue = new ReferenceQueue();
    private static final int MAX_ITERATIONS = 400;
    private final Permission controlPermission = new LoggingPermission("control", null);
    private static LoggingMXBean loggingMXBean;
    public static final String LOGGING_MXBEAN_NAME = "java.util.logging:type=Logging";

    protected LogManager() {
        this(LogManager.checkSubclassPermissions());
    }

    private LogManager(Void void_) {
        try {
            Runtime.getRuntime().addShutdownHook(new Cleaner());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private static Void checkSubclassPermissions() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(new RuntimePermission("shutdownHooks"));
            securityManager.checkPermission(new RuntimePermission("setContextClassLoader"));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void ensureLogManagerInitialized() {
        final LogManager logManager = this;
        if (this.initializationDone || logManager != manager) {
            return;
        }
        LogManager logManager2 = this;
        synchronized (logManager2) {
            boolean bl;
            boolean bl2 = bl = this.initializedCalled;
            assert (this.initializedCalled || !this.initializationDone) : "Initialization can't be done if initialized has not been called!";
            if (bl || this.initializationDone) {
                return;
            }
            this.initializedCalled = true;
            try {
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        assert (LogManager.this.rootLogger == null);
                        assert (LogManager.this.initializedCalled && !LogManager.this.initializationDone);
                        logManager.readPrimordialConfiguration();
                        LogManager logManager2 = logManager;
                        logManager2.getClass();
                        logManager.rootLogger = logManager2.new RootLogger();
                        logManager.addLogger(logManager.rootLogger);
                        if (!logManager.rootLogger.isLevelInitialized()) {
                            logManager.rootLogger.setLevel(defaultLevel);
                        }
                        Logger logger = Logger.global;
                        logManager.addLogger(logger);
                        return null;
                    }
                });
            }
            finally {
                this.initializationDone = true;
            }
        }
    }

    public static LogManager getLogManager() {
        if (manager != null) {
            manager.ensureLogManagerInitialized();
        }
        return manager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readPrimordialConfiguration() {
        if (!this.readPrimordialConfiguration) {
            LogManager logManager = this;
            synchronized (logManager) {
                block8: {
                    if (!this.readPrimordialConfiguration) {
                        if (System.out == null) {
                            return;
                        }
                        this.readPrimordialConfiguration = true;
                        try {
                            AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                                @Override
                                public Void run() throws Exception {
                                    LogManager.this.readConfiguration();
                                    PlatformLogger.redirectPlatformLoggers();
                                    return null;
                                }
                            });
                        }
                        catch (Exception exception) {
                            if ($assertionsDisabled) break block8;
                            throw new AssertionError((Object)("Exception raised while reading logging configuration: " + exception));
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SecurityException {
        PropertyChangeListener propertyChangeListener2 = Objects.requireNonNull(propertyChangeListener);
        this.checkPermission();
        Map<Object, Integer> map = this.listenerMap;
        synchronized (map) {
            Integer n = this.listenerMap.get(propertyChangeListener2);
            n = n == null ? 1 : n + 1;
            this.listenerMap.put(propertyChangeListener2, n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) throws SecurityException {
        this.checkPermission();
        if (propertyChangeListener != null) {
            PropertyChangeListener propertyChangeListener2 = propertyChangeListener;
            Map<Object, Integer> map = this.listenerMap;
            synchronized (map) {
                Integer n = this.listenerMap.get(propertyChangeListener2);
                if (n != null) {
                    int n2 = n;
                    if (n2 == 1) {
                        this.listenerMap.remove(propertyChangeListener2);
                    } else {
                        assert (n2 > 1);
                        this.listenerMap.put(propertyChangeListener2, n2 - 1);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LoggerContext getUserContext() {
        LoggerContext loggerContext = null;
        SecurityManager securityManager = System.getSecurityManager();
        JavaAWTAccess javaAWTAccess = SharedSecrets.getJavaAWTAccess();
        if (securityManager != null && javaAWTAccess != null) {
            JavaAWTAccess javaAWTAccess2 = javaAWTAccess;
            synchronized (javaAWTAccess2) {
                Object object = javaAWTAccess.getAppletContext();
                if (object != null) {
                    if (this.contextsMap == null) {
                        this.contextsMap = new WeakHashMap();
                    }
                    if ((loggerContext = this.contextsMap.get(object)) == null) {
                        loggerContext = new LoggerContext();
                        this.contextsMap.put(object, loggerContext);
                    }
                }
            }
        }
        return loggerContext != null ? loggerContext : this.userContext;
    }

    final LoggerContext getSystemContext() {
        return this.systemContext;
    }

    private List<LoggerContext> contexts() {
        ArrayList<LoggerContext> arrayList = new ArrayList<LoggerContext>();
        arrayList.add(this.getSystemContext());
        arrayList.add(this.getUserContext());
        return arrayList;
    }

    Logger demandLogger(String string, String string2, Class<?> clazz) {
        Logger logger = this.getLogger(string);
        if (logger == null) {
            Logger logger2 = new Logger(string, string2, clazz, this, false);
            do {
                if (!this.addLogger(logger2)) continue;
                return logger2;
            } while ((logger = this.getLogger(string)) == null);
        }
        return logger;
    }

    Logger demandSystemLogger(String string, String string2) {
        Logger logger;
        final Logger logger2 = this.getSystemContext().demandLogger(string, string2);
        while ((logger = this.addLogger(logger2) ? logger2 : this.getLogger(string)) == null) {
        }
        if (logger != logger2 && logger2.accessCheckedHandlers().length == 0) {
            final Logger logger3 = logger;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    for (Handler handler : logger3.accessCheckedHandlers()) {
                        logger2.addHandler(handler);
                    }
                    return null;
                }
            });
        }
        return logger2;
    }

    private void loadLoggerHandlers(final Logger logger, String string, final String string2) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                String[] stringArray = LogManager.this.parseClassNames(string2);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    try {
                        Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
                        Handler handler = (Handler)clazz.newInstance();
                        String string22 = LogManager.this.getProperty(string + ".level");
                        if (string22 != null) {
                            Level level = Level.findLevel(string22);
                            if (level != null) {
                                handler.setLevel(level);
                            } else {
                                System.err.println("Can't set level for " + string);
                            }
                        }
                        logger.addHandler(handler);
                        continue;
                    }
                    catch (Exception exception) {
                        System.err.println("Can't load log handler \"" + string + "\"");
                        System.err.println("" + exception);
                        exception.printStackTrace();
                    }
                }
                return null;
            }
        });
    }

    final void drainLoggerRefQueueBounded() {
        LoggerWeakRef loggerWeakRef;
        for (int i = 0; i < 400 && this.loggerRefQueue != null && (loggerWeakRef = (LoggerWeakRef)this.loggerRefQueue.poll()) != null; ++i) {
            loggerWeakRef.dispose();
        }
    }

    public boolean addLogger(Logger logger) {
        String string = logger.getName();
        if (string == null) {
            throw new NullPointerException();
        }
        this.drainLoggerRefQueueBounded();
        LoggerContext loggerContext = this.getUserContext();
        if (loggerContext.addLocalLogger(logger)) {
            this.loadLoggerHandlers(logger, string, string + ".handlers");
            return true;
        }
        return false;
    }

    private static void doSetLevel(final Logger logger, final Level level) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            logger.setLevel(level);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                logger.setLevel(level);
                return null;
            }
        });
    }

    private static void doSetParent(final Logger logger, final Logger logger2) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            logger.setParent(logger2);
            return;
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                logger.setParent(logger2);
                return null;
            }
        });
    }

    public Logger getLogger(String string) {
        return this.getUserContext().findLogger(string);
    }

    public Enumeration<String> getLoggerNames() {
        return this.getUserContext().getLoggerNames();
    }

    public void readConfiguration() throws IOException, SecurityException {
        Object object;
        String string;
        this.checkPermission();
        String string2 = System.getProperty("java.util.logging.config.class");
        if (string2 != null) {
            try {
                try {
                    Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                    clazz.newInstance();
                    return;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string2);
                    clazz.newInstance();
                    return;
                }
            }
            catch (Exception exception) {
                System.err.println("Logging configuration class \"" + string2 + "\" failed");
                System.err.println("" + exception);
            }
        }
        if ((string = System.getProperty("java.util.logging.config.file")) == null) {
            string = System.getProperty("java.home");
            if (string == null) {
                throw new Error("Can't find java.home ??");
            }
            object = new File(string, "lib");
            object = new File((File)object, "logging.properties");
            string = ((File)object).getCanonicalPath();
        }
        object = new FileInputStream(string);
        Throwable throwable = null;
        try {
            BufferedInputStream bufferedInputStream = new BufferedInputStream((InputStream)object);
            this.readConfiguration(bufferedInputStream);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            if (object != null) {
                if (throwable != null) {
                    try {
                        ((InputStream)object).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    ((InputStream)object).close();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() throws SecurityException {
        this.checkPermission();
        LogManager logManager = this;
        synchronized (logManager) {
            this.props = new Properties();
            this.initializedGlobalHandlers = true;
        }
        for (LoggerContext loggerContext : this.contexts()) {
            Enumeration<String> enumeration = loggerContext.getLoggerNames();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Logger logger = loggerContext.findLogger(string);
                if (logger == null) continue;
                this.resetLogger(logger);
            }
        }
    }

    private void resetLogger(Logger logger) {
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            Handler handler = handlerArray[i];
            logger.removeHandler(handler);
            try {
                handler.close();
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String string = logger.getName();
        if (string != null && string.equals("")) {
            logger.setLevel(defaultLevel);
        } else {
            logger.setLevel(null);
        }
    }

    private String[] parseClassNames(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return new String[0];
        }
        string2 = string2.trim();
        int n = 0;
        ArrayList<String> arrayList = new ArrayList<String>();
        while (n < string2.length()) {
            int n2;
            for (n2 = n; n2 < string2.length() && !Character.isWhitespace(string2.charAt(n2)) && string2.charAt(n2) != ','; ++n2) {
            }
            String string3 = string2.substring(n, n2);
            n = n2 + 1;
            if ((string3 = string3.trim()).length() == 0) continue;
            arrayList.add(string3);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readConfiguration(InputStream inputStream) throws IOException, SecurityException {
        Object object;
        this.checkPermission();
        this.reset();
        this.props.load(inputStream);
        String[] stringArray = this.parseClassNames("config");
        for (int i = 0; i < stringArray.length; ++i) {
            object = stringArray[i];
            try {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass((String)object);
                clazz.newInstance();
                continue;
            }
            catch (Exception exception) {
                System.err.println("Can't load config class \"" + (String)object + "\"");
                System.err.println("" + exception);
            }
        }
        this.setLevelsOnExistingLoggers();
        HashMap<Object, Integer> hashMap = null;
        object = this.listenerMap;
        synchronized (object) {
            if (!this.listenerMap.isEmpty()) {
                hashMap = new HashMap<Object, Integer>(this.listenerMap);
            }
        }
        if (hashMap != null) {
            assert (Beans.isBeansPresent());
            object = Beans.newPropertyChangeEvent(LogManager.class, null, null, null);
            for (Map.Entry entry : hashMap.entrySet()) {
                Object k = entry.getKey();
                int n = (Integer)entry.getValue();
                for (int i = 0; i < n; ++i) {
                    Beans.invokePropertyChange(k, object);
                }
            }
        }
        object = this;
        synchronized (object) {
            this.initializedGlobalHandlers = false;
        }
    }

    public String getProperty(String string) {
        return this.props.getProperty(string);
    }

    String getStringProperty(String string, String string2) {
        String string3 = this.getProperty(string);
        if (string3 == null) {
            return string2;
        }
        return string3.trim();
    }

    int getIntProperty(String string, int n) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return n;
        }
        try {
            return Integer.parseInt(string2.trim());
        }
        catch (Exception exception) {
            return n;
        }
    }

    boolean getBooleanProperty(String string, boolean bl) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return bl;
        }
        if ((string2 = string2.toLowerCase()).equals("true") || string2.equals("1")) {
            return true;
        }
        if (string2.equals("false") || string2.equals("0")) {
            return false;
        }
        return bl;
    }

    Level getLevelProperty(String string, Level level) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return level;
        }
        Level level2 = Level.findLevel(string2.trim());
        return level2 != null ? level2 : level;
    }

    Filter getFilterProperty(String string, Filter filter) {
        String string2 = this.getProperty(string);
        try {
            if (string2 != null) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                return (Filter)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return filter;
    }

    Formatter getFormatterProperty(String string, Formatter formatter) {
        String string2 = this.getProperty(string);
        try {
            if (string2 != null) {
                Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string2);
                return (Formatter)clazz.newInstance();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return formatter;
    }

    private synchronized void initializeGlobalHandlers() {
        if (this.initializedGlobalHandlers) {
            return;
        }
        this.initializedGlobalHandlers = true;
        if (this.deathImminent) {
            return;
        }
        this.loadLoggerHandlers(this.rootLogger, null, "handlers");
    }

    void checkPermission() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(this.controlPermission);
        }
    }

    public void checkAccess() throws SecurityException {
        this.checkPermission();
    }

    private synchronized void setLevelsOnExistingLoggers() {
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!string.endsWith(".level")) continue;
            int n = string.length() - 6;
            String string2 = string.substring(0, n);
            Level level = this.getLevelProperty(string, null);
            if (level == null) {
                System.err.println("Bad level value for property: " + string);
                continue;
            }
            for (LoggerContext loggerContext : this.contexts()) {
                Logger logger = loggerContext.findLogger(string2);
                if (logger == null) continue;
                logger.setLevel(level);
            }
        }
    }

    public static synchronized LoggingMXBean getLoggingMXBean() {
        if (loggingMXBean == null) {
            loggingMXBean = new Logging();
        }
        return loggingMXBean;
    }

    static {
        defaultLevel = Level.INFO;
        manager = AccessController.doPrivileged(new PrivilegedAction<LogManager>(){

            @Override
            public LogManager run() {
                LogManager logManager = null;
                String string = null;
                try {
                    string = System.getProperty("java.util.logging.manager");
                    if (string != null) {
                        try {
                            Class<?> clazz = ClassLoader.getSystemClassLoader().loadClass(string);
                            logManager = (LogManager)clazz.newInstance();
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            Class<?> clazz = Thread.currentThread().getContextClassLoader().loadClass(string);
                            logManager = (LogManager)clazz.newInstance();
                        }
                    }
                }
                catch (Exception exception) {
                    System.err.println("Could not load Logmanager \"" + string + "\"");
                    exception.printStackTrace();
                }
                if (logManager == null) {
                    logManager = new LogManager();
                }
                return logManager;
            }
        });
        loggingMXBean = null;
    }

    private static class Beans {
        private static final Class<?> propertyChangeListenerClass = Beans.getClass("java.beans.PropertyChangeListener");
        private static final Class<?> propertyChangeEventClass = Beans.getClass("java.beans.PropertyChangeEvent");
        private static final Method propertyChangeMethod = Beans.getMethod(propertyChangeListenerClass, "propertyChange", propertyChangeEventClass);
        private static final Constructor<?> propertyEventCtor = Beans.getConstructor(propertyChangeEventClass, Object.class, String.class, Object.class, Object.class);

        private Beans() {
        }

        private static Class<?> getClass(String string) {
            try {
                return Class.forName(string, true, Beans.class.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                return null;
            }
        }

        private static Constructor<?> getConstructor(Class<?> clazz, Class<?> ... classArray) {
            try {
                return clazz == null ? null : clazz.getDeclaredConstructor(classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)noSuchMethodException);
            }
        }

        private static Method getMethod(Class<?> clazz, String string, Class<?> ... classArray) {
            try {
                return clazz == null ? null : clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new AssertionError((Object)noSuchMethodException);
            }
        }

        static boolean isBeansPresent() {
            return propertyChangeListenerClass != null && propertyChangeEventClass != null;
        }

        static Object newPropertyChangeEvent(Object object, String string, Object object2, Object object3) {
            try {
                return propertyEventCtor.newInstance(object, string, object2, object3);
            }
            catch (IllegalAccessException | InstantiationException reflectiveOperationException) {
                throw new AssertionError((Object)reflectiveOperationException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new AssertionError((Object)invocationTargetException);
            }
        }

        static void invokePropertyChange(Object object, Object object2) {
            try {
                propertyChangeMethod.invoke(object, object2);
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new AssertionError((Object)illegalAccessException);
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable instanceof Error) {
                    throw (Error)throwable;
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                throw new AssertionError((Object)invocationTargetException);
            }
        }
    }

    private class Cleaner
    extends Thread {
        private Cleaner() {
            this.setContextClassLoader(null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LogManager logManager = manager;
            LogManager logManager2 = LogManager.this;
            synchronized (logManager2) {
                LogManager.this.deathImminent = true;
                LogManager.this.initializedGlobalHandlers = true;
            }
            LogManager.this.reset();
        }
    }

    private static class LogNode {
        HashMap<String, LogNode> children;
        LoggerWeakRef loggerRef;
        LogNode parent;
        final LoggerContext context;

        LogNode(LogNode logNode, LoggerContext loggerContext) {
            this.parent = logNode;
            this.context = loggerContext;
        }

        void walkAndSetParent(Logger logger) {
            if (this.children == null) {
                return;
            }
            for (LogNode logNode : this.children.values()) {
                Logger logger2;
                LoggerWeakRef loggerWeakRef = logNode.loggerRef;
                Logger logger3 = logger2 = loggerWeakRef == null ? null : (Logger)loggerWeakRef.get();
                if (logger2 == null) {
                    logNode.walkAndSetParent(logger);
                    continue;
                }
                LogManager.doSetParent(logger2, logger);
            }
        }
    }

    class LoggerContext {
        private final Hashtable<String, LoggerWeakRef> namedLoggers = new Hashtable();
        private final LogNode root = new LogNode(null, this);

        private LoggerContext() {
        }

        final boolean requiresDefaultLoggers() {
            boolean bl;
            boolean bl2 = bl = this.getOwner() == manager;
            if (bl) {
                this.getOwner().ensureLogManagerInitialized();
            }
            return bl;
        }

        final LogManager getOwner() {
            return LogManager.this;
        }

        final Logger getRootLogger() {
            return this.getOwner().rootLogger;
        }

        final Logger getGlobalLogger() {
            Logger logger = Logger.global;
            return logger;
        }

        Logger demandLogger(String string, String string2) {
            LogManager logManager = this.getOwner();
            return logManager.demandLogger(string, string2, null);
        }

        private void ensureInitialized() {
            if (this.requiresDefaultLoggers()) {
                this.ensureDefaultLogger(this.getRootLogger());
                this.ensureDefaultLogger(this.getGlobalLogger());
            }
        }

        synchronized Logger findLogger(String string) {
            this.ensureInitialized();
            LoggerWeakRef loggerWeakRef = this.namedLoggers.get(string);
            if (loggerWeakRef == null) {
                return null;
            }
            Logger logger = (Logger)loggerWeakRef.get();
            if (logger == null) {
                loggerWeakRef.dispose();
            }
            return logger;
        }

        private void ensureAllDefaultLoggers(Logger logger) {
            String string;
            if (this.requiresDefaultLoggers() && !(string = logger.getName()).isEmpty()) {
                this.ensureDefaultLogger(this.getRootLogger());
                if (!"global".equals(string)) {
                    this.ensureDefaultLogger(this.getGlobalLogger());
                }
            }
        }

        private void ensureDefaultLogger(Logger logger) {
            if (!this.requiresDefaultLoggers() || logger == null || logger != Logger.global && logger != LogManager.this.rootLogger) {
                assert (logger == null);
                return;
            }
            if (!this.namedLoggers.containsKey(logger.getName())) {
                this.addLocalLogger(logger, false);
            }
        }

        boolean addLocalLogger(Logger logger) {
            return this.addLocalLogger(logger, this.requiresDefaultLoggers());
        }

        synchronized boolean addLocalLogger(Logger logger, boolean bl) {
            LoggerWeakRef loggerWeakRef;
            String string;
            if (bl) {
                this.ensureAllDefaultLoggers(logger);
            }
            if ((string = logger.getName()) == null) {
                throw new NullPointerException();
            }
            LoggerWeakRef loggerWeakRef2 = this.namedLoggers.get(string);
            if (loggerWeakRef2 != null) {
                if (loggerWeakRef2.get() == null) {
                    loggerWeakRef2.dispose();
                } else {
                    return false;
                }
            }
            LogManager logManager = this.getOwner();
            logger.setLogManager(logManager);
            LogManager logManager2 = logManager;
            logManager2.getClass();
            loggerWeakRef2 = logManager2.new LoggerWeakRef(logger);
            this.namedLoggers.put(string, loggerWeakRef2);
            Level level = logManager.getLevelProperty(string + ".level", null);
            if (level != null && !logger.isLevelInitialized()) {
                LogManager.doSetLevel(logger, level);
            }
            this.processParentHandlers(logger, string);
            LogNode logNode = this.getNode(string);
            logNode.loggerRef = loggerWeakRef2;
            Logger logger2 = null;
            LogNode logNode2 = logNode.parent;
            while (logNode2 != null && ((loggerWeakRef = logNode2.loggerRef) == null || (logger2 = (Logger)loggerWeakRef.get()) == null)) {
                logNode2 = logNode2.parent;
            }
            if (logger2 != null) {
                LogManager.doSetParent(logger, logger2);
            }
            logNode.walkAndSetParent(logger);
            loggerWeakRef2.setNode(logNode);
            return true;
        }

        synchronized void removeLoggerRef(String string, LoggerWeakRef loggerWeakRef) {
            this.namedLoggers.remove(string, loggerWeakRef);
        }

        synchronized Enumeration<String> getLoggerNames() {
            this.ensureInitialized();
            return this.namedLoggers.keys();
        }

        private void processParentHandlers(final Logger logger, final String string) {
            int n;
            final LogManager logManager = this.getOwner();
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    boolean bl;
                    if (logger != logManager.rootLogger && !(bl = logManager.getBooleanProperty(string + ".useParentHandlers", true))) {
                        logger.setUseParentHandlers(false);
                    }
                    return null;
                }
            });
            int n2 = 1;
            while ((n = string.indexOf(".", n2)) >= 0) {
                String string2 = string.substring(0, n);
                if (logManager.getProperty(string2 + ".level") != null || logManager.getProperty(string2 + ".handlers") != null) {
                    this.demandLogger(string2, null);
                }
                n2 = n + 1;
            }
        }

        LogNode getNode(String string) {
            if (string == null || string.equals("")) {
                return this.root;
            }
            LogNode logNode = this.root;
            while (string.length() > 0) {
                LogNode logNode2;
                String string2;
                int n = string.indexOf(".");
                if (n > 0) {
                    string2 = string.substring(0, n);
                    string = string.substring(n + 1);
                } else {
                    string2 = string;
                    string = "";
                }
                if (logNode.children == null) {
                    logNode.children = new HashMap();
                }
                if ((logNode2 = logNode.children.get(string2)) == null) {
                    logNode2 = new LogNode(logNode, this);
                    logNode.children.put(string2, logNode2);
                }
                logNode = logNode2;
            }
            return logNode;
        }
    }

    final class LoggerWeakRef
    extends WeakReference<Logger> {
        private String name;
        private LogNode node;
        private WeakReference<Logger> parentRef;
        private boolean disposed;

        LoggerWeakRef(Logger logger) {
            super(logger, LogManager.this.loggerRefQueue);
            this.disposed = false;
            this.name = logger.getName();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void dispose() {
            Object object;
            Object object2 = this;
            synchronized (object2) {
                if (this.disposed) {
                    return;
                }
                this.disposed = true;
            }
            object2 = this.node;
            if (object2 != null) {
                object = ((LogNode)object2).context;
                synchronized (object) {
                    ((LogNode)object2).context.removeLoggerRef(this.name, this);
                    this.name = null;
                    if (((LogNode)object2).loggerRef == this) {
                        ((LogNode)object2).loggerRef = null;
                    }
                    this.node = null;
                }
            }
            if (this.parentRef != null) {
                object = (Logger)this.parentRef.get();
                if (object != null) {
                    ((Logger)object).removeChildLogger(this);
                }
                this.parentRef = null;
            }
        }

        void setNode(LogNode logNode) {
            this.node = logNode;
        }

        void setParentRef(WeakReference<Logger> weakReference) {
            this.parentRef = weakReference;
        }
    }

    private final class RootLogger
    extends Logger {
        private RootLogger() {
            super("", null, null, LogManager.this, true);
        }

        @Override
        public void log(LogRecord logRecord) {
            LogManager.this.initializeGlobalHandlers();
            super.log(logRecord);
        }

        @Override
        public void addHandler(Handler handler) {
            LogManager.this.initializeGlobalHandlers();
            super.addHandler(handler);
        }

        @Override
        public void removeHandler(Handler handler) {
            LogManager.this.initializeGlobalHandlers();
            super.removeHandler(handler);
        }

        @Override
        Handler[] accessCheckedHandlers() {
            LogManager.this.initializeGlobalHandlers();
            return super.accessCheckedHandlers();
        }
    }

    final class SystemLoggerContext
    extends LoggerContext {
        SystemLoggerContext() {
        }

        @Override
        Logger demandLogger(String string, String string2) {
            Logger logger = this.findLogger(string);
            if (logger == null) {
                Logger logger2 = new Logger(string, string2, null, this.getOwner(), true);
                while ((logger = this.addLocalLogger(logger2) ? logger2 : this.findLogger(string)) == null) {
                }
            }
            return logger;
        }
    }
}

