/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.commons.xmlutil;

import com.sun.istack.internal.NotNull;
import com.sun.istack.internal.logging.Logger;
import com.sun.xml.internal.ws.api.message.Message;
import com.sun.xml.internal.ws.api.message.Messages;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.commons.xmlutil.ContextClassloaderLocal;
import com.sun.xml.internal.ws.util.xml.XmlUtil;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Constructor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public final class Converter {
    public static final String UTF_8 = "UTF-8";
    private static final Logger LOGGER = Logger.getLogger(Converter.class);
    private static final ContextClassloaderLocal<XMLOutputFactory> xmlOutputFactory = new ContextClassloaderLocal<XMLOutputFactory>(){

        @Override
        protected XMLOutputFactory initialValue() throws Exception {
            return XMLOutputFactory.newInstance();
        }
    };
    private static final AtomicBoolean logMissingStaxUtilsWarning = new AtomicBoolean(false);

    private Converter() {
    }

    public static String toString(Throwable throwable) {
        if (throwable == null) {
            return "[ No exception ]";
        }
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static String toString(Packet packet) {
        if (packet == null) {
            return "[ Null packet ]";
        }
        if (packet.getMessage() == null) {
            return "[ Empty packet ]";
        }
        return Converter.toString(packet.getMessage());
    }

    public static String toStringNoIndent(Packet packet) {
        if (packet == null) {
            return "[ Null packet ]";
        }
        if (packet.getMessage() == null) {
            return "[ Empty packet ]";
        }
        return Converter.toStringNoIndent(packet.getMessage());
    }

    public static String toString(Message message) {
        return Converter.toString(message, true);
    }

    public static String toStringNoIndent(Message message) {
        return Converter.toString(message, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String toString(Message message, boolean bl) {
        if (message == null) {
            return "[ Null message ]";
        }
        StringWriter stringWriter = null;
        try {
            stringWriter = new StringWriter();
            XMLStreamWriter xMLStreamWriter = null;
            try {
                xMLStreamWriter = xmlOutputFactory.get().createXMLStreamWriter(stringWriter);
                if (bl) {
                    xMLStreamWriter = Converter.createIndenter(xMLStreamWriter);
                }
                message.copy().writeTo(xMLStreamWriter);
            }
            catch (Exception exception) {
                LOGGER.log(Level.WARNING, "Unexpected exception occured while dumping message", exception);
            }
            finally {
                if (xMLStreamWriter != null) {
                    try {
                        xMLStreamWriter.close();
                    }
                    catch (XMLStreamException xMLStreamException) {
                        LOGGER.fine("Unexpected exception occured while closing XMLStreamWriter", xMLStreamException);
                    }
                }
            }
            String string = stringWriter.toString();
            return string;
        }
        finally {
            if (stringWriter != null) {
                try {
                    stringWriter.close();
                }
                catch (IOException iOException) {
                    LOGGER.finest("An exception occured when trying to close StringWriter", iOException);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] toBytes(Message message, String string) throws XMLStreamException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            Object object;
            if (message != null) {
                object = xmlOutputFactory.get().createXMLStreamWriter(byteArrayOutputStream, string);
                try {
                    message.writeTo((XMLStreamWriter)object);
                }
                finally {
                    try {
                        object.close();
                    }
                    catch (XMLStreamException xMLStreamException) {
                        LOGGER.warning("Unexpected exception occured while closing XMLStreamWriter", xMLStreamException);
                    }
                }
            }
            object = byteArrayOutputStream.toByteArray();
            return object;
        }
        finally {
            try {
                byteArrayOutputStream.close();
            }
            catch (IOException iOException) {
                LOGGER.warning("Unexpected exception occured while closing ByteArrayOutputStream", iOException);
            }
        }
    }

    public static Message toMessage(@NotNull InputStream inputStream, String string) throws XMLStreamException {
        XMLStreamReader xMLStreamReader = XmlUtil.newXMLInputFactory(true).createXMLStreamReader(inputStream, string);
        return Messages.create(xMLStreamReader);
    }

    public static String messageDataToString(byte[] byArray, String string) {
        try {
            return Converter.toString(Converter.toMessage(new ByteArrayInputStream(byArray), string));
        }
        catch (XMLStreamException xMLStreamException) {
            LOGGER.warning("Unexpected exception occured while converting message data to string", xMLStreamException);
            return "[ Message Data Conversion Failed ]";
        }
    }

    private static XMLStreamWriter createIndenter(XMLStreamWriter xMLStreamWriter) {
        block2: {
            try {
                Class<?> clazz = Converter.class.getClassLoader().loadClass("javanet.staxutils.IndentingXMLStreamWriter");
                Constructor<?> constructor = clazz.getConstructor(XMLStreamWriter.class);
                xMLStreamWriter = (XMLStreamWriter)XMLStreamWriter.class.cast(constructor.newInstance(xMLStreamWriter));
            }
            catch (Exception exception) {
                if (!logMissingStaxUtilsWarning.compareAndSet(false, true)) break block2;
                LOGGER.log(Level.WARNING, "Put stax-utils.jar to the classpath to indent the dump output", exception);
            }
        }
        return xMLStreamWriter;
    }
}

