// MemoryManagemant.h
// f[^ǗNX
// coded by Naotoshi Yoda

#include <set>
#include <string>

#define MM_DEFAULT_PRINTMEMORYSIZE 5	//ftHg5Ԓn\

//----------ONX----------
class MemoryManagementException
{
public:
	virtual void printMessage(void){
		std::cout << "error" << std::endl;
	}
};
class FileOpenError : public MemoryManagementException
{
private:
	const char *pc_message;
public:
	FileOpenError(const char *pc_in_message){
		pc_message = pc_in_message;
	}
	void printMessage(void){
		std::cout << pc_message << std::endl;
	}
};
class FileFormatError : public MemoryManagementException
{
private:
	int i_line;
	std::string *postr_line;
public:
	FileFormatError(int i_in_line, const char *pc_in_line){
		i_line = i_in_line;
		postr_line = new std::string(pc_in_line);
	}
	~FileFormatError(void){
		delete postr_line;
	}
	void printMessage(void){
		std::cout << i_line << ":" << *postr_line << std::endl;
	}
};
class BreakPointDuplicateError : public MemoryManagementException
{
private:
	int i_address;
public:
	BreakPointDuplicateError(int i_dup_address){
		i_address = i_dup_address;
	}
	void printMessage(void){
		std::cout << i_address << std::endl;
	}
};
class BreakPointRemoveError : public MemoryManagementException
{
private:
	int i_address;
public:
	BreakPointRemoveError(int i_dup_address){
		i_address = i_dup_address;
	}
	void printMessage(void){
		std::cout << i_address << std::endl;
	}
};

//----------MemoryManagementNX----------
class MemoryManagement
{
public:
	enum flagtype{
		FLAG_PLUS, FLAG_ZERO, FLAG_MINUS
	};

private:
	std::set<int> oseti_breakpoint;
	int  i_programcounter;
	int ai_generalregister[5];
	flagtype e_flagregister;
	int ai_memory[0xFFFF];

	int parseLine(char *pc_line, int i_line_number);

public:
	//RXgN^EfXgN^
	MemoryManagement(char *pc_filename_input);
	~MemoryManagement();

	//\֐
	void printAllRegister(void);
	void printMemory(int i_address_start, int i_address_size = MM_DEFAULT_PRINTMEMORYSIZE);
	void printMemory(char *pc_filename_output, int i_address_start, int i_address_size = MM_DEFAULT_PRINTMEMORYSIZE);
	void printBreakPoint(void);

	//u[N|Cg
	void setBreakPoint(int i_address);
	void removeBreakPoint(int i_address);
	bool checkBreakPoint(int i_address);	//false:BPZbgĂȂ

	//vOJE^
	void setProgramCounter(int i_address);
	int  getProgramCounter(void);
	void addProgramCounter(int i_value = 1);

	//ėpWX^
	void setGeneralRegister(int i_gr_num, int i_value);
	int  getGeneralRegister(int i_gr_num);
	void addGeneralRegister(int i_gr_num, int i_value);

	//tOWX^
	void setFlagRegister(flagtype e_flag_sign);
	flagtype getFlagRegister(void);

	//ėp
	void setMemory(int i_address, int i_value);
	int  getMemory(int i_address);
};
