// MemoryManagemant.cpp
// f[^ǗNX
// coded by Naotoshi Yoda

#include <iostream>
#include <iomanip>
#include <utility>
#include <set>
#include <fstream>
#include "MemoryManagement.h"

//----------AhX\p}js[^----------
namespace manip
{
	std::ostream &addr(std::ostream &stream){
		stream << "0x" << std::setw(4) << std::setfill('0') << std::hex;
		return stream;
	}
}

//----------ONX----------


//----------RXgN^----------
MemoryManagement::MemoryManagement(char *pc_filename)
{
	std::ifstream oifs_input(pc_filename, std::ios::in);
	if( !oifs_input ) throw FileOpenError(pc_filename);

	//oϐ̏
	i_programcounter = 0;
	e_flagregister = FLAG_ZERO;
	for(int i=0; i<5; ++i)
		ai_generalregister[i] = 0;
	for(int i=0; i<0xFFFF; ++i)
		ai_memory[i] = 0;

	//t@Cǂݍ
	char ac_tmp_input[255];

	//vOJE^̃Zbg
	oifs_input.getline(ac_tmp_input, sizeof(ac_tmp_input));
	i_programcounter = parseLine(ac_tmp_input, 0);

	for(int i=0; !oifs_input.eof() ; ++i ){
		oifs_input.getline(ac_tmp_input, sizeof(ac_tmp_input));
		ai_memory[i] = parseLine(ac_tmp_input, i+2);
	}
}

int MemoryManagement::parseLine(char *pc_line, int i_line_number)
{
	const char C_UD = -1;	//undefined char
	const char ac_table[128]={
		C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,
		C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,
		C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,
		   0,   1,   2,   3,   4,   5,   6,   7,   8,   9,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,
		C_UD,  10,  11,  12,  13,  14,  15,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,
		C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,
		C_UD,  10,  11,  12,  13,  14,  15,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,
		C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD,C_UD
	};
	int i, i_value = 0;
	static int i_breakline_flag = 0;
	if( pc_line[0]==0 ){
		i_breakline_flag ^= 1;
		return 0;
	}
	for(i=0; pc_line[i]; ++i ){
		char c_tmp_number = ac_table[ pc_line[i] ];
		if( c_tmp_number==C_UD || i==4 ) throw FileFormatError( i_line_number, pc_line );
		i_value |= c_tmp_number<<((3-i)<<2);
	}
	if(i<4) throw FileFormatError( i_line_number, pc_line );
	if( i_breakline_flag==0 ){
		return i_value;
	}else{
		throw FileFormatError( i_line_number, pc_line );
	}
}


//----------fXgN^----------
MemoryManagement::~MemoryManagement(){};

//----------\֐----------
void MemoryManagement::printAllRegister(void)
{
	std::cout << "PC:" << manip::addr << i_programcounter;
	std::cout.unsetf( std::ios::showbase );
	std::cout << "  FR:" << std::setw(1) << ((e_flagregister>>1)&1) << (e_flagregister&1) << std::endl;

	int i=0;
	for(; i<3; ++i){
		std::cout << "GR" << i << ":" << manip::addr << ai_generalregister[i] << "  ";
	}
	std::cout << std::endl;
	for(; i<5; ++i){
		std::cout << "GR" << i << ":" << manip::addr << ai_generalregister[i] << "  ";
	}
	std::cout << std::endl;
}

void MemoryManagement::printMemory(int i_address_start, int i_address_size)
{
	//Wo͂փo
	for(int i=0; i<i_address_size; ++i, ++i_address_start){
		std::cout << manip::addr << i_address_start << "  " << manip::addr << ai_memory[i_address_start] << std::endl;
	}
}

void MemoryManagement::printMemory(char *pc_filename_output, int i_address_start, int i_address_size)
{
	//t@CI[v
	std::ofstream oofs_output( pc_filename_output );
	if( !oofs_output ) throw FileOpenError(pc_filename_output);

	for(int i=0; i<i_address_size; ++i, ++i_address_start){
		std::cout << manip::addr << i_address_start << "  " << manip::addr << ai_memory[i_address_start] << std::endl;
	}
}

void MemoryManagement::printBreakPoint(void)
{
	std::set<int>::iterator osetit_it = oseti_breakpoint.begin();
	while( osetit_it!=oseti_breakpoint.end() ){
		std::cout << manip::addr << *osetit_it++ << std::endl;
	}
}

//----------u[N|Cg----------
void MemoryManagement::setBreakPoint(int i_address)
{
	std::pair<std::set<int>::iterator,bool> opair_check_insert;
	opair_check_insert = oseti_breakpoint.insert(i_address&0xFFFF);
	if( opair_check_insert.second==false ){
		throw BreakPointDuplicateError(i_address);
	}
}

void MemoryManagement::removeBreakPoint(int i_address)
{
	if( oseti_breakpoint.erase(i_address&0xFFFF)==0 ){
		throw BreakPointRemoveError(i_address);
	}
}

bool MemoryManagement::checkBreakPoint(int i_address)
{
	if( oseti_breakpoint.find(i_address)==oseti_breakpoint.end() ){
		return false;
	}
	return true;
}

//----------vOJE^----------
void MemoryManagement::setProgramCounter(int i_address)
{
	i_programcounter = i_address & 0xFFFF;
}

int  MemoryManagement::getProgramCounter(void)
{
	return i_programcounter;
}

void MemoryManagement::addProgramCounter(int i_value)
{
	i_programcounter += i_value;
	i_programcounter &= 0xFFFF;
}

//----------ėpWX^----------
void MemoryManagement::setGeneralRegister(int i_gr_num, int i_value)
{
	ai_generalregister[i_gr_num] = i_value&0xFFFF;
}

int  MemoryManagement::getGeneralRegister(int i_gr_num)
{
	return ai_generalregister[i_gr_num];
}

void MemoryManagement::addGeneralRegister(int i_gr_num, int i_value)
{
	ai_generalregister[i_gr_num] += i_value;
	ai_generalregister[i_gr_num] &= 0xFFFF;
}

//----------tOWX^----------
void MemoryManagement::setFlagRegister(MemoryManagement::flagtype e_flag_sign)
{
	e_flagregister = e_flag_sign;
}

MemoryManagement::flagtype MemoryManagement::getFlagRegister(void)
{
	return e_flagregister;
}

//----------ėp----------
void MemoryManagement::setMemory(int i_address, int i_value)
{
	ai_memory[i_address] = i_value&0xFFFF;
}

int  MemoryManagement::getMemory(int i_address)
{
	return ai_memory[i_address];
}
