/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.util.Iterator;
import java.util.Map;
import javax.swing.JPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TempoPanel
extends JPanel {
    private int[] xPoints;
    private int[] yPoints;
    private int nPoints;
    private double scale = 0.05;
    private int WINDOW_HEIGHT = 200;
    private RowHeader rowHeader;

    public TempoPanel(int n, Map<Integer, Integer> map) {
        this.setPreferredSize(new Dimension((int)((double)n * this.scale), this.WINDOW_HEIGHT));
        this.setPoints(map);
        this.rowHeader = new RowHeader();
    }

    public JPanel getRowHeader() {
        return this.rowHeader;
    }

    public void setPoints(Map<Integer, Integer> map) {
        this.nPoints = map.size() * 2 - 1;
        this.xPoints = new int[this.nPoints];
        this.yPoints = new int[this.nPoints];
        Iterator<Map.Entry<Integer, Integer>> iterator = map.entrySet().iterator();
        Map.Entry<Integer, Integer> entry = iterator.next();
        this.xPoints[0] = (int)((double)entry.getKey().intValue() * this.scale);
        this.yPoints[0] = this.WINDOW_HEIGHT - entry.getValue();
        int n = 2;
        while (iterator.hasNext()) {
            int n2;
            Map.Entry<Integer, Integer> entry2 = iterator.next();
            this.xPoints[n - 1] = n2 = (int)((double)entry2.getKey().intValue() * this.scale);
            this.yPoints[n - 1] = this.yPoints[n - 2];
            this.xPoints[n] = n2;
            this.yPoints[n] = this.WINDOW_HEIGHT - entry2.getValue();
            n += 2;
        }
    }

    @Override
    public void paint(Graphics graphics) {
        super.paint(graphics);
        graphics.setColor(Color.BLACK);
        graphics.drawPolyline(this.xPoints, this.yPoints, this.nPoints);
        graphics.drawLine(this.xPoints[this.nPoints - 1], this.yPoints[this.nPoints - 1], this.getWidth(), this.yPoints[this.nPoints - 1]);
    }

    private class RowHeader
    extends JPanel {
        private RowHeader() {
            this.setPreferredSize(new Dimension(32, TempoPanel.this.WINDOW_HEIGHT));
        }

        public void paint(Graphics graphics) {
            super.paint(graphics);
            graphics.setColor(Color.BLACK);
            for (int i = 0; i < TempoPanel.this.WINDOW_HEIGHT; i += 30) {
                graphics.drawString(TempoPanel.this.WINDOW_HEIGHT - i + "", 0, i);
            }
        }
    }
}

