/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.commands;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.DeviationInstanceWrapper;
import jp.crestmuse.cmx.filewrappers.MIDIXMLWrapper;
import jp.crestmuse.cmx.filewrappers.MusicXMLWrapper;
import jp.crestmuse.cmx.filewrappers.SCCXMLWrapper;
import jp.crestmuse.cmx.misc.PerformanceMatcher3;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeviationInstanceExtractor
extends CMXCommand<MusicXMLWrapper, DeviationInstanceWrapper> {
    private MIDIXMLWrapper midixml;
    private String scoreFileName = "score.mid";
    private String midiXmlFileName = "midi.xml";
    private String sccXmlFileName = "scc.xml";
    private String remadeSmfFileName = "result.mid";
    private boolean remakeSMF = false;
    private int division = 0;

    @Override
    public String getDestDir() {
        return super.getDestDir();
    }

    @Override
    protected boolean setOptionsLocal(String string, String string2) {
        if (string.equals("-smf")) {
            try {
                this.midixml = MIDIXMLWrapper.readSMF(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }
        if (string.equals("-midixml")) {
            try {
                this.midixml = (MIDIXMLWrapper)CMXFileWrapper.readfile(string2);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
            return true;
        }
        if (string.equals("-score")) {
            this.scoreFileName = string2;
            return true;
        }
        if (string.equals("-midi")) {
            this.midiXmlFileName = string2;
            return true;
        }
        if (string.equals("-result")) {
            this.remadeSmfFileName = string2;
            return true;
        }
        if (string.equals("-division")) {
            this.division = Integer.parseInt(string2);
            return true;
        }
        return false;
    }

    @Override
    protected boolean setBoolOptionsLocal(String string) {
        if (string.equals("-remakeSMF")) {
            this.remakeSMF = true;
            return true;
        }
        return false;
    }

    @Override
    protected DeviationInstanceWrapper run(MusicXMLWrapper musicXMLWrapper) throws IOException, ParserConfigurationException, SAXException, TransformerException {
        String string = this.getDestDir();
        if (this.remakeSMF) {
            musicXMLWrapper.makeDeadpanSCCXML(this.midixml.ticksPerBeat()).toMIDIXML().writefileAsSMF(new File(string, this.scoreFileName));
        }
        DeviationInstanceWrapper deviationInstanceWrapper = this.division == 0 ? PerformanceMatcher3.extractDeviation(musicXMLWrapper, this.midixml) : PerformanceMatcher3.extractDeviation(musicXMLWrapper, this.midixml, this.division);
        deviationInstanceWrapper.finalizeDocument();
        if (this.remakeSMF) {
            SCCXMLWrapper sCCXMLWrapper = deviationInstanceWrapper.toSCCXML(this.midixml.ticksPerBeat());
            sCCXMLWrapper.writefile(new File(string, this.sccXmlFileName));
            MIDIXMLWrapper mIDIXMLWrapper = sCCXMLWrapper.toMIDIXML();
            mIDIXMLWrapper.writefile(new File(string, this.midiXmlFileName));
            mIDIXMLWrapper.writefileAsSMF(new File(string, this.remadeSmfFileName));
        }
        return deviationInstanceWrapper;
    }

    public static void main(String[] stringArray) {
        DeviationInstanceExtractor deviationInstanceExtractor = new DeviationInstanceExtractor();
        try {
            deviationInstanceExtractor.start(stringArray);
        }
        catch (Exception exception) {
            deviationInstanceExtractor.showErrorMessage(exception);
            System.exit(1);
        }
    }
}

