/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.sp;

import java.util.Map;
import jp.crestmuse.cmx.amusaj.filewrappers.PeakSet;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPComplexArray;
import jp.crestmuse.cmx.amusaj.sp.SPElement;
import jp.crestmuse.cmx.amusaj.sp.SPModule;
import jp.crestmuse.cmx.commands.CMXCommand;
import jp.crestmuse.cmx.filewrappers.ConfigXMLWrapper;
import jp.crestmuse.cmx.math.DoubleArray;
import jp.crestmuse.cmx.math.DoubleArrayFactory;
import jp.crestmuse.cmx.math.Operations;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeakExtractor
extends SPModule {
    private static double powerthrs = 0.0;
    private static double rpowerthrs = 0.0;
    private int fs;
    private int winsize;
    private int size = 0;
    private double[] power0;
    private DoubleArray freq;
    private DoubleArray power;
    private DoubleArray phase;
    private DoubleArray iid;
    private DoubleArray ipd;
    private int t;
    private DoubleArrayFactory factory = DoubleArrayFactory.getFactory();
    private ConfigXMLWrapper config = CMXCommand.getConfigXMLWrapper();

    public PeakExtractor() {
        powerthrs = this.config.getParamDouble("param", "fft", "POWER_THRESHOLD");
        rpowerthrs = this.config.getParamDouble("param", "fft", "RELATIVE_POWER_THRESHOLD");
    }

    private void reset(int n) {
        this.size = n;
        this.power0 = new double[n];
        this.freq = this.factory.createArray(n);
        this.power = this.factory.createArray(n);
        this.phase = this.factory.createArray(n);
        this.iid = this.factory.createArray(n);
        this.ipd = this.factory.createArray(n);
    }

    @Override
    public Class<SPElement>[] getInputClasses() {
        return new Class[]{SPComplexArray.class, SPComplexArray.class, SPComplexArray.class};
    }

    @Override
    public Class<SPElement>[] getOutputClasses() {
        return new Class[]{PeakSet.class};
    }

    @Override
    public void execute(SPElement[] sPElementArray, TimeSeriesCompatible<SPElement>[] timeSeriesCompatibleArray) throws InterruptedException {
        boolean bl;
        SPComplexArray sPComplexArray;
        SPComplexArray sPComplexArray2;
        SPComplexArray sPComplexArray3 = (SPComplexArray)sPElementArray[0];
        if (sPElementArray.length > 1 && sPElementArray[1] != null) {
            sPComplexArray2 = (SPComplexArray)sPElementArray[1];
            sPComplexArray = (SPComplexArray)sPElementArray[2];
            bl = true;
        } else {
            sPComplexArray2 = null;
            sPComplexArray = null;
            bl = false;
        }
        double d = Double.NEGATIVE_INFINITY;
        int n = sPComplexArray3.length();
        if (this.size != n) {
            this.reset(n);
        }
        for (int i = 0; i < this.size; ++i) {
            double d2;
            this.power0[i] = d2 = Math.hypot(sPComplexArray3.getReal(i), sPComplexArray3.getImag(i));
            if (!(d2 > d)) continue;
            d = d2;
        }
        double d3 = d * rpowerthrs;
        int n2 = 0;
        int n3 = 2;
        while (n3 < this.size - 2) {
            if (this.power0[n3] > this.power0[n3 + 1]) {
                if (this.power0[n3 + 1] > this.power0[n3 + 2]) {
                    if (this.power0[n3] > this.power0[n3 - 1] && this.power0[n3 - 1] > this.power0[n3 - 2] && this.power0[n3] > powerthrs && this.power0[n3] > d3) {
                        this.freq.set(n2, (double)(n3 * this.fs) / (double)this.winsize);
                        this.power.set(n2, this.power0[n3]);
                        this.phase.set(n2, Math.atan2(sPComplexArray3.getImag(n3), sPComplexArray3.getReal(n3)));
                        if (bl) {
                            this.iid.set(n2, Math.hypot(sPComplexArray.getReal(n3), sPComplexArray.getImag(n3)) / Math.hypot(sPComplexArray2.getReal(n3), sPComplexArray2.getImag(n3)));
                            this.ipd.set(n2, Math.atan2(sPComplexArray.getImag(n3), sPComplexArray.getReal(n3)) - Math.atan2(sPComplexArray2.getImag(n3), sPComplexArray2.getReal(n3)));
                        } else {
                            this.iid.set(n2, 1.0);
                            this.ipd.set(n2, 0.0);
                        }
                        ++n2;
                        n3 += 4;
                        continue;
                    }
                    n3 += 4;
                    continue;
                }
                n3 += 3;
                continue;
            }
            if (this.power0[n3] <= this.power0[n3 - 1]) {
                n3 += 2;
                continue;
            }
            ++n3;
        }
        PeakSet peakSet = new PeakSet(Operations.subarray(this.freq, 0, n2), Operations.subarray(this.power, 0, n2), Operations.subarray(this.phase, 0, n2), Operations.subarray(this.iid, 0, n2), Operations.subarray(this.ipd, 0, n2));
        timeSeriesCompatibleArray[0].add(peakSet);
    }

    @Override
    public void setParams(Map<String, String> map) {
        super.setParams(map);
        this.fs = this.getParamInt("SAMPLE_RATE");
        this.winsize = this.getParamInt("WINDOW_SIZE");
    }
}

