/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.util.LinkedHashMap;
import java.util.Map;
import jp.crestmuse.cmx.filewrappers.AbstractHeaderNodeInterface;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.filewrappers.NodeInterface;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmusaScriptWrapper
extends CMXFileWrapper {
    private Params params;
    private Modules modules;
    private Connections connections;
    private Outputs outputs;

    @Override
    protected void analyze() {
        this.params = new Params(this.selectSingleNode("/script/params"));
        this.modules = new Modules(this.selectSingleNode("/script/modules"));
        this.connections = new Connections(this.selectSingleNode("/script/connections"));
        this.outputs = new Outputs(this.selectSingleNode("/script/outputs"));
    }

    public String[] getParamNameList() {
        return this.params.getHeaderNameList();
    }

    public String getParam(String string) {
        return this.params.getHeaderElement(string);
    }

    public Map<String, String> getModules() {
        return this.modules.map;
    }

    public Connection[] getConnections() {
        return this.connections.list;
    }

    public Output[] getOutputs() {
        return this.outputs.outputs;
    }

    public String getOutputFormat() {
        return this.outputs.fmt;
    }

    public class Output {
        public String object;
        public int ch;
    }

    private class Outputs
    extends NodeInterface {
        private String fmt;
        private Output[] outputs;

        private Outputs(Node node) {
            super(node);
            this.fmt = this.getAttribute("format");
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            this.outputs = new Output[n];
            for (int i = 0; i < n; ++i) {
                Output output = new Output();
                output.object = Outputs.getAttribute(nodeList.item(i), "object");
                output.ch = Outputs.getAttributeInt(nodeList.item(i), "ch");
                this.outputs[i] = output;
            }
        }

        protected String getSupportedNodeName() {
            return "outputs";
        }
    }

    public class Connection {
        public String objFrom;
        public String objTo;
        public int chFrom;
        public int chTo;
    }

    private class Connections
    extends NodeInterface {
        private Connection[] list;

        private Connections(Node node) {
            super(node);
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            this.list = new Connection[n];
            for (int i = 0; i < n; ++i) {
                Connection connection = new Connection();
                connection.objFrom = Connections.getAttribute(nodeList.item(i), "objFrom");
                connection.objTo = Connections.getAttribute(nodeList.item(i), "objTo");
                connection.chFrom = Connections.getAttributeInt(nodeList.item(i), "chFrom");
                connection.chTo = Connections.getAttributeInt(nodeList.item(i), "chTo");
                this.list[i] = connection;
            }
        }

        protected String getSupportedNodeName() {
            return "connections";
        }
    }

    private class Modules
    extends NodeInterface {
        private Map<String, String> map;

        private Modules(Node node) {
            super(node);
            NodeList nodeList = this.getChildNodes();
            int n = nodeList.getLength();
            this.map = new LinkedHashMap<String, String>();
            for (int i = 0; i < n; ++i) {
                this.map.put(Modules.getAttribute(nodeList.item(i), "name"), Modules.getAttribute(nodeList.item(i), "object"));
            }
        }

        protected String getSupportedNodeName() {
            return "modules";
        }
    }

    private class Params
    extends AbstractHeaderNodeInterface {
        private Params(Node node) {
            super(node);
        }

        protected String getSupportedNodeName() {
            return "params";
        }
    }
}

