/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.amusaj.filewrappers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaDataSetCompatible;
import jp.crestmuse.cmx.amusaj.filewrappers.AmusaXMLWrapper;
import jp.crestmuse.cmx.amusaj.filewrappers.TimeSeriesCompatible;
import jp.crestmuse.cmx.amusaj.sp.SPElement;
import jp.crestmuse.cmx.amusaj.sp.SPElementEncodable;
import jp.crestmuse.cmx.amusaj.sp.SPTerminator;
import jp.crestmuse.cmx.filewrappers.CMXFileWrapper;
import jp.crestmuse.cmx.misc.PrintStreamWrapper;
import jp.crestmuse.cmx.misc.PrintWriterWrapper;
import jp.crestmuse.cmx.misc.Printable;
import jp.crestmuse.cmx.misc.QueueReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AmusaDataSet<D extends TimeSeriesCompatible>
implements AmusaDataSetCompatible<D> {
    private Map<String, String> header;
    private List<D> data;
    String fmt;

    AmusaDataSet() {
        this.header = new HashMap<String, String>();
        this.data = new ArrayList<D>();
    }

    public AmusaDataSet(String string) {
        this.fmt = string;
        this.header = new HashMap<String, String>();
        this.data = new ArrayList<D>();
    }

    public AmusaDataSet(String string, Map<String, String> map) {
        this.fmt = string;
        this.header = map;
        this.data = new ArrayList<D>();
    }

    @Override
    public String getHeader(String string) {
        return this.header.get(string);
    }

    @Override
    public int getHeaderInt(String string) {
        return Integer.parseInt(this.getHeader(string));
    }

    @Override
    public double getHeaderDouble(String string) {
        return Double.parseDouble(this.getHeader(string));
    }

    @Override
    public boolean containsHeaderKey(String string) {
        return this.header.containsKey(string);
    }

    @Override
    public void setHeader(String string, String string2) {
        this.header.put(string, string2);
    }

    @Override
    public void setHeader(String string, int n) {
        this.header.put(string, String.valueOf(n));
    }

    @Override
    public void setHeader(String string, double d) {
        this.header.put(string, String.valueOf(d));
    }

    public void setHeaders(Map<String, Object> map) {
        Set<Map.Entry<String, Object>> set = map.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            this.header.put(entry.getKey(), entry.getValue().toString());
        }
    }

    public void setHeaders(Map<String, Object> map, String ... stringArray) {
        for (String string : stringArray) {
            this.header.put(string, map.get(string).toString());
        }
    }

    @Override
    public void add(D d) {
        this.data.add(d);
    }

    @Override
    public List<D> getDataList() {
        return this.data;
    }

    public AmusaXMLWrapper toWrapper() throws IOException, InterruptedException {
        AmusaXMLWrapper amusaXMLWrapper = (AmusaXMLWrapper)CMXFileWrapper.createDocument("amusaxml");
        amusaXMLWrapper.setAttribute("format", this.fmt);
        amusaXMLWrapper.addChild("header");
        Set<Map.Entry<String, String>> set = this.header.entrySet();
        for (Map.Entry<String, String> object : set) {
            amusaXMLWrapper.addChild("meta");
            amusaXMLWrapper.setAttribute("name", object.getKey());
            amusaXMLWrapper.setAttribute("content", object.getValue());
            amusaXMLWrapper.returnToParent();
        }
        amusaXMLWrapper.returnToParent();
        for (TimeSeriesCompatible timeSeriesCompatible : this.data) {
            Object object;
            int n = 0;
            QueueReader queueReader = timeSeriesCompatible.getQueueReader();
            StringBuilder stringBuilder = new StringBuilder();
            while (!((object = (SPElement)queueReader.take()) instanceof SPTerminator)) {
                if (object instanceof SPElementEncodable) {
                    if (stringBuilder.length() > 0) {
                        stringBuilder.append("\n");
                    }
                    stringBuilder.append(((SPElementEncodable)object).encode());
                    ++n;
                    continue;
                }
                throw new UnsupportedOperationException("The objects should be SPElementEncodable to be written in an XML format.");
            }
            amusaXMLWrapper.addChild("data");
            object = timeSeriesCompatible.getAttributeIterator();
            while (object.hasNext()) {
                Map.Entry entry = (Map.Entry)object.next();
                amusaXMLWrapper.setAttribute((String)entry.getKey(), (String)entry.getValue());
            }
            amusaXMLWrapper.setAttribute("frames", n);
            if (timeSeriesCompatible.dim() > 0) {
                amusaXMLWrapper.setAttribute("dim", timeSeriesCompatible.dim());
            }
            amusaXMLWrapper.addText(stringBuilder.toString());
            amusaXMLWrapper.returnToParent();
        }
        amusaXMLWrapper.finalizeDocument();
        return amusaXMLWrapper;
    }

    @Override
    public String getFileName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        this.write(new PrintStreamWrapper(new PrintStream(outputStream)));
    }

    @Override
    public void write(Writer writer) throws IOException {
        this.write(new PrintWriterWrapper(new PrintWriter(writer)));
    }

    @Override
    public void writefile(File file) throws IOException {
        this.write(new PrintStreamWrapper(new PrintStream(file)));
    }

    @Override
    public void writeGZippedFile(File file) throws IOException {
        this.write(new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(file))));
    }

    private void write(Printable printable) throws IOException {
        try {
            printable.println("<amusaxml format=\"" + this.fmt + "\">");
            printable.println("  <header>");
            Set<Map.Entry<String, String>> set = this.header.entrySet();
            for (Map.Entry<String, String> object : set) {
                printable.println("    <meta name=\"" + object.getKey() + "\" content=\"" + object.getValue() + "\" />");
            }
            printable.println("  </header>");
            for (TimeSeriesCompatible timeSeriesCompatible : this.data) {
                SPElement sPElement;
                Object object;
                SPElement sPElement2;
                QueueReader queueReader = timeSeriesCompatible.getQueueReader();
                LinkedList<SPElement> linkedList = new LinkedList<SPElement>();
                do {
                    sPElement2 = (SPElement)queueReader.take();
                    linkedList.add(sPElement2);
                } while (!(sPElement2 instanceof SPTerminator));
                StringBuilder stringBuilder = new StringBuilder();
                timeSeriesCompatible.setAttribute("frames", linkedList.size() - 1);
                if (timeSeriesCompatible.dim() > 0) {
                    timeSeriesCompatible.setAttribute("dim", timeSeriesCompatible.dim());
                }
                Iterator<Map.Entry<String, String>> iterator = timeSeriesCompatible.getAttributeIterator();
                while (iterator.hasNext()) {
                    object = iterator.next();
                    stringBuilder.append(" ").append(object.getKey()).append("=\"").append(object.getValue()).append("\"");
                }
                printable.println("  <data" + stringBuilder.toString() + ">");
                object = linkedList.iterator();
                while (object.hasNext() && !((sPElement = (SPElement)object.next()) instanceof SPTerminator)) {
                    if (sPElement instanceof SPElementEncodable) {
                        printable.println(((SPElementEncodable)sPElement).encode());
                        continue;
                    }
                    throw new UnsupportedOperationException("The objects should be SPElementEncodable to be written in an XML format.");
                }
                printable.println("  </data>");
            }
            printable.println("</amusaxml>");
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

