/*
 * Decompiled with CFR 0.152.
 */
package jp.crestmuse.cmx.gui.deveditor;

import java.awt.Color;
import java.awt.Graphics;
import jp.crestmuse.cmx.gui.deveditor.CompiledDeviation;
import jp.crestmuse.cmx.gui.deveditor.PianoRollPanel;

public class PrintableNote {
    private PianoRollPanel parent;
    private int x;
    private int y;
    private int width;
    private int height;
    private int onset;
    private int offset;
    private int onsetInMSec;
    private int offsetInMSec;

    public PrintableNote(CompiledDeviation.DeviatedNote deviatedNote, PianoRollPanel pianoRollPanel) {
        this.parent = pianoRollPanel;
        this.onset = deviatedNote.onsetOriginal();
        this.offset = deviatedNote.offsetOriginal();
        this.onsetInMSec = deviatedNote.onsetOriginalInMSec();
        this.offsetInMSec = deviatedNote.offsetOriginalInMSec();
        this.y = PianoRollPanel.HEIGHT_PER_NOTE * (127 - deviatedNote.notenum());
        this.height = PianoRollPanel.HEIGHT_PER_NOTE;
        this.asTickTime();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(Color.BLACK);
        graphics.drawRect(this.x, this.y, this.width - 1, this.height - 1);
    }

    public void asTickTime() {
        int n = CompiledDeviation.TICKS_PER_BEAT;
        this.x = (int)((double)this.onset / (double)n * (double)PianoRollPanel.WIDTH_PER_BEAT);
        this.width = (int)((double)(this.offset - this.onset) / (double)n * (double)PianoRollPanel.WIDTH_PER_BEAT);
    }

    public void asRealTime() {
        int n = this.parent.getPreferredSize().width;
        int n2 = (int)(this.parent.getCompiledDeviation().getSequence().getMicrosecondLength() / 1000L);
        this.x = n * this.onsetInMSec / n2;
        this.width = n * (this.offsetInMSec - this.onsetInMSec) / n2;
    }
}

