/*
 * Copyright (C) 2010 awk4j - http://awk4j.sourceforge.jp/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package plus.io;

import java.io.InputStream;

/**
 * [%device%] null 入力ストリーム.
 * <p>
 * The class to which this annotation is applied is immutable.
 *
 * @author kunio himei.
 */
public final class NullInputStream extends InputStream {

    /**
     * Singleton Object.
     */
    public static final NullInputStream THIS = new NullInputStream();

    /**
     * default constructor.
     */
    private NullInputStream() {
        super();
    }

    /**
     * 何もしない.
     */
    @Override
    public void close() {
        // (何もしない)
    }

    /**
     * @return -1 (ストリームの終わりに達した).
     */
    @Override
    public int read() {
        return -1;
    }
}