/*
 * Decompiled with CFR 0.152.
 */
package plus.lex;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;

final class LexRegx {
    private final Pattern pattern;
    private Matcher matcher;

    LexRegx(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Nullable
    public static String isNativeRegexp(String s) {
        if ('/' == s.charAt(0)) {
            int len = s.length() - 1;
            int inCharClass = 0;
            int inParen = 0;
            int ix = 0;
            while (len > ix++) {
                char c = s.charAt(ix);
                if ('\\' == c) {
                    ++ix;
                    continue;
                }
                if ('[' == c) {
                    ++inCharClass;
                    continue;
                }
                if (']' == c && 0 < inCharClass) {
                    --inCharClass;
                    continue;
                }
                if ('(' == c) {
                    ++inParen;
                    continue;
                }
                if (')' == c) {
                    if (0 >= inParen && 0 >= inCharClass) {
                        return null;
                    }
                    --inParen;
                    continue;
                }
                if ('/' != c) continue;
                return s.substring(0, ix + 1);
            }
        }
        return null;
    }

    public boolean find(Object s) {
        if (s instanceof CharSequence) {
            this.matcher = this.pattern.matcher((CharSequence)s);
            return this.matcher.find();
        }
        return false;
    }

    public String group(int i) {
        assert (this.matcher.groupCount() >= i);
        return this.matcher.group(i);
    }

    public String toString() {
        return null == this.matcher ? this.pattern.toString() : this.matcher.toString();
    }
}

