/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileTime;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plus.BiIO;

public class NanoTools {
    private static final int LIST_CAPACITY = 2048;
    private static final int MOD_CAPACITY = 341;
    private final Thread myThread = Thread.currentThread();
    private final ExecutorService pool = Executors.newWorkStealingPool();
    private final List<Path> arr = new ArrayList<Path>(2048);
    private final List<Path> drop = new ArrayList<Path>(2048);
    private final Map<Path, FileTime> mod = new HashMap<Path, FileTime>(341);
    private long start;
    private Analysis ana;
    private AnalysisOut jal;
    private AsyncCtrl async = new AsyncCtrl();
    private boolean isRemove;
    private int DISPLAY_WIDTH = 35;
    private int MAX_PATH = 260;
    private static final String DISPLAY_WIDTH_KEY = "DISPLAY_WIDTH";
    private static final String MAX_PATH_KEY = "MAX_PATH";
    private static final int STATUS_ERROR = 3;
    private static final int STATUS_WARNING = 2;
    private static final int STATUS_FILE = 1;
    private static final int STATUS_INFORMATION = 1;
    private static final int STATUS_NORMAL = 0;
    private static final int CHK_ROOT = 1;
    private static final int CHK_DIRECTORY = 2;
    private static final int CHK_FILE = 4;
    private static final String RE_QUOTE = "'";
    private static final String RE_ESCAPE_01 = "\\'";
    private static final String RE_ESCAPE_02 = "''";
    private static final String BOM_QUOTE_BE = "\ufeff";
    private static final Pattern RE_DIRECT = Pattern.compile("([12]?)(>{1,2})\\s*('?)(.+)(\\3)");
    private static final Pattern RE_FILE = Pattern.compile("(.+[.]\\S+)");
    private Redirect __STDOUT;
    private Redirect __STDERR;
    private static final Redirect defaultOUT = new Redirect(false, "", "", "/dev/stdout", false);
    private static final Redirect defaultERR = new Redirect(false, "", "", "/dev/stderr", true);
    private final Map<String, Object> optAll = new TreeMap<String, Object>();
    private final Set<String> optIn = new TreeSet<String>();
    private final Set<String> optARGV = new HashSet<String>(32);
    private static final String CLEAN = "clean";
    private static final String COMMA = ",";
    private static final String FILE = "file";
    private static final String MX_260 = "260";
    private static final String MX_no260 = "no260";
    private static final String PATH = "";
    private static final String PRO = "progress";
    private static final String ROOT = "root";
    private static final String SIMPLE = "0";
    private static final String SYNC = "sync";
    private static final String UNIT = "k";
    private static final String noRECURSIVE = "noRecursive";
    private static final String noTIME = "noTime";
    private static final Pattern IS_SET = Pattern.compile("(\\w+)=([-+]?\\d+)");
    private static final String SYSTEM = "System Volume Information".toLowerCase();
    private static final String RECYCLE = "$RECYCLE.BIN".toLowerCase();
    private static final boolean THROW_ERROR = true;
    private static final boolean EAT_ERROR = false;
    private static final boolean _STDOUT = true;
    private static final boolean _STDERR = false;
    private static final int ACT_SKIP = -2;
    private static final int ACT_SAME_PATH = -1;
    private static final int ACT_SAME_FILE = 0;
    private static final int ACT_ACCEPT = 1;
    private static final boolean _COPY = true;
    private static final boolean _MOVE = false;
    private static final AsyncAction ACTION_HAS_SKIP = new AsyncAction(-2, null);
    private static final AsyncAction ACTION_HAS_SAME_PATH = new AsyncAction(-1, null);
    private static final long FAT_TIME_ERROR = 2000L;
    private static final String NUMBER_UNIT = "BKMGTPEZY";
    private static final boolean USE_PATH_NAME = true;
    private static final String RESET = "\u001b[m";
    private static final String RED = "\u001b[91m";
    private static final String GREEN = "\u001b[92m";
    private static final String YELLOW = "\u001b[93m";
    private static final String BLUE = "\u001b[94m";
    private static final String MAGENTA = "\u001b[95m";
    private static final String CYAN = "\u001b[96m";

    private void initialize(String input, Object ... x) {
        this.start = System.currentTimeMillis();
        this.ana = new Analysis(input, this.DISPLAY_WIDTH);
        this.jal = null;
        this.async.clear();
        this.isRemove = false;
        Thread.interrupted();
        this.arr.clear();
        this.mod.clear();
        this.drop.clear();
        this.optAll.clear();
        this.optIn.clear();
        this.optARGV.clear();
        for (Object o : x) {
            String[] opts = o.toString().trim().toLowerCase().split("\\s+");
            this.optARGV.addAll(List.of(opts));
        }
        this.optARGV.remove(PATH);
        this.__STDOUT = defaultOUT;
        this.__STDERR = defaultERR;
        this.redirect(x);
    }

    private void close() {
        this.closeImpl(this.__STDOUT);
        this.closeImpl(this.__STDERR);
    }

    private void closeImpl(Redirect re) {
        try {
            BiIO.fflush(re.file);
            if (re.redirect) {
                BiIO.close(re.file);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.exception("close", re.name));
        }
    }

    private AnalysisOut analysisOut(Path input, String output) {
        String src = output.trim();
        Path out = Path.of(src, new String[0]);
        Path in = this.getParent(input);
        Path parent = out;
        boolean createHolder = false;
        if (src.endsWith("/")) {
            if (!Files.exists(out, new LinkOption[0]) && this.createFolder(in, out)) {
                createHolder = true;
            }
        } else if (!Files.isDirectory(out, new LinkOption[0]) && !Files.exists(parent = this.getParent(out), new LinkOption[0]) && this.createFolder(in, parent)) {
            createHolder = true;
        }
        this.setModifiedTime(parent, this.getModifiedTime(in), true);
        this.async = new AsyncCtrl(in, parent);
        return new AnalysisOut(out, createHolder);
    }

    private void finishAsyncModTime(Progress pro, Path output) {
        if (NanoTools.isSystem(output)) {
            return;
        }
        if (Files.isDirectory(output, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(output);){
                for (Path path : ds) {
                    if (!Files.isDirectory(path, new LinkOption[0]) || NanoTools.isSystem(path)) continue;
                    this.finishAsyncModTime(pro, path);
                }
                if (this.removeStartFolder(output)) {
                    pro.decrementFolder();
                } else {
                    FileTime time = this.mod.get(output);
                    if (time != null) {
                        this.setModifiedTime(output, time, true);
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(NanoTools.exception("cleanup", e));
            }
        }
    }

    private void finishMoveDropFile(Path input) {
        for (Path path : this.drop) {
            this.removeSafetyFile(path);
        }
        this.finishMoveCleanFolder(this.getParent(input));
    }

    private void finishMoveCleanFolder(Path input) {
        if (NanoTools.isSystem(input)) {
            return;
        }
        if (Files.isDirectory(input, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                for (Path path : ds) {
                    if (!Files.isDirectory(path, new LinkOption[0]) || NanoTools.isSystem(path)) continue;
                    this.finishMoveCleanFolder(path);
                }
                this.removeSafetyFolder(input);
            }
            catch (IOException e) {
                throw new RuntimeException(NanoTools.exception("moveClean", e));
            }
        }
    }

    private static int checkPath(Path input, int flags) {
        Path path = input.toAbsolutePath();
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean isRoot = path.equals(path.getRoot());
            if (isRoot && (flags & 1) == 0) {
                NanoTools.rootCannotBeSpecified(input);
                return 3;
            }
            return 0;
        }
        if ((flags & 4) != 0) {
            if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                return 1;
            }
            NanoTools.PathDoesNotExist(input);
            return 2;
        }
        NanoTools.PathDoesNotExist(input);
        return 2;
    }

    private void redirect(Object ... x) {
        for (Object o : x) {
            String arg = o.toString().trim();
            int ix1 = arg.indexOf(62);
            if (ix1 < 0) continue;
            int ix2 = arg.indexOf(62, ix1 + 2);
            if (ix2 >= 0) {
                if ((ix2 = arg.lastIndexOf(32, ix2)) >= 0) {
                    this.redirectImpl(arg.substring(0, ix2));
                    this.redirectImpl(arg.substring(ix2 + 1));
                    continue;
                }
                throw new IllegalArgumentException(NanoTools.exception("redirect", arg));
            }
            this.redirectImpl(arg);
        }
    }

    private void redirectImpl(String redirect) {
        String src = redirect.trim().replace(RE_ESCAPE_01, BOM_QUOTE_BE).replace(RE_ESCAPE_02, BOM_QUOTE_BE);
        Matcher m = RE_DIRECT.matcher(src);
        if (m.find()) {
            String rno = NanoTools.getValue(m.group(1));
            String rid = NanoTools.getValue(m.group(2));
            String bracket = NanoTools.getValue(m.group(3));
            String file = NanoTools.getValue(m.group(4)).trim();
            if (bracket.isEmpty()) {
                Matcher mx;
                if (file.contains(RE_QUOTE)) {
                    NanoTools.messageMAGENTA("Redirect, Paired <'> mistake", redirect);
                    file = file.replaceFirst(RE_QUOTE, PATH);
                }
                if ((mx = RE_FILE.matcher(file)).find()) {
                    file = NanoTools.getValue(mx.group(1)).trim();
                } else {
                    int ix = file.indexOf(32);
                    if (ix >= 0) {
                        file = file.substring(0, ix);
                    }
                }
            }
            file = file.replace(BOM_QUOTE_BE, RE_QUOTE);
            String name = rno + rid + file;
            Redirect re = new Redirect(true, name, rid, file, rno.equals("2"));
            if (re.isSTDERR) {
                this.__STDERR = re;
            } else {
                this.__STDOUT = re;
            }
            this.optIn.add(name);
        }
    }

    private boolean applyOption(String name, boolean ... value) {
        boolean val = value.length == 0;
        String key = name.toLowerCase();
        String key2 = key.startsWith("no") ? "-" + key.substring(2) : key;
        for (String x : this.optARGV) {
            if (x.isEmpty() || !key.startsWith(x) && !key2.startsWith(x)) continue;
            this.optIn.add(name);
            this.optAll.put(name, val);
            return val;
        }
        this.optAll.put(name, !val);
        return !val;
    }

    private int applyShellVariable(String name, int value) {
        String key = name.toLowerCase();
        for (String x : this.optARGV) {
            if (x.isEmpty()) continue;
            Matcher m = IS_SET.matcher(x);
            while (m.find()) {
                String g1 = NanoTools.getValue(m.group(1));
                if (!key.startsWith(g1)) continue;
                String g2 = NanoTools.getValue(m.group(2));
                int val = Integer.parseInt(g2);
                String var = name + "=" + g2;
                this.optIn.add(BLUE + var + RESET);
                return val;
            }
        }
        this.optIn.add(name + "=" + value);
        return value;
    }

    private boolean getBooOption(String key) {
        Object o;
        if (this.optAll.containsKey(key) && (o = this.optAll.get(key)) instanceof Boolean) {
            Boolean e = (Boolean)o;
            return e;
        }
        throw new RuntimeException(NanoTools.exception("No option", key));
    }

    private void resetOptions(String ... x) {
        for (String key : x) {
            if (!this.optAll.containsKey(key)) {
                throw new RuntimeException(NanoTools.exception("No option", key));
            }
            this.optAll.put(key, false);
            this.optIn.remove(key);
        }
    }

    private String listOptions() {
        StringBuilder sb = new StringBuilder(64);
        sb.append(BLUE);
        for (String x : this.optIn) {
            sb.append(' ').append(x);
        }
        return sb.append(RESET).toString();
    }

    private static String getFileName(Path path) {
        Path name = path.getFileName();
        return name == null ? PATH : name.toString();
    }

    private Path getParent(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            return path;
        }
        Path pa = path.getParent();
        if (pa == null) {
            pa = path.toAbsolutePath().normalize().getParent();
        }
        if (pa == null) {
            throw new RuntimeException(this.exception("getParent", path));
        }
        return pa;
    }

    private static boolean isSystem(Path path) {
        String str = path.toString().toLowerCase();
        return str.contains(SYSTEM) || str.contains(RECYCLE);
    }

    private boolean isMatch(Path path) {
        if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
            if (this.ana.alwaysTrue) {
                return true;
            }
            String name = NanoTools.getFileName(path);
            return this.ana.regex.matcher(name).matches();
        }
        return false;
    }

    private boolean removeStartFolder(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean started = this.getModifiedTime(path).toMillis() >= this.start;
            return started && this.removeSafetyFolder(path);
        }
        return false;
    }

    private boolean removeNoTime0Folder(Path path) {
        if (Files.isDirectory(path, new LinkOption[0])) {
            boolean time0 = this.getModifiedTime(path).toMillis() != 0L;
            return time0 && this.removeSafetyFolder(path);
        }
        return false;
    }

    private boolean removeSafetyFolder(Path path) {
        return this.isRemove && !NanoTools.isSystem(path) && Files.isDirectory(path, new LinkOption[0]) && path.toFile().delete();
    }

    private boolean removeSafetyFile(Path path) {
        try {
            return this.isRemove && !NanoTools.isSystem(path) && Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]) && Files.deleteIfExists(path);
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.exception("removeSafetyFile", e));
        }
    }

    private long getFileSize(Path path) {
        try {
            return Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0]) ? Files.size(path) : 0L;
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.exception("getFileSize", e));
        }
    }

    private FileTime getModifiedTime(Path path) {
        try {
            if (Files.exists(path, new LinkOption[0])) {
                return Files.getLastModifiedTime(path, new LinkOption[0]);
            }
            return FileTime.fromMillis(0L);
        }
        catch (IOException e) {
            throw new RuntimeException(NanoTools.exception("getModifiedTime", e));
        }
    }

    private void setModifiedTime(Path path, FileTime time, boolean error) {
        block4: {
            try {
                if (Files.exists(path, new LinkOption[0])) {
                    FileTime curTime = this.getModifiedTime(path);
                    if (curTime.equals(time)) {
                        return;
                    }
                    Files.setLastModifiedTime(path, time);
                }
            }
            catch (Exception e) {
                if (!error) break block4;
                NanoTools.messageRED("setModifiedTime(ro.)", path);
                throw new RuntimeException(NanoTools.exception("setModifiedTime", e));
            }
        }
    }

    private boolean createFolder(Path input, Path output) {
        try {
            FileTime time = this.getModifiedTime(input);
            this.mod.put(output, time);
            if (!Files.exists(output, new LinkOption[0])) {
                Files.createDirectories(output, new FileAttribute[0]);
                if (time.toMillis() == 0L) {
                    this.setModifiedTime(output, time, true);
                }
                return true;
            }
        }
        catch (IOException e) {
            NanoTools.messageRED("Make directory", output);
            throw new RuntimeException(e);
        }
        return false;
    }

    private void printX(boolean stdout, String x) {
        Redirect re = stdout ? this.__STDOUT : this.__STDERR;
        BiIO.print(re.rid, re.file, x);
    }

    private void printX(boolean stdout, Path path, boolean ... type) {
        Redirect re;
        Redirect redirect = re = stdout ? this.__STDOUT : this.__STDERR;
        if (re.redirect) {
            this.printX(stdout, NanoTools.applySlashSeparator(path, type));
        } else {
            this.printX(stdout, this.pack(path, type));
        }
    }

    private String sprintX(boolean stdout, Path path, boolean ... type) {
        Redirect re;
        Redirect redirect = re = stdout ? this.__STDOUT : this.__STDERR;
        if (re.redirect) {
            return NanoTools.applySlashSeparator(path, type);
        }
        return this.pack(path, type);
    }

    public int set(Object ... x) {
        this.initialize("./", x);
        boolean hasARGV = this.optARGV.size() > 0;
        this.DISPLAY_WIDTH = this.applyShellVariable(DISPLAY_WIDTH_KEY, this.DISPLAY_WIDTH);
        this.MAX_PATH = this.applyShellVariable(MAX_PATH_KEY, this.MAX_PATH);
        String args = hasARGV ? this.listOptions() : PATH;
        NanoTools.messageTitle("set", args);
        if (!hasARGV) {
            for (String k : this.optIn) {
                System.out.println(k);
            }
        }
        this.messageFinish("Number of processed", this.optIn.size(), PATH);
        return 0;
    }

    public int clean(String input, Object ... x) {
        this.initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = true;
        boolean isClean = this.applyOption(CLEAN, new boolean[0]);
        boolean isTime = this.applyOption(noTIME, false);
        String args = this.ana.virtualPath + " " + this.listOptions();
        NanoTools.messageTitle(CLEAN, args);
        Clean cln = new Clean();
        int ri = NanoTools.checkPath(in, 3);
        if (ri <= 1) {
            this.cleanupFolderImpl(in, cln, true, isTime, isClean);
        }
        this.messageFinish("Number of processed", cln.file, cln.folder);
        return 0;
    }

    private long cleanupFolderImpl(Path input, Clean cln, boolean warning, boolean isTime, boolean isClean) {
        if (NanoTools.isSystem(input)) {
            return 0L;
        }
        long modTime = 0L;
        if (Files.isDirectory(input, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                for (Path path : ds) {
                    long time;
                    if (NanoTools.isSystem(path)) continue;
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        time = this.cleanupFolderImpl(path, cln, warning, isTime, isClean);
                    } else {
                        time = this.getModifiedTime(path).toMillis();
                        ++cln.file;
                    }
                    if (modTime >= time) continue;
                    modTime = time;
                }
                if (Files.isDirectory(input, new LinkOption[0])) {
                    long time2 = this.getModifiedTime(input).toMillis();
                    if (isTime && time2 != modTime) {
                        FileTime fileTime = FileTime.fromMillis(modTime);
                        this.setModifiedTime(input, fileTime, false);
                    }
                    if (warning && !isClean && modTime == 0L) {
                        NanoTools.messageMAGENTA("Empty folder", this.pack(input, new boolean[0]));
                    } else if (isClean && this.removeSafetyFolder(input)) {
                        if (warning) {
                            NanoTools.messageMAGENTA("remove", this.pack(input, new boolean[0]));
                        }
                        --cln.folder;
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(NanoTools.exception(CLEAN, e));
            }
            ++cln.folder;
        }
        return modTime;
    }

    public int copy(String input, String output, Object ... x) {
        this.initialize(input, x);
        Path in = this.ana.path;
        this.jal = this.analysisOut(in, output);
        Path out = this.jal.out;
        this.isRemove = true;
        boolean isPro = this.applyOption(PRO, new boolean[0]);
        boolean isSync = this.applyOption(SYNC, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + " " + this.pack(output) + this.listOptions();
        NanoTools.messageTitle("copy", args);
        if (in.equals(out)) {
            NanoTools.inputAndOutputAreSamePath(in);
            return 3;
        }
        int ri = NanoTools.checkPath(in, 7);
        int ro = NanoTools.checkPath(out, 7);
        if ((ri = Math.max(ri, ro)) <= 1) {
            Progress pro = new Progress(false, isPro);
            if (isSync) {
                this.copySync(pro, this.getParent(in), this.getParent(out));
                pro.flush();
                if (pro.printX) {
                    for (Path sync : this.arr) {
                        this.printX(false, sync, new boolean[0]);
                    }
                }
                NanoTools.messageCYAN("Synchronized", pro.fileNumber);
            }
            pro = new Progress(true, isPro);
            if (this.jal.hasCreatedHolder) {
                pro.incrementFolder();
            }
            this.copyImpl(pro, in, out, isRecursive);
            pro.flush();
            if (pro.printX) {
                for (Path copy : this.arr) {
                    this.printX(true, copy, new boolean[0]);
                }
            }
            this.finishAsyncModTime(pro, this.getParent(out));
            this.messageFinish("Number of processed", pro.fileNumber, pro.fileSize);
        }
        this.close();
        return ri;
    }

    private void copyImpl(Progress pro, Path input, Path output, boolean recursive) {
        block14: {
            if (NanoTools.isSystem(input)) {
                return;
            }
            if (Files.isDirectory(input, new LinkOption[0])) {
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                    for (Path path : ds) {
                        if (NanoTools.isSystem(path)) continue;
                        Path newOut = output.resolve(path.getFileName());
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            if (!recursive) continue;
                            if (this.createFolder(path, newOut)) {
                                pro.incrementFolder();
                            }
                            this.copyImpl(pro, path, newOut, recursive);
                            continue;
                        }
                        if (!this.isMatch(path)) continue;
                        this.atomicCopy(pro, path, newOut);
                    }
                    break block14;
                }
                catch (IOException e) {
                    throw new RuntimeException(NanoTools.exception("copy", e));
                }
            }
            if (this.isMatch(input)) {
                this.atomicCopy(pro, input, output);
            }
        }
    }

    private void copySync(Progress pro, Path input, Path output) {
        String name;
        String name2;
        DirectoryStream<Path> ds;
        HashMap<String, Path> map = new HashMap<String, Path>(1024);
        if (NanoTools.isSystem(input) || NanoTools.isSystem(output)) {
            return;
        }
        if (Files.isDirectory(output, new LinkOption[0])) {
            try {
                ds = Files.newDirectoryStream(output);
                try {
                    for (Path path : ds) {
                        if (NanoTools.isSystem(path)) continue;
                        name2 = NanoTools.getFileName(path);
                        map.put(name2, path);
                    }
                }
                finally {
                    if (ds != null) {
                        ds.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(NanoTools.exception(SYNC, e));
            }
        }
        if (Files.exists(output, new LinkOption[0])) {
            name = NanoTools.getFileName(output);
            map.put(name, output);
        }
        if (Files.isDirectory(input, new LinkOption[0])) {
            try {
                ds = Files.newDirectoryStream(input);
                try {
                    for (Path path : ds) {
                        if (NanoTools.isSystem(path)) continue;
                        name2 = NanoTools.getFileName(path);
                        map.remove(name2);
                        if (!Files.isDirectory(path, new LinkOption[0])) continue;
                        Path newOut = output.resolve(path.getFileName());
                        this.copySync(pro, path, newOut);
                    }
                }
                finally {
                    if (ds != null) {
                        ds.close();
                    }
                }
            }
            catch (IOException e) {
                throw new RuntimeException(NanoTools.exception(SYNC, e));
            }
        }
        if (Files.exists(input, new LinkOption[0])) {
            name = NanoTools.getFileName(input);
            map.remove(name);
        }
        map.remove(PATH);
        for (Path path : map.values()) {
            this.copySyncRemove(pro, path);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void copySyncRemove(Progress pro, Path input) {
        if (NanoTools.isSystem(input)) {
            return;
        }
        if (Files.isDirectory(input, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                for (Path path : ds) {
                    if (NanoTools.isSystem(path)) continue;
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        this.copySyncRemove(pro, path);
                        continue;
                    }
                    long size = this.getFileSize(path);
                    if (!this.removeSafetyFile(path)) continue;
                    pro.addFile(path, size);
                }
                if (!this.removeSafetyFolder(input)) return;
                pro.incrementFolder();
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(NanoTools.exception(SYNC, e));
            }
        } else {
            long size = this.getFileSize(input);
            if (!this.removeSafetyFile(input)) return;
            pro.addFile(input, size);
        }
    }

    public int move(String input, String output, Object ... x) {
        this.initialize(input, x);
        Path in = this.ana.path;
        this.jal = this.analysisOut(in, output);
        Path out = this.jal.out;
        this.isRemove = true;
        boolean isPro = this.applyOption(PRO, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + " " + this.pack(output) + this.listOptions();
        NanoTools.messageTitle("move", args);
        if (in.equals(out)) {
            NanoTools.inputAndOutputAreSamePath(in);
            return 3;
        }
        int ri = NanoTools.checkPath(in, 7);
        int ro = NanoTools.checkPath(out, 7);
        if ((ri = Math.max(ri, ro)) <= 1) {
            Progress pro = new Progress(true, isPro);
            if (this.jal.hasCreatedHolder) {
                pro.incrementFolder();
            }
            this.moveImpl(pro, in, out, isRecursive);
            pro.flush();
            if (pro.printX) {
                for (Path move : this.arr) {
                    this.printX(true, move, new boolean[0]);
                }
            }
            this.finishAsyncModTime(pro, this.getParent(out));
            this.finishMoveDropFile(in);
            this.messageFinish("Number of processed", pro.fileNumber, pro.fileSize);
        }
        this.close();
        return ri;
    }

    private void moveImpl(Progress pro, Path input, Path output, boolean recursive) {
        block14: {
            if (NanoTools.isSystem(input)) {
                return;
            }
            if (Files.isDirectory(input, new LinkOption[0])) {
                try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                    for (Path path : ds) {
                        if (NanoTools.isSystem(path)) continue;
                        Path newOut = output.resolve(path.getFileName());
                        if (Files.isDirectory(path, new LinkOption[0])) {
                            if (!recursive) continue;
                            if (this.createFolder(path, newOut)) {
                                pro.incrementFolder();
                            }
                            this.moveImpl(pro, path, newOut, recursive);
                            continue;
                        }
                        if (!this.isMatch(path)) continue;
                        this.atomicMove(pro, path, newOut);
                    }
                    break block14;
                }
                catch (IOException e) {
                    throw new RuntimeException(NanoTools.exception("move", e));
                }
            }
            if (this.isMatch(input)) {
                this.atomicMove(pro, input, output);
            }
        }
    }

    private void atomicCopy(Progress pro, Path input, Path output) {
        AsyncAction act = this.isAtomicSameFile(input, output);
        output = act.path;
        if (output == null || act.action == 0) {
            return;
        }
        this.async.atom.incrementAndGet();
        this.pool.submit(new AsyncIO(pro, true, act.action, input, output));
    }

    private void atomicMove(Progress pro, Path input, Path output) {
        AsyncAction act = this.isAtomicSameFile(input, output);
        output = act.path;
        if (output == null) {
            return;
        }
        if (act.action == 0) {
            this.drop.add(input);
        }
        this.async.atom.incrementAndGet();
        this.pool.submit(new AsyncIO(pro, false, act.action, input, output));
    }

    private AsyncAction isAtomicSameFile(Path input, Path output) {
        if (!Files.exists(input, new LinkOption[0]) || Files.isDirectory(input, new LinkOption[0])) {
            throw new RuntimeException(this.exception("Folders are not allowed", input));
        }
        if (!this.isMatch(input) || NanoTools.isSystem(input)) {
            return ACTION_HAS_SKIP;
        }
        if (Files.isDirectory(output, new LinkOption[0])) {
            output = output.resolve(input.getFileName());
        }
        if (input.equals(output)) {
            NanoTools.inputAndOutputAreSamePath(input);
            return ACTION_HAS_SAME_PATH;
        }
        Path outParent = this.getParent(output);
        if (!Files.exists(outParent, new LinkOption[0])) {
            Path inParent = this.getParent(input);
            this.createFolder(inParent, outParent);
        }
        if (Files.exists(output, new LinkOption[0]) && !Files.isDirectory(output, new LinkOption[0]) && input.getFileName().equals(output.getFileName())) {
            long iSize = this.getFileSize(input);
            long oSize = this.getFileSize(output);
            long iMod = this.getModifiedTime(input).toMillis() / 2000L;
            long oMod = this.getModifiedTime(output).toMillis() / 2000L;
            if (iSize == oSize && iMod == oMod) {
                return new AsyncAction(0, output);
            }
            if (iMod < oMod) {
                return ACTION_HAS_SKIP;
            }
        }
        return new AsyncAction(1, output);
    }

    public int remove(String input, Object ... x) {
        int ri;
        this.initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = true;
        boolean isPro = this.applyOption(PRO, new boolean[0]);
        boolean isRoot = this.applyOption(ROOT, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + this.listOptions();
        NanoTools.messageTitle("remove", args);
        int check = 6;
        if (isRoot) {
            check |= 1;
        }
        if ((ri = NanoTools.checkPath(in, check)) <= 1) {
            Progress pro = new Progress(true, isPro);
            this.removeImpl(pro, in, isRecursive);
            pro.flush();
            if (pro.printX) {
                for (Path remove : this.arr) {
                    if (Files.isDirectory(remove, new LinkOption[0])) continue;
                    this.printX(true, remove, new boolean[0]);
                }
            }
            this.messageFinish("Number of processed", pro.fileNumber, pro.fileSize);
        }
        this.close();
        return ri;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void removeImpl(Progress pro, Path input, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return;
        }
        if (Files.isDirectory(input, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                for (Path path : ds) {
                    if (NanoTools.isSystem(path)) continue;
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        if (!recursive) continue;
                        this.removeImpl(pro, path, recursive);
                        continue;
                    }
                    if (!this.isMatch(path)) continue;
                    long size = this.getFileSize(path);
                    if (!this.removeSafetyFile(path)) continue;
                    pro.addFile(path, size);
                }
                if (!this.removeNoTime0Folder(input)) return;
                pro.incrementFolder();
                return;
            }
            catch (IOException e) {
                throw new RuntimeException(NanoTools.exception("remove", e));
            }
        } else {
            if (!this.isMatch(input)) return;
            long size = this.getFileSize(input);
            if (!this.removeSafetyFile(input)) return;
            pro.addFile(input, size);
        }
    }

    public int tree(String input, Object ... x) {
        this.initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = false;
        boolean isFile = this.applyOption(FILE, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        String args = this.ana.virtualPath + this.listOptions();
        NanoTools.messageTitle("tree", args);
        int ri = NanoTools.checkPath(in, 3);
        if (ri <= 1) {
            int max = this.treeImpl(in, PATH, isFile, isRecursive);
            this.messageFinish(MAX_PATH_KEY, max, " chars");
        }
        this.close();
        return ri;
    }

    private int treeImpl(Path input, String indent, boolean isFile, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return 0;
        }
        int max = 0;
        if (Files.isDirectory(input, new LinkOption[0])) {
            String x;
            TreeSet<Path> tree = new TreeSet<Path>();
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                for (Path path : ds) {
                    if (NanoTools.isSystem(path)) continue;
                    tree.add(path);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(NanoTools.exception("ls", e));
            }
            for (Path path : tree) {
                if (!this.isMatch(path)) continue;
                if (isFile) {
                    x = indent + "| " + this.packTree(path);
                    this.printX(true, x);
                }
                max = Math.max(max, path.toString().length());
            }
            for (Path path : tree) {
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                x = indent + "/" + this.packTree(path);
                this.printX(true, x);
                max = Math.max(max, path.toString().length());
                if (!recursive) continue;
                max = Math.max(max, this.treeImpl(path, indent + " ", isFile, recursive));
            }
        }
        return max;
    }

    public int ls(String input, Object ... x) {
        boolean isAttr;
        this.initialize(input, x);
        Path in = this.ana.path;
        this.isRemove = false;
        boolean isPath = this.applyOption(PATH, new boolean[0]);
        boolean isSimple = this.applyOption(SIMPLE, new boolean[0]);
        boolean isComma = this.applyOption(COMMA, new boolean[0]);
        boolean isUnit = this.applyOption(UNIT, new boolean[0]);
        boolean is260 = this.applyOption(MX_260, new boolean[0]);
        boolean isNo260 = this.applyOption(MX_no260, new boolean[0]);
        boolean isRecursive = this.applyOption(noRECURSIVE, false);
        boolean bl = isAttr = isPath || isSimple || isComma || isUnit;
        if (isPath) {
            this.resetOptions(SIMPLE, COMMA, UNIT);
        }
        String args = this.ana.virtualPath + this.listOptions();
        NanoTools.messageTitle("ls", args);
        int ri = NanoTools.checkPath(in, 3);
        if (ri <= 1) {
            Progress pro = new Progress(true, false);
            this.lsImpl(pro, in, is260, isNo260, isRecursive);
            pro.flush();
            if (pro.printX) {
                for (Path path : this.arr) {
                    String ls = this.lsAttr(path, isAttr);
                    this.printX(true, ls);
                }
            }
            this.messageFinish("Number of processed", pro.fileNumber, PATH);
        }
        this.close();
        return ri;
    }

    private void lsImpl(Progress pro, Path input, boolean is260, boolean isNo260, boolean recursive) {
        if (NanoTools.isSystem(input)) {
            return;
        }
        if (Files.isDirectory(input, new LinkOption[0])) {
            try (DirectoryStream<Path> ds = Files.newDirectoryStream(input);){
                for (Path path : ds) {
                    if (NanoTools.isSystem(path)) continue;
                    if (Files.isDirectory(path, new LinkOption[0])) {
                        if (!recursive) continue;
                        this.lsImpl(pro, path, is260, isNo260, recursive);
                        continue;
                    }
                    this.lsSelect260(pro, path, is260, isNo260);
                }
            }
            catch (IOException e) {
                throw new RuntimeException(NanoTools.exception("ls", e));
            }
        }
    }

    private String lsAttr(Path input, boolean isAttr) {
        StringBuilder sb = new StringBuilder(256);
        if (isAttr) {
            SimpleDateFormat sdf = new SimpleDateFormat("yy/MM/dd HH:mm");
            long time = this.getModifiedTime(input).toMillis();
            String daytime = sdf.format(time);
            String len = this.lsLength(this.getBooOption(PATH) ? (long)input.toString().length() : this.getFileSize(input));
            sb.append(daytime).append('\t');
            sb.append(len).append('\t');
        }
        String path = this.sprintX(true, input, new boolean[0]);
        return sb.append(path).toString();
    }

    private void lsSelect260(Progress pro, Path input, boolean is260, boolean isNo260) {
        if (this.isMatch(input)) {
            if (is260) {
                if (this.isLonger260(input)) {
                    pro.addFile(input);
                }
            } else if (isNo260) {
                if (!this.isLonger260(input)) {
                    pro.addFile(input);
                }
            } else {
                pro.addFile(input);
            }
        }
    }

    private boolean isLonger260(Path input) {
        return input.toString().length() > this.MAX_PATH;
    }

    private String lsLength(long len) {
        if (this.getBooOption(PATH)) {
            return String.format("%, 7d", len);
        }
        if (this.getBooOption(COMMA)) {
            return String.format("%,d", len);
        }
        if (this.getBooOption(UNIT)) {
            return NanoTools.formatSize(len);
        }
        return Long.toString(len);
    }

    private static String formatSize(long length) {
        double len = length;
        for (int i = 0; i < NUMBER_UNIT.length(); ++i) {
            if (len < 1024.0) {
                String unit = Character.toString(NUMBER_UNIT.charAt(i));
                String str = "  " + String.format("%3.1f%s", len, unit);
                return str.substring(str.length() - 6);
            }
            len /= 1024.0;
        }
        return Long.toString((long)len);
    }

    private String packTree(Path input) {
        StringBuilder sb = new StringBuilder(this.DISPLAY_WIDTH + 32);
        sb.append(this.sprintX(true, input, true)).append(' ');
        String path = input.toString();
        String name = NanoTools.getFileName(input);
        String info = name.length() + "/" + path.length();
        String maxPathID = this.isLonger260(input) ? " *" : PATH;
        sb.append((String)(maxPathID.isEmpty() ? info : NanoTools.color(MAGENTA, info + maxPathID)));
        return sb.toString();
    }

    private String pack(Path path, boolean ... type) {
        int last;
        Object str = NanoTools.applySlashSeparator(path, type);
        int n = ((String)str).replaceAll("[^/]+", PATH).length();
        int len = ((String)str).length();
        while (n-- > 2 && len > this.DISPLAY_WIDTH) {
            str = ((String)str).replaceFirst("^[^/]*/[^/]*", PATH);
            len = ((String)str).length();
        }
        int del = len - this.DISPLAY_WIDTH;
        if (del > 0 && (last = ((String)str).lastIndexOf(47)) >= 0) {
            String file = ((String)str).substring(last);
            if (file.length() >= this.DISPLAY_WIDTH) {
                str = file;
            } else {
                int top = Math.max(0, last - del - 1);
                str = ((String)str).substring(0, top) + "\u2026" + file;
            }
        }
        return NanoTools.pack((String)str, this.DISPLAY_WIDTH);
    }

    private String pack(String source) {
        return NanoTools.pack(source, this.DISPLAY_WIDTH);
    }

    private static String pack(String source, int DISPLAY_WIDTH) {
        int len = source.length();
        if (len > DISPLAY_WIDTH) {
            int half = DISPLAY_WIDTH / 2;
            return source.substring(0, half) + "\u2026" + source.substring(len - half + 1);
        }
        return source;
    }

    private static String applySlashSeparator(Path input, boolean ... type) {
        if (type.length != 0) {
            return NanoTools.getFileName(input);
        }
        String path = input.toString();
        return File.separatorChar == '/' ? path : path.replace('\\', '/');
    }

    private static String color(String color, String message) {
        return color + message + RESET;
    }

    private static void messageTitle(String name, Object arg) {
        System.out.println(NanoTools.color(YELLOW, name + " ") + String.valueOf(arg));
    }

    private void messageFinish(String name, Number arg1, Object arg2) {
        Object str2;
        String cyan = NanoTools.color(CYAN, name + ": ");
        String ela = NanoTools.elapsedTime(System.currentTimeMillis() - this.start);
        String str1 = String.format(", %,d", arg1.intValue());
        if (arg2 instanceof AtomicLong) {
            AtomicLong e = (AtomicLong)arg2;
            str2 = " (" + NanoTools.formatSize(e.get()).trim().replace(".0B", "B") + ")";
        } else if (arg2 instanceof Number) {
            Number e = (Number)arg2;
            str2 = String.format(" (%,d)", e.intValue());
        } else {
            str2 = arg2.toString();
        }
        String foo = cyan + ela + str1 + (String)str2;
        NanoTools.messageSync(foo);
    }

    private static String elapsedTime(long millis) {
        Calendar cl = Calendar.getInstance();
        cl.setTimeInMillis(millis);
        cl.set(15, -21600000);
        SimpleDateFormat sdf = new SimpleDateFormat("H:m:s.SSS");
        return sdf.format(cl.getTime());
    }

    private static synchronized void messageSync(Object arg) {
        System.err.println(arg);
    }

    private static void messageCYAN(String name, Object arg) {
        String str;
        if (arg instanceof Number) {
            Number e = (Number)arg;
            str = String.format("%,d", e.intValue());
        } else {
            str = arg.toString();
        }
        NanoTools.messageSync(NanoTools.color(CYAN, name + ": ") + str);
    }

    private static void messageGREEN(String name, Object arg) {
        NanoTools.messageSync(NanoTools.color(GREEN, name + ": ") + String.valueOf(arg));
    }

    private static void messageBLUE(String name, Object arg) {
        NanoTools.messageSync(NanoTools.color(BLUE, name + ": ") + String.valueOf(arg));
    }

    private static void messageMAGENTA(String name, Object arg) {
        NanoTools.messageSync(NanoTools.color(MAGENTA, name + ": ") + String.valueOf(arg));
    }

    private static void messageRED(String name, Object arg) {
        NanoTools.messageSync(NanoTools.color(RED, name + ": ") + String.valueOf(arg));
    }

    private static String exception(String name, String str) {
        return NanoTools.color(RED, name + ": ") + str;
    }

    private String exception(String name, Path path) {
        return NanoTools.color(RED, name + ": ") + this.pack(path, new boolean[0]);
    }

    private static String exception(String name, Throwable e) {
        return NanoTools.color(RED, name + ": ") + String.valueOf(e);
    }

    private static void rootCannotBeSpecified(Path path) {
        NanoTools.messageRED("Root folder cannot be specified", NanoTools.applySlashSeparator(path, new boolean[0]));
    }

    private static void inputAndOutputAreSamePath(Path path) {
        NanoTools.messageRED("Input and  are the same ", NanoTools.applySlashSeparator(path, new boolean[0]));
    }

    private static void PathDoesNotExist(Path path) {
        NanoTools.messageMAGENTA("Path does not exist", NanoTools.applySlashSeparator(path, new boolean[0]));
    }

    private static String getValue(String x) {
        return x == null ? PATH : x;
    }

    private static class AsyncCtrl {
        private final String fs1;
        private final String fs2;
        private final boolean ATOMIC_MOVE;
        private final AtomicInteger atom = new AtomicInteger();
        private final AtomicInteger error = new AtomicInteger();
        private volatile boolean submitCompleted;
        private static final Pattern EXTRACT_UNC_PATH = Pattern.compile("^(.:|//[^/]+/[^/]+/)");

        AsyncCtrl(Path input, Path output) {
            this.fs1 = this.getFileStoreInfo(input);
            this.fs2 = this.getFileStoreInfo(output);
            this.ATOMIC_MOVE = this.fs1.equalsIgnoreCase(this.fs2);
        }

        AsyncCtrl() {
            this.fs2 = null;
            this.fs1 = null;
            this.ATOMIC_MOVE = false;
        }

        private void clear() {
            this.atom.set(0);
            this.error.set(0);
            this.submitCompleted = false;
        }

        private void debug() {
            System.err.println(this);
        }

        public String toString() {
            return NanoTools.color(NanoTools.MAGENTA, "FileStore.1: ") + this.fs1 + "\n" + NanoTools.color(NanoTools.MAGENTA, "FileStore.2: ") + this.fs2;
        }

        private String getFileStoreInfo(Path path) {
            try {
                StringBuilder sb = new StringBuilder(64);
                Path abs = path.toAbsolutePath().normalize();
                String str = abs.toString().replace('\\', '/');
                Matcher m = EXTRACT_UNC_PATH.matcher(str + "/");
                if (m.find()) {
                    sb.append(NanoTools.getValue(m.group(1))).append(NanoTools.COMMA);
                }
                FileStore fs = Files.getFileStore(abs);
                sb.append(fs.name()).append(',');
                sb.append(fs.type());
                return sb.toString();
            }
            catch (IOException e) {
                throw new RuntimeException(NanoTools.exception("getFileStoreInfo", e));
            }
        }
    }

    private static class Analysis {
        private static final Pattern IS_PATH_HAS_FILE_UNIX = Pattern.compile("(.*/)*([^/]*)$");
        private static final Pattern IS_PATH_HAS_FILE_WIN = Pattern.compile("(.*[/\\\\])*([^/\\\\]*)$");
        private static final Pattern SPLIT_PATH = File.separatorChar == '/' ? IS_PATH_HAS_FILE_UNIX : IS_PATH_HAS_FILE_WIN;
        private static final Pattern WILD_CARD_ALL = Pattern.compile(".*");
        private final String virtualPath;
        private final Path path;
        private final Pattern regex;
        private final boolean alwaysTrue;

        private Analysis(String input, int DISPLAY_WIDTH) {
            String g2;
            String path = input.trim();
            String wild = NanoTools.PATH;
            Pattern regex = WILD_CARD_ALL;
            Matcher m = SPLIT_PATH.matcher(path);
            if (m.matches() && Analysis.hasWildcard(g2 = NanoTools.getValue(m.group(2).trim()))) {
                path = NanoTools.getValue(m.group(1)).trim();
                wild = g2;
                regex = Analysis.mkWildcard(g2);
            }
            if (path.isEmpty()) {
                path = "./";
            }
            this.path = Path.of(path, new String[0]);
            this.virtualPath = NanoTools.pack(path, DISPLAY_WIDTH) + (wild.isEmpty() ? NanoTools.PATH : NanoTools.color(NanoTools.BLUE, wild));
            this.regex = regex;
            this.alwaysTrue = WILD_CARD_ALL.equals(regex);
        }

        private static boolean hasWildcard(String wild) {
            for (int i = 0; i < wild.length(); ++i) {
                char c = wild.charAt(i);
                if (0 > "*?|".indexOf(c)) continue;
                return true;
            }
            return wild.endsWith(".");
        }

        private static Pattern mkWildcard(String wild) {
            StringBuilder sb = new StringBuilder(128);
            if (wild.endsWith(".")) {
                wild = wild.substring(0, wild.length() - 1);
            }
            if (wild.isEmpty()) {
                wild = "*";
            }
            block5: for (int i = 0; i < wild.length(); ++i) {
                char c = wild.charAt(i);
                switch (c) {
                    case '*': {
                        sb.append(".*");
                        continue block5;
                    }
                    case '?': {
                        sb.append('.');
                        continue block5;
                    }
                    case '.': {
                        sb.append("\\.");
                        continue block5;
                    }
                    default: {
                        sb.append(c);
                    }
                }
            }
            return Pattern.compile(sb.toString(), 2);
        }
    }

    private record AnalysisOut(Path out, boolean hasCreatedHolder) {
    }

    private record Redirect(boolean redirect, String name, String rid, String file, boolean isSTDERR) {
    }

    private class Progress {
        private final boolean enable;
        private final PrintStream printStream;
        private final boolean printX;
        private final AtomicInteger folderNumber = new AtomicInteger();
        private final AtomicInteger fileNumber = new AtomicInteger();
        private final AtomicLong fileSize = new AtomicLong();
        private static final Path EMPTY_PATH = Path.of("/", new String[0]);
        private volatile Path path = EMPTY_PATH;
        private volatile boolean hasPrinted;
        private final AtomicInteger noBlockingPrint = new AtomicInteger();
        private static final long PRINT_ELAPSED = 200L;
        private volatile long elapsedTime;

        private Progress(boolean stdout, boolean enable) {
            Redirect re;
            this.printStream = stdout ? System.out : System.err;
            this.enable = enable;
            Redirect redirect = re = stdout ? NanoTools.this.__STDOUT : NanoTools.this.__STDERR;
            this.printX = re.redirect ? true : !enable;
            NanoTools.this.arr.clear();
        }

        private void flush() {
            NanoTools.this.async.submitCompleted = true;
            this.waitForInterrupt();
            if (this.enable) {
                if (this.path != EMPTY_PATH) {
                    this.elapsedTime = 0L;
                    this.print(this.path);
                }
                if (this.hasPrinted) {
                    this.printStream.println();
                }
                this.hasPrinted = false;
            }
            if (NanoTools.this.arr.size() > 1) {
                NanoTools.this.arr.sort(null);
            }
        }

        private synchronized void waitForInterrupt() {
            while (NanoTools.this.async.atom.get() > 0) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
            }
        }

        private void print(Path path) {
            if (this.enable) {
                long now;
                if (this.noBlockingPrint.getAndIncrement() <= 0 && (now = System.currentTimeMillis()) - this.elapsedTime > 200L) {
                    this.printStream.print(this.mkPrintData(path));
                    this.hasPrinted = true;
                    this.elapsedTime = System.currentTimeMillis();
                }
                this.noBlockingPrint.decrementAndGet();
            }
        }

        private void debugPrint(String name, Object arg) {
            if (this.noBlockingPrint.getAndIncrement() <= 0) {
                String msg = "\u001b[1A" + NanoTools.color(NanoTools.MAGENTA, name) + " " + String.valueOf(arg) + " \n";
                this.printStream.print(msg);
            }
            this.noBlockingPrint.decrementAndGet();
        }

        private void incrementFolder() {
            this.folderNumber.incrementAndGet();
        }

        private void decrementFolder() {
            this.folderNumber.decrementAndGet();
        }

        private void addFile(Path path) {
            this.addFile(path, NanoTools.this.getFileSize(path));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addFile(Path path, long size) {
            this.fileNumber.incrementAndGet();
            this.fileSize.addAndGet(size);
            Progress progress = this;
            synchronized (progress) {
                this.path = path;
                if (this.printX) {
                    NanoTools.this.arr.add(path);
                }
            }
            this.print(path);
        }

        private String mkPrintData(Path path) {
            String elapsed = NanoTools.elapsedTime(System.currentTimeMillis() - NanoTools.this.start);
            String progress = String.format("%s %,d(%,d): ", elapsed, this.fileNumber.get(), this.folderNumber.get());
            return NanoTools.color(NanoTools.BLUE, progress) + NanoTools.this.pack(path, new boolean[0]) + "\u001b[K\r";
        }
    }

    private static class Clean {
        private int folder;
        private int file;

        private Clean() {
        }
    }

    private record AsyncAction(int action, Path path) {
    }

    private class AsyncIO
    implements Runnable {
        private static final long ERROR_SLEEP_TIME = 1000L;
        private static final int RETRY = 7;
        private final Progress pro;
        private final boolean copy;
        private final int action;
        private final Path input;
        private final Path output;
        private final String name;

        private AsyncIO(Progress pro, boolean copy, int action, Path input, Path output) {
            this.pro = pro;
            this.copy = copy;
            this.action = action;
            this.input = input;
            this.output = output;
            this.name = copy ? "copy" : "move";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this.task();
            if (NanoTools.this.async.atom.decrementAndGet() <= 0 && NanoTools.this.async.submitCompleted && NanoTools.this.async.atom.get() <= 0) {
                AsyncIO asyncIO = this;
                synchronized (asyncIO) {
                    NanoTools.this.myThread.interrupt();
                }
            }
        }

        private void task() {
            IOException ex = null;
            this.pro.addFile(this.output, NanoTools.this.getFileSize(this.input));
            for (int i = 0; i < 7; ++i) {
                try {
                    if (this.action != 0) {
                        Files.deleteIfExists(this.output);
                        if (this.copy) {
                            Files.copy(this.input, this.output, StandardCopyOption.COPY_ATTRIBUTES, StandardCopyOption.REPLACE_EXISTING);
                        } else if (NanoTools.this.async.ATOMIC_MOVE) {
                            Files.move(this.input, this.output, StandardCopyOption.ATOMIC_MOVE);
                        } else {
                            Files.move(this.input, this.output, new CopyOption[0]);
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    ex = e;
                    int err = NanoTools.this.async.error.incrementAndGet();
                    NanoTools.messageMAGENTA(this.name + "(" + err + ")", this.input);
                    NanoTools.messageMAGENTA(this.name, ex);
                    AsyncIO.sleep();
                    continue;
                }
            }
            NanoTools.messageRED(this.name, ex);
            ex.printStackTrace();
            throw new RuntimeException(ex);
        }

        private static synchronized void sleep() {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

