/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import javax.net.ssl.HttpsURLConnection;
import plus.io.IoConstants;
import plus.io.NullInputStream;
import plus.io.NullOutputStream;
import plus.io.StreamWriter;
import plus.io.TextReader;

public final class Device {
    private static final String PREFIX_HTTP_URL = "http:";
    private static final String PREFIX_HTTPS_URL = "https:";

    private Device() {
    }

    static String getCharset(String name, char ... mode) {
        String charset;
        String string = charset = name.contains("://") && 0 <= name.indexOf(35) ? name.replaceFirst("^.*#", "") : "";
        if (charset.isEmpty()) {
            if (0 < mode.length) {
                return IoConstants.CHARSET_DEFAULT_NAME;
            }
            return IoConstants.CHARSET_UTF8_NAME;
        }
        return charset;
    }

    static String getPath(String name) {
        return name.contains("://") ? name.replaceAll("^(file:///)|(#[-\\w]+)$", "") : name;
    }

    public static Reader openInput(String name) throws IOException {
        if ("/dev/stdin".equals(name) || "-".equals(name)) {
            return new TextReader(System.in);
        }
        if ("/dev/null".equals(name)) {
            return new TextReader(NullInputStream.THIS);
        }
        if (name.startsWith(PREFIX_HTTP_URL)) {
            URL url = new URL(name);
            HttpURLConnection conn = (HttpURLConnection)url.openConnection();
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                System.err.println("HTTP responseCode: " + responseCode);
            }
            InputStream in = conn.getInputStream();
            return new InputStreamReader(in, Device.getCharset(name, new char[0]));
        }
        if (name.startsWith(PREFIX_HTTPS_URL)) {
            URL url = new URL(name);
            HttpsURLConnection conn = (HttpsURLConnection)url.openConnection();
            conn.connect();
            int responseCode = conn.getResponseCode();
            if (responseCode != 200) {
                System.err.println("HTTPS responseCode: " + responseCode);
            }
            InputStream in = conn.getInputStream();
            return new InputStreamReader(in, Device.getCharset(name, new char[0]));
        }
        Path path = Path.of(Device.getPath(name), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            throw new FileNotFoundException("'" + String.valueOf(path) + "'");
        }
        InputStream in = Files.newInputStream(path, new OpenOption[0]);
        return new InputStreamReader(in, Device.getCharset(name, 'r'));
    }

    public static Writer openOutput(String rid, String name) throws IOException {
        if ("/dev/stdout".equals(name) || "-".equals(name)) {
            return new StreamWriter(System.out);
        }
        if ("/dev/stderr".equals(name)) {
            return new StreamWriter(System.err);
        }
        if ("/dev/null".equals(name)) {
            return new StreamWriter(NullOutputStream.THIS);
        }
        String path = Device.getPath(name);
        OutputStream out = Device.openOutputStreamImpl(rid, path);
        return new StreamWriter(out, Device.getCharset(name, 'w'));
    }

    private static OutputStream openOutputStreamImpl(String rid, String name) throws IOException {
        Path path = Path.of(name, new String[0]);
        Path dir = path.getParent();
        if (null != dir && !Files.exists(dir, new LinkOption[0])) {
            Files.createDirectories(dir, new FileAttribute[0]);
        }
        if (">".equals(rid)) {
            return Files.newOutputStream(path, new OpenOption[0]);
        }
        return Files.newOutputStream(path, StandardOpenOption.CREATE, StandardOpenOption.APPEND);
    }
}

