/*
 * Copyright (C) 2009 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package plus.run

import groovy.transform.CompileStatic
import plus.BiIO
import plus.exception.ExitException
import plus.exception.NextException
import plus.runtime.BuiltInVar

/**
 * AWK~plus - Runtime routine.
 *
 * @author kunio himei.
 */
@SuppressWarnings("unused")
@CompileStatic
abstract class RunTime extends Accessor {
    // ------------------------------------------------------------------------
    // Abstracts.
    // ------------------------------------------------------------------------
    abstract void BEGIN()

    abstract void MAIN()

    abstract void END()

    private static final Integer C_INTEGER1 = 1

    void _run(String[] args, Object owner, boolean hasMain) {
        _newArgs(args, owner)
        int exitCode = 0
        try {
            try {
                BEGIN()
                if (hasMain) { // MAIN{} 呼び出しの有無
                    Object file = (0 == ARGIND) ? nextfile() : FILENAME
                    while (exists(file)) { // パラメータの終端まで
                        BuiltInVar.FNR.put(0) // FNRをリセット
                        while (null != getline('', file, 0)) {
                            // NOTE 'The AWK 2-5 getline関数'参照.
                            BuiltInVar.NR.calculate("+", C_INTEGER1) // 入力したレコード数の合計
                            BuiltInVar.FNR.calculate("+", C_INTEGER1) // 現在のファイルから入力したレコード数
                            try {
                                MAIN()
                            } catch (NextException ignored) {
                                file = FILENAME
                            }
                        }
                        file = nextfile()
                    }
                }
            } catch (ExitException e) {
                exitCode = e.value()
            }
            END()
        } catch (ExitException e) {
            exitCode = e.value()
        } finally {
            close()
        }
        if (0 != exitCode) System.exit(exitCode)
    }
}