/** AWK~plus - Property.
 */
# @TypeChecked
BEGIN {
    test
    print '.'
}
function test() {
    delete T
    val A = 123
    print "   .'is'(instanceof)"
    assertTrue("a" is String, '"a" is String')
    assertTrue(123 is Number, '123 is Number')
    assertTrue(A is Number, 'A is Number')

    print "   .'as'(groovy forced cast)"
    # 強制型変換: 静的型付け＋ダイナミック言語機能が必要なため、インタプリタでは未サポート.
    var B = 456
    print "\t", B, "\t'before'", B.getClass()
    B = B as Double
    print "\t", B, "\t'after'", B.getClass()
    B = new AtomicNumber(B)
    print "\t", B, "\t'before'", B.getClass()
    B = B as String
    print "\t", B, "\t'after'", B.getClass(), (.length() in B)

    print "   .'in'(duck typing)"
    # もしもそれがアヒルのように歩き、アヒルのように鳴くのなら、それはアヒルに違いない.
    print "\t.If it walks like a duck and quacks like a duck, it must be a duck."
    assertTrue(.length() in "duck")
    assertTrue(.length in "type")
    assertTrue(!(.length() in A))
    assertTrue(.size in T)

    print "   .property"
    # インタプリタでは、空の()は、省略して、プロパティに見せかけることができます.
    # コンパイラは、変数属性を理解しないため、省略しないのが無難です.
    print "\t.The interpreter can omit the empty () and pretend to be a property."
    print "\t.The compiler doesn't understand variable attributes, so it's safe to omit them."
    val C = "a"
    assertEquals(3.141592653589793, Math.PI)
    assertEquals(123, A.intValue())
    assertEquals(1, "b".length)
    assertEquals(1, C.length(), "C.length()")
}