/*
 * Decompiled with CFR 0.152.
 */
package plus.spawn.system;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.regex.Pattern;
import plus.spawn.Cat;
import plus.spawn.Echo;
import plus.spawn.Exec;
import plus.spawn.SimpleDate;
import plus.spawn.Sort;

public final class Util {
    private static final Pattern RX_COMMAND = Pattern.compile("(^.*[/\\\\])|(\\.exe$)");

    private Util() {
    }

    public static Writer spawn(List<List<String>> pipeline, Writer output) throws IOException {
        Writer out = output;
        int i = pipeline.size();
        while (0 <= --i) {
            List<String> cmd = pipeline.get(i);
            String name = RX_COMMAND.matcher(cmd.get(0)).replaceAll("");
            List<String> cmdArgs = cmd.subList(1, cmd.size());
            String[] args = cmdArgs.toArray(new String[0]);
            if ("cat".equals(name)) {
                out = new Cat(args, out);
                continue;
            }
            if ("date".equals(name)) {
                out = new SimpleDate(args, out);
                continue;
            }
            if ("echo".equals(name)) {
                out = new Echo(args, out);
                continue;
            }
            if ("sort".equals(name)) {
                out = new Sort(args, out);
                continue;
            }
            out = Exec.getWriter(cmd, out);
        }
        return out;
    }
}

