/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Writer;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;

public class StreamWriter
extends Writer {
    private final String charsetName;
    private final OutputStream out;

    StreamWriter(OutputStream out) {
        this(out, Charset.defaultCharset().name());
    }

    StreamWriter(OutputStream out, String charsetName) {
        this.charsetName = charsetName;
        this.out = out;
    }

    StreamWriter(PrintStream out) {
        this.charsetName = null;
        this.out = out;
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void write(@NotNull char[] buf, int off, int len) throws IOException {
        if (buf == null) {
            StreamWriter.$$$reportNull$$$0(0);
        }
        this.write(String.valueOf(buf, off, len));
    }

    @Override
    public void write(@NotNull String str) throws IOException {
        OutputStream outputStream;
        if (str == null) {
            StreamWriter.$$$reportNull$$$0(1);
        }
        if ((outputStream = this.out) instanceof PrintStream) {
            PrintStream ps = (PrintStream)outputStream;
            ps.print(str);
        } else {
            this.out.write(str.getBytes(this.charsetName));
        }
    }

    @Override
    public void write(@NotNull String str, int off, int len) throws IOException {
        if (str == null) {
            StreamWriter.$$$reportNull$$$0(2);
        }
        this.write(str.substring(off, off + len));
    }

    @Override
    public void write(@NotNull char[] buf) throws IOException {
        if (buf == null) {
            StreamWriter.$$$reportNull$$$0(3);
        }
        this.write(new String(buf));
    }

    @Override
    public void write(int c) throws IOException {
        this.write(String.valueOf((char)c));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "buf";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "str";
                break;
            }
        }
        objectArray[1] = "plus/io/StreamWriter";
        objectArray[2] = "write";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

