/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.Closeable;
import java.io.IOException;
import java.net.ServerSocket;
import java.net.SocketAddress;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import plus.io.Connectable;
import plus.io.InetSocket;
import plus.io.ReadWriteable;

final class InetServerSocket
implements Closeable,
Connectable {
    private final ServerSocketChannel channel = ServerSocketChannel.open();
    private final ServerSocket serverSocket = this.channel.socket();
    private final int timeout;

    InetServerSocket(SocketAddress address, int tout) throws IOException {
        this.serverSocket.bind(address);
        this.timeout = tout;
    }

    @Override
    public void close() throws IOException {
        try {
            if (!this.serverSocket.isClosed()) {
                this.serverSocket.close();
            }
        }
        finally {
            if (this.channel.isOpen()) {
                this.channel.close();
            }
        }
    }

    @Override
    public ReadWriteable connect() throws IOException {
        this.serverSocket.setSoTimeout(this.timeout);
        SocketChannel sock = this.serverSocket.accept().getChannel();
        return new InetSocket(sock, this.timeout);
    }
}

