/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.regex.Pattern;
import plus.io.Connectable;
import plus.io.InetDatagramSocket;
import plus.io.InetServerSocket;
import plus.io.InetSocket;

final class InetHelper {
    private static final Object[][] INET_PORTNUMBER = new Object[][]{{"echo", 7}, {"discard", 9}, {"daytime", 13}, {"chargen", 19}, {"http", 80}};
    private static final int MILLISECOND = 1000;
    private static final Pattern RX_INET_SPLIT = Pattern.compile("/");
    private static final Pattern RX_NUMBER = Pattern.compile("^[0-9.]+$");
    private static final Pattern RX_PORT_NUMBER = Pattern.compile("^[0-9]+$");

    private InetHelper() {
    }

    private static InetSocketAddress getAddress(String host, int localPort, int remotePort) throws UnknownHostException {
        boolean hasHost;
        boolean bl = hasHost = !host.isEmpty() && !"0".equals(host);
        if (0 == localPort) {
            if (hasHost) {
                return new InetSocketAddress(host, remotePort);
            }
            return new InetSocketAddress(InetAddress.getLocalHost(), remotePort);
        }
        if (hasHost) {
            return new InetSocketAddress(host, localPort);
        }
        return new InetSocketAddress(localPort);
    }

    private static int getPort(String port) {
        if (RX_PORT_NUMBER.matcher(port).matches()) {
            return Integer.parseInt(port);
        }
        for (Object[] o : INET_PORTNUMBER) {
            if (!port.equalsIgnoreCase((String)o[0])) continue;
            return (Integer)o[1];
        }
        return 0;
    }

    static Connectable open(String inet) throws IOException {
        if (null != inet) {
            int p;
            String[] parts = RX_INET_SPLIT.split(inet);
            int n = p = parts[1].startsWith("inet") ? 2 : 4;
            if (p + 3 < parts.length) {
                String protocol = parts[p++];
                int localPort = InetHelper.getPort(parts[p++]);
                String host = parts[p++];
                int remotePort = InetHelper.getPort(parts[p++]);
                int timeout = (int)(p < parts.length && RX_NUMBER.matcher(parts[p]).matches() ? Double.parseDouble(parts[p]) * 1000.0 : 0.0);
                InetSocketAddress addr = InetHelper.getAddress(host, localPort, remotePort);
                if ("tcp".equals(protocol)) {
                    if (0 == localPort) {
                        Socket soc = new Socket(addr.getAddress(), remotePort);
                        return new InetSocket(soc, timeout);
                    }
                    return new InetServerSocket(addr, timeout);
                }
                if ("udp".equals(protocol)) {
                    if (0 == localPort) {
                        return new InetDatagramSocket(addr, timeout);
                    }
                    return new InetDatagramSocket(addr, localPort, timeout);
                }
            }
        }
        throw new FileNotFoundException(inet);
    }
}

