/*
 * Copyright (C) 2009 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.awk4j.bench;

import org.awk4j.bench.target.Strip;
import org.awk4j.bench.target.Trim;

import static org.awk4j.bench.Bench.*;

/**
 * Benchmark Framework 5 - Template.
 *
 * @author kunio himei.
 */
class F05Template {

    // ドライバ - driver
    private static int driver01StripOriginal() {
        long nano = Bench.driver_loop_time;
        int count = 0;
        String rs;
        do {
            long start = System.nanoTime();
            rs = BENCH_UTF.strip();
            nano -= System.nanoTime() - start;
            if (isDriverComplete(++count)) break; // Driver is Complete
        } while (0 < nano);
        assert ANS_BOTH_UTF.equals(rs) : "01[" + rs + "]";
        return count;
    }

    // ドライバ - driver
    private static int driver02Challenger() {
        long nano = Bench.driver_loop_time;
        int count = 0;
        String rs;
        do {
            long start = System.nanoTime();
            rs = Strip.strip02Challenger(BENCH_UTF);
            nano -= System.nanoTime() - start;
            if (isDriverComplete(++count)) break; // Driver is Complete
        } while (0 < nano);
        assert ANS_BOTH_UTF.equals(rs) : "strip 2[" + rs + "]";
        return count;
    }

    // ドライバ - driver
    private static int driver03StripJoin() {
        long nano = Bench.driver_loop_time;
        int count = 0;
        String rs;
        do {
            long start = System.nanoTime();
            rs = Strip.strip03Join(BENCH_UTF);
            nano -= System.nanoTime() - start;
            if (isDriverComplete(++count)) break; // Driver is Complete
        } while (0 < nano);
        assert ANS_BOTH_UTF.equals(rs) : "strip 3[" + rs + "]";
        return count;
    }

    //////////////////////////////////////////////////////////////////////
    private static final StringBuilder sb = new StringBuilder(BENCH_DATA.length());

    // Warmup Target - ウオームアップ ターゲット.
    static void warmupTarget() {
        BENCH_UTF.strip(); // #1 Original
        Strip.strip02Challenger(BENCH_UTF); // #2
        Strip.strip03Join(BENCH_UTF); // #3

        // #4 → #6 削除
        sb.setLength(0);
        sb.append(BENCH_DATA);
        Trim.rTrim07Builder(sb); // #7
    }

    //////////////////////////////////////////////////////////////////////
    // クルー - crew
    @SuppressWarnings("SameParameterValue")
    static void crew(int[] ANSWER) {
        ANSWER[1] = driver01StripOriginal();
        Bench.cool();
        ANSWER[2] = driver02Challenger();
        Bench.cool();
        ANSWER[3] = driver03StripJoin();
        // #4 → #6 削除
        Bench.cool();
        ANSWER[7] = F01Classic.driver07rTrimBuilder();
    }
}