/*
 * Copyright (C) 2009 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package org.awk4j.asm;

import org.awk4j.bench.target.Trim;

import static org.awk4j.bench.Bench.*;

/**
 * Asm Future.
 *
 * @author kunio himei.
 */
@SuppressWarnings("unused")
public class AsmFuture {

    // ラッパー（Wrapper）
    abstract static class Future<T, R> {
        abstract R apply(T t);
    }

    private static class trim03Original<T, R> extends Future<String, String> {
        @Override
        public String apply(String t) {
            return t.trim();
        }
    }

    private static class trim04String<T, R> extends Future<String, String> {
        @Override
        public String apply(String t) {
            return Trim.trim04String(t);
        }
    }

    private static class trim05CharSeq<T, R> extends Future<CharSequence, String> {
        @Override
        public String apply(CharSequence t) {
            return Trim.trim05CharSeq(t);
        }
    }

    private static final trim03Original<String, String> trim03Original = new trim03Original<>();
    private static final trim04String<String, String> trim04String = new trim04String<>();
    private static final trim05CharSeq<CharSequence, String> trim05CharSeq = new trim05CharSeq<>();

    //////////////////////////////////////////////////////////////////////
    // ドライバ - driver (String と CharSequence を受け付ける)
    @SuppressWarnings("SameParameterValue")
    static <T> int driver01Generics(Future<T, String> fnc, String ans) {
        long nano = loop_time;
        int count = 0;
        String rs;
        do {
            long start = System.nanoTime();
            //noinspection unchecked
            rs = fnc.apply((T) BENCH_DATA);
            nano -= System.nanoTime() - start;
            if (isDriverComplete(++count)) break; // Driver is Complete
        } while (0 < nano);
        assert ans.equals(rs) : rs;
        return count;
    }

    //////////////////////////////////////////////////////////////////////
    // クルー - crew
    @SuppressWarnings("SameParameterValue")
    static void crew(int[] ANSWER, long time) {
        loop_time = time;
        ANSWER[2] = driver01Generics(trim03Original, ANS_BOTH);
        ANSWER[3] = driver01Generics(trim04String, ANS_BOTH);
        ANSWER[4] = driver01Generics(trim05CharSeq, ANS_BOTH);
    }

    private static long loop_time; // Main.mainTime or Main.loop (ns)

    /**
     * Genericsを使って望みの型にキャストする.
     * <p>
     * Object x = "x";
     * String  str = as(x);
     *
     * @param <T> キャスト後の型
     * @param o   オブジェクト
     * @return キャスト後のオブジェクト
     */
    @SuppressWarnings("unused")
    static <T> T as(Object o) {
        //noinspection unchecked
        return (T) o;
    }
}