/*
 * Decompiled with CFR 0.152.
 */
package org.awk4j.bench;

import org.awk4j.bench.Bench;

public class Main {
    private static final String USAGE = "benchTrim [-options] 1>JIT.log 2>Result.list\n    -T=<title>\n    -priority=10  1...10\n    -f=1[.1]      Framework: 1 ... 4 [.1: Generics type]\n    -driverTime=500 (ms/driver)\n    -warmup       Disable warmup\n      -prefetch=16000 (times) Warmup Target and Driver\n    -cool=0 (ms)  Cool down\n    -ice=10 (ms)  Forced cooling\n    -msg          Disable message\n    -h or -?      Version 1.0.3";
    static String title = "No title";
    static int priority = 10;
    static float framework = 1.0f;
    static int majorVersion = (int)framework;
    static float minorVersion = framework - (float)majorVersion;
    static int driverTime = 500;
    static boolean msg = true;
    static boolean warmup = true;
    static int prefetch = 16000;
    static int cool = 0;
    static int ice = 10;

    public static void main(String[] args) {
        String arg;
        for (int ix = 0; ix < args.length && '-' == (arg = args[ix]).charAt(0); ++ix) {
            if (arg.equals("-h") || arg.equals("-?")) {
                System.err.println(USAGE);
                return;
            }
            if (arg.startsWith("-f=")) {
                framework = Float.parseFloat(arg.substring(3));
                majorVersion = (int)framework;
                minorVersion = framework - (float)majorVersion;
                continue;
            }
            if (arg.startsWith("-T=")) {
                title = arg.substring(3);
                continue;
            }
            if (arg.startsWith("-priority=")) {
                priority = Integer.parseInt(arg.substring(10));
                continue;
            }
            if (arg.startsWith("-driverTime=")) {
                driverTime = Integer.parseInt(arg.substring(12));
                continue;
            }
            if (arg.startsWith("-prefetch=")) {
                prefetch = Integer.parseInt(arg.substring(10));
                continue;
            }
            if (arg.startsWith("-cool=")) {
                cool = Integer.parseInt(arg.substring(6));
                continue;
            }
            if (arg.startsWith("-ice=")) {
                ice = Integer.parseInt(arg.substring(5));
                continue;
            }
            if (arg.startsWith("-warmup")) {
                warmup = !warmup;
                continue;
            }
            if (arg.startsWith("-msg")) {
                msg = !msg;
                continue;
            }
            throw new IllegalArgumentException(arg);
        }
        Thread th = Thread.currentThread();
        th.setPriority(priority);
        Bench.bench();
    }
}

