/*
 * Copyright (C) 2010 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package plus.reflect;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

/**
 * Cache (Implementation of the Cache).
 * <p>
 * The class to which this annotation is applied is mutable.
 *
 * @author kunio himei.
 */
public enum Cache {

    /**
     * Class Cache.
     */
    CLASS(new ConcurrentHashMap<String, Class<?>>()),

    /**
     * Constructor Cache.
     */
    CONSTRUCTOR(new ConcurrentHashMap<String, Constructor<?>[]>()),

    /**
     * Field Cache.
     */
    FIELD(new ConcurrentHashMap<String, Field>()),

    /**
     * Method Cache.
     */
    METHOD(new ConcurrentHashMap<String, Method[]>()),

    /**
     * RegExp Cache.
     */
    REGEXP(new ConcurrentHashMap<String, Pattern>());

    /**
     * The Cache of this Enumeration.
     */
    private final Map<?, ?> map;

    /**
     *
     */
    Cache(Map<?, ?> cache) {
        this.map = cache;
    }

    /**
     * get Cache a value.
     */
    @SuppressWarnings("unchecked")
    public <T> T get(Object key) { //
        return (null == key) ? null : (T) this.map.get(key);
    }

    /**
     * Cache a value.
     */
    @SuppressWarnings("unchecked")
    public <T> void put(Object key, T value) {
        ((Map<Object, T>) this.map).put(key, value);
    }
}