/*
 * Copyright (C) 2010 awk4j - https://ja.osdn.net/projects/awk4j/
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

package plus.lex;

import java.util.ArrayList;

/**
 * List インタフェースのサイズ変更可能な配列の実装.
 *
 * @author kunio himei.
 */
public final class LexArray<E> extends ArrayList<E> {

    public LexArray() {
        super();
    }

    /**
     * Displays all elements of the Array in a string using start, end, and
     * separator strings.
     */
    public String mkString(String start, String sep, String end) {
        StringBuilder sb = new StringBuilder(start);
        for (Object x : this)
            sb.append(x).append(sep);
        sb.setLength(sb.length() - sep.length());
        return sb.append(end).toString();
    }

    /**
     * Listを Arrayに変換して返す.(Listは、クリアする)
     */
    public String[] moveArray() {
        String[] arr = new String[super.size()];
        for (int i = 0; super.size() > i; ++i)
            arr[i] = (String) get(i);
        super.clear();
        return arr;
    }

    /**
     * Listを返す.(Listは、クリアする)
     */
    public LexArray<E> moveList() {
        LexArray<E> arr = cloneList();
        super.clear();
        return arr;
    }


    /**
     * このリストのクローンを返す.
     */
    @SuppressWarnings("unchecked")
    public LexArray<E> cloneList() {
        return (LexArray<E>) this.clone();
    }
}