/*
 * Decompiled with CFR 0.152.
 */
package plus.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import plus.io.Device;
import plus.io.Io;
import plus.io.IoConstants;

public final class IoHelper {
    private IoHelper() {
    }

    public static void copy(String input, Writer output) throws IOException {
        if (output instanceof PrintWriter || "/dev/stdin".equals(input) || "-".equals(input)) {
            IoHelper.copyline(input, output);
        } else {
            int len;
            char[] buf = new char[4096];
            Reader in = Device.openInput(input);
            while (0 <= (len = in.read(buf))) {
                if (0 >= len) continue;
                output.write(buf, 0, len);
            }
            output.flush();
            Io.close(in);
        }
    }

    public static void copyline(String input, Writer output) throws IOException {
        BufferedReader in = new BufferedReader(Device.openInput(input), 8192);
        String x = in.readLine();
        while (null != x) {
            IoHelper.writeln(output, x, true);
            x = in.readLine();
        }
        Io.close(in);
    }

    public static void writeln(Writer out, CharSequence x) throws IOException {
        IoHelper.writeln(out, x, out instanceof PrintWriter);
    }

    public static void writeln(Writer out, CharSequence x, boolean autoFlush) throws IOException {
        StringBuilder sb = x instanceof StringBuilder ? (StringBuilder)x : new StringBuilder(x);
        out.write(sb.append(IoConstants.PLATFORM_LINE_SEPARATOR).toString());
        if (autoFlush) {
            out.flush();
        }
    }
}

