/*  Jaleco 'Stepping Stage'


******************************************************************************************

	Gemuno@Masatti added :

	Jaleco 'Stepping Stage' Hardware
	(C)Jaleco,1999

	Known games on this hardware include.... (only 4 games)
          Stepping Stage 			(C)Jaleco,1999
          Stepping Stage Special		(C)Jaleco,1999
          Stepping Stage 2 Supreme	(C)Jaleco,1999
          Stepping 3 Superior		(C)Jaleco,1999

	Hardware Info
	CPU        : MC68000 CPU x2 (Video Main CPU and Input handles CPU) and PC Computer CPU (Pentium?) (Unknown)
	Video      : 3 Screens 256?x256? size
	SPU        : Unknown
	Input      : 2 Playersx6 Bottons Foot Switches? , 2? Coin Switches and 1 Service Button
	Dip Switch : 2x8 Ways Normal Dip Switches?
	Roms       : Some Normal Roms and 1 PC Computer Harddisc Drive


******************************************************************************************
 Naibo added :

 A PC computer(Harddisk not dumped yet) + Two 68000 based board set.

 One 68000 drives 3 screens, another handles players input.
******************************************************************************************

 dump is incomplete, these are leftovers from an upgrade
 music roms are missing at least

 is it a 3 screen game (1 horizontal, 2 vertical) ?

 TODO:
 - clearly derived from Tetris Plus 2 HW
 - NVRAM is unchecked

 */

#include "driver.h"

#include "cpu/m68000/m68000.h"
#include "sound/ymz280b.h"
#include "drivers/tetrisp2.c"

READ16_HANDLER( unknown_read_0xc00000 )
{
	return mame_rand();
}

READ16_HANDLER( unknown_read_0xd00000 )
{
	return mame_rand();
}

READ16_HANDLER( unknown_read_0xffff00 )
{
	return mame_rand();
}

static ADDRESS_MAP_START( stepstag_readmem, ADDRESS_SPACE_PROGRAM, 16 )
	AM_RANGE(0x000000, 0x0fffff) AM_READ(MRA16_ROM				)	// ROM
	AM_RANGE(0x100000, 0x103fff) AM_READ(MRA16_RAM				)	// Object RAM
	AM_RANGE(0x104000, 0x107fff) AM_READ(MRA16_RAM				)	// Spare Object RAM
	AM_RANGE(0x108000, 0x10ffff) AM_READ(MRA16_RAM				)	// Work RAM
	AM_RANGE(0x200000, 0x23ffff) AM_READ(tetrisp2_priority_r	)	// Priority
	AM_RANGE(0x300000, 0x31ffff) AM_READ(MRA16_RAM				)	// Palette
	AM_RANGE(0x400000, 0x403fff) AM_READ(MRA16_RAM				)	// Foreground
	AM_RANGE(0x404000, 0x407fff) AM_READ(MRA16_RAM				)	// Background
	AM_RANGE(0x408000, 0x409fff) AM_READ(MRA16_RAM				)	// ???
	AM_RANGE(0x500000, 0x50ffff) AM_READ(MRA16_RAM				)	// Line
	AM_RANGE(0x600000, 0x60ffff) AM_READ(MRA16_RAM				)	// Rotation
	AM_RANGE(0x650000, 0x651fff) AM_READ(MRA16_RAM				)	// Rotation (mirror)
	AM_RANGE(0x800002, 0x800003) AM_READ(tetrisp2_sound_r		)	// Sound
	AM_RANGE(0x900000, 0x903fff) AM_READ(tetrisp2_nvram_r	)	// NVRAM
	AM_RANGE(0x904000, 0x907fff) AM_READ(tetrisp2_nvram_r	)	// NVRAM (mirror)
	AM_RANGE(0xbe0000, 0xbe0001) AM_READ(MRA16_NOP				)	// INT-level1 dummy read
	AM_RANGE(0xbe0002, 0xbe0003) AM_READ(input_port_0_word_r	)	// Inputs
	AM_RANGE(0xbe0004, 0xbe0005) AM_READ(tetrisp2_ip_1_word_r	)	// Inputs & protection
	AM_RANGE(0xbe0008, 0xbe0009) AM_READ(input_port_2_word_r	)	// Inputs
	AM_RANGE(0xbe000a, 0xbe000b) AM_READ(watchdog_reset16_r	)	// Watchdog
ADDRESS_MAP_END

static ADDRESS_MAP_START( stepstag_writemem, ADDRESS_SPACE_PROGRAM, 16 )
	AM_RANGE(0x000000, 0x0fffff) AM_WRITE(MWA16_ROM									)	// ROM
	AM_RANGE(0x100000, 0x103fff) AM_WRITE(MWA16_RAM) AM_BASE(&spriteram16) AM_SIZE(&spriteram_size	)	// Object RAM
	AM_RANGE(0x104000, 0x107fff) AM_WRITE(MWA16_RAM									)	// Spare Object RAM
	AM_RANGE(0x108000, 0x10ffff) AM_WRITE(MWA16_RAM									)	// Work RAM
	AM_RANGE(0x200000, 0x23ffff) AM_WRITE(tetrisp2_priority_w) AM_BASE(&tetrisp2_priority	)	// Priority
	AM_RANGE(0x300000, 0x31ffff) AM_WRITE(tetrisp2_palette_w) AM_BASE(&paletteram16			)	// Palette
	AM_RANGE(0x400000, 0x403fff) AM_WRITE(tetrisp2_vram_fg_w) AM_BASE(&tetrisp2_vram_fg		)	// Foreground
	AM_RANGE(0x404000, 0x407fff) AM_WRITE(tetrisp2_vram_bg_w) AM_BASE(&tetrisp2_vram_bg		)	// Background
	AM_RANGE(0x408000, 0x409fff) AM_WRITE(MWA16_RAM									)	// ???
	AM_RANGE(0x500000, 0x50ffff) AM_WRITE(MWA16_RAM									)	// Line
	AM_RANGE(0x600000, 0x60ffff) AM_WRITE(tetrisp2_vram_rot_w) AM_BASE(&tetrisp2_vram_rot	)	// Rotation
	AM_RANGE(0x650000, 0x651fff) AM_WRITE(tetrisp2_vram_rot_w						)	// Rotation (mirror)
	AM_RANGE(0x800000, 0x800003) AM_WRITE(tetrisp2_sound_w							)	// Sound
	AM_RANGE(0x900000, 0x903fff) AM_WRITE(tetrisp2_nvram_w) AM_BASE(&tetrisp2_nvram) AM_SIZE(&tetrisp2_nvram_size	)	// NVRAM
	AM_RANGE(0x904000, 0x907fff) AM_WRITE(tetrisp2_nvram_w							)	// NVRAM (mirror)
	AM_RANGE(0xb00000, 0xb00001) AM_WRITE(tetrisp2_coincounter_w					)	// Coin Counter
	AM_RANGE(0xb20000, 0xb20001) AM_WRITE(MWA16_NOP									)	// ???
	AM_RANGE(0xb40000, 0xb4000b) AM_WRITE(MWA16_RAM) AM_BASE(&tetrisp2_scroll_fg			)	// Foreground Scrolling
	AM_RANGE(0xb40010, 0xb4001b) AM_WRITE(MWA16_RAM) AM_BASE(&tetrisp2_scroll_bg			)	// Background Scrolling
	AM_RANGE(0xb4003e, 0xb4003f) AM_WRITE(MWA16_NOP									)	// scr_size
	AM_RANGE(0xb60000, 0xb6002f) AM_WRITE(MWA16_RAM) AM_BASE(&tetrisp2_rotregs				)	// Rotation Registers
	AM_RANGE(0xba0000, 0xba001f) AM_WRITE(tetrisp2_systemregs_w						)	// system param
	AM_RANGE(0xba001a, 0xba001b) AM_WRITE(MWA16_NOP									)	// Lev 4 irq ack
	AM_RANGE(0xba001e, 0xba001f) AM_WRITE(MWA16_NOP									)	// Lev 2 irq ack
ADDRESS_MAP_END

READ16_HANDLER( unknown_sub_read_0xbe0004 )
{
	return mame_rand();
}


static ADDRESS_MAP_START( stepstag_sub_readmem, ADDRESS_SPACE_PROGRAM, 16 )
	AM_RANGE(0x000000, 0x0fffff) AM_READ(MRA16_ROM)
	AM_RANGE(0xbe0004, 0xbe0005) AM_READ(unknown_sub_read_0xbe0004)
ADDRESS_MAP_END

static ADDRESS_MAP_START( stepstag_sub_writemem, ADDRESS_SPACE_PROGRAM, 16 )
	AM_RANGE(0x000000, 0x0fffff) AM_WRITE(MWA16_ROM)
ADDRESS_MAP_END

#define TETPLUS2_COMMON\
	PORT_START_TAG("IN0") /*$be0002.w*/ \
	PORT_BIT(  0x0001, IP_ACTIVE_LOW, IPT_JOYSTICK_UP ) PORT_PLAYER(1)\
	PORT_BIT(  0x0002, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN ) PORT_PLAYER(1)\
	PORT_BIT(  0x0004, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT ) PORT_PLAYER(1)\
	PORT_BIT(  0x0008, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT ) PORT_PLAYER(1)\
	PORT_BIT(  0x0010, IP_ACTIVE_LOW, IPT_BUTTON1 ) PORT_PLAYER(1)\
	PORT_BIT(  0x0020, IP_ACTIVE_LOW, IPT_BUTTON2 ) PORT_PLAYER(1)\
	PORT_BIT(  0x0040, IP_ACTIVE_LOW, IPT_BUTTON3 ) PORT_PLAYER(1)\
	PORT_BIT(  0x0080, IP_ACTIVE_LOW, IPT_UNUSED )\
	PORT_BIT(  0x0100, IP_ACTIVE_LOW, IPT_JOYSTICK_UP ) PORT_PLAYER(2)\
	PORT_BIT(  0x0200, IP_ACTIVE_LOW, IPT_JOYSTICK_DOWN ) PORT_PLAYER(2)\
	PORT_BIT(  0x0400, IP_ACTIVE_LOW, IPT_JOYSTICK_LEFT ) PORT_PLAYER(2)\
	PORT_BIT(  0x0800, IP_ACTIVE_LOW, IPT_JOYSTICK_RIGHT ) PORT_PLAYER(2)\
	PORT_BIT(  0x1000, IP_ACTIVE_LOW, IPT_BUTTON1 ) PORT_PLAYER(2)\
	PORT_BIT(  0x2000, IP_ACTIVE_LOW, IPT_BUTTON2 ) PORT_PLAYER(2)\
	PORT_BIT(  0x4000, IP_ACTIVE_LOW, IPT_BUTTON3 ) PORT_PLAYER(2)\
	PORT_BIT(  0x8000, IP_ACTIVE_LOW, IPT_UNUSED )\
	PORT_START_TAG("IN1") /*$be0004.w*/\
	PORT_BIT(  0x0001, IP_ACTIVE_LOW, IPT_UNKNOWN  )\
	PORT_BIT(  0x0002, IP_ACTIVE_LOW, IPT_UNKNOWN  )\
	PORT_BIT(  0x0004, IP_ACTIVE_LOW, IPT_START1   )\
	PORT_BIT(  0x0008, IP_ACTIVE_LOW, IPT_START2   )\
	PORT_BIT(  0x0010, IP_ACTIVE_LOW, IPT_UNKNOWN  )\
	PORT_BIT(  0x0020, IP_ACTIVE_LOW, IPT_SERVICE1 )\
	PORT_BIT(  0x0040, IP_ACTIVE_LOW, IPT_COIN1    )\
	PORT_BIT(  0x0080, IP_ACTIVE_LOW, IPT_COIN2    )\
	PORT_BIT(  0x0100, IP_ACTIVE_LOW, IPT_SPECIAL  )	/* ?*/\
	PORT_BIT(  0x0200, IP_ACTIVE_LOW, IPT_SPECIAL  )	/* ?*/\
	PORT_BIT(  0x0400, IP_ACTIVE_LOW, IPT_UNKNOWN  )\
	PORT_BIT(  0x0800, IP_ACTIVE_LOW, IPT_UNKNOWN  )\
	PORT_BIT(  0x1000, IP_ACTIVE_LOW, IPT_UNKNOWN  )\
	PORT_BIT(  0x2000, IP_ACTIVE_LOW, IPT_UNKNOWN  )\
	PORT_BIT(  0x4000, IP_ACTIVE_LOW, IPT_UNKNOWN  )\
	PORT_BIT(  0x8000, IP_ACTIVE_LOW, IPT_UNKNOWN  )


/* TODO: inputs are copied from Tetris Plus 2, they needs to be changed accordingly */
INPUT_PORTS_START( stepstag )
TETPLUS2_COMMON

	PORT_START_TAG("IN2") //$be0008.w
	PORT_DIPNAME( 0x0007, 0x0007, DEF_STR( Coin_A ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( 5C_1C ) )
	PORT_DIPSETTING(      0x0001, DEF_STR( 4C_1C ) )
	PORT_DIPSETTING(      0x0002, DEF_STR( 3C_1C ) )
	PORT_DIPSETTING(      0x0003, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(      0x0007, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(      0x0006, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(      0x0005, DEF_STR( 1C_3C ) )
	PORT_DIPSETTING(      0x0004, DEF_STR( 1C_4C ) )
	PORT_DIPNAME( 0x0038, 0x0038, DEF_STR( Coin_B ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( 5C_1C ) )
	PORT_DIPSETTING(      0x0008, DEF_STR( 4C_1C ) )
	PORT_DIPSETTING(      0x0010, DEF_STR( 3C_1C ) )
	PORT_DIPSETTING(      0x0018, DEF_STR( 2C_1C ) )
	PORT_DIPSETTING(      0x0038, DEF_STR( 1C_1C ) )
	PORT_DIPSETTING(      0x0030, DEF_STR( 1C_2C ) )
	PORT_DIPSETTING(      0x0028, DEF_STR( 1C_3C ) )
	PORT_DIPSETTING(      0x0020, DEF_STR( 1C_4C ) )
	PORT_DIPNAME( 0x0040, 0x0040, DEF_STR( Free_Play ) )
	PORT_DIPSETTING(      0x0040, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( On ) )
	PORT_SERVICE( 0x0080, IP_ACTIVE_LOW )
	PORT_DIPNAME( 0x0300, 0x0300, DEF_STR( Difficulty ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( Easy ) )
	PORT_DIPSETTING(      0x0300, DEF_STR( Normal ) )
	PORT_DIPSETTING(      0x0100, DEF_STR( Hard ) )
	PORT_DIPSETTING(      0x0200, DEF_STR( Hardest ) )
	PORT_DIPNAME( 0x0400, 0x0400, "Vs Mode Rounds" )
	PORT_DIPSETTING(      0x0000, "1" )
	PORT_DIPSETTING(      0x0400, "3" )
	PORT_DIPNAME( 0x0800, 0x0000, DEF_STR( Language ) )
	PORT_DIPSETTING(      0x0800, DEF_STR( Japanese ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( English ) )
	PORT_DIPNAME( 0x1000, 0x1000, "F.B.I Logo" )
	PORT_DIPSETTING(      0x1000, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( On ) )
	PORT_DIPNAME( 0x2000, 0x2000, "Voice" )
	PORT_DIPSETTING(      0x0000, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x2000, DEF_STR( On ) )
	PORT_DIPNAME( 0x4000, 0x4000, DEF_STR( Demo_Sounds ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x4000, DEF_STR( On ) )
	PORT_DIPNAME( 0x8000, 0x8000, DEF_STR( Flip_Screen ) )
	PORT_DIPSETTING(      0x8000, DEF_STR( Off ) )
	PORT_DIPSETTING(      0x0000, DEF_STR( On ) )

INPUT_PORTS_END

static const gfx_layout tiles8x8_layout =
{
	8,8,
	RGN_FRAC(1,1),
	8,
	{ 0,1, 2,3, 4,5,6,7 },
	{ 0, 8, 16, 24, 32, 40, 48, 56 },
	{ 0*64, 1*64, 2*64, 3*64, 4*64, 5*64, 6*64, 7*64 },
	64*8
};

static const gfx_decode gfxdecodeinfo[] =
{
	{ REGION_GFX1, 0, &tiles8x8_layout, 0, 2 },
	{ REGION_GFX2, 0, &tiles8x8_layout, 0, 2 },
	{ REGION_GFX3, 0, &tiles8x8_layout, 0, 2 },
	{ REGION_GFX4, 0, &tiles8x8_layout, 0, 2 },
	{ REGION_GFX5, 0, &tiles8x8_layout, 0, 2 },
	{ REGION_GFX6, 0, &tiles8x8_layout, 0, 2 },
	{ REGION_GFX7, 0, &tiles8x8_layout, 0, 2 },
	{ REGION_GFX8, 0, &tiles8x8_layout, 0, 2 },

	{ -1 }
};

#if 0
VIDEO_START(stepstag)
{
	return 0;
}
VIDEO_UPDATE(stepstag)
{

}
#endif

static struct YMZ280Binterface ymz280b_stepstag_intf =
{
	0,
	0	// irq
};

static MACHINE_DRIVER_START( stepstag )
	/* basic machine hardware */
	MDRV_CPU_ADD(M68000, 16000000 ) //??
	MDRV_CPU_PROGRAM_MAP(stepstag_readmem,stepstag_writemem)
	MDRV_CPU_VBLANK_INT(irq4_line_hold,1) // 4 & 6 valid

	MDRV_CPU_ADD(M68000, 16000000 ) //??
	MDRV_CPU_PROGRAM_MAP(stepstag_sub_readmem,stepstag_sub_writemem)


	MDRV_FRAMES_PER_SECOND(60)
	MDRV_VBLANK_DURATION(DEFAULT_60HZ_VBLANK_DURATION)

	/* video hardware */
	MDRV_VIDEO_ATTRIBUTES(VIDEO_TYPE_RASTER)
//	MDRV_SCREEN_SIZE(64*8, 32*8)
//	MDRV_VISIBLE_AREA(0*8, 32*8-1, 0*8, 32*8-1)

	/* Screen Style fixed (Wrong?) by Gemuno@Masatti */

	MDRV_SCREEN_SIZE(0x140, 0xe0)
	MDRV_VISIBLE_AREA(0*8, 0x0140-1, 0*8, 0xe0-1)
	MDRV_PALETTE_LENGTH(0x8000)
	MDRV_GFXDECODE(gfxdecodeinfo)

#if 1
	MDRV_VIDEO_START(tetrisp2)
	MDRV_VIDEO_UPDATE(tetrisp2)
#else
	MDRV_VIDEO_START(stepstag)
	MDRV_VIDEO_UPDATE(stepstag)
#endif


#if 1
	MDRV_SPEAKER_STANDARD_STEREO("left", "right")

	MDRV_SOUND_ADD(YMZ280B, 16934400)// really?
	MDRV_SOUND_CONFIG(ymz280b_stepstag_intf)
	MDRV_SOUND_ROUTE(0, "left", 1.0)
	MDRV_SOUND_ROUTE(1, "right", 1.0)
#endif

MACHINE_DRIVER_END


ROM_START( stepstag )
	ROM_REGION( 0x100000, REGION_CPU1, 0 ) /* 68k */
	ROM_LOAD16_BYTE( "vj98348ver11.11", 0x00000, 0x80000, CRC(29b7f848) SHA1(c4d89e5c9be622b2d9038c359a5f65ce0dd461b0) )
	ROM_LOAD16_BYTE( "vj98348ver11.14", 0x00001, 0x80000, CRC(e3314c6c) SHA1(61b0e9f9d0126d9f475304866a03cfa21701d9aa) )

	ROM_REGION( 0x100000, REGION_CPU2, 0 ) /* 68k */
	ROM_LOAD16_BYTE( "vj98344ver11.1", 0x00001, 0x80000, CRC(aedcb225) SHA1(f167c390e79ffbf7c019c326384ae656ae8b7d13) )
	ROM_LOAD16_BYTE( "vj98344ver11.4", 0x00000, 0x80000, CRC(391ca913) SHA1(2cc329aa6419f8a0d7e0fb8a9f4c2b8ca25197b3) )


	ROM_REGION( 0x400000, REGION_GFX1, 0 ) /* */
	ROM_LOAD( "mr99001-06", 0x00000, 0x400000, CRC(cfa27c93) SHA1(a0837877736e8e898f3acc64bc87ee0cc4d9f243) )

	ROM_REGION( 0x400000, REGION_GFX2, 0 ) /* */
	ROM_LOAD( "mr99001-05", 0x00000, 0x400000, CRC(3958473b) SHA1(12279a587263290945744b22aafb80460eea77f7) )

	ROM_REGION( 0x400000, REGION_GFX3, 0 ) /* */
	ROM_LOAD( "mr99001-04", 0x00000, 0x400000, CRC(d6837981) SHA1(56709d73304f0b186c70844ae96f73400b541609) )

	ROM_REGION( 0x400000, REGION_GFX4, 0 ) /* */
	ROM_LOAD( "mr99001-03", 0x00000, 0x400000, CRC(40fee0df) SHA1(94c3567e82f8039b3169bf4dcb1fcd9e39c6eb27) )

	ROM_REGION( 0x400000, REGION_GFX5, 0 ) /* */
	ROM_LOAD( "mr99001-02", 0x00000, 0x400000, CRC(12c65d86) SHA1(7fe5853fa3ba086f8da15702b126eb13c6ea30a9) )

	ROM_REGION( 0x400000, REGION_GFX6, 0 ) /* */
	ROM_LOAD( "mr99001-01", 0x00000, 0x400000,  CRC(aa92cebf) SHA1(2ccc0d2ef9bc92c27f0a625819154bbcf9cfde0c) )

	ROM_REGION( 0x400000, REGION_GFX7, 0 ) /* */
	ROM_LOAD( "s.s.s._vj-98348_19_pr99021-02", 0x00000, 0x400000, CRC(2d98da1a) SHA1(b09375fa1b4b2e0794632d6e237459009f40310d) )

	ROM_REGION( 0x400000, REGION_GFX8, 0 ) /* */
	ROM_LOAD( "s.s.s._vj-98348_26_pr99021-01", 0x00000, 0x400000, CRC(fefb3777) SHA1(df624e105ab1dea52317e318ad29caa02b900788) )
	ROM_LOAD( "s.s.s._vj-98348_3_pr99021-01", 0x00000, 0x400000, CRC(e0fbc6f1) SHA1(7ca4507702f3f81bb9de3f9b5d270d379e439633) )
ROM_END

ROM_START( step3 )
ROM_REGION( 0x100000, REGION_CPU1, 0 ) /* 68k */
	ROM_LOAD16_BYTE( "vj98344ver11.1", 0x00001, 0x80000, NO_DUMP )
	ROM_LOAD16_BYTE( "vj98344ver11.4", 0x00000, 0x80000, NO_DUMP )
	// c'est la programme de stepstag (avoir besoin de modifications, numero de chansons par example)

	ROM_REGION( 0x100000, REGION_CPU2, 0 ) /* 68k */
	ROM_LOAD16_BYTE( "vj98348_step3_11_v1.1", 0x00000, 0x80000, CRC(9c36aef5) SHA1(bbac48c2c7949a6f8a6ec83515e94a343c88d1b6) )
	ROM_LOAD16_BYTE( "vj98348_step3_14_v1.1", 0x00001, 0x80000, CRC(b86be557) SHA1(49dbd6ef1c50adcf3386d5423da8ae7685649c46) )

	ROM_REGION( 0x1000000, REGION_GFX1, 0 ) /* */
	ROM_LOAD( "mr9930-01.ic2", 0x000000, 0x400000, CRC(9e3e054e) SHA1(06a4fa76cb83dbe9d565d5ccd0a5ecc5067887c9) )

	ROM_REGION( 0x1000000, REGION_GFX2, 0 ) /* */
	ROM_LOAD( "mr9930-02.ic3", 0x000000, 0x400000, CRC(b23c29f4) SHA1(a7b10a3a9af43db319baf8633bb3728120960923) )

	ROM_REGION( 0x1000000, REGION_GFX3, 0 ) /* */
	ROM_LOAD( "mr9930-03.ic4", 0x000000, 0x400000, CRC(9a5d070f) SHA1(b4668b4f299033140a2c56499cc2712ba111cb57) )

	ROM_REGION( 0x1000000, REGION_GFX4, 0 ) /* screen centre */
	ROM_LOAD( "mr99030-04.ic17", 0x000000, 0x400000, CRC(3eac3591) SHA1(3b294e94af23fd92fdf51d2c9c43f60d2ebd1688) )

	ROM_REGION( 0x1000000, REGION_GFX5, 0 ) /* */
	ROM_LOAD( "mr99030-05.ic18", 0x000000, 0x400000, CRC(dea7b8d6) SHA1(d7d98675eb3998a8057929f90aa340c1e5f6a617) )

	ROM_REGION( 0x1000000, REGION_GFX6, 0 ) /* */
	ROM_LOAD( "mr99030-06.ic19", 0x000000, 0x400000, CRC(71489d79) SHA1(0398a354c2588e3974cb76a331e46165db6af06d) )

	ROM_REGION( 0x1000000, REGION_GFX7, 0 ) /* */
	ROM_LOAD( "mr9930-01.ic30", 0x000000, 0x400000, CRC(9e3e054e) SHA1(06a4fa76cb83dbe9d565d5ccd0a5ecc5067887c9) )
	ROM_LOAD( "mr9930-02.ic29", 0x400000, 0x400000, CRC(b23c29f4) SHA1(a7b10a3a9af43db319baf8633bb3728120960923) )
	ROM_LOAD( "mr9930-03.ic28", 0x800000, 0x400000, CRC(9a5d070f) SHA1(b4668b4f299033140a2c56499cc2712ba111cb57) )

	ROM_REGION( 0x1000000, REGION_GFX8, 0 ) /* */
	ROM_LOAD( "vj98348_step3_4_v1.1", 0x000000, 0x400000, CRC(dec612df) SHA1(acb86bb90c1cc61c7db3e022c69a5ff0611ffbae) )
	ROM_LOAD( "vj98348_step3_18_v1.1", 0x400000, 0x400000, CRC(bc92f0a0) SHA1(49c08de7a898a27972d4209709ddf447c5dca36a) )
	ROM_LOAD( "vj98348_step3_25_v1.1", 0x800000, 0x400000, CRC(dec612df) SHA1(acb86bb90c1cc61c7db3e022c69a5ff0611ffbae) )


ROM_END

GAME( 1999, stepstag, 0, stepstag, stepstag, 0, ROT0, "Jaleco", "Stepping Stage Special", GAME_NO_SOUND| GAME_NOT_WORKING )
GAME( 1999, step3   , 0, stepstag, stepstag, 0,	ROT0, "Jaleco", "Stepping 3 Superior", GAME_NO_SOUND| GAME_NOT_WORKING )
