/**
 * DecoratorManager.java
 * Created on 2004/02/21
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.view;

import java.util.ArrayList;
import java.util.HashMap;

import net.prixdami.alexis.system.SystemParameter;

/**
 * DecoratorChainǗp}l[WNX
 * Oɂ͌JȂ
 * @author es
 */
class DecoratorManager {

    private static DecoratorManager me = new DecoratorManager();
    private HashMap cache;

    private DecoratorManager() {
        cache = new HashMap();
    }

    /**
     * w肵`ɑΉDecorator̐VKCX^X𐶐
     * @param key@`
     * @return@Decorator̐VKCX^XA`ꍇRuntimeException
     */
    static Decorator getDecorator(String key) {
        Decorator d;
        try {
            d = (Decorator) Class.forName(SystemParameter.getDecoratorClassName(key)).newInstance();
        } catch (Exception e) {
            throw new RuntimeException(e);
        }
        return d;
    }

    /**
     * DecoratorChain̎擾
     * ŏɓLbVTAꍇ̓VXep[^̒`
     * VKCX^XALbVɒǉ
     * @param url 擾Ώۂurlp^[
     * @return@ΉDecoratorChainA`Ȃꍇnull
     * 
     */
    static DecoratorChain getDecoratorChain(String url) {
		//TODO LbṼtbVlĂȂ̂ŁAl
		//ȂĂ悤ȋCȂłȂ
		if (me.cache.containsKey(url)) {
            return (DecoratorChain) me.cache.get(url);
        }
        ArrayList[] al = SystemParameter.getDecoratorMap(url);
        if (al == null) {
            me.cache.put(url, null);
            return null;
        }
        DecoratorChain dc = new DecoratorChain();
        for (int i = 0; i < al.length; i++) {
            for (int j = 0; j < al[i].size(); j++) {
                dc.decorators[i].add(getDecorator((String) al[i].get(j)));
            }
        }
        me.cache.put(url, dc);
        return dc;
    }
}
