/**
 * Utils.java
 * Created on 2003/06/12 22:37:49
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.util;

import java.net.URL;
import java.security.MessageDigest;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;

/**
 * Tu[`W
 * @author es
 * @version 
 */
public class Utils {
	private static Random r = new MersenneTwister();

	private Utils() {}

	public static Random getRadom(){
		return r;
	}

	public static String cropHostName(String arg){
		URL url;
		try {
			url = new URL(arg);
		} catch (Exception e) {
			return null;
		}
		return url.getPath();
	}

	/**
	 * ANVL[쐬
	 * @return
	 */
	public static Object makeKey() {
		return getMD5(String.valueOf(new Date().getTime() + r.nextDouble()));
	}

    /**
     * w肵MD5_CWFXg擾
     * @param arg Ώ
     * @return 
     */
    public static String getMD5(String arg) {
        try {
            StringBuffer sb = new StringBuffer();
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] data = md.digest(arg.getBytes());
            for (int i = 0; i < data.length; i++) {
                sb.append(Integer.toHexString(data[i] & 0x00ff));
            }
            return sb.toString();
        } catch (Exception ex) {
            return null;
        }
    }

    /**
     * w肵ɊȈՔtnbV܂
     * @param arg Ώ
     * @return 
     */
    public static String getID(String arg) {
        try {
            StringBuffer sb = new StringBuffer();
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] data = md.digest(arg.getBytes());
            for (int i = 0; i < data.length; i++) {
                char p = (char) (data[i] & 0x7fff);
                if (p > 126)
                    p %= 126;
                if (p < 47)
                    p += 47;
                sb.append(p);
            }
            return sb.toString();
        } catch (Exception ex) {
            return "";
        }
    }

    /**
     * 񕪊
     * @param src Ώ
     * @param splitter ؂蕶
     * @return
     * @deprecated java1.4Stringɓ\bho
     */
    public static String[] split(String src, String splitter) {
        StringTokenizer st = new StringTokenizer(src, splitter);
        String[] to = new String[st.countTokens()];
        int i = 0;
        while (st.hasMoreTokens()) {
            to[i++] = st.nextToken();
        }
        return to;
    }

    /**
     * u
     * @param src uΏ
     * @param from uO̕
     * @param to u̕
     * @return
     */
    public static String escape(String src, String from, String to) {
        if (src == null) {
            src = "";
        }
        int index = src.indexOf(from);
        if (index == -1) {
            return src;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(src.substring(0, index) + to);
        if (index + from.length() < src.length()) {
            String rest = src.substring(index + from.length(), src.length());
            buffer.append(escape(rest, from, to));
        }
        return buffer.toString();
    }

    /**
     * xss΍ŃoȕSGXP[v
     * @param arg ϊΏ
     * @return ϊ
     */
    public static String aviod(String arg) {
        arg = Utils.escape(arg, "&", "&amp;");
        arg = Utils.escape(arg, ">", "&gt;");
        arg = Utils.escape(arg, "<", "&lt;");
        arg = Utils.escape(arg, "\"", "&quot;");
        arg = Utils.escape(arg, ",", "&#x2c;");
        return arg;
    }

    public static String quote(String arg) {
        return "\"" + aviod(arg) + "\"";
    }

	/**
	 * java.util.DateHH:mm:ss`̕ɕϊ
	 * @param date ϊΏ
	 * @return ϊ
	 */
	public static String getTime(Date date) {
		SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss");
		return df.format(date);
	}

	/**
	 * java.util.DateHH:mm:ss`̕ɕϊ
	 * @param date ϊΏ
	 * @return ϊ
	 */
	public static String getDate(Date date) {
		SimpleDateFormat df = new SimpleDateFormat("yyyyNMd HH:mm");
		return df.format(date);
	}

}