/**
 * ParameterManager.java
 * Created on 2004/02/15
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.system;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import net.prixdami.alexis.logic.ActionModel;

import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

/**
 * VXep[^NX
 * ̃VXep̃p[^`xmlt@Cp[XAێ
 * p[^`xmlt@C̈ʒuVMœn(b)
 * "-Dalexis.systemfile=path"Ŏw
 * @author es
 */
public class SystemParameter {
    private static final String ATTR_URL = "url";
    public static final String NAME = "alexis.system";
    private static final String ATTR_LOGIC = "logic";
    private static final String ATTR_CODE = "code";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_NAME = "name";
    private static final String ATTR_PATH = "path";
    private static final String ATTR_VALUE = "value";
    private static final String ATTR_CLASS = "class";
    private static final String TAG_ACTION = "action";
    private static final String TAG_PARAMETER = "parameter";
    private static final String TAG_PROPERTY = "property";
    private static final String TAG_RESULT = "result";
    private static final String TAG_DECORATORLIST = "decorator-list";
    private static final String TAG_DECORATOR = "decorator";
    private static final String TAG_DECORATORMAPPING = "decorator-mapping";
    private static final String TAG_DECORATORMAP = "decorator-map";
    private static final String TAG_PRE_DECORATOR = "pre-" + TAG_DECORATOR;
    private static final String TAG_POST_DECORATOR = "post-" + TAG_DECORATOR;

    //ANV}bvꗗMap
    private static Map actionMap;
    //PropertiesꗗMap
    private static Map props;

    private static Map decs;

    //CX^X
    private static SystemParameter me = new SystemParameter();

    public static String getSystemProperty(String key) {
        return getProperties(NAME).getProperty(key);
    }

    /**
     * `ĂSĂActionModelꗗ擾
     * @return `ĂSĂActionModelMap L[̓ANV
     */
    public static Map getActionMap() {
        return actionMap;
    }

    /**
     * w肳ꂽANVɑΉActionModel擾
     * @param key 擾Ώۂ̃L[
     * @return L[ɑΉActionModel `ȂȂnull
     */
    public static ActionModel getActionModel(String key) {
        return (ActionModel) actionMap.get(key);
    }

    /**
     * w肳ꂽL[ɑΉProperties擾
     * @param key 擾Ώۂ̃L[
     * @return L[ɑΉProperties
     */
    public static Properties getProperties(String key) {
        Properties p = (Properties) props.get(key);
        if (p == null) {
            p = new Properties();
            props.put(key, p);
        }
        return p;
    }

    //VOgŕێ
    private SystemParameter() {
        init();
    }

    /**
     * 
     * xmlt@Cp[X
     */
    private void init() {
        String path = System.getProperty(NAME);
        props = new HashMap();
        actionMap = new HashMap();
        decs = new HashMap();

        try {
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = builder.parse(new File(path));
            //<property>擾
            NodeList nodelist = doc.getElementsByTagName(TAG_PROPERTY);
            for (int i = 0; i < nodelist.getLength(); i++) {
                Properties p = new Properties();
                Node n = nodelist.item(i);
                String key = n.getAttributes().getNamedItem(ATTR_KEY).getNodeValue();
                NodeList params = n.getChildNodes();
                for (int j = 0; j < params.getLength(); j++) {
                    Node param = params.item(j);
                    if (!param.getNodeName().equals(TAG_PARAMETER)) {
                        continue;
                    }
                    String name = param.getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
                    String value = param.getAttributes().getNamedItem(ATTR_VALUE).getNodeValue();
                    p.put(name, value);
                }
                props.put(key, p);
            }

            //<action>擾
            nodelist = doc.getElementsByTagName(TAG_ACTION);
            for (int i = 0; i < nodelist.getLength(); i++) {
                Node n = nodelist.item(i);
                String name = n.getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
                String cls = n.getAttributes().getNamedItem(ATTR_LOGIC).getNodeValue();
                ActionModel am = new ActionModel(name, cls, getProperties(name));
                NodeList result = n.getChildNodes();
                for (int j = 0; j < result.getLength(); j++) {
                    Node param = result.item(j);
                    if (!param.getNodeName().equals(TAG_RESULT)) {
                        continue;
                    }
                    String code = param.getAttributes().getNamedItem(ATTR_CODE).getNodeValue();
                    String resultpath = param.getAttributes().getNamedItem(ATTR_PATH).getNodeValue();
                    am.setReturnPath(ResultCodeMap.getCode(code), resultpath);
                }
                actionMap.put(am.getName(), am);
            }

            //decorator-list
            nodelist = doc.getElementsByTagName(TAG_DECORATORLIST);
            for (int i = 0; i < nodelist.getLength(); i++) {
                Node n = nodelist.item(i);
                NodeList dec = n.getChildNodes();
                for (int j = 0; j < dec.getLength(); j++) {
                    Node d = dec.item(j);
                    if (!d.getNodeName().equals(TAG_DECORATOR)) {
                        continue;
                    }
                    String name = d.getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
                    String classname = d.getAttributes().getNamedItem(ATTR_CLASS).getNodeValue();
                    decs.put(name, classname);
                }
            }

            //decorator-mapping
            nodelist = doc.getElementsByTagName(TAG_DECORATORMAPPING);
            for (int i = 0; i < nodelist.getLength(); i++) {
                Node n = nodelist.item(i);
                NodeList decmap = n.getChildNodes();
                for (int j = 0; j < decmap.getLength(); j++) {
                    Node d = decmap.item(j);
                    if (!d.getNodeName().equals(TAG_DECORATORMAP)) {
                        continue;
                    }
                    ArrayList[] al = new ArrayList[2];
                    al[0] = new ArrayList();
                    al[1] = new ArrayList();
                    String url = d.getAttributes().getNamedItem(ATTR_URL).getNodeValue();

					NodeList decl = d.getChildNodes();
					for (int k = 0; k < decl.getLength(); k++) {
						Node dl = decl.item(k);
						if (!dl.getNodeName().equals(TAG_PRE_DECORATOR)
						&& !dl.getNodeName().equals(TAG_POST_DECORATOR)) {
							continue;
						}
						int index = dl.getNodeName().equals(TAG_PRE_DECORATOR) ? 0 : 1;
						NodeList dec = dl.getChildNodes();
						for (int l = 0; l < dec.getLength(); l++) {
							Node di = dec.item(l);
							if (!di.getNodeName().equals(TAG_DECORATOR)) {
								continue;
							}
							String dname = di.getAttributes().getNamedItem(ATTR_NAME).getNodeValue();
							al[index].add(dname);
						}
					}
                    decs.put(url, al);
                }
            }

        } catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    /**
     * @param key
     * @return
     */
    public static String getDecoratorClassName(String key) {
        return (String) decs.get(key);
    }

	/**
	 * @param key
	 * @return
	 */
	public static ArrayList[] getDecoratorMap(String key) {
		return (ArrayList[]) decs.get(key);
	}

}
