/**
 * MimeData.java
 * Created on 2003/06/05 22:30:00
 * Copyright (c) by es , All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND 
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED 
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A 
 * PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE 
 * COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY 
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR 
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, 
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF 
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER 
 * CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN 
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE 
 * OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS 
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.prixdami.alexis.model;

import java.io.File;

/**
 * MIME data class
 * uploaderp̓et@CpIuWFNg
 * @author es
 * @version 1.02
 */

public class MimeData {
    private File file;
    private byte[] data;
    private String mimeType;
    private String filename;
    private String suffix;
    private boolean isFile;

    private final String[] path = new String[] { "/", "\\" };

    public MimeData(byte[] data, String mimeType, String filename) {
        this(data, mimeType, filename, false);
    }

    public MimeData(byte[] data, String mimeType, String filename, boolean keepPath) {
        this.isFile = false;
        this.data = data;
        this.mimeType = mimeType;
        this.filename = keepPath ? filename : killPath(filename);
        this.suffix = makeSuffix(this.filename);
    }

    public MimeData(File file, String mimeType, String filename) {
        this(file, mimeType, filename, false);
    }

    public MimeData(File file, String mimeType, String filename, boolean keepPath) {
        this.isFile = true;
        this.file = file;
        this.mimeType = mimeType;
        this.filename = keepPath ? filename : killPath(filename);
        this.suffix = makeSuffix(this.filename);
    }

    public byte[] getBinary() {
        return this.data;
    }
    public File getFile() {
        return this.file;
    }
    public String getType() {
        return this.mimeType;
    }
    public int getBinarySize() {
        return this.data.length;
    }
    public String getFileName() {
        return this.filename;
    }
    public String getSuffix() {
        return this.suffix;
    }
    public boolean isFile() {
        return this.isFile;
    }

    private String makeSuffix(String arg) {
        String temp = arg;
        int pos = temp.lastIndexOf(".");
        if (pos == -1)
            return "";
        temp = temp.substring(pos);
        return temp;
    }

    private String killPath(String arg) {
        String temp = arg;
        for (int i = 0; i < path.length; i++) {
            int pos = temp.lastIndexOf(path[i]);
            if (pos == -1)
                continue;
            temp = temp.substring(pos + 1);
        }
        return temp;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MIME data[");
        sb.append("Content-Type :" + this.mimeType + "; ");
        sb.append("Filename :" + this.filename + " (");
        if (!isFile()) {
            sb.append(this.data.length + " byte)]");
        } else {
            sb.append(this.file.length() + " byte)]");
        }
        return sb.toString();
    }
}